function RoleplayData.OwnDoor(userid)
	_TraceLine(_PlayerGetShootPos(userid), _PlayerGetShootAng(userid), RoleplayData.UseRange, userid)
	
	if _TraceHitNonWorld() then
	local Ent = _TraceGetEnt()
	local Type = _EntGetType(Ent)
		if string.find(Type, "door") or string.find(Type, "vehicle") then
			local ElseGotIt = false
			local ElseGotItID = 0
			for i = 1, _MaxPlayers() do
				for k,v in RoleplayData[i].Property do
					if (v == Ent) and (i ~= userid) then
					ElseGotIt = true
					ElseGotItID = i
					end
				end
			end
		
			local GotIt = false
			for k,v in RoleplayData[userid].Property do
				if v == Ent then
				GotIt = true
				table.remove(RoleplayData[userid].Property, k)
				end
			end
			if GotIt then
				if string.find(Type, "door") then
				_PrintMessage(userid, 4, "You no longer own this door.")
				else
				_PrintMessage(userid, 4, "You no longer own this vehicle.")
				end
			_PlaySoundPlayer(userid, "buttons/button17.wav")
			else
				if ElseGotIt then
					if string.find(Type, "door") then
					_PrintMessage(userid, 4, "This door is owned by " .. _PlayerInfo(ElseGotItID, "name") .. ".")
					else
					_PrintMessage(userid, 4, "This vehicle is owned by " .. _PlayerInfo(ElseGotItID, "name") .. ".")
					end
				_PlaySoundPlayer(userid, "buttons/button18.wav")
				else
				table.insert(RoleplayData[userid].Property, Ent)
					if string.find(Type, "door") then
					_PrintMessage(userid, 4, "You now own this door.")
					else
					_PrintMessage(userid, 4, "You now own this vehicle.")
					end
				_PlaySoundPlayer(userid, "buttons/button17.wav")
				end
			end
		end
	end
end
CONCOMMAND("rp_own", RoleplayData.OwnDoor)
function GetUseridByName(args)
	for i = 1, _MaxPlayers() do
		if not _PlayerInfo(i, "connected") then return end
		local Names = _PlayerInfo(i, "name")
		--_Msg("Name: " .. Names .. " ID: " .. i .. "\n")
		if string.find(string.lower(Names), string.lower(args)) then
			return i
		end
	end
end
function RoleplayData.GiveKeys(userid, args)
	_TraceLine(_PlayerGetShootPos(userid), _PlayerGetShootAng(userid), RoleplayData.UseRange, userid)
	local GiveToId = 0
	GiveToId = GetUseridByName(args)
	local GiveToName = _PlayerInfo(GiveToId, "name")
	if _TraceHitNonWorld() then
	local Ent = _TraceGetEnt()
	local Type = _EntGetType(Ent)	
		if GiveToId ~= 0 then
			if string.find(Type, "door") or string.find(Type, "vehicle") then
				local GotIt = false
				for k,v in RoleplayData[userid].Property do
					if v == Ent then
						GotIt = true
					end
				end
				if GotIt then
					local GotIt2 = false
					for k,v in RoleplayData[userid].KeyProperty do
						if v == Ent then
							GotIt2 = true
						end
					end
					if GotIt2 then
						_PrintMessage(userid, 1, "This User already has keys to this.")
						_PrintMessage(userid, 3, "This User already has keys to this.")
					else
						table.insert(RoleplayData[GiveToId].KeyProperty, Ent)
						_PrintMessage(userid, 1, "Gave Keys to: " .. GiveToName)
						_PrintMessage(userid, 3, "Gave Keys to: " .. GiveToName)
					end
				else
					--_Msg("[Debug] Level5 Failed")
					_PrintMessage(userid, 1, "This does not belong to you.")
					_PrintMessage(userid, 3, "This does not belong to you.")
				end
			end
		end
	end
end
CONCOMMAND("rp_givekey", RoleplayData.GiveKeys)

function RoleplayData.TakeKeys(userid, args)
	_TraceLine(_PlayerGetShootPos(userid), _PlayerGetShootAng(userid), RoleplayData.UseRange, userid)
	local GiveToId = 0
	GiveToId = GetUseridByName(args)
	local GiveToName = _PlayerInfo(GiveToId, "name")
	if _TraceHitNonWorld() then
	local Ent = _TraceGetEnt()
	local Type = _EntGetType(Ent)	
		if GiveToId ~= 0 then

			if string.find(Type, "door") or string.find(Type, "vehicle") then
				local GotIt = false
				for k,v in RoleplayData[userid].Property do
					if v == Ent then
						GotIt = true
					end
				end
				if GotIt then
					for k,v in RoleplayData[userid].Property do
						if v == Ent then
							table.remove(RoleplayData[GiveToId].KeyProperty, k)
							_PrintMessage(userid, 1, "Removed Keys from: " .. GiveToName)
							_PrintMessage(userid, 3, "Removed Keys from: " .. GiveToName)
						end
					end
				else
					_PrintMessage(userid, 1, "This does not belong to you.")
					_PrintMessage(userid, 3, "This does not belong to you.")
				end
			end
		end
	end
end
CONCOMMAND("rp_takekey", RoleplayData.TakeKeys)

function RoleplayData.LockUnlock(userid, lock)
	_TraceLine(_PlayerGetShootPos(userid), _PlayerGetShootAng(userid), RoleplayData.UseRange, userid)
	if _TraceHitNonWorld() then
	local Ent = _TraceGetEnt()
	local Type = _EntGetType(Ent)
		if string.find(Type, "door") or string.find(Type, "vehicle") then
			local GotIt = false
			for k,v in RoleplayData[userid].KeyProperty do
				if v == Ent then
					GotIt = true
				end
			end	
			for k,v in RoleplayData[userid].Property do
				if v == Ent then
					GotIt = true
				end
			end	
			if not GotIt then
				if string.find(Type, "door") then
				_PrintMessage(userid, 4, "This is not your door.")
				else
				_PrintMessage(userid, 4, "This is not your vehicle.")
				end
			return
			end
			
			_EntEmitSound(Ent, "doors/default_locked.wav")
			if lock then -- Lock the door
			_EntFire(Ent, "lock", "", 0)
				if string.find(Type, "door") then
				_PrintMessage(userid, 4, "The door is now locked.")
				else
				_PrintMessage(userid, 4, "The vehicle is now locked.")
				end
			else -- Unlock the door
			_EntFire(Ent, "unlock", "", 0)
				if string.find(Type, "door") then
				_PrintMessage(userid, 4, "The door is now unlocked.")
				else
				_PrintMessage(userid, 4, "The vehicle is now unlocked.")
				end
			end
		end
	end
end


function ShowTable(userid)
	for i = 1, _MaxPlayers() do
	if not _PlayerInfo(i, "connected") then return end
		for k,v in RoleplayData[i].Property do
		_PrintMessage(userid, 1, _PlayerInfo(i, "name") .. ": " .. k .. " - " .. v)
		end
	end
end
CONCOMMAND("table", ShowTable)
function ShowTable2(userid)
	for i = 1, _MaxPlayers() do
	if not _PlayerInfo(i, "connected") then return end
		for k,v in RoleplayData[i].KeyProperty do
		_PrintMessage(userid, 1, _PlayerInfo(i, "name") .. ": " .. k .. " - " .. v)
		end
	end
end
CONCOMMAND("table2", ShowTable2)