function RoleplayData.AddRemHunger(userid, amount)
	if RoleplayData[userid].Hunger == 5 then
	_PrintMessage(userid, 3, "You are starting to starve!")
	end
	
	if RoleplayData[userid].Hunger <= 0 then
	RoleplayData.TakeDamage(userid)
	_PrintMessage(userid, 3, "You are starving!")
	end
	
	if RoleplayData[userid].Hunger + amount > RoleplayData.MaxHunger then
	RoleplayData[userid].Hunger = RoleplayData.MaxHunger
	else
	RoleplayData[userid].Hunger = RoleplayData[userid].Hunger + amount
	end
	RoleplayData.ShowGUI(userid)
	RoleplayData.CheckEnergyAmount(userid)
end

function RoleplayData.EatFood(userid, entity)
	for i in RoleplayData.Food do
		if entity == RoleplayData.Food[i].FoodID then
		RoleplayData.AddRemHunger(userid, RoleplayData.Food[i].Amount)
		if RoleplayData[userid].Hunger >= RoleplayData.MaxHunger then
		RoleplayData[userid].Hunger = RoleplayData.MaxHunger
		end
		table.remove(RoleplayData.Food, i)
		_EntRemove(entity)
		_PlayerFreeze(userid, true)
		_EntEmitSound(userid, "UCRPM/eat.wav")
		AddTimer(1, 0, _PlayerFreeze, userid, false)
		RoleplayData.ShowGUI(userid)
		RoleplayData.CheckEnergyAmount(userid)
		end
	end
end

function RoleplayData.HungerThink()
	for i = 1, _MaxPlayers() do
	if not _PlayerInfo(i, "connected") then return end
		if not RoleplayData[i].IsSleeping then
		RoleplayData.AddRemHunger(i, -1)
		else
		RoleplayData.AddRemHunger(i, 3)
		end
	end
end

if RoleplayData.HungerTimer ~= nil then HaltTimer(RoleplayData.HungerTimer) end -- If you reload so it doesn't screw up.
RoleplayData.HungerTimer = AddTimer(RoleplayData.HungerDrain, 0, RoleplayData.HungerThink)

function RoleplayData.TakeDamage(userid)
	local Health = _PlayerInfo(userid, "health")
	_PlayerSetHealth(userid, (Health - RoleplayData.StarveDamage))
	if _PlayerInfo(userid, "health") <= 0 then
	_PlayerKill(userid)
	end
end

function RoleplayData.CheckEnergyAmount(userid)
	if (RoleplayData[userid].Hunger < 20) then
	local Alpha = (200 - (RoleplayData[userid].Hunger * 10))
	_GModRect_Start("gmod/white")
	_GModRect_SetPos(0, 0, 1, 1)
	_GModRect_SetTime(9999, 0, 0)
	_GModRect_SetColor(0, 0, 0,  Alpha)
	_GModRect_Send(userid, (RoleplayData.IndexGUI + 100))
	else
	_GModRect_Hide(userid, (RoleplayData.IndexGUI + 100), 3, 0)
	end
end

function RoleplayData.MakeFood(userid, model, name)
	_TraceLine(_PlayerGetShootPos(userid), _PlayerGetShootAng(userid), 50, userid)
	local Food = _EntCreate("prop_physics")
	_EntPrecacheModel(model)
	_EntSetModel(Food, model)
	_EntSetPos(Food, _TraceEndPos())
	_EntSetName(Food, name)
	_EntSpawn(Food)
	if (name == "egg") then
	_EntSetMaterial(Food,"models/debug/debugwhite")
	end
	
	--[[local FoodInfo = {}
	FoodInfo.FoodID = Food
	FoodInfo.Amount = math.ceil(amount)
	table.insert(RoleplayData.Food, FoodInfo)]]
end

function RoleplayData.RestoreHunger(userid)
	RoleplayData[userid].Hunger = RoleplayData.StartingHunger
	RoleplayData.ShowGUI(userid)
end

function RoleplayData.SpawnFood(userid, strText)
	local From = _PlayerInfo(userid, "name") -- Find the name of the player
	NoNameTxt1 = string.gsub( From, "([%[%]%(%)%%%+%-%*%?%^%$%.])", "%%%1" ) -- Lets get rid of the special chars.
	NoNameTxt = string.gsub(strText, NoNameTxt1..":", "") -- Remove the name

	Text = _Explode(NoNameTxt, " ", 0)
	if string.lower(Text[2]) == string.lower("/food") then
		if not RoleplayData[userid].isChef then
		_PrintMessage(userid, 3, "You must work as a Chef to spawn food!")
		return true
		end
		RoleplayData.FoodMenu(userid)
		return true
	end
end

function RoleplayData.CheckFoodCost(userid, amount)
		local Cost = amount * RoleplayData.FoodMultiplier
		if Cost <= RoleplayData[userid].Cash then
		RoleplayData[userid].Cash = RoleplayData[userid].Cash - Cost
		RoleplayData[userid].Cash = math.round(RoleplayData[userid].Cash, 0.01)
		RoleplayData.ShowGUI(userid)
		else
		_PrintMessage(userid, 3, "You don't have enough money!")
		return true
		end
end 

------------------------
-- Begin Food Menu --
------------------------
function RoleplayData.FoodMenu(userid)
	local MilkC = ( RoleplayData.Milk * RoleplayData.FoodMultiplier )
	local EggsC = ( RoleplayData.Eggs * RoleplayData.FoodMultiplier )
	local FlourC = ( RoleplayData.Flour * RoleplayData.FoodMultiplier )
	local AppleC = ( RoleplayData.Apple * RoleplayData.FoodMultiplier )
	
	_GModRect_Start("gmod/white")
	_GModRect_SetPos(0.0, 0.3, 0.18, 0.28)
	_GModRect_SetColor(0, 0, 0, 100)
	_GModRect_SetTime(9999, 0.5, 0.5)
	_GModRect_Send(userid, (RoleplayData.IndexGUI - 10))

	_GModText_Start("Default")
	_GModText_SetPos(0.01, 0.32)
	_GModText_SetTime(99999, 1, 0.5)
	_GModText_SetText("FOOD SPAWN MENU:\n\n1. Orange\n2. Banana\n3. Melon\n4. Sandwich\n5. Milk (" .. RoleplayData.CashPrefix .. MilkC .. ")\n6. Egg (" .. RoleplayData.CashPrefix .. EggsC .. ")\n7. Flour (" .. RoleplayData.CashPrefix .. FlourC .. ")\n8. Apple (" .. RoleplayData.CashPrefix .. AppleC .. ")\n9. Next Page\n\n0. Close")
 	_GModText_SetColor(255, 255, 255, 255)
	_GModText_Send(userid, (RoleplayData.IndexGUI - 10))
	
	_PlayerOption(userid, "FoodMenu1", 99999)
end

function FoodMenu1(userid, num, seconds)
	if (num == 1) then 
		RoleplayData.OrangeMenu(userid)
	elseif (num == 2) then
		RoleplayData.BananaMenu(userid)
	elseif (num == 3) then
		RoleplayData.MelonMenu(userid)
	elseif (num == 4) then
		RoleplayData.SandwichMenu(userid)
	elseif (num == 5) then
		if RoleplayData.CheckFoodCost(userid, RoleplayData.Milk) then return true end
		RoleplayData.MakeFood(userid, "models/props_junk/garbage_milkcarton002a.mdl", "milk")
		local Cost = RoleplayData.Milk * RoleplayData.FoodMultiplier
		_PrintMessage(userid, 3, "You made some Milk with " .. RoleplayData.Milk .. " food! (" .. RoleplayData.CashPrefix .. Cost .. ")")
		RoleplayData.FoodMenu(userid)
	elseif (num == 6) then
		if RoleplayData.CheckFoodCost(userid, RoleplayData.Eggs) then return true end
		RoleplayData.MakeFood(userid, "models/props/cs_italy/orange.mdl", "egg")
		local Cost = RoleplayData.Eggs * RoleplayData.FoodMultiplier
		_PrintMessage(userid, 3, "You made an egg with " .. RoleplayData.Eggs .. " food! (" .. RoleplayData.CashPrefix .. Cost .. ")")
		RoleplayData.FoodMenu(userid)
	elseif (num == 7) then
		if RoleplayData.CheckFoodCost(userid, RoleplayData.Flour) then return true end
		RoleplayData.MakeFood(userid, "models/props_lab/jar01b.mdl", "flour")
		local Cost = RoleplayData.Flour * RoleplayData.FoodMultiplier
		_PrintMessage(userid, 3, "You made a flour bag with " .. RoleplayData.Flour .. " food! (" .. RoleplayData.CashPrefix .. Cost .. ")")
		RoleplayData.FoodMenu(userid)
	elseif (num == 8) then
		if RoleplayData.CheckFoodCost(userid, RoleplayData.Apple) then return true end
		RoleplayData.MakeFood(userid, "models/appleg.mdl", "apple")
		local Cost = RoleplayData.Apple * RoleplayData.FoodMultiplier
		_PrintMessage(userid, 3, "You made an apple with " .. RoleplayData.Apple .. " food! (" .. RoleplayData.CashPrefix .. Cost .. ")")
		RoleplayData.FoodMenu(userid)
	elseif (num == 9) then
		RoleplayData.FoodMenu2(userid)
	elseif (num == 0) then
		_GModText_Hide(userid, (RoleplayData.IndexGUI - 10), 0.5, 0)
		_GModRect_Hide(userid, (RoleplayData.IndexGUI - 10), 0.5, 0)
	else
		RoleplayData.FoodMenu(userid)
	end
end

function RoleplayData.FoodMenu2(userid)
	local DoughnutC = ( RoleplayData.Doughnut * RoleplayData.FoodMultiplier )
	local PieC = ( RoleplayData.Pie * RoleplayData.FoodMultiplier )
	
	_GModRect_Start("gmod/white")
	_GModRect_SetPos(0.0, 0.3, 0.18, 0.28)
	_GModRect_SetColor(0, 0, 0, 100)
	_GModRect_SetTime(9999, 0.5, 0.5)
	_GModRect_Send(userid, (RoleplayData.IndexGUI - 10))

	_GModText_Start("Default")
	_GModText_SetPos(0.01, 0.32)
	_GModText_SetTime(99999, 1, 0.5)
	_GModText_SetText("FOOD SPAWN MENU:\n\n1. Doughnut (" .. RoleplayData.CashPrefix .. DoughnutC .. ")\n2. Pie (" .. RoleplayData.CashPrefix .. PieC .. ")\n3.\n4.\n5.\n6.\n7.\n8.\n9. Go Back\n\n0. Close")
 	_GModText_SetColor(255, 255, 255, 255)
	_GModText_Send(userid, (RoleplayData.IndexGUI - 10))
	
	_PlayerOption(userid, "FoodMenu2", 99999)
end

function FoodMenu2(userid, num, seconds)
	if (num == 1) then
		if RoleplayData.CheckFoodCost(userid, RoleplayData.Doughnut) then return true end
		RoleplayData.MakeFood(userid, "models/Cloud/doughnut.mdl", "doughnut")
		local Cost = RoleplayData.Doughnut * RoleplayData.FoodMultiplier
		_PrintMessage(userid, 3, "You made a doughnut with " .. RoleplayData.Doughnut .. " food! (" .. RoleplayData.CashPrefix .. Cost .. ")")
		RoleplayData.FoodMenu2(userid)
	elseif (num == 2) then
		if RoleplayData.CheckFoodCost(userid, RoleplayData.Pie) then return true end
		RoleplayData.MakeFood(userid, "models/Cloud/pie_whole.mdl", "pie")
		local Cost = RoleplayData.Pie * RoleplayData.FoodMultiplier
		_PrintMessage(userid, 3, "You made a pie with " .. RoleplayData.Pie .. " food! (" .. RoleplayData.CashPrefix .. Cost .. ")")
		RoleplayData.FoodMenu2(userid)
	elseif (num == 9) then
		RoleplayData.FoodMenu(userid)
	elseif (num == 0) then
		_GModText_Hide(userid, (RoleplayData.IndexGUI - 10), 0.5, 0)
		_GModRect_Hide(userid, (RoleplayData.IndexGUI - 10), 0.5, 0)
	else
		RoleplayData.FoodMenu(userid)
	end

end

-------------
-- Orange --
-------------
function RoleplayData.OrangeMenu(userid)
	local S = RoleplayData.OrangeSmall * RoleplayData.FoodMultiplier
	local M = RoleplayData.OrangeMedium * RoleplayData.FoodMultiplier
	local L = RoleplayData.OrangeLarge * RoleplayData.FoodMultiplier
		
	_GModRect_Start("gmod/white")
	_GModRect_SetPos(0.0, 0.3, 0.18, 0.28)
	_GModRect_SetColor(0, 0, 0, 100)
	_GModRect_SetTime(9999, 0.5, 0.5)
	_GModRect_Send(userid, RoleplayData.IndexGUI - 10)

	_GModText_Start("Default")
	_GModText_SetPos(0.01, 0.32)
	_GModText_SetTime(99999, 1, 0.5)
	_GModText_SetText("FOOD SPAWN MENU:\n\n1. Small Orange (" .. RoleplayData.CashPrefix .. S .. ")\n2. Medium Orange (" .. RoleplayData.CashPrefix .. M .. ")\n3. Large Orange (" .. RoleplayData.CashPrefix .. L .. ")\n4.\n5.\n6.\n7.\n8.\n9. Go Back\n\n0. Close")
 	_GModText_SetColor(255, 255, 255, 255)
	_GModText_Send(userid, (RoleplayData.IndexGUI - 10))
	
	_PlayerOption(userid, "OrangeMenu", 99999)
end

function OrangeMenu(userid, num, seconds)
	_GModText_Hide(userid, (RoleplayData.IndexGUI - 10), 0, 0)
	_GModRect_Hide(userid, (RoleplayData.IndexGUI - 10), 0, 0)

	if (num == 1) then 
		if RoleplayData.CheckFoodCost(userid, RoleplayData.OrangeSmall) then return true end
		RoleplayData.MakeFood(userid, "models/props/cs_italy/orange.mdl", "orangesmall")
		local Cost = RoleplayData.OrangeSmall * RoleplayData.FoodMultiplier
		_PrintMessage(userid, 3, "You made a small orange with " .. RoleplayData.OrangeSmall .. " food! (" .. RoleplayData.CashPrefix .. Cost .. ")")
	elseif (num == 2) then
		if RoleplayData.CheckFoodCost(userid, RoleplayData.OrangeMedium) then return true end
		RoleplayData.MakeFood(userid, "models/props/cs_italy/orange.mdl", "orangemedium")
		local Cost = RoleplayData.OrangeMedium * RoleplayData.FoodMultiplier
		_PrintMessage(userid, 3, "You made a medium orange with " .. RoleplayData.OrangeMedium .. " food! (" .. RoleplayData.CashPrefix .. Cost .. ")")
	elseif (num == 3) then
		if RoleplayData.CheckFoodCost(userid, RoleplayData.OrangeLarge) then return true end
		RoleplayData.MakeFood(userid, "models/props/cs_italy/orange.mdl", "orangelarge")
		local Cost = RoleplayData.OrangeLarge * RoleplayData.FoodMultiplier
		_PrintMessage(userid, 3, "You made a large orange with " .. RoleplayData.OrangeLarge .. " food! (" .. RoleplayData.CashPrefix .. Cost .. ")")
	elseif (num == 9) then
		RoleplayData.FoodMenu(userid)
	elseif (num == 0) then
	_GModText_Hide(userid, (RoleplayData.IndexGUI - 10), 0.5, 0)
	_GModRect_Hide(userid, (RoleplayData.IndexGUI - 10), 0.5, 0)
	else -- Any other number
	RoleplayData.OrangeMenu(userid)
	end
	
	if (num ~= 0) then 
	RoleplayData.FoodMenu(userid)
	end
end


-------------
-- Banana --
-------------
function RoleplayData.BananaMenu(userid)
	local S = RoleplayData.BananaSmall * RoleplayData.FoodMultiplier
	local M = RoleplayData.BananaMedium * RoleplayData.FoodMultiplier
	local L = RoleplayData.BananaLarge * RoleplayData.FoodMultiplier
		
	_GModRect_Start("gmod/white")
	_GModRect_SetPos(0.0, 0.3, 0.18, 0.28)
	_GModRect_SetColor(0, 0, 0, 100)
	_GModRect_SetTime(9999, 0.5, 0.5)
	_GModRect_Send(userid, RoleplayData.IndexGUI - 10)

	_GModText_Start("Default")
	_GModText_SetPos(0.01, 0.32)
	_GModText_SetTime(99999, 1, 0.5)
	_GModText_SetText("FOOD SPAWN MENU:\n\n1. Small Banana (" .. RoleplayData.CashPrefix .. S .. ")\n2. Medium Banana (" .. RoleplayData.CashPrefix .. M .. ")\n3. Large Banana (" .. RoleplayData.CashPrefix .. L .. ")\n4.\n5.\n6.\n7.\n8.\n9. Go Back\n\n0. Close")
 	_GModText_SetColor(255, 255, 255, 255)
	_GModText_Send(userid, (RoleplayData.IndexGUI - 10))
	
	_PlayerOption(userid, "BananaMenu", 99999)
end

function BananaMenu(userid, num, seconds)
	_GModText_Hide(userid, (RoleplayData.IndexGUI - 10), 0, 0)
	_GModRect_Hide(userid, (RoleplayData.IndexGUI - 10), 0, 0)

	if (num == 1) then 
		if RoleplayData.CheckFoodCost(userid, RoleplayData.BananaSmall) then return true end
		RoleplayData.MakeFood(userid, "models/props/cs_italy/bananna.mdl", "bananasmall")
		local Cost = RoleplayData.BananaSmall * RoleplayData.FoodMultiplier
		_PrintMessage(userid, 3, "You made a small banana with " .. RoleplayData.BananaSmall .. " food! (" .. RoleplayData.CashPrefix .. Cost .. ")")
	elseif (num == 2) then
		if RoleplayData.CheckFoodCost(userid, RoleplayData.BananaMedium) then return true end
		RoleplayData.MakeFood(userid, "models/props/cs_italy/bananna.mdl", "bananamedium")
		local Cost = RoleplayData.BananaMedium * RoleplayData.FoodMultiplier
		_PrintMessage(userid, 3, "You made a medium banana with " .. RoleplayData.BananaMedium .. " food! (" .. RoleplayData.CashPrefix .. Cost .. ")")	
	elseif (num == 3) then
		if RoleplayData.CheckFoodCost(userid, RoleplayData.BananaLarge) then return true end
		RoleplayData.MakeFood(userid, "models/props/cs_italy/bananna.mdl", "bananalarge")
		local Cost = RoleplayData.BananaLarge * RoleplayData.FoodMultiplier
		_PrintMessage(userid, 3, "You made a large banana with " .. RoleplayData.BananaLarge .. " food! (" .. RoleplayData.CashPrefix .. Cost .. ")")
	elseif (num == 9) then
		RoleplayData.FoodMenu(userid)
	elseif (num == 0) then
	_GModText_Hide(userid, (RoleplayData.IndexGUI - 10), 0.5, 0)
	_GModRect_Hide(userid, (RoleplayData.IndexGUI - 10), 0.5, 0)
	else -- Any other number
	RoleplayData.BananaMenu(userid)
	end
	
	if (num ~= 0) then 
	RoleplayData.FoodMenu(userid)
	end
end


-------------
-- Melon --
-------------
function RoleplayData.MelonMenu(userid)
	local S = RoleplayData.MelonSmall * RoleplayData.FoodMultiplier
	local M = RoleplayData.MelonMedium * RoleplayData.FoodMultiplier
	local L = RoleplayData.MelonLarge * RoleplayData.FoodMultiplier
		
	_GModRect_Start("gmod/white")
	_GModRect_SetPos(0.0, 0.3, 0.18, 0.28)
	_GModRect_SetColor(0, 0, 0, 100)
	_GModRect_SetTime(9999, 0.5, 0.5)
	_GModRect_Send(userid, RoleplayData.IndexGUI - 10)

	_GModText_Start("Default")
	_GModText_SetPos(0.01, 0.32)
	_GModText_SetTime(99999, 1, 0.5)
	_GModText_SetText("FOOD SPAWN MENU:\n\n1. Small Melon (" .. RoleplayData.CashPrefix .. S .. ")\n2. Medium Melon (" .. RoleplayData.CashPrefix .. M .. ")\n3. Large Melon (" .. RoleplayData.CashPrefix .. L .. ")\n4.\n5.\n6.\n7.\n8.\n9. Go Back\n\n0. Close")
 	_GModText_SetColor(255, 255, 255, 255)
	_GModText_Send(userid, (RoleplayData.IndexGUI - 10))
	
	_PlayerOption(userid, "MelonMenu", 99999)
end

function MelonMenu(userid, num, seconds)
	_GModText_Hide(userid, (RoleplayData.IndexGUI - 10), 0, 0)
	_GModRect_Hide(userid, (RoleplayData.IndexGUI - 10), 0, 0)

	if (num == 1) then 
		if RoleplayData.CheckFoodCost(userid, RoleplayData.MelonSmall) then return true end
		RoleplayData.MakeFood(userid, "models/props_junk/watermelon01.mdl", "melonsmall")
		local Cost = RoleplayData.MelonSmall * RoleplayData.FoodMultiplier
		_PrintMessage(userid, 3, "You made a small melon with " .. RoleplayData.MelonSmall .. " food! (" .. RoleplayData.CashPrefix .. Cost .. ")")
	elseif (num == 2) then
		if RoleplayData.CheckFoodCost(userid, RoleplayData.MelonMedium) then return true end
		RoleplayData.MakeFood(userid, "models/props_junk/watermelon01.mdl", "melonmedium")
		local Cost = RoleplayData.MelonMedium * RoleplayData.FoodMultiplier
		_PrintMessage(userid, 3, "You made a medium melon with " .. RoleplayData.MelonMedium .." food! (" .. RoleplayData.CashPrefix .. Cost .. ")")
	elseif (num == 3) then
		if RoleplayData.CheckFoodCost(userid, RoleplayData.MelonLarge) then return true end
		RoleplayData.MakeFood(userid, "models/props_junk/watermelon01.mdl", "melonlarge")
		local Cost = RoleplayData.MelonLarge * RoleplayData.FoodMultiplier
		_PrintMessage(userid, 3, "You made a large melon with " .. RoleplayData.MelonLarge .. " food! (" .. RoleplayData.CashPrefix .. Cost .. ")")
	elseif (num == 9) then
		RoleplayData.FoodMenu(userid)
	elseif (num == 0) then
	_GModText_Hide(userid, (RoleplayData.IndexGUI - 10), 0.5, 0)
	_GModRect_Hide(userid, (RoleplayData.IndexGUI - 10), 0.5, 0)
	else -- Any other number
	RoleplayData.MelonMenu(userid)
	end
	
	if (num ~= 0) then 
	RoleplayData.FoodMenu(userid)
	end
end


----------------
-- Sandwich --
----------------
function RoleplayData.SandwichMenu(userid)
	local S = RoleplayData.SandwichSmall * RoleplayData.FoodMultiplier
	local M = RoleplayData.SandwichMedium * RoleplayData.FoodMultiplier
	local L = RoleplayData.SandwichLarge * RoleplayData.FoodMultiplier
		
	_GModRect_Start("gmod/white")
	_GModRect_SetPos(0.0, 0.3, 0.18, 0.28)
	_GModRect_SetColor(0, 0, 0, 100)
	_GModRect_SetTime(9999, 0.5, 0.5)
	_GModRect_Send(userid, RoleplayData.IndexGUI - 10)

	_GModText_Start("Default")
	_GModText_SetPos(0.01, 0.32)
	_GModText_SetTime(99999, 1, 0.5)
	_GModText_SetText("FOOD SPAWN MENU:\n\n1. Small Sandwich (" .. RoleplayData.CashPrefix .. S .. ")\n2. Medium Sandwich (" .. RoleplayData.CashPrefix .. M .. ")\n3. Large Sandwich (" .. RoleplayData.CashPrefix .. L .. ")\n4.\n5.\n6.\n7.\n8.\n9. Go Back\n\n0. Close")
 	_GModText_SetColor(255, 255, 255, 255)
	_GModText_Send(userid, (RoleplayData.IndexGUI - 10))
	
	_PlayerOption(userid, "SandwichMenu", 99999)
end

function SandwichMenu(userid, num, seconds)
	_GModText_Hide(userid, (RoleplayData.IndexGUI - 10), 0, 0)
	_GModRect_Hide(userid, (RoleplayData.IndexGUI - 10), 0, 0)

	if (num == 1) then 
		if RoleplayData.CheckFoodCost(userid, RoleplayData.SandwichSmall) then return true end
		RoleplayData.MakeFood(userid, "models/NeoDement/BigSandwich.mdl", "sandwichsmall")
		local Cost = RoleplayData.SandwichSmall * RoleplayData.FoodMultiplier
		_PrintMessage(userid, 3, "You made a small sandwich with " .. RoleplayData.SandwichSmall .. " food! (" .. RoleplayData.CashPrefix .. Cost .. ")")
	elseif (num == 2) then
		if RoleplayData.CheckFoodCost(userid, RoleplayData.SandwichMedium) then return true end
		RoleplayData.MakeFood(userid, "models/NeoDement/BigSandwich.mdl", "sandwichmedium")
		local Cost = RoleplayData.SandwichMedium * RoleplayData.FoodMultiplier
		_PrintMessage(userid, 3, "You made a medium sandwich with " .. RoleplayData.SandwichMedium .." food! (" .. RoleplayData.CashPrefix .. Cost .. ")")
	elseif (num == 3) then
		if RoleplayData.CheckFoodCost(userid, RoleplayData.SandwichLarge) then return true end
		RoleplayData.MakeFood(userid, "models/NeoDement/BigSandwich.mdl", "sandwichlarge")
		local Cost = RoleplayData.SandwichLarge * RoleplayData.FoodMultiplier
		_PrintMessage(userid, 3, "You made a large sandwich with " .. RoleplayData.SandwichLarge .. " food! (" .. RoleplayData.CashPrefix .. Cost .. ")")	elseif (num == 9) then
		RoleplayData.FoodMenu(userid)
	elseif (num == 0) then
	_GModText_Hide(userid, (RoleplayData.IndexGUI - 10), 0.5, 0)
	_GModRect_Hide(userid, (RoleplayData.IndexGUI - 10), 0.5, 0)
	else -- Any other number
	RoleplayData.SandwichMenu(userid)
	end
	
	if (num ~= 0) then 
	RoleplayData.FoodMenu(userid)
	end
end

----------
-- Milk --
----------
function RoleplayData.MilkMenu(userid)
	_GModRect_Start("gmod/white")
	_GModRect_SetPos(0.0, 0.3, 0.18, 0.28)
	_GModRect_SetColor(0, 0, 0, 100)
	_GModRect_SetTime(9999, 0.5, 0.5)
	_GModRect_Send(userid, RoleplayData.IndexGUI - 10)

	_GModText_Start("Default")
	_GModText_SetPos(0.01, 0.32)
	_GModText_SetTime(99999, 1, 0.5)
	_GModText_SetText("FOOD SPAWN MENU:\n\n1. 1 Milk (" .. RoleplayData.CashPrefix .. "1" .. ")\n2. 2 Milk (" .. RoleplayData.CashPrefix .. "1.90" .. ")\n3. 3 Milk (" .. RoleplayData.CashPrefix .. "2.80" .. ")\n4. 4 Milk (" .. RoleplayData.CashPrefix .. "3.70" .. ")\n5. 5 Milk (" .. RoleplayData.CashPrefix .. "4.60" .. ")\n6.\n7.\n8.\n9. Go Back\n\n0. Close")
 	_GModText_SetColor(255, 255, 255, 255)
	_GModText_Send(userid, (RoleplayData.IndexGUI - 10))
	
	_PlayerOption(userid, "MilkMenu", 99999)
end

function MilkMenu(userid, num, seconds)
	_GModText_Hide(userid, (RoleplayData.IndexGUI - 10), 0, 0)
	_GModRect_Hide(userid, (RoleplayData.IndexGUI - 10), 0, 0)

	if (num == 1) then 
		if RoleplayData.CheckFoodCost(userid, 1) then return true end
		RoleplayData.MakeFood(userid, "models/props_junk/garbage_milkcarton002a.mdl", "milk")
		_PrintMessage(userid, 3, "You made 1 Milk (" .. RoleplayData.CashPrefix .. "1" .. ")")
	elseif (num == 2) then
		if RoleplayData.CheckFoodCost(userid, 1.9) then return true end
		RoleplayData.MakeFood(userid, "models/props_junk/garbage_milkcarton002a.mdl", "milk")
		_PrintMessage(userid, 3, "You made 2 Milk (" .. RoleplayData.CashPrefix .. "1.90" .. ")")
	elseif (num == 3) then
		if RoleplayData.CheckFoodCost(userid, 2.8) then return true end
		RoleplayData.MakeFood(userid, "models/props_junk/garbage_milkcarton002a.mdl", "milk")
		_PrintMessage(userid, 3, "You made 3 Milk (" .. RoleplayData.CashPrefix .. "2.80" .. ")")
	elseif (num == 4) then
		if RoleplayData.CheckFoodCost(userid, 3.7) then return true end
		RoleplayData.MakeFood(userid, "models/props_junk/garbage_milkcarton002a.mdl", "milk")
		_PrintMessage(userid, 3, "You made 4 Milk (" .. RoleplayData.CashPrefix .. "3.70" .. ")")
	elseif (num == 5) then
		if RoleplayData.CheckFoodCost(userid, 4.6) then return true end
		RoleplayData.MakeFood(userid, "models/props_junk/garbage_milkcarton002a.mdl", "milk")
		_PrintMessage(userid, 3, "You made 5 Milk (" .. RoleplayData.CashPrefix .. "4.60" .. ")")
	elseif (num == 0) then
	_GModText_Hide(userid, (RoleplayData.IndexGUI - 10), 0.5, 0)
	_GModRect_Hide(userid, (RoleplayData.IndexGUI - 10), 0.5, 0)
	else -- Any other number
	RoleplayData.MilkMenu(userid)
	end
	
	if (num ~= 0) then 
	RoleplayData.FoodMenu(userid)
	end
end
