function RoleplayData.CreateNPCChef(userid, pos, ang)
	if RoleplayData.isAdmin(userid) or (userid == 0) then
	local angle = _PlayerGetShootAng(userid)
	if ang == nil or pos == nil or pos == "" then
	_TraceLine(_PlayerGetShootPos(userid), angle, 1000, userid)
	end
		
	local f = _EntCreate("filter_damage_type")
	_EntSetKeyValue(f, "damagetype", "4194304")
	_EntSetKeyValue(f, "Negated", "0")
	_EntSetKeyValue(f, "targetname", "npc_chef_f")	
	_EntSpawn(f)
	
	local NPC = _EntCreate("generic_actor")
	if pos == nil or pos == "" then
	_EntSetPos(NPC, vecAdd(_TraceEndPos(), vector3(0,0,64)))
	else
	_EntSetPos(NPC, pos)
	end
	if ang == nil then
	angle.x = -angle.x
	angle.y = -angle.y
	angle.z = 0
	_EntSetAng(NPC, angle)
	else
	_EntSetAng(NPC, ang)
	end
	_EntPrecacheModel("models/gman.mdl")
	_EntSetKeyValue(NPC, "model", "models/gman.mdl")
	_EntSetCollisionGroup(NPC, COLLISION_GROUP_NPC)
	_EntSetSolid(NPC, SOLID_VPHYSICS)
	_EntSetMoveType(NPC, MOVETYPE_NOCLIP)
	_EntSetKeyValue(NPC, "damagefilter", "npc_chef_f")
	_EntSetKeyValue(NPC, "hull_name", "HUMAN_HULL")
	_EntSetKeyValue(NPC, "spawnflags", "8848")
	_EntSetName(NPC, "npc_chef")
	_EntSpawn(NPC)
	_EntActivate(NPC)		
	end
end
CONCOMMAND("rp_chefcreate", RoleplayData.CreateNPCChef)

function RoleplayData.OnChefUse(userid, ent)
	if _EntGetName(ent) == "npc_chef" then
	RoleplayData.FoodMenuBuyBuy(userid)
	end
end 

function RoleplayData.SaveChefPos(userid)
	if not RoleplayData.isAdmin(userid) then return _PrintMessage(userid, 1, "Access Denied!") end
	local npcs = _EntitiesFindByName("npc_chef")
	local map = _GetCurrentMap()
	local s = ""
		for k,v in npcs do
		local pos = _EntGetPos(v)
		local ang = _EntGetAng(v)
		s = s .. "RoleplayData.CreateNPCChef(0, vector3("..pos.x..","..pos.y..","..pos.z.."), vector3("..ang.x..","..ang.y..","..ang.z.."))\n"
		end
	if s ~= "" then
	_file.Write("lua/gamemodes/UCRPM/data/" .. map .. ".lua", s)
	_PrintMessage(userid, 1, "NPC Chefs positions saved successfully!")
	else
	_PrintMessage(userid, 1, "There is no NPC Chefs to save!")
	end
end
CONCOMMAND("rp_chefsave", RoleplayData.SaveChefPos)

function RoleplayData.LoadChefPos(userid)
	if not RoleplayData.isAdmin(userid) then return _PrintMessage(userid, 1, "Access Denied!") end
	local npcs = _EntitiesFindByName("npc_chef")
	local map = _GetCurrentMap()
	if _file.Exists("lua/gamemodes/UCRPM/data/" .. map .. ".lua") then
		for k,v in npcs do
		_EntRemove(v)
		end
	local load = _file.Read("lua/gamemodes/UCRPM/data/" .. map .. ".lua")
	_RunString(load)
	_PrintMessage(userid, 1, "Saved NPC Chefs loaded!")
	else
	_PrintMessage(userid, 1, "There is no save file for this map!")
	end
end
CONCOMMAND("rp_chefload", RoleplayData.LoadChefPos)

function RoleplayData.CheckBuyRange(userid)
	local sphere = _EntitiesFindInSphere(_EntGetPos(userid), RoleplayData.BuyRange)
	for k,v in sphere do
		if _EntGetName(v) == "npc_chef" then
		return true
		end
	end
	_PrintMessage(userid, 3, "You are too far away from the Chef!")
	return false
end


-----------------------
----- MENU ---------
-----------------------

-- NPC Chef Menu
--- Written by CBMz
---- Credit goes to Robbis_1 (aka Killer HAHA) for the base and helping

function RoleplayData.CheckMoney(userid, amount)
	if RoleplayData.CheckBuyRange(userid) then
		if amount <= RoleplayData[userid].Cash then
			return true
		else
			_PrintMessage(userid, 3, "You don't have enough money!")
			return false
		end
	end
end 


function RoleplayData.FoodMenuBuyBuy(userid)
	local MilkC = ( RoleplayData.Milk * RoleplayData.FoodMultiplier ) * 1.5
	local EggsC = ( RoleplayData.Eggs * RoleplayData.FoodMultiplier ) * 1.4
	local FlourC = ( RoleplayData.Flour * RoleplayData.FoodMultiplier ) * 1.5
	local AppleC = ( RoleplayData.Apple * RoleplayData.FoodMultiplier ) * 1.5

	_GModRect_Start("gmod/white")
	_GModRect_SetPos(0.0, 0.3, 0.18, 0.28)
	_GModRect_SetColor(0, 0, 0, 100)
	_GModRect_SetTime(9999, 0.5, 0.5)
	_GModRect_Send(userid, RoleplayData.IndexGUI - 10)

	_GModText_Start("Default")
	_GModText_SetPos(0.01, 0.32)
	_GModText_SetTime(99999, 1, 0.5)
	_GModText_SetText("FOOD BUY MENU:\n\n1. Orange\n2. Banana\n3. Melon\n4. Sandwich\n5. Milk (" .. RoleplayData.CashPrefix .. MilkC .. ")\n6. Egg (" .. RoleplayData.CashPrefix .. EggsC .. ")\n7. Flour (" .. RoleplayData.CashPrefix .. FlourC .. ")\n8. Apple (" .. RoleplayData.CashPrefix .. AppleC .. ")\n9. Next Page\n\n0. Close")
 	_GModText_SetColor(255, 255, 255, 255)
	_GModText_Send(userid, (RoleplayData.IndexGUI - 10))
	
	_PlayerOption(userid, "FoodMenuBuy1", 99999)
end

function FoodMenuBuy1(userid, num, seconds)
	if (num == 1) then 
		RoleplayData.OrangeBuyMenu(userid)
	elseif (num == 2) then
		RoleplayData.BananaBuyMenu(userid)
	elseif (num == 3) then
		RoleplayData.MelonBuyMenu(userid)
	elseif (num == 4) then
		RoleplayData.SandwichBuyMenu(userid)
	elseif (num == 5) then
		local Cost = ( RoleplayData.Milk * RoleplayData.FoodMultiplier ) * 1.5
		_GModText_Hide(userid, (RoleplayData.IndexGUI - 10), 0, 0)
		_GModRect_Hide(userid, (RoleplayData.IndexGUI - 10), 0, 0)
		if not RoleplayData.CheckMoney(userid, Cost) then return true end
		_PrintMessage(userid, 3, "You bought some Milk with " .. RoleplayData.Milk .. " food! (" .. RoleplayData.CashPrefix .. Cost .. ")")
		RoleplayData.Inventory.Pickup(userid, "milk")
		RoleplayData.TakeMoney(userid, Cost)
	elseif (num == 6) then
		local Cost = ( RoleplayData.Eggs * RoleplayData.FoodMultiplier ) * 1.4
		_GModText_Hide(userid, (RoleplayData.IndexGUI - 10), 0, 0)
		_GModRect_Hide(userid, (RoleplayData.IndexGUI - 10), 0, 0)
		if not RoleplayData.CheckMoney(userid, Cost) then return true end
		_PrintMessage(userid, 3, "You bought an egg with " .. RoleplayData.Eggs .. " food! (" .. RoleplayData.CashPrefix .. Cost .. ")")
		RoleplayData.Inventory.Pickup(userid, "egg")
		RoleplayData.TakeMoney(userid, Cost)
	elseif (num == 7) then
		local Cost = ( RoleplayData.Flour * RoleplayData.FoodMultiplier ) * 1.5
		_GModText_Hide(userid, (RoleplayData.IndexGUI - 10), 0, 0)
		_GModRect_Hide(userid, (RoleplayData.IndexGUI - 10), 0, 0)
		if not RoleplayData.CheckMoney(userid, Cost) then return true end
		_PrintMessage(userid, 3, "You bought a flour bag with " .. RoleplayData.Flour .. " food! (" .. RoleplayData.CashPrefix .. Cost .. ")")
		RoleplayData.Inventory.Pickup(userid, "flour")
		RoleplayData.TakeMoney(userid, Cost)
	elseif (num == 8) then
		local Cost = ( RoleplayData.Apple * RoleplayData.FoodMultiplier ) * 1.5
		_GModText_Hide(userid, (RoleplayData.IndexGUI - 10), 0, 0)
		_GModRect_Hide(userid, (RoleplayData.IndexGUI - 10), 0, 0)
		if not RoleplayData.CheckMoney(userid, Cost) then return true end
		_PrintMessage(userid, 3, "You bought an apple with " .. RoleplayData.Apple .. " food! (" .. RoleplayData.CashPrefix .. Cost .. ")")
		RoleplayData.Inventory.Pickup(userid, "apple")
		RoleplayData.TakeMoney(userid, Cost)
	elseif (num == 9) then
		RoleplayData.FoodMenuBuyBuy2(userid) -- not used
	elseif (num == 0) then
	_GModText_Hide(userid, (RoleplayData.IndexGUI - 10), 0.5, 0)
	_GModRect_Hide(userid, (RoleplayData.IndexGUI - 10), 0.5, 0)
	else
	RoleplayData.FoodMenuBuyBuy(userid)
	end
end

function RoleplayData.FoodMenuBuyBuy2(userid)
	local DoughnutC = ( RoleplayData.Doughnut * RoleplayData.FoodMultiplier ) * 1.5
	local PieC = ( RoleplayData.Pie * RoleplayData.FoodMultiplier ) * 1.5
	_GModRect_Start("gmod/white")
	_GModRect_SetPos(0.0, 0.3, 0.18, 0.28)
	_GModRect_SetColor(0, 0, 0, 100)
	_GModRect_SetTime(9999, 0.5, 0.5)
	_GModRect_Send(userid, RoleplayData.IndexGUI - 10)

	_GModText_Start("Default")
	_GModText_SetPos(0.01, 0.32)
	_GModText_SetTime(99999, 1, 0.5)
	_GModText_SetText("FOOD BUY MENU:\n\n1. Doughnut (" .. RoleplayData.CashPrefix .. DoughnutC .. ")\n2. Pie (" .. RoleplayData.CashPrefix .. PieC .. ")\n3.\n4.\n5.\n6.\n7.\n8.\n9. Go Back\n\n0. Close")
 	_GModText_SetColor(255, 255, 255, 255)
	_GModText_Send(userid, (RoleplayData.IndexGUI - 10))
	
	_PlayerOption(userid, "FoodMenuBuy2", 99999)
end

function FoodMenuBuy2(userid, num, seconds)
	if (num == 1) then
		local Cost = ( RoleplayData.Doughnut * RoleplayData.FoodMultiplier ) * 1.5
		_GModText_Hide(userid, (RoleplayData.IndexGUI - 10), 0, 0)
		_GModRect_Hide(userid, (RoleplayData.IndexGUI - 10), 0, 0)
		if not RoleplayData.CheckMoney(userid, Cost) then return true end
		_PrintMessage(userid, 3, "You bought a doughnut with " .. RoleplayData.Doughnut .. " food! (" .. RoleplayData.CashPrefix .. Cost .. ")")
		RoleplayData.Inventory.Pickup(userid, "doughnut")
		RoleplayData.TakeMoney(userid, Cost)
	elseif (num == 2) then
		local Cost = ( RoleplayData.Pie * RoleplayData.FoodMultiplier ) * 1.5
		_GModText_Hide(userid, (RoleplayData.IndexGUI - 10), 0, 0)
		_GModRect_Hide(userid, (RoleplayData.IndexGUI - 10), 0, 0)
		if not RoleplayData.CheckMoney(userid, Cost) then return true end
		_PrintMessage(userid, 3, "You bought a pie with " .. RoleplayData.Pie .. " food! (" .. RoleplayData.CashPrefix .. Cost .. ")")
		RoleplayData.Inventory.Pickup(userid, "pie")
		RoleplayData.TakeMoney(userid, Cost)
	elseif (num == 9) then
		RoleplayData.FoodMenuBuyBuy(userid)
	elseif (num == 0) then
	_GModText_Hide(userid, (RoleplayData.IndexGUI - 10), 0.5, 0)
	_GModRect_Hide(userid, (RoleplayData.IndexGUI - 10), 0.5, 0)
	end

end

-------------
-- Orange --
-------------
function RoleplayData.OrangeBuyMenu(userid)
	local S =  ( RoleplayData.OrangeSmall * RoleplayData.FoodMultiplier ) * 1.5
	local M = ( RoleplayData.OrangeMedium * RoleplayData.FoodMultiplier ) * 1.5
	local L = ( RoleplayData.OrangeLarge * RoleplayData.FoodMultiplier ) * 1.5
		
	_GModRect_Start("gmod/white")
	_GModRect_SetPos(0.0, 0.3, 0.18, 0.28)
	_GModRect_SetColor(0, 0, 0, 100)
	_GModRect_SetTime(9999, 0.5, 0.5)
	_GModRect_Send(userid, RoleplayData.IndexGUI - 10)

	_GModText_Start("Default")
	_GModText_SetPos(0.01, 0.32)
	_GModText_SetTime(99999, 1, 0.5)
	_GModText_SetText("FOOD BUY MENU:\n\n1. Small Orange (" .. RoleplayData.CashPrefix .. S .. ")\n2. Medium Orange (" .. RoleplayData.CashPrefix .. M .. ")\n3. Large Orange (" .. RoleplayData.CashPrefix .. L .. ")\n4.\n5.\n6.\n7.\n8.\n9. Go Back\n\n0. Close")
 	_GModText_SetColor(255, 255, 255, 255)
	_GModText_Send(userid, (RoleplayData.IndexGUI - 10))
	
	_PlayerOption(userid, "OrangeBuyMenu", 99999)
end

function OrangeBuyMenu(userid, num, seconds)
	_GModText_Hide(userid, (RoleplayData.IndexGUI - 10), 0, 0)
	_GModRect_Hide(userid, (RoleplayData.IndexGUI - 10), 0, 0)

	if (num == 1) then 

		local Cost = ( RoleplayData.OrangeSmall * RoleplayData.FoodMultiplier ) * 1.5
		if not RoleplayData.CheckMoney(userid, Cost) then return true end
		_PrintMessage(userid, 3, "You bought a small orange with " .. RoleplayData.OrangeSmall .. " food! (" .. RoleplayData.CashPrefix .. Cost .. ")")
		RoleplayData.TakeMoney(userid, Cost)
		RoleplayData.Inventory.Pickup(userid, "orangesmall")
	elseif (num == 2) then
		local Cost = ( RoleplayData.OrangeMedium * RoleplayData.FoodMultiplier ) * 1.5
		if not RoleplayData.CheckMoney(userid, Cost) then return true end
		_PrintMessage(userid, 3, "You bought a medium orange with " .. RoleplayData.OrangeMedium .. " food! (" .. RoleplayData.CashPrefix .. Cost .. ")")
		RoleplayData.TakeMoney(userid, Cost)
		RoleplayData.Inventory.Pickup(userid, "orangemedium")
	elseif (num == 3) then
		local Cost = ( RoleplayData.OrangeLarge * RoleplayData.FoodMultiplier ) * 1.5
		if not RoleplayData.CheckMoney(userid, Cost) then return true end
		_PrintMessage(userid, 3, "You bought a large orange with " .. RoleplayData.OrangeLarge .. " food! (" .. RoleplayData.CashPrefix .. Cost .. ")")
		RoleplayData.TakeMoney(userid, Cost)
		RoleplayData.Inventory.Pickup(userid, "orangelarge")
	elseif (num == 9) then
		RoleplayData.FoodMenuBuyBuy(userid)
	elseif (num == 0) then
	_GModText_Hide(userid, (RoleplayData.IndexGUI - 10), 0.5, 0)
	_GModRect_Hide(userid, (RoleplayData.IndexGUI - 10), 0.5, 0)
	else -- Any other number
	RoleplayData.OrangeBuyMenu(userid)
	end
	
	if (num ~= 0) then 
	--RoleplayData.FoodMenuBuyBuy(userid)
	end
end


-------------
-- Banana --
-------------
function RoleplayData.BananaBuyMenu(userid)
	local S = ( RoleplayData.BananaSmall * RoleplayData.FoodMultiplier ) * 1.5
	local M = ( RoleplayData.BananaMedium * RoleplayData.FoodMultiplier ) * 1.5
	local L = ( RoleplayData.BananaLarge * RoleplayData.FoodMultiplier ) * 1.5
		
	_GModRect_Start("gmod/white")
	_GModRect_SetPos(0.0, 0.3, 0.18, 0.28)
	_GModRect_SetColor(0, 0, 0, 100)
	_GModRect_SetTime(9999, 0.5, 0.5)
	_GModRect_Send(userid, RoleplayData.IndexGUI - 10)

	_GModText_Start("Default")
	_GModText_SetPos(0.01, 0.32)
	_GModText_SetTime(99999, 1, 0.5)
	_GModText_SetText("FOOD BUY MENU:\n\n1. Small Banana (" .. RoleplayData.CashPrefix .. S .. ")\n2. Medium Banana (" .. RoleplayData.CashPrefix .. M .. ")\n3. Large Banana (" .. RoleplayData.CashPrefix .. L .. ")\n4.\n5.\n6.\n7.\n8.\n9. Go Back\n\n0. Close")
 	_GModText_SetColor(255, 255, 255, 255)
	_GModText_Send(userid, (RoleplayData.IndexGUI - 10))
	
	_PlayerOption(userid, "BananaBuyMenu", 99999)
end

function BananaBuyMenu(userid, num, seconds)
	_GModText_Hide(userid, (RoleplayData.IndexGUI - 10), 0, 0)
	_GModRect_Hide(userid, (RoleplayData.IndexGUI - 10), 0, 0)

	if (num == 1) then 
		local Cost = ( RoleplayData.BananaSmall * RoleplayData.FoodMultiplier ) * 1.5
		if not RoleplayData.CheckMoney(userid, Cost) then return true end
		_PrintMessage(userid, 3, "You bought a small banana with " .. RoleplayData.BananaSmall .. " food! (" .. RoleplayData.CashPrefix .. Cost .. ")")
		RoleplayData.TakeMoney(userid, Cost)
		RoleplayData.Inventory.Pickup(userid, "bananasmall")
	elseif (num == 2) then
		local Cost = ( RoleplayData.BananaMedium * RoleplayData.FoodMultiplier ) * 1.5
		if not RoleplayData.CheckMoney(userid, Cost) then return true end
		_PrintMessage(userid, 3, "You bought a medium banana with " .. RoleplayData.BananaMedium .. " food! (" .. RoleplayData.CashPrefix .. Cost .. ")")
		RoleplayData.TakeMoney(userid, Cost)
		RoleplayData.Inventory.Pickup(userid, "bananamedium")	
	elseif (num == 3) then
		local Cost = ( RoleplayData.BananaLarge * RoleplayData.FoodMultiplier ) * 1.5
		if not RoleplayData.CheckMoney(userid, Cost) then return true end
		_PrintMessage(userid, 3, "You bought a large banana with " .. RoleplayData.BananaLarge .. " food! (" .. RoleplayData.CashPrefix .. Cost .. ")")
		RoleplayData.TakeMoney(userid, Cost)
		RoleplayData.Inventory.Pickup(userid, "bananalarge")
	elseif (num == 9) then
		RoleplayData.FoodMenuBuyBuy(userid)
	elseif (num == 0) then
	_GModText_Hide(userid, (RoleplayData.IndexGUI - 10), 0.5, 0)
	_GModRect_Hide(userid, (RoleplayData.IndexGUI - 10), 0.5, 0)
	else -- Any other number
	RoleplayData.BananaBuyMenu(userid)
	end
	
	if (num ~= 0) then 
	--RoleplayData.FoodMenuBuyBuy(userid)
	end
end


-------------
-- Melon --
-------------
function RoleplayData.MelonBuyMenu(userid)
	local S = ( RoleplayData.MelonSmall * RoleplayData.FoodMultiplier ) * 1.5
	local M = ( RoleplayData.MelonMedium * RoleplayData.FoodMultiplier ) * 1.5
	local L = ( RoleplayData.MelonLarge * RoleplayData.FoodMultiplier ) * 1.5
		
	_GModRect_Start("gmod/white")
	_GModRect_SetPos(0.0, 0.3, 0.18, 0.28)
	_GModRect_SetColor(0, 0, 0, 100)
	_GModRect_SetTime(9999, 0.5, 0.5)
	_GModRect_Send(userid, RoleplayData.IndexGUI - 10)

	_GModText_Start("Default")
	_GModText_SetPos(0.01, 0.32)
	_GModText_SetTime(99999, 1, 0.5)
	_GModText_SetText("FOOD BUY MENU:\n\n1. Small Melon (" .. RoleplayData.CashPrefix .. S .. ")\n2. Medium Melon (" .. RoleplayData.CashPrefix .. M .. ")\n3. Large Melon (" .. RoleplayData.CashPrefix .. L .. ")\n4.\n5.\n6.\n7.\n8.\n9. Go Back\n\n0. Close")
 	_GModText_SetColor(255, 255, 255, 255)
	_GModText_Send(userid, (RoleplayData.IndexGUI - 10))
	
	_PlayerOption(userid, "MelonBuyMenu", 99999)
end

function MelonBuyMenu(userid, num, seconds)
	_GModText_Hide(userid, (RoleplayData.IndexGUI - 10), 0, 0)
	_GModRect_Hide(userid, (RoleplayData.IndexGUI - 10), 0, 0)

	if (num == 1) then 
		local Cost = ( RoleplayData.MelonSmall * RoleplayData.FoodMultiplier ) * 1.5
		if not RoleplayData.CheckMoney(userid, Cost) then return true end
		_PrintMessage(userid, 3, "You bought a small melon with " .. RoleplayData.MelonSmall .. " food! (" .. RoleplayData.CashPrefix .. Cost .. ")")
		RoleplayData.TakeMoney(userid, Cost)
		RoleplayData.Inventory.Pickup(userid, "melonsmall")
	elseif (num == 2) then
		local Cost = ( RoleplayData.MelonMedium * RoleplayData.FoodMultiplier ) * 1.5
		if not RoleplayData.CheckMoney(userid, Cost) then return true end
		_PrintMessage(userid, 3, "You bought a medium melon with " .. RoleplayData.MelonMedium .." food! (" .. RoleplayData.CashPrefix .. Cost .. ")")
		RoleplayData.TakeMoney(userid, Cost)
		RoleplayData.Inventory.Pickup(userid, "melonmedium")
	elseif (num == 3) then
		local Cost = ( RoleplayData.MelonLarge * RoleplayData.FoodMultiplier ) * 1.5
		if not RoleplayData.CheckMoney(userid, Cost) then return true end
		_PrintMessage(userid, 3, "You bought a large melon with " .. RoleplayData.MelonLarge .. " food! (" .. RoleplayData.CashPrefix .. Cost .. ")")
		RoleplayData.TakeMoney(userid, Cost)
		RoleplayData.Inventory.Pickup(userid, "melonlarge")
	elseif (num == 9) then
		RoleplayData.FoodMenuBuyBuy(userid)
	elseif (num == 0) then
	_GModText_Hide(userid, (RoleplayData.IndexGUI - 10), 0.5, 0)
	_GModRect_Hide(userid, (RoleplayData.IndexGUI - 10), 0.5, 0)
	else -- Any other number
	RoleplayData.MelonBuyMenu(userid)
	end
	
	if (num ~= 0) then 
	--RoleplayData.FoodMenuBuyBuy(userid)
	end
end


----------------
-- Sandwich --
----------------
function RoleplayData.SandwichBuyMenu(userid)
	local S = ( RoleplayData.SandwichSmall * RoleplayData.FoodMultiplier ) * 1.5
	local M = ( RoleplayData.SandwichMedium * RoleplayData.FoodMultiplier ) * 1.5
	local L = ( RoleplayData.SandwichLarge * RoleplayData.FoodMultiplier ) * 1.5
		
	_GModRect_Start("gmod/white")
	_GModRect_SetPos(0.0, 0.3, 0.18, 0.28)
	_GModRect_SetColor(0, 0, 0, 100)
	_GModRect_SetTime(9999, 0.5, 0.5)
	_GModRect_Send(userid, RoleplayData.IndexGUI - 10)

	_GModText_Start("Default")
	_GModText_SetPos(0.01, 0.32)
	_GModText_SetTime(99999, 1, 0.5)
	_GModText_SetText("FOOD BUY MENU:\n\n1. Small Sandwich (" .. RoleplayData.CashPrefix .. S .. ")\n2. Medium Sandwich (" .. RoleplayData.CashPrefix .. M .. ")\n3. Large Sandwich (" .. RoleplayData.CashPrefix .. L .. ")\n4.\n5.\n6.\n7.\n8.\n9. Go Back\n\n0. Close")
 	_GModText_SetColor(255, 255, 255, 255)
	_GModText_Send(userid, (RoleplayData.IndexGUI - 10))
	
	_PlayerOption(userid, "SandwichBuyMenu", 99999)
end

function SandwichBuyMenu(userid, num, seconds)
	_GModText_Hide(userid, (RoleplayData.IndexGUI - 10), 0, 0)
	_GModRect_Hide(userid, (RoleplayData.IndexGUI - 10), 0, 0)

	if (num == 1) then 
		local Cost = ( RoleplayData.SandwichSmall * RoleplayData.FoodMultiplier ) * 1.5
		if not RoleplayData.CheckMoney(userid, Cost) then return true end
		_PrintMessage(userid, 3, "You bought a small sandwich with " .. RoleplayData.SandwichSmall .. " food! (" .. RoleplayData.CashPrefix .. Cost .. ")")
		RoleplayData.TakeMoney(userid, Cost)
		RoleplayData.Inventory.Pickup(userid, "sandwichsmall")
	elseif (num == 2) then
		local Cost = ( RoleplayData.SandwichMedium * RoleplayData.FoodMultiplier ) * 1.5
		if not RoleplayData.CheckMoney(userid, Cost) then return true end
		_PrintMessage(userid, 3, "You bought a medium sandwich with " .. RoleplayData.SandwichMedium .." food! (" .. RoleplayData.CashPrefix .. Cost .. ")")
		RoleplayData.TakeMoney(userid, Cost)
		RoleplayData.Inventory.Pickup(userid, "sandwichmedium")
	elseif (num == 3) then
		local Cost = ( RoleplayData.SandwichLarge * RoleplayData.FoodMultiplier ) * 1.5
		if not RoleplayData.CheckMoney(userid, Cost) then return true end
		_PrintMessage(userid, 3, "You bought a large sandwich with " .. RoleplayData.SandwichLarge .. " food! (" .. RoleplayData.CashPrefix .. Cost .. ")")
		RoleplayData.TakeMoney(userid, Cost)
		RoleplayData.Inventory.Pickup(userid, "sandwichlarge")
	elseif (num == 9) then
		RoleplayData.FoodMenuBuyBuy(userid)
	elseif (num == 0) then
	_GModText_Hide(userid, (RoleplayData.IndexGUI - 10), 0.5, 0)
	_GModRect_Hide(userid, (RoleplayData.IndexGUI - 10), 0.5, 0)
	else -- Any other number
	RoleplayData.SandwichBuyMenu(userid)
	end
	
	if (num ~= 0) then 
	--RoleplayData.FoodMenuBuyBuy(userid)
	end
end
