	function onPrimaryAttack( )	
		_EntEmitSoundEx(Owner, "weapons/scout/scout_fire-1.wav", 1, 2.5)
		
		local Dart = _EntCreate("prop_physics")
		_EntPrecacheModel("models/Items/AR2_Grenade.mdl")
		_EntSetModel(Dart, "models/Items/AR2_Grenade.mdl")
		_EntSetAng(Dart, _PlayerGetShootAng(Owner))
		_EntSetPos(Dart, _PlayerGetShootPos(Owner))
		_EntSetName(Dart, "tranquilizer_dart")
		_EntSetOwner(Dart, Owner)
		_EntSpawn(Dart)
		_EntFire(Dart, "kill", "", 20)
		_phys.SetMass(Dart, 2)
		_phys.EnableGravity(Dart, false)
		_phys.ApplyForceCenter(Dart, vecMul(_PlayerGetShootAng(Owner), 999999))
		
		_SWEPUseAmmo(MyIndex, 0, 1)
	end
	
	function onSecondaryAttack()
	--_EntRemove(MyIndex)
	end
	
	function onPickup(playerid)
		_RunString([[
		if RoleplayData[]]..playerid..[[].Team == TEAM_RED then
		_EntRemove(]]..MyIndex..[[)
		end
		]])
	end
	
	function onDrop(playerid)
		_EntRemove(MyIndex)
	end

-- When player presses reload. Returning false means DONT RELOAD. Although this will hitch on the client.

	function onReload( )
		return true;

	end

	
	function getHUDMaterial() 
		return "VGUI/gfx/VGUI/scout.vmt";
	end


-- These are only accessed once when setting up the weapon

	

	function getWeaponSwapHands()

		return true;	

	end

	

	function getWeaponFOV()

		return 70;	

	end

	

	function getWeaponSlot()

		return 4;	

	end

	

	function getWeaponSlotPos()

		return 2;	

	end

	

	function getFiresUnderwater()

		return false;

	end

	

	function getReloadsSingly()

		return false;

	end

	



	

	-- Primary Attack

	

	function getDamage()

		return 0;

	end

	

	function getPrimaryShotDelay()
		return 1;
	end

		

	function getPrimaryIsAutomatic()
		return false;
	end

			

	function getBulletSpread()
		return vector3( 0, 0, 0 );
	end

	

	function getViewKick()

		return vector3( -3.5, 0.0, 0.0);

	end

	

	function getViewKickRandom()
		return vector3( 0.5, 0.3, 0.3 );
	end

		

	function getNumShotsPrimary()

		return 1;

	end

	

	function getPrimaryAmmoType()

		return "pistol";

	end

	

	-- Secondary attack

	

	function getDamageSecondary()

		return 30;

	end

	

	function getSecondaryShotDelay()

		return 0;

	end

	

	function getSecondaryIsAutomatic()

		return false;

	end

	

	function getBulletSpreadSecondary()

		return vector3( 0.001, 0.001, 0.001 );

	end

	

	function getViewKickSecondary()

		return vector3( 0.5, 0.0, 0.0);

	end

	

	function getViewKickRandomSecondary()

		return vector3( 0.5, 0.5, 0.2 );

	end

	

	function getNumShotsSecondary()

		return 15;

	end

	

	function getSecondaryAmmoType()

		return "none";

	end

	

	



	function getViewModel( )
		return "models/weapons/v_snip_scout.mdl";
	end
	
	function getWorldModel( )
		return "models/weapons/w_snip_scout.mdl";
	end

	

	function getClassName() 

		return "weapon_rp_tranqulizer";

	end


	function getMaxClipPrimary() -- return -1 if it doesn't use clips

		return 3;

	end

	

	function getMaxClipSecondary() -- return -1 if it doesn't use clips

		return 1;

	end

	

	function getDefClipPrimary() -- ammo in gun by default

		return 50;

	end

	

	function getDefClipSecondary()

		return 1;

	end



	

	function getAnimPrefix() -- How the player holds the weapon: pistol, smg, ar2, shotgun, rpg, phys, crossbow, melee, slam, grenade

		return "ar2";

	end



	function getPrintName()

		return "Tranquilizer Rifle";

	end

	

	

	-- 0 = Don't override, shoot bullets, make sound and flash

	-- 1 = Don't shoot bullets but do make flash/sounds

	-- 2 = Only play animations

	-- 3 = Don't do anything

	

	function getPrimaryScriptOverride()

		return 2;

	end



	function getSecondaryScriptOverride()

		return 3;

	end 