--[[
	Title: ULib init

	Opens everything needed by ULib. It handles multiple loadings itself, 
	so you do not need to worry about it.
]]

--- If we haven't already loaded ULib, load it!
if not ULib then
--[[
	Table: ULib

	Contains ULib. Everything in ULib is within this table, and should be used with "ULib." infront of it.
]]
	ULib = {}
	
--[[
	Function: openScript
	
	This is similar to GMod 9's normal ULib.openScript, but it will return nil if the file did not load right.

	Parameters:

		file - The file to load.
		
	Returns:
	
		True on success, nil and error otherwise.
]]
function ULib.openScript( file )
	if not _file.Exists( "lua/" .. file ) then return nil, "File does not exist." end
	
	str = _file.Read( "lua/" .. file )
	local obj, err = loadstring( str )
	if obj then
		obj() -- Put it into our environment
		return true
	else
		return nil, err
	end
end

-- We don't want any other scipts using this.
local function major_error( err )
	_file.Write( "lua/ULib/crash.log", err )
	_Msg( "[ULib] ERROR: " .. err .. "\n" )

	local function rep( userid )
		_PrintMessage( userid, HUD_PRINTTALK, "ULib had a fatal error! Please look at lua/ULib/crash.log" )
		_PrintMessage( userid, HUD_PRINTCONSOLE, "ULib had a fatal error! Please look at lua/ULib/crash.log" )
	end

	if ULib.commands then
		for command, t in pairs( ULib.commands ) do
			CONCOMMAND( command, rep )
		end
	end
	
	function ULib.CONCOMMAND( command )
		CONCOMMAND( command, rep )
	end

	AddTimer( 30, 1, _PrintMessageAll, HUD_PRINTTALK, "ULib had a fatal error! Please look at lua/ULib/crash.log" )
	AddTimer( 30, 1, _PrintMessageAll, HUD_PRINTCONSOLE, "ULib had a fatal error! Please look at lua/ULib/crash.log" )
	AddTimer( 30, 1, major_error, err )
end

local function openScript( file )
	local status, err = ULib.openScript( file )
	if not status then
		if file ~= "ULib/ucl_public.lua" then
			major_error( err .. " in file " .. file )
		else
			major_error( "Crashed loading ucl_public.lua, this is usually due to incorrect syntax in users.ini. Please make sure you have the correct syntax in this file." )
		end
	end
end

	_Msg( "///////////////////////////////\n" )
	_Msg( "//      Ulysses Library      //\n" )
	_Msg( "///////////////////////////////\n" )
	_Msg( "// Loading...                //\n" )

       	_Msg( "//  defines.lua              //\n" )
	openScript( "ULib/defines.lua" )
	_Msg( "//  misc.lua                 //\n" )
	openScript( "ULib/misc.lua" )
	_Msg( "//  util.lua                 //\n" )
	openScript( "ULib/util.lua" )
	_Msg( "//  tables.lua               //\n" )
	openScript( "ULib/tables.lua" )
	_Msg( "//  database.lua             //\n" )
	openScript( "ULib/database.lua" )
	_Msg( "//  ai.lua                   //\n" )
	openScript( "ULib/ai.lua" )
	_Msg( "//  color.lua                //\n" )
	openScript( "ULib/color.lua" )
	_Msg( "//  concommand.lua           //\n" )
	openScript( "ULib/concommand.lua" )
	_Msg( "//  download.lua             //\n" )
	openScript( "ULib/download.lua" )
	_Msg( "//  entity.lua               //\n" )
	openScript( "ULib/entity.lua" )
	_Msg( "//  list.lua                 //\n" )
	openScript( "ULib/list.lua" )
	_Msg( "//  menu.lua                 //\n" )
	openScript( "ULib/menu.lua" )
	_Msg( "//    menu_skins/default.lua //\n" )
	openScript( "ULib/menu_skins/default.lua" )
	_Msg( "//    menu_skins/round.lua   //\n" )
	openScript( "ULib/menu_skins/round.lua" )
	_Msg( "//  messages.lua             //\n" )
	openScript( "ULib/messages.lua" )
	_Msg( "//  misc.lua                 //\n" )
	openScript( "ULib/misc.lua" )
	_Msg( "//  phys.lua                 //\n" )
	openScript( "ULib/phys.lua" )
	_Msg( "//  player.lua               //\n" )
	openScript( "ULib/player.lua" )
	_Msg( "//  say.lua                  //\n" )
	openScript( "ULib/say.lua" )
	_Msg( "//  ucl.lua                  //\n" )
	openScript( "ULib/ucl.lua" )
	_Msg( "//  ucl_public.lua           //\n" )
	openScript( "ULib/ucl_public.lua" )
	_Msg( "//  vector.lua               //\n" )
	openScript( "ULib/vector.lua" )
	_Msg( "//  compat.lua               //\n" )
	openScript( "ULib/compat.lua" )
	_Msg( "//  log.lua                  //\n" )
	openScript( "ULib/log.lua" )
	_Msg( "//  ulib_plugin.lua          //\n" )
	openScript( "ULib/ulib_plugin.lua" )

	_Msg( "// Load Complete!            //\n" )
	_Msg( "///////////////////////////////\n" )
end