--[[
	Title: Round menu skin

	ULib's round menu skin. To see the full skin callback API, see menu_skins/default.lua
	If you'd like to use this skin in your mod with ULib, or modify if and include it, GO AHEAD!
	
	Revisions:
	
		v1.2 - Initial
]]

ULib.round_skin = {}
ULib.round_skin.prev = "Previous Page"
ULib.round_skin.next = "Next Page"
ULib.round_skin.exit = "Exit"
ULib.round_skin.max_options = 10
ULib.round_skin.bind_options = true

local menuColor = { r=255, g=80, b=80, a=220 }
local textColor = { r=255, g=255, b=255, a=255 }
local disabledTextColor = { r=175, g=175, b=175, a=255 }

local menuPos = { x=0.025, y=0.35, w=0.2, h=0.29 }
local textPos = { x=0.045, y=0.375, spacing=0.02, titlespace=0.02 }

local rectKey = 589
local textKey = 590 -- This is where to start, this skin will take (max_options+1) keys

function ULib.round_skin.showMenu( userid, title, page_options, timeout, page, menu )
	--ULib.sendRect( userid, rectKey, 0.025, 0.35, .2, .3, 1000, 75, 180, 255, 220, "ULib/menu" )
	--ULib.sendRect( userid, titleKey, 0.06, 0.325, .07, .045, 1000, 255, 255, 255, 220, "ulx/title" )

	ULib.sendRect( userid, rectKey, menuPos.x, menuPos.y, menuPos.w, menuPos.h, timeout, menuColor.r, menuColor.g, menuColor.b, menuColor.a, "ULib/menu" )

	ULib.sendText( userid, textKey, textPos.x, textPos.y, "    " .. title, timeout, textColor.r, textColor.g, textColor.b, textColor.a )
	for k, v in pairs( page_options ) do
		if v.disabled then
			ULib.sendText( userid, textKey + k, textPos.x, textPos.y + k * textPos.spacing + textPos.titlespace, math.mod( k, 10 ) .. ". " .. v.text, timeout, disabledTextColor.r, disabledTextColor.g, disabledTextColor.b, disabledTextColor.a ) -- Mod so 10 shows up as 0
		else
			ULib.sendText( userid, textKey + k, textPos.x, textPos.y + k * textPos.spacing + textPos.titlespace, math.mod( k, 10 ) .. ". " .. v.text, timeout, textColor.r, textColor.g, textColor.b, textColor.a ) -- Mod so 10 shows up as 0
		end
	end
end

function ULib.round_skin.hideMenu( userid, page_options, page, menu )
	for i=textKey, textKey + ULib.round_skin.max_options + 1 do
		_GModText_Hide( userid, i )
	end
	_GModRect_Hide( userid, rectKey )
	--_GModRect_Hide( userid, titleKey )
end

function ULib.round_skin.startVote( userid, time, voteMenu )
end

function ULib.round_skin.updateVote( userid, optionid, time, text, voteMenu )
end

function ULib.round_skin.endVote( winning_id, winning_text, total_votes, total_voters, voteMenu )
end