--[[
	Title: Vector

	This file contains vector manipulation functions
]]

--[[
	Function: vecEqual

	Checks if two vectors are equal

	Parameters:

		v1 - The first vector
		v2 - The second vector

	Returns:

		True if equal, false otherwise.
		
	Revisions:
	
		v1 - Initial
]]
function ULib.vecEqual( v1, v2 )
	if v1.x == v2.x and v1.y == v2.y and v1.z == v2.z then
		return true
	else
		return false
	end
end


--[[
	Function: vecCopy

	Returns a copy of a vector

	Parameters:

		v1 - The vector to copy

	Revisions:
	
		v1 - Initial
]]
function ULib.vecCopy( v1 )
	return vector3( v1.x, v1.y, v1.z )
end