function gmx.distBetweenVecs(vectorA,vectorB)
	if gmx.allValid({vectorA,vectorB})==false then return gmx.error("gmx.distBetweenVecs - Arguments invalid.") end
	return vecLength(vecSub(vectorA,vectorB));
end

function gmx.angBetweenVecs(vectorA,vectorB)
	if gmx.allValid({vectorA,vectorB})==false then return gmx.error("gmx.angBetweenVecs - Arguments invalid.") end
	return vecNormalize(vecSub(vectorA,vectorB));
end

function gmx.polorOffset(where,angle,distance)
	if gmx.allValid({where,angle,distance})==false then return gmx.error("gmx.polorOffset - Arguments invalid.") end
	return vecAdd(where,vecMul(vecNormalize(angle),distance));
end

function gmx.isVector(data)
	if gmx.isValid(data,"userdata")==false then return false end
	if gmx.allValid({data.x,data.y,data.z},{"number","number","number"}) then
		return true;
	else
		return false;
	end
end

function gmx.vectorToTable(v)
	if gmx.isVector(v)==false then return gmx.error("gmx.vectorToTable - Arguments invalid.") end
	local newTable={};
	newTable.x=v.x;
	newTable.y=v.y;
	newTable.z=v.z;
	return newTable;
end

--The following three functions are created by GeoGriff
--http://forum.facepunchstudios.com/showthread.php?t=71795

function gmx.vectorToAngle(unitVec)
	if gmx.isVector(unitVec)==false then return gmx.error("gmx.vectorToAngle - Arguments invalid.") end
	local elevAngle = math.asin(unitVec.z);
	local dirAngle = math.acos(unitVec.x / math.cos(elevAngle));
	if (unitVec.y < 0) then
		dirAngle = -(dirAngle);
	end
	return vector3(math.deg(dirAngle), math.deg(elevAngle), 0);
end

function gmx.angleToVector(angleVec)
	if gmx.isVector(angleVec)==false then return gmx.error("gmx.angleToVector - Arguments invalid.") end
	return vector3(math.cos(math.rad(angleVec.x))*math.cos(math.rad(angleVec.y)),math.sin(math.rad(angleVec.x))*math.cos(math.rad(angleVec.y)),math.sin(math.rad(angleVec.y)));
end

function gmx.vecLinMul(vector, multiplier)
	return vector3(vector.x*multiplier,vector.y*multiplier,vector.z*multiplier);
end 