

-- DO NOT EDIT THIS FILE!

-- When an event is called it also calls this function which allows you to hook into
-- the events without overriding the main gamemode event.
-- event hooks are called AFTER the gamemode hook.

-- To add a hook:
--
--  AddHook( "eventPlayerSay", functionname );
--


g_EvenHooks = {}
ShowEvents = false;


	-- NEVER CALL THIS FUNCTION DIRECTLY
	function DoEventHook( name, ... )
		
		-- Developing? Want to see what events are being called?
		-- in the HL2 console:
		--
		-- ShowEvents = true;
		--
		if ( ShowEvents ) then
			Msg( "CLua Event: [" .. arg.n  .."]  " .. name .. "( " );
			for i=1, arg.n do
				
				Msg( tostring( arg[i] ) );
				if ( i < arg.n ) then Msg( ", " );	end
				
			end 
			Msg( " )\n" );
		end
		
		
		for k, v in g_EvenHooks do

			

			if ( g_EvenHooks[k] and g_EvenHooks[k].name == name ) then
			
				g_EvenHooks[k].func( unpack(arg) );
			end
			
		end
		
	end

	
	function AddHook( name, func )

		local i = 0;
		while ( g_EvenHooks[i] ) do
			i = i + 1
		end
		
		g_EvenHooks[i] = {};
		g_EvenHooks[i].name = name;
		g_EvenHooks[i].func = func;
		
		return i;
		
	end
	
	
	function UnHookEvent( num )
		
		g_EvenHooks[num] = nil;
		
	end
