--##############################
--## Hide and Seek
--## fayte, gdhughes@gmail.com
--## Map by MrSteak63
--##############################


--# Hider score generation - this number affects how often Hiders are
--# awarded points for not getting caught. 9 seems to work well on 
--# most maps, however for larger maps you might want to increase it
--# slightly to keep the scores balanced. Experiment for yourself!

HIDER_SCORE_MODIFIER = 9




--###############################################################
--################## DO NOT EDIT BEYOND HERE! ###################
--###############################################################

_PrintMessageAll(3, "Starting the Hide and Seek gamemode.")

_GameSetTargetIDRules(3)

for userid=0, _MaxPlayers() do
	_PlayerChangeTeam( userid, TEAM_SPECTATOR )
	_EntSpawn( userid )
end

_TeamSetScore(2, 0)
_TeamSetScore(4, 0)

isFound = {}
numFound = 0

roundNum = 1

function DrawScores( player )

	_GModText_Start( "ChatFont" )
	_GModText_SetPos( 0.015, 0.015 )
	_GModText_SetColor( 255, 255, 255, 255 )
	_GModText_SetTime( 99999, 0, 0 )
	_GModText_SetText( "Hide and Seek     Round " .. roundNum .. "     Press F2 for team selection     Hiders: " .. _TeamScore(2) .. " points     Seekers: " .. _TeamScore(4) .. " points" )
	_GModText_SetDelay( 0 )
	_GModText_Send( player, 2 )

end

function gamerulesThink() 

	if (_TeamNumPlayers(2) < 1) and (numFound > 0) then
		_PrintMessageAll( 3, "All Hiders have been found. A new round begins in a few seconds." )
		if _TeamScore(2) > _TeamScore(4) then
			_PrintMessageAll( 3, "The Hiders won that round with " .. _TeamScore(2) .. " points! " )
		elseif _TeamScore(2) < _TeamScore(4) then
			_PrintMessageAll( 3, "The Seekers won that round with " .. _TeamScore(4) .. " points!" )		
		else
			_PrintMessageAll( 3, "Both teams tied with " .. _TeamScore(2) .. " points!" )		
		end
		_TeamSetScore(2, 0)
		_TeamSetScore(4, 0)
		isFound = {}
		numFound = 0
		roundNum = roundNum + 1 
		for userid=0, _MaxPlayers() do
			_PlayerChangeTeam( userid, TEAM_SPECTATOR )
			_EntSpawn( userid )
		end
	end
	
end

function eventPlayerSay( userid, text, team )
	if _PlayerInfo( userid, "team" ) == 1 then
		for listid=1, _MaxPlayers() do
			if _PlayerInfo( listid, "team" ) == 1 then
				_PrintMessage( listid, 3, "*SPEC* " .. text )
			end
		end
		return ""
	end
	return text
end

function eventPlayerSpawn( userid )
	if isFound[userid] then
		if _TeamNumPlayers(2) > 1 then
			_PrintMessage( userid, 3, "You are spectating. Please wait until the round ends." )
		end
		_PlayerChangeTeam( userid, TEAM_SPECTATOR )
	elseif _PlayerInfo( userid, "team" ) == TEAM_SPECTATOR then
		onShowTeam( userid )	
	elseif _PlayerInfo( userid, "team" ) == TEAM_GREEN then
		_PrintMessage( userid, 3, "You have spawned as a Seeker." )
		_EntFire( userid, "Alpha", 255, 0 )
	else
		_PrintMessage( userid, 3, "You have spawned as a Hider. Hide for as long as possible." )
		_PrintMessage(userid, 3, "You have been granted invisibility for 30 seconds. Use this time to hide!" )
		_EntFire( userid, "Alpha", 0, 0 )
		_EntSetMaterial( userid, "models/props_c17/fisheyelens" )
		AddTimer( 30, 1, MakeHiderVisible, userid )
	end
	
	DrawScores( userid );
end

function MakeHiderVisible( userid ) 
	if _PlayerInfo( userid, "team" ) ~= 2 then return; end
	if _PlayerInfo( userid, "alive" ) ~= true then return; end
	_EntFire( userid, "Alpha", 30, 0 )
	_PrintMessage( userid, 3, "You are now visible - all Seekers can see you." )
	_PlayerGiveItem( userid, "weapon_physcannon" )
	AddTimer( _TeamNumPlayers(2) * HIDER_SCORE_MODIFIER, 1, IncreaseHiderScore, userid )
end

function IncreaseHiderScore( userid ) 
	if _PlayerInfo( userid, "team" ) ~= 2 then return; end
	if _PlayerInfo( userid, "alive" ) ~= true then return; end
	if _TeamNumPlayers(4) > 0 then _TeamAddScore( 2, 1 ); end
	AddTimer( _TeamNumPlayers(2) * HIDER_SCORE_MODIFIER, 1, IncreaseHiderScore, userid )
	
	DrawScores( 0 );
end

function eventPlayerActive ( name, userid, steamid )
	_PlayerChangeTeam( userid, TEAM_SPECTATOR )
	_EntSpawn( userid )

	DrawScores( userid );
end

function GiveDefaultItems( userid )
	if _PlayerInfo( userid, "team" ) == 4 then
		_PlayerGiveSWEP( userid, "weapons/hideandseek/weapon_catcher.lua" )
	end
end

function onShowTeam( userid )
	if isFound[userid] then 
		_PrintMessage( userid, 3, "Please wait for the next round until you change your team.")
		return
	end
	_PlayerOption( userid, "TeamSelect", 99999 )
	_GModText_Start( "ChatFont" )
	_GModText_SetPos( -1, -1 )
	_GModText_SetColor( 255, 255, 255, 255 )
	_GModText_SetTime( 99999, 0.3, 0.3 )
	_GModText_SetText( "Choose your team:\n\n\n1. Hiders\n2. Seekers\n\n\nPress 3 to close." )
	_GModText_SetDelay( 0.5 )
	_GModText_Send( userid, 1 )
end

function TeamSelect( userid, team, seconds )
	_GModText_Hide( userid, 1, 0.5, 0 )
	if isFound[userid] then 
		_PrintMessage( userid, 3, "Please wait for the next round until you change your team.")
		return
	end
	if team == 1 then
		if ( _PlayerInfo( userid, "team" ) == TEAM_BLUE ) then return; end
		_PlayerChangeTeam( userid, TEAM_BLUE )
		_EntSetKeyValue( userid, "rendermode", 1 )
		_EntSpawn( userid )
	elseif team == 2 then
		if ( _PlayerInfo( userid, "team" ) == TEAM_GREEN ) then return; end
		_PlayerChangeTeam( userid, TEAM_GREEN )
		_EntSetKeyValue( userid, "rendermode", 1 )
		_EntSpawn( userid )
	end
end

function weaponFires( Owner ) 
	 local vecpos = _PlayerGetShootPos( Owner );
  	 local plyang = _PlayerGetShootAng( Owner );
  	 _TraceLine( vecpos, plyang, 4096, Owner );
	
	if not _PlayerInfo( Owner, "alive" ) then return; end
	if not _TraceHit() then return; end
	if _EntGetType( _TraceGetEnt() ) ~= "player" then return; end
	if _PlayerInfo( _TraceGetEnt(), "team" ) ~= 2 then return; end
	if _PlayerInfo( Owner, "team" ) ~= 4 then return; end
	
	userid = _TraceGetEnt()
	numFound = numFound + 1
	isFound[userid] = true

	_PrintMessage( _TraceGetEnt(), 4, "You were found!" )	
	_PrintMessageAll( 3, _PlayerInfo(_TraceGetEnt(), "name") .. " was found by " .. _PlayerInfo(Owner, "name") .. "!" )

	_TeamAddScore( 4, 7 )

	_PlayerSilentKill( _TraceGetEnt(), 1, true )
	
	DrawScores( 0 );
	
end