------------------------------------------------

--  Variable defines.

--  You should never change this file.

------------------------------------------------





-- Used to make the PrintMessageAll and PrintMessage functions more readable

	HUD_PRINTNOTIFY		=	1
	HUD_PRINTCONSOLE	=	2
	HUD_PRINTTALK		=	3
	HUD_PRINTCENTER		=	4



-- When a player doesn't have a model this is reported as their model
-- YOU SHOULD NEVER CHANGE THIS VALUE IT'S JUST USED AS A MACRO SO WE
-- DON'T HAVE TO TYPE OUT THE FILENAME ALL THE TIME!

	DEFAULT_PLAYER_MODEL =	"models/player.mdl"


-- Team names so we don't have to remember numbers

	TEAM_UNASSIGNED	=	0 -- When there are no teams all players should be this
	TEAM_SPECTATOR	=	1 -- Not used
	TEAM_BLUE		=	2
	TEAM_YELLOW		=	3
	TEAM_GREEN		=	4
	TEAM_RED		=	5
	

-- Target ID Rules  ( for use with _GameSetTargetIDRules )

	TRGTID_NOENEMYHEALTH 	= 0
	TRGTID_ENEMYHEALTH 		= 1
	TRGTID_ENEMYONLY 		= 2
	TRGTID_TEAMONLY 		= 3
	TRGTID_ALL 				= 4
	TRGTID_ALLNOHEALTH 		= 5
	TRGTID_NONE 			= 6
	

-- Entity dispositions

	D_ER	= 	0	-- Undefined - error
	D_HT	= 	1	-- Hate
	D_FR	= 	2	-- Fear
	D_LI	= 	3	-- Like
	D_NU	= 	4	-- Neutral

-- Observer modes



	OBS_MODE_NONE 			= 0	-- not in spectator mode
	OBS_MODE_DEATHCAM 		= 1	-- special mode for detah cam animation
	OBS_MODE_FIXED 			= 2	-- view from a fixed camera position
	OBS_MODE_IN_EYE 		= 3	-- follow a player in first perosn view
	OBS_MODE_CHASE 			= 4	-- follow a player in third person view
	OBS_MODE_ROAMING 		= 5	-- free roaming


-- IN KEYS



	IN_ATTACK				= 1
	IN_JUMP					= 2
	IN_DUCK					= 4
	IN_FORWARD				= 8
	IN_BACK					= 16
	IN_USE					= 32
	IN_CANCEL				= 64
	IN_LEFT					= 128
	IN_RIGHT				= 256
	IN_MOVELEFT				= 512
	IN_MOVERIGHT			= 1024
	IN_ATTACK2				= 2048
	IN_RUN					= 4096
	IN_RELOAD				= 8192
	IN_ALT1					= 16384
	IN_ALT2					= 32768
	IN_SCORE				= 65536 	-- Used by client.dll for when scoreboard is held down
	IN_SPEED				= 131072	-- Player is holding the speed key
	IN_WALK					= 262144	-- Player holding walk key
	IN_ZOOM					= 524288	-- Zoom key for HUD zoom
	IN_WEAPON1				= 1048576	-- weapon defines these bits
	IN_WEAPON2				= 2097152	-- weapon defines these bits
	IN_BULLRUSH				= 4194304


-- MOVETYPES

	MOVETYPE_NONE			= 0		-- never moves
	MOVETYPE_ISOMETRIC		= 1		-- For players -- in TF2 commander view, etc.
	MOVETYPE_WALK			= 2		-- Player only - moving on the ground
	MOVETYPE_STEP			= 3		-- gravity, special edge handling -- monsters use this
	MOVETYPE_FLY			= 4		-- No gravity, but still collides with stuff
	MOVETYPE_FLYGRAVITY		= 5		-- flies through the air + is affected by gravity
	MOVETYPE_VPHYSICS		= 6		-- uses VPHYSICS for simulation
	MOVETYPE_PUSH			= 7		-- no clip to world, push and crush
	MOVETYPE_NOCLIP			= 8		-- No gravity, no collisions, still do velocity/avelocity
	MOVETYPE_LADDER			= 9		-- Used by players only when going onto a ladder
	MOVETYPE_OBSERVER		= 10	-- Observer movement, depends on player's observer mode
	MOVETYPE_CUSTOM			= 11	-- Allows the entity to describe its own physics

-- MOVE COLLIDES

	MOVECOLLIDE_DEFAULT 	= 0
	MOVECOLLIDE_FLY_BOUNCE	= 1 	-- bounces, reflects, based on elasticity of surface and object - applies friction (adjust velocity)
	MOVECOLLIDE_FLY_CUSTOM	= 2 	-- Touch() will modify the velocity however it likes
	MOVECOLLIDE_FLY_SLIDE	= 3 	-- slides along surfaces (no bounce) - applies friciton (adjusts velocity)

-- SOLID TYPES

	SOLID_NONE			= 0 	-- no solid model
	SOLID_BSP			= 1 	-- a BSP tree
	SOLID_BBOX			= 2 	-- an AABB
	SOLID_OBB			= 3 	-- an OBB (not implemented yet)
	SOLID_OBB_YAW		= 4 	-- an OBB, constrained so that it can only yaw
	SOLID_CUSTOM		= 5 	-- Always call into the entity for tests
	SOLID_VPHYSICS		= 6

-- COLLISION GROUPS

	COLLISION_GROUP_NONE  				= 0		--
	COLLISION_GROUP_DEBRIS  			= 1		-- Collides with nothing but world and static stuff
	COLLISION_GROUP_DEBRIS_TRIGGER  	= 2		-- Same as debris, but hits triggers
	COLLISION_GROUP_INTERACTIVE_DEBRIS  = 3		-- Collides with everything except other interactive debris or debris
	COLLISION_GROUP_INTERACTIVE  		= 4		-- Collides with everything except interactive debris or debris
	COLLISION_GROUP_PLAYER  			= 5		--
	COLLISION_GROUP_BREAKABLE_GLASS  	= 6		--
	COLLISION_GROUP_VEHICLE  			= 7		--
	COLLISION_GROUP_PLAYER_MOVEMENT  	= 8		-- For HL2, same as Collision_Group_Player
	COLLISION_GROUP_NPC  				= 9		-- Generic NPC group
	COLLISION_GROUP_IN_VEHICLE  		= 10	-- for any entity inside a vehicle
	COLLISION_GROUP_WEAPON  			= 11	-- for any weapons that need collision detection
	COLLISION_GROUP_VEHICLE_CLIP  		= 12	-- vehicle clip brush to restrict vehicle movement
	COLLISION_GROUP_PROJECTILE  		= 13	-- Projectiles!
	COLLISION_GROUP_DOOR_BLOCKER  		= 14	-- Blocks entities not permitted to get near moving doors
	COLLISION_GROUP_PASSABLE_DOOR  		= 15	-- Doors that the player shouldn't collide with
	COLLISION_GROUP_DISSOLVING  		= 16	-- Things that are dissolving are in this group
	COLLISION_GROUP_PUSHAWAY  			= 17	-- Nonsolid on client and server, pushaway in player code
	
	
-- ACT sequences

	ACT_RESET					= 0
	ACT_IDLE					= 1
	ACT_TRANSITION					= 2
	ACT_COVER					= 3
	ACT_COVER_MED					= 4
	ACT_COVER_LOW					= 5
	ACT_WALK					= 6
	ACT_WALK_AIM					= 7
	ACT_WALK_CROUCH					= 8
	ACT_WALK_CROUCH_AIM					= 9
	ACT_RUN					= 10
	ACT_RUN_AIM					= 11
	ACT_RUN_CROUCH					= 12
	ACT_RUN_CROUCH_AIM					= 13
	ACT_RUN_PROTECTED					= 14
	ACT_SCRIPT_CUSTOM_MOVE					= 15
	ACT_RANGE_ATTACK1					= 16		-- can use with _PlayerSetWeaponSequence
	ACT_RANGE_ATTACK2					= 17
	ACT_RANGE_ATTACK1_LOW					= 18
	ACT_RANGE_ATTACK2_LOW					= 19
	ACT_DIESIMPLE					= 20
	ACT_DIEBACKWARD					= 21
	ACT_DIEFORWARD					= 22
	ACT_DIEVIOLENT					= 23
	ACT_DIERAGDOLL					= 24
	ACT_FLY					= 25
	ACT_HOVER					= 26
	ACT_GLIDE					= 27
	ACT_SWIM					= 28
	ACT_JUMP					= 29
	ACT_HOP					= 30
	ACT_LEAP					= 31
	ACT_LAND					= 32
	ACT_CLIMB_UP					= 33
	ACT_CLIMB_DOWN					= 34
	ACT_CLIMB_DISMOUNT					= 35
	ACT_SHIPLADDER_UP					= 36
	ACT_SHIPLADDER_DOWN					= 37
	ACT_STRAFE_LEFT					= 38
	ACT_STRAFE_RIGHT					= 39
	ACT_ROLL_LEFT					= 40
	ACT_ROLL_RIGHT					= 41
	ACT_TURN_LEFT					= 42
	ACT_TURN_RIGHT					= 43
	ACT_CROUCH					= 44
	ACT_CROUCHIDLE					= 45
	ACT_STAND					= 46
	ACT_USE					= 47
	ACT_SIGNAL1					= 48
	ACT_SIGNAL2					= 49
	ACT_SIGNAL3					= 50
	ACT_SIGNAL_ADVANCE					= 51
	ACT_SIGNAL_FORWARD					= 52
	ACT_SIGNAL_GROUP					= 53
	ACT_SIGNAL_HALT					= 54
	ACT_SIGNAL_LEFT					= 55
	ACT_SIGNAL_RIGHT					= 56
	ACT_SIGNAL_TAKECOVER					= 57
	ACT_LOOKBACK_RIGHT					= 58
	ACT_LOOKBACK_LEFT					= 59
	ACT_COWER					= 60
	ACT_SMALL_FLINCH					= 61
	ACT_BIG_FLINCH					= 62
	ACT_MELEE_ATTACK1					= 63
	ACT_MELEE_ATTACK2					= 64
	ACT_RELOAD					= 65
	ACT_RELOAD_LOW					= 66
	ACT_ARM					= 67
	ACT_DISARM					= 68
	ACT_PICKUP_GROUND					= 69
	ACT_PICKUP_RACK					= 70
	ACT_IDLE_ANGRY					= 71
	ACT_IDLE_RELAXED					= 72
	ACT_IDLE_STIMULATED					= 73
	ACT_IDLE_AGITATED					= 74
	ACT_WALK_RELAXED					= 75
	ACT_WALK_STIMULATED					= 76
	ACT_WALK_AGITATED					= 77
	ACT_RUN_RELAXED					= 78
	ACT_RUN_STIMULATED					= 79
	ACT_RUN_AGITATED					= 80
	ACT_IDLE_AIM_RELAXED					= 81
	ACT_IDLE_AIM_STIMULATED					= 82
	ACT_IDLE_AIM_AGITATED					= 83
	ACT_WALK_AIM_RELAXED					= 84
	ACT_WALK_AIM_STIMULATED					= 85
	ACT_WALK_AIM_AGITATED					= 86
	ACT_RUN_AIM_RELAXED					= 87
	ACT_RUN_AIM_STIMULATED					= 88
	ACT_RUN_AIM_AGITATED					= 89
	ACT_WALK_HURT					= 90
	ACT_RUN_HURT					= 91
	ACT_SPECIAL_ATTACK1					= 92
	ACT_SPECIAL_ATTACK2					= 93
	ACT_COMBAT_IDLE					= 94
	ACT_WALK_SCARED					= 95
	ACT_RUN_SCARED					= 96
	ACT_VICTORY_DANCE					= 97
	ACT_DIE_HEADSHOT					= 98
	ACT_DIE_CHESTSHOT					= 99
	ACT_DIE_GUTSHOT					= 100
	ACT_DIE_BACKSHOT					= 101
	ACT_FLINCH_HEAD					= 102
	ACT_FLINCH_CHEST					= 103
	ACT_FLINCH_STOMACH					= 104
	ACT_FLINCH_LEFTARM					= 105
	ACT_FLINCH_RIGHTARM					= 106
	ACT_FLINCH_LEFTLEG					= 107
	ACT_FLINCH_RIGHTLEG					= 108
	ACT_FLINCH_PHYSICS					= 109
	ACT_IDLE_ON_FIRE					= 110
	ACT_WALK_ON_FIRE					= 111
	ACT_RUN_ON_FIRE					= 112
	ACT_RAPPEL_LOOP					= 113
	ACT_180_LEFT					= 114
	ACT_180_RIGHT					= 115
	ACT_90_LEFT					= 116
	ACT_90_RIGHT					= 117
	ACT_STEP_LEFT					= 118
	ACT_STEP_RIGHT					= 119
	ACT_STEP_BACK					= 120
	ACT_STEP_FORE					= 121
	ACT_GESTURE_RANGE_ATTACK1					= 122
	ACT_GESTURE_RANGE_ATTACK2					= 123
	ACT_GESTURE_MELEE_ATTACK1					= 124
	ACT_GESTURE_MELEE_ATTACK2					= 125
	ACT_GESTURE_RANGE_ATTACK1_LOW					= 126
	ACT_GESTURE_RANGE_ATTACK2_LOW					= 127
	ACT_MELEE_ATTACK_SWING_GESTURE					= 128
	ACT_GESTURE_SMALL_FLINCH					= 129
	ACT_GESTURE_BIG_FLINCH					= 130
	ACT_GESTURE_FLINCH_BLAST					= 131
	ACT_GESTURE_FLINCH_HEAD					= 132
	ACT_GESTURE_FLINCH_CHEST					= 133
	ACT_GESTURE_FLINCH_STOMACH					= 134
	ACT_GESTURE_FLINCH_LEFTARM					= 135
	ACT_GESTURE_FLINCH_RIGHTARM					= 136
	ACT_GESTURE_FLINCH_LEFTLEG					= 137
	ACT_GESTURE_FLINCH_RIGHTLEG					= 138
	ACT_GESTURE_TURN_LEFT					= 139
	ACT_GESTURE_TURN_RIGHT					= 140
	ACT_GESTURE_TURN_LEFT45					= 141
	ACT_GESTURE_TURN_RIGHT45					= 142
	ACT_GESTURE_TURN_LEFT90					= 143
	ACT_GESTURE_TURN_RIGHT90					= 144
	ACT_GESTURE_TURN_LEFT45_FLAT					= 145
	ACT_GESTURE_TURN_RIGHT45_FLAT					= 146
	ACT_GESTURE_TURN_LEFT90_FLAT					= 147
	ACT_GESTURE_TURN_RIGHT90_FLAT					= 148
	ACT_BARNACLE_HIT					= 149
	ACT_BARNACLE_PULL					= 150
	ACT_BARNACLE_CHOMP					= 151
	ACT_BARNACLE_CHEW					= 152
	ACT_DO_NOT_DISTURB					= 153
	
	
	-- VIEW MODEL ANIMATIONS - use with _PlayerViewModelSequence
	
	ACT_VM_DRAW					= 154
	ACT_VM_HOLSTER					= 155
	ACT_VM_IDLE					= 156
	ACT_VM_FIDGET					= 157
	ACT_VM_PULLBACK					= 158
	ACT_VM_PULLBACK_HIGH					= 159
	ACT_VM_PULLBACK_LOW					= 160
	ACT_VM_THROW					= 161
	ACT_VM_PULLPIN					= 162
	ACT_VM_PRIMARYATTACK					= 163
	ACT_VM_SECONDARYATTACK					= 164
	ACT_VM_RELOAD					= 165
	ACT_VM_DRYFIRE					= 166
	ACT_VM_HITLEFT					= 167
	ACT_VM_HITLEFT2					= 168
	ACT_VM_HITRIGHT					= 169
	ACT_VM_HITRIGHT2					= 170
	ACT_VM_HITCENTER					= 171
	ACT_VM_HITCENTER2					= 172
	ACT_VM_MISSLEFT					= 173
	ACT_VM_MISSLEFT2					= 174
	ACT_VM_MISSRIGHT					= 175
	ACT_VM_MISSRIGHT2					= 176
	ACT_VM_MISSCENTER					= 177
	ACT_VM_MISSCENTER2					= 178
	ACT_VM_HAULBACK					= 179
	ACT_VM_SWINGHARD					= 180
	ACT_VM_SWINGMISS					= 181
	ACT_VM_SWINGHIT					= 182
	ACT_VM_IDLE_TO_LOWERED					= 183
	ACT_VM_IDLE_LOWERED					= 184
	ACT_VM_LOWERED_TO_IDLE					= 185
	ACT_VM_RECOIL1					= 186
	ACT_VM_RECOIL2					= 187
	ACT_VM_RECOIL3					= 188
	ACT_VM_ATTACH_SILENCER					= 189
	ACT_VM_DETACH_SILENCER					= 190
	
	
	ACT_SLAM_STICKWALL_IDLE					= 191
	ACT_SLAM_STICKWALL_ND_IDLE					= 192
	ACT_SLAM_STICKWALL_ATTACH					= 193
	ACT_SLAM_STICKWALL_ATTACH2					= 194
	ACT_SLAM_STICKWALL_ND_ATTACH					= 195
	ACT_SLAM_STICKWALL_ND_ATTACH2					= 196
	ACT_SLAM_STICKWALL_DETONATE					= 197
	ACT_SLAM_STICKWALL_DETONATOR_HOLSTER					= 198
	ACT_SLAM_STICKWALL_DRAW					= 199
	ACT_SLAM_STICKWALL_ND_DRAW					= 200
	ACT_SLAM_STICKWALL_TO_THROW					= 201
	ACT_SLAM_STICKWALL_TO_THROW_ND					= 202
	ACT_SLAM_STICKWALL_TO_TRIPMINE_ND					= 203
	ACT_SLAM_THROW_IDLE					= 204
	ACT_SLAM_THROW_ND_IDLE					= 205
	ACT_SLAM_THROW_THROW					= 206
	ACT_SLAM_THROW_THROW2					= 207
	ACT_SLAM_THROW_THROW_ND					= 208
	ACT_SLAM_THROW_THROW_ND2					= 209
	ACT_SLAM_THROW_DRAW					= 210
	ACT_SLAM_THROW_ND_DRAW					= 211
	ACT_SLAM_THROW_TO_STICKWALL					= 212
	ACT_SLAM_THROW_TO_STICKWALL_ND					= 213
	ACT_SLAM_THROW_DETONATE					= 214
	ACT_SLAM_THROW_DETONATOR_HOLSTER					= 215
	ACT_SLAM_THROW_TO_TRIPMINE_ND					= 216
	ACT_SLAM_TRIPMINE_IDLE					= 217
	ACT_SLAM_TRIPMINE_DRAW					= 218
	ACT_SLAM_TRIPMINE_ATTACH					= 219
	ACT_SLAM_TRIPMINE_ATTACH2					= 220
	ACT_SLAM_TRIPMINE_TO_STICKWALL_ND					= 221
	ACT_SLAM_TRIPMINE_TO_THROW_ND					= 222
	ACT_SLAM_DETONATOR_IDLE					= 223
	ACT_SLAM_DETONATOR_DRAW					= 224
	ACT_SLAM_DETONATOR_DETONATE					= 225
	ACT_SLAM_DETONATOR_HOLSTER					= 226
	ACT_SLAM_DETONATOR_STICKWALL_DRAW					= 227
	ACT_SLAM_DETONATOR_THROW_DRAW					= 228
	
	ACT_SHOTGUN_RELOAD_START					= 229
	ACT_SHOTGUN_RELOAD_FINISH					= 230
	ACT_SHOTGUN_PUMP					= 231
	ACT_SMG2_IDLE2					= 232
	ACT_SMG2_FIRE2					= 233
	ACT_SMG2_DRAW2					= 234
	ACT_SMG2_RELOAD2					= 235
	ACT_SMG2_DRYFIRE2					= 236
	ACT_SMG2_TOAUTO					= 237
	ACT_SMG2_TOBURST					= 238
	ACT_PHYSCANNON_UPGRADE					= 239
	ACT_RANGE_ATTACK_AR1					= 240
	ACT_RANGE_ATTACK_AR2					= 241
	ACT_RANGE_ATTACK_AR2_LOW					= 242
	ACT_RANGE_ATTACK_AR2_GRENADE					= 243
	ACT_RANGE_ATTACK_HMG1					= 244
	ACT_RANGE_ATTACK_ML					= 245
	ACT_RANGE_ATTACK_SMG1					= 246
	ACT_RANGE_ATTACK_SMG1_LOW					= 247
	ACT_RANGE_ATTACK_SMG2					= 248
	ACT_RANGE_ATTACK_SHOTGUN					= 249
	ACT_RANGE_ATTACK_SHOTGUN_LOW					= 250
	ACT_RANGE_ATTACK_PISTOL					= 251
	ACT_RANGE_ATTACK_PISTOL_LOW					= 252
	ACT_RANGE_ATTACK_SLAM					= 253
	ACT_RANGE_ATTACK_TRIPWIRE					= 254
	ACT_RANGE_ATTACK_THROW					= 255
	ACT_RANGE_ATTACK_SNIPER_RIFLE					= 256
	ACT_RANGE_ATTACK_RPG					= 257
	ACT_MELEE_ATTACK_SWING					= 258
	ACT_RANGE_AIM_LOW					= 259
	ACT_RANGE_AIM_SMG1_LOW					= 260
	ACT_RANGE_AIM_PISTOL_LOW					= 261
	ACT_RANGE_AIM_AR2_LOW					= 262
	ACT_COVER_PISTOL_LOW					= 263
	ACT_COVER_SMG1_LOW					= 264
	ACT_GESTURE_RANGE_ATTACK_AR1					= 265
	ACT_GESTURE_RANGE_ATTACK_AR2					= 266
	ACT_GESTURE_RANGE_ATTACK_AR2_GRENADE					= 267
	ACT_GESTURE_RANGE_ATTACK_HMG1					= 268
	ACT_GESTURE_RANGE_ATTACK_ML					= 269
	ACT_GESTURE_RANGE_ATTACK_SMG1					= 270
	ACT_GESTURE_RANGE_ATTACK_SMG1_LOW					= 271
	ACT_GESTURE_RANGE_ATTACK_SMG2					= 272
	ACT_GESTURE_RANGE_ATTACK_SHOTGUN					= 273
	ACT_GESTURE_RANGE_ATTACK_PISTOL					= 274
	ACT_GESTURE_RANGE_ATTACK_PISTOL_LOW					= 275
	ACT_GESTURE_RANGE_ATTACK_SLAM					= 276
	ACT_GESTURE_RANGE_ATTACK_TRIPWIRE					= 277
	ACT_GESTURE_RANGE_ATTACK_THROW					= 278
	ACT_GESTURE_RANGE_ATTACK_SNIPER_RIFLE					= 279
	ACT_GESTURE_MELEE_ATTACK_SWING					= 280
	ACT_IDLE_RIFLE					= 281
	ACT_IDLE_SMG1					= 282
	ACT_IDLE_ANGRY_SMG1					= 283
	ACT_IDLE_PISTOL					= 284
	ACT_IDLE_ANGRY_PISTOL					= 285
	ACT_IDLE_ANGRY_SHOTGUN					= 286
	ACT_IDLE_PACKAGE					= 287
	ACT_WALK_PACKAGE					= 288
	ACT_IDLE_SUITCASE					= 289
	ACT_WALK_SUITCASE					= 290
	ACT_IDLE_SMG1_RELAXED					= 291
	ACT_IDLE_SMG1_STIMULATED					= 292
	ACT_WALK_RIFLE_RELAXED					= 293
	ACT_RUN_RIFLE_RELAXED					= 294
	ACT_WALK_RIFLE_STIMULATED					= 295
	ACT_RUN_RIFLE_STIMULATED					= 296
	ACT_IDLE_AIM_RIFLE_STIMULATED					= 297
	ACT_WALK_AIM_RIFLE_STIMULATED					= 298
	ACT_RUN_AIM_RIFLE_STIMULATED					= 299
	ACT_IDLE_SHOTGUN_RELAXED					= 300
	ACT_IDLE_SHOTGUN_STIMULATED					= 301
	ACT_IDLE_SHOTGUN_AGITATED					= 302
	ACT_WALK_ANGRY					= 303
	ACT_POLICE_HARASS1					= 304
	ACT_POLICE_HARASS2					= 305
	ACT_IDLE_MANNEDGUN					= 306
	ACT_IDLE_MELEE					= 307
	ACT_IDLE_ANGRY_MELEE					= 308
	ACT_IDLE_RPG_RELAXED					= 309
	ACT_IDLE_RPG					= 310
	ACT_IDLE_ANGRY_RPG					= 311
	ACT_COVER_LOW_RPG					= 312
	ACT_WALK_RPG					= 313
	ACT_RUN_RPG					= 314
	ACT_WALK_CROUCH_RPG					= 315
	ACT_RUN_CROUCH_RPG					= 316
	ACT_WALK_RPG_RELAXED					= 317
	ACT_RUN_RPG_RELAXED					= 318
	ACT_WALK_RIFLE					= 319
	ACT_WALK_AIM_RIFLE					= 320
	ACT_WALK_CROUCH_RIFLE					= 321
	ACT_WALK_CROUCH_AIM_RIFLE					= 322
	ACT_RUN_RIFLE					= 323
	ACT_RUN_AIM_RIFLE					= 324
	ACT_RUN_CROUCH_RIFLE					= 325
	ACT_RUN_CROUCH_AIM_RIFLE					= 326
	ACT_WALK_AIM_SHOTGUN					= 327
	ACT_RUN_AIM_SHOTGUN					= 328
	ACT_WALK_AIM_PISTOL					= 329
	ACT_RUN_AIM_PISTOL					= 330
	ACT_RELOAD_PISTOL					= 331
	ACT_RELOAD_PISTOL_LOW					= 332
	ACT_RELOAD_SMG1					= 333
	ACT_RELOAD_SMG1_LOW					= 334
	ACT_GESTURE_RELOAD					= 335
	ACT_GESTURE_RELOAD_PISTOL					= 336
	ACT_GESTURE_RELOAD_SMG1					= 337
	ACT_BUSY_LEAN_LEFT					= 338
	ACT_BUSY_LEAN_LEFT_ENTRY					= 339
	ACT_BUSY_LEAN_LEFT_EXIT					= 340
	ACT_BUSY_LEAN_BACK					= 341
	ACT_BUSY_LEAN_BACK_ENTRY					= 342
	ACT_BUSY_LEAN_BACK_EXIT					= 343
	ACT_BUSY_SIT_GROUND					= 344
	ACT_BUSY_SIT_GROUND_ENTRY					= 345
	ACT_BUSY_SIT_GROUND_EXIT					= 346
	ACT_BUSY_SIT_CHAIR					= 347
	ACT_BUSY_SIT_CHAIR_ENTRY					= 348
	ACT_BUSY_SIT_CHAIR_EXIT					= 349
	ACT_BUSY_STAND					= 350
	ACT_BUSY_QUEUE					= 351
	ACT_DIE_BARNACLE_SWALLOW					= 352
	ACT_GESTURE_BARNACLE_STRANGLE					= 353
	ACT_PHYSCANNON_DETACH					= 354
	ACT_DIE_FRONTSIDE					= 355
	ACT_DIE_RIGHTSIDE					= 356
	ACT_DIE_BACKSIDE					= 357
	ACT_DIE_LEFTSIDE					= 358
	ACT_OPEN_DOOR					= 359
	ACT_STARTDYING					= 360
	ACT_DYINGLOOP					= 361
	ACT_DYINGTODEAD					= 362
	ACT_RIDE_MANNED_GUN					= 363
	ACT_VM_SPRINT_ENTER					= 364
	ACT_VM_SPRINT_IDLE					= 365
	ACT_VM_SPRINT_LEAVE					= 366
	ACT_FIRE_START					= 367
	ACT_FIRE_LOOP					= 368
	ACT_FIRE_END					= 369
	ACT_CROUCHING_GRENADEIDLE					= 370
	ACT_CROUCHING_GRENADEREADY					= 371
	ACT_CROUCHING_PRIMARYATTACK					= 372
	ACT_OVERLAY_GRENADEIDLE					= 373
	ACT_OVERLAY_GRENADEREADY					= 374
	ACT_OVERLAY_PRIMARYATTACK					= 375
	ACT_OVERLAY_SHIELD_UP					= 376
	ACT_OVERLAY_SHIELD_DOWN					= 377
	ACT_OVERLAY_SHIELD_UP_IDLE					= 378
	ACT_OVERLAY_SHIELD_ATTACK					= 379
	ACT_OVERLAY_SHIELD_KNOCKBACK					= 380
	ACT_SHIELD_UP					= 381
	ACT_SHIELD_DOWN					= 382
	ACT_SHIELD_UP_IDLE					= 383
	ACT_SHIELD_ATTACK					= 384
	ACT_SHIELD_KNOCKBACK					= 385
	ACT_CROUCHING_SHIELD_UP					= 386
	ACT_CROUCHING_SHIELD_DOWN					= 387
	ACT_CROUCHING_SHIELD_UP_IDLE					= 388
	ACT_CROUCHING_SHIELD_ATTACK					= 389
	ACT_CROUCHING_SHIELD_KNOCKBACK					= 390
	ACT_TURNRIGHT45					= 391
	ACT_TURNLEFT45					= 392
	ACT_TURN					= 393
	ACT_OBJ_ASSEMBLING					= 394
	ACT_OBJ_DISMANTLING					= 395

	ACT_OBJ_STARTUP					= 396

	ACT_OBJ_RUNNING					= 397

	ACT_OBJ_IDLE					= 398

	ACT_OBJ_PLACING					= 399

	ACT_OBJ_DETERIORATING					= 400

	ACT_DEPLOY					= 401

	ACT_DEPLOY_IDLE					= 402

	ACT_UNDEPLOY					= 403

	ACT_GRENADE_ROLL					= 404

	ACT_GRENADE_TOSS					= 405

	ACT_HANDGRENADE_THROW1					= 406

	ACT_HANDGRENADE_THROW2					= 407

	ACT_HANDGRENADE_THROW3					= 408

	ACT_SHOTGUN_IDLE_DEEP					= 409

	ACT_SHOTGUN_IDLE4					= 410

	ACT_GLOCK_SHOOTEMPTY					= 411

	ACT_GLOCK_SHOOT_RELOAD					= 412

	ACT_RPG_DRAW_UNLOADED					= 413

	ACT_RPG_HOLSTER_UNLOADED					= 414

	ACT_RPG_IDLE_UNLOADED					= 415

	ACT_RPG_FIDGET_UNLOADED					= 416

	ACT_CROSSBOW_DRAW_UNLOADED					= 417

	ACT_CROSSBOW_IDLE_UNLOADED					= 418

	ACT_CROSSBOW_FIDGET_UNLOADED					= 419

	ACT_GAUSS_SPINUP					= 420

	ACT_GAUSS_SPINCYCLE					= 421

	ACT_TRIPMINE_GROUND					= 422

	ACT_TRIPMINE_WORLD					= 423

	ACT_VM_PRIMARYATTACK_SILENCED					= 424

	ACT_VM_RELOAD_SILENCED					= 425

	ACT_VM_DRYFIRE_SILENCED					= 426

	ACT_VM_IDLE_SILENCED					= 427

	ACT_VM_DRAW_SILENCED					= 428

	ACT_VM_IDLE_EMPTY_LEFT					= 429

	ACT_VM_DRYFIRE_LEFT					= 430

	ACT_PLAYER_IDLE_FIRE					= 431

	ACT_PLAYER_CROUCH_FIRE					= 432

	ACT_PLAYER_CROUCH_WALK_FIRE					= 433

	ACT_PLAYER_WALK_FIRE					= 434

	ACT_PLAYER_RUN_FIRE					= 435

	ACT_IDLETORUN					= 436

	ACT_RUNTOIDLE					= 437

	ACT_SPRINT					= 438

	ACT_GET_DOWN					= 439

	ACT_GET_UP					= 440

	ACT_PRONE_FORWARD					= 441

	ACT_PRONE_IDLE					= 442

	ACT_DEEPIDLE1					= 443

	ACT_DEEPIDLE2					= 444

	ACT_DEEPIDLE3					= 445

	ACT_DEEPIDLE4					= 446

	ACT_VM_RELOAD_DEPLOYED					= 447

	ACT_VM_RELOAD_IDLE					= 448

	ACT_VM_DRAW_EMPTY					= 449

	ACT_VM_PRIMARYATTACK_EMPTY					= 450

	ACT_VM_RELOAD_EMPTY					= 451

	ACT_VM_IDLE_EMPTY					= 452

	ACT_VM_IDLE_DEPLOYED_EMPTY					= 453

	ACT_VM_IDLE_8					= 454

	ACT_VM_IDLE_7					= 455

	ACT_VM_IDLE_6					= 456

	ACT_VM_IDLE_5					= 457

	ACT_VM_IDLE_4					= 458

	ACT_VM_IDLE_3					= 459

	ACT_VM_IDLE_2					= 460

	ACT_VM_IDLE_1					= 461

	ACT_VM_IDLE_DEPLOYED					= 462

	ACT_VM_IDLE_DEPLOYED_8					= 463

	ACT_VM_IDLE_DEPLOYED_7					= 464

	ACT_VM_IDLE_DEPLOYED_6					= 465

	ACT_VM_IDLE_DEPLOYED_5					= 466

	ACT_VM_IDLE_DEPLOYED_4					= 467

	ACT_VM_IDLE_DEPLOYED_3					= 468

	ACT_VM_IDLE_DEPLOYED_2					= 469

	ACT_VM_IDLE_DEPLOYED_1					= 470

	ACT_VM_UNDEPLOY					= 471

	ACT_VM_UNDEPLOY_8					= 472

	ACT_VM_UNDEPLOY_7					= 473

	ACT_VM_UNDEPLOY_6					= 474

	ACT_VM_UNDEPLOY_5					= 475

	ACT_VM_UNDEPLOY_4					= 476

	ACT_VM_UNDEPLOY_3					= 477

	ACT_VM_UNDEPLOY_2					= 478

	ACT_VM_UNDEPLOY_1					= 479

	ACT_VM_UNDEPLOY_EMPTY					= 480

	ACT_VM_DEPLOY					= 481

	ACT_VM_DEPLOY_8					= 482

	ACT_VM_DEPLOY_7					= 483

	ACT_VM_DEPLOY_6					= 484

	ACT_VM_DEPLOY_5					= 485

	ACT_VM_DEPLOY_4					= 486

	ACT_VM_DEPLOY_3					= 487

	ACT_VM_DEPLOY_2					= 488

	ACT_VM_DEPLOY_1					= 489

	ACT_VM_DEPLOY_EMPTY					= 490

	ACT_VM_PRIMARYATTACK_8					= 491

	ACT_VM_PRIMARYATTACK_7					= 492

	ACT_VM_PRIMARYATTACK_6					= 493

	ACT_VM_PRIMARYATTACK_5					= 494

	ACT_VM_PRIMARYATTACK_4					= 495

	ACT_VM_PRIMARYATTACK_3					= 496

	ACT_VM_PRIMARYATTACK_2					= 497

	ACT_VM_PRIMARYATTACK_1					= 498

	ACT_VM_PRIMARYATTACK_DEPLOYED					= 499

	ACT_VM_PRIMARYATTACK_DEPLOYED_8					= 500

	ACT_VM_PRIMARYATTACK_DEPLOYED_7					= 501

	ACT_VM_PRIMARYATTACK_DEPLOYED_6					= 502

	ACT_VM_PRIMARYATTACK_DEPLOYED_5					= 503

	ACT_VM_PRIMARYATTACK_DEPLOYED_4					= 504

	ACT_VM_PRIMARYATTACK_DEPLOYED_3					= 505

	ACT_VM_PRIMARYATTACK_DEPLOYED_2					= 506

	ACT_VM_PRIMARYATTACK_DEPLOYED_1					= 507

	ACT_VM_PRIMARYATTACK_DEPLOYED_EMPTY					= 508

	

	

	ACT_DOD_DEPLOYED					= 509

	ACT_DOD_PRONE_DEPLOYED					= 510

	ACT_DOD_IDLE_ZOOMED					= 511

	ACT_DOD_WALK_ZOOMED					= 512

	ACT_DOD_CROUCH_ZOOMED					= 513

	ACT_DOD_CROUCHWALK_ZOOMED					= 514

	ACT_DOD_PRONE_ZOOMED					= 515

	ACT_DOD_PRONE_FORWARD_ZOOMED					= 516

	ACT_DOD_PRIMARYATTACK_DEPLOYED					= 517

	ACT_DOD_PRIMARYATTACK_PRONE_DEPLOYED					= 518

	ACT_DOD_RELOAD_DEPLOYED					= 519

	ACT_DOD_RELOAD_PRONE_DEPLOYED					= 520

	ACT_DOD_PRIMARYATTACK_PRONE					= 521

	ACT_DOD_SECONDARYATTACK_PRONE					= 522

	ACT_DOD_RELOAD_PRONE					= 523

	ACT_DOD_STAND_AIM_PISTOL					= 524

	ACT_DOD_CROUCH_AIM_PISTOL					= 525

	ACT_DOD_CROUCHWALK_AIM_PISTOL					= 526

	ACT_DOD_WALK_AIM_PISTOL					= 527

	ACT_DOD_RUN_AIM_PISTOL					= 528

	ACT_DOD_PRONE_AIM_PISTOL					= 529

	ACT_DOD_STAND_AIM_RIFLE					= 530

	ACT_DOD_CROUCH_AIM_RIFLE					= 531

	ACT_DOD_CROUCHWALK_AIM_RIFLE					= 532

	ACT_DOD_WALK_AIM_RIFLE					= 533

	ACT_DOD_RUN_AIM_RIFLE					= 534

	ACT_DOD_PRONE_AIM_RIFLE					= 535

	ACT_DOD_STAND_AIM_BOLT					= 536

	ACT_DOD_CROUCH_AIM_BOLT					= 537

	ACT_DOD_CROUCHWALK_AIM_BOLT					= 538

	ACT_DOD_WALK_AIM_BOLT					= 539

	ACT_DOD_RUN_AIM_BOLT					= 540

	ACT_DOD_PRONE_AIM_BOLT					= 541

	ACT_DOD_STAND_AIM_TOMMY					= 542

	ACT_DOD_CROUCH_AIM_TOMMY					= 543

	ACT_DOD_CROUCHWALK_AIM_TOMMY					= 544

	ACT_DOD_WALK_AIM_TOMMY					= 545

	ACT_DOD_RUN_AIM_TOMMY					= 546

	ACT_DOD_PRONE_AIM_TOMMY					= 547

	ACT_DOD_STAND_AIM_MP40					= 548

	ACT_DOD_CROUCH_AIM_MP40					= 549

	ACT_DOD_CROUCHWALK_AIM_MP40					= 550

	ACT_DOD_WALK_AIM_MP40					= 551

	ACT_DOD_RUN_AIM_MP40					= 552

	ACT_DOD_PRONE_AIM_MP40					= 553

	ACT_DOD_STAND_AIM_MP44					= 554

	ACT_DOD_CROUCH_AIM_MP44					= 555

	ACT_DOD_CROUCHWALK_AIM_MP44					= 556

	ACT_DOD_WALK_AIM_MP44					= 557

	ACT_DOD_RUN_AIM_MP44					= 558

	ACT_DOD_PRONE_AIM_MP44					= 559

	ACT_DOD_STAND_AIM_GREASE					= 560

	ACT_DOD_CROUCH_AIM_GREASE					= 561

	ACT_DOD_CROUCHWALK_AIM_GREASE					= 562

	ACT_DOD_WALK_AIM_GREASE					= 563

	ACT_DOD_RUN_AIM_GREASE					= 564

	ACT_DOD_PRONE_AIM_GREASE					= 565

	ACT_DOD_STAND_AIM_MG					= 566

	ACT_DOD_CROUCH_AIM_MG					= 567

	ACT_DOD_CROUCHWALK_AIM_MG					= 568

	ACT_DOD_WALK_AIM_MG					= 569

	ACT_DOD_RUN_AIM_MG					= 570

	ACT_DOD_PRONE_AIM_MG					= 571

	ACT_DOD_STAND_AIM_30CAL					= 572

	ACT_DOD_CROUCH_AIM_30CAL					= 573

	ACT_DOD_CROUCHWALK_AIM_30CAL					= 574

	ACT_DOD_WALK_AIM_30CAL					= 575

	ACT_DOD_RUN_AIM_30CAL					= 576

	ACT_DOD_PRONE_AIM_30CAL					= 577

	ACT_DOD_STAND_AIM_GREN					= 578

	ACT_DOD_CROUCH_AIM_GREN					= 579

	ACT_DOD_CROUCHWALK_AIM_GREN					= 580

	ACT_DOD_WALK_AIM_GREN					= 581

	ACT_DOD_RUN_AIM_GREN					= 582

	ACT_DOD_PRONE_AIM_GREN					= 583

	ACT_DOD_STAND_AIM_KNIFE					= 584

	ACT_DOD_CROUCH_AIM_KNIFE					= 585

	ACT_DOD_CROUCHWALK_AIM_KNIFE					= 586

	ACT_DOD_WALK_AIM_KNIFE					= 587

	ACT_DOD_RUN_AIM_KNIFE					= 588

	ACT_DOD_PRONE_AIM_KNIFE					= 589

	ACT_DOD_STAND_AIM_SPADE					= 590

	ACT_DOD_CROUCH_AIM_SPADE					= 591

	ACT_DOD_CROUCHWALK_AIM_SPADE					= 592

	ACT_DOD_WALK_AIM_SPADE					= 593

	ACT_DOD_RUN_AIM_SPADE					= 594

	ACT_DOD_PRONE_AIM_SPADE					= 595

	ACT_DOD_STAND_AIM_BAZOOKA					= 596

	ACT_DOD_CROUCH_AIM_BAZOOKA					= 597

	ACT_DOD_CROUCHWALK_AIM_BAZOOKA					= 598

	ACT_DOD_WALK_AIM_BAZOOKA					= 599

	ACT_DOD_RUN_AIM_BAZOOKA					= 600

	ACT_DOD_PRONE_AIM_BAZOOKA					= 601

	ACT_DOD_STAND_AIM_PSCHRECK					= 602

	ACT_DOD_CROUCH_AIM_PSCHRECK					= 603

	ACT_DOD_CROUCHWALK_AIM_PSCHRECK					= 604

	ACT_DOD_WALK_AIM_PSCHRECK					= 605

	ACT_DOD_RUN_AIM_PSCHRECK					= 606

	ACT_DOD_PRONE_AIM_PSCHRECK					= 607

	ACT_DOD_STAND_ZOOM_TOMMY					= 608

	ACT_DOD_CROUCH_ZOOM_TOMMY					= 609

	ACT_DOD_CROUCHWALK_ZOOM_TOMMY					= 610

	ACT_DOD_WALK_ZOOM_TOMMY					= 611

	ACT_DOD_RUN_ZOOM_TOMMY					= 612

	ACT_DOD_PRONE_ZOOM_TOMMY					= 613

	ACT_DOD_STAND_ZOOM_BOLT					= 614

	ACT_DOD_CROUCH_ZOOM_BOLT					= 615

	ACT_DOD_CROUCHWALK_ZOOM_BOLT					= 616

	ACT_DOD_WALK_ZOOM_BOLT					= 617

	ACT_DOD_RUN_ZOOM_BOLT					= 618

	ACT_DOD_PRONE_ZOOM_BOLT					= 619

	ACT_DOD_STAND_ZOOM_BAZOOKA					= 620

	ACT_DOD_CROUCH_ZOOM_BAZOOKA					= 621

	ACT_DOD_CROUCHWALK_ZOOM_BAZOOKA					= 622

	ACT_DOD_WALK_ZOOM_BAZOOKA					= 623

	ACT_DOD_RUN_ZOOM_BAZOOKA					= 624

	ACT_DOD_PRONE_ZOOM_BAZOOKA					= 625

	ACT_DOD_STAND_ZOOM_PSCHRECK					= 626

	ACT_DOD_CROUCH_ZOOM_PSCHRECK					= 627

	ACT_DOD_CROUCHWALK_ZOOM_PSCHRECK					= 628

	ACT_DOD_WALK_ZOOM_PSCHRECK					= 629

	ACT_DOD_RUN_ZOOM_PSCHRECK					= 630

	ACT_DOD_PRONE_ZOOM_PSCHRECK					= 631

	ACT_DOD_DEPLOY_RIFLE					= 632

	ACT_DOD_DEPLOY_TOMMY					= 633

	ACT_DOD_DEPLOY_MG					= 634

	ACT_DOD_DEPLOY_30CAL					= 635

	ACT_DOD_PRONE_DEPLOY_RIFLE					= 636

	ACT_DOD_PRONE_DEPLOY_TOMMY					= 637

	ACT_DOD_PRONE_DEPLOY_MG					= 638

	ACT_DOD_PRONE_DEPLOY_30CAL					= 639

	ACT_DOD_PRIMARYATTACK_RIFLE					= 640

	ACT_DOD_SECONDARYATTACK_RIFLE					= 641

	ACT_DOD_PRIMARYATTACK_PRONE_RIFLE					= 642

	ACT_DOD_SECONDARYATTACK_PRONE_RIFLE					= 643

	ACT_DOD_PRIMARYATTACK_PRONE_DEPLOYED_RIFLE					= 644

	ACT_DOD_PRIMARYATTACK_DEPLOYED_RIFLE					= 645

	ACT_DOD_PRIMARYATTACK_BOLT					= 646

	ACT_DOD_SECONDARYATTACK_BOLT					= 647

	ACT_DOD_PRIMARYATTACK_PRONE_BOLT					= 648

	ACT_DOD_SECONDARYATTACK_PRONE_BOLT					= 649

	ACT_DOD_PRIMARYATTACK_TOMMY					= 650

	ACT_DOD_PRIMARYATTACK_PRONE_TOMMY					= 651

	ACT_DOD_PRIMARYATTACK_DEPLOYED_TOMMY					= 652

	ACT_DOD_PRIMARYATTACK_PRONE_DEPLOYED_TOMMY					= 653

	ACT_DOD_PRIMARYATTACK_MP40					= 654

	ACT_DOD_PRIMARYATTACK_PRONE_MP40					= 655

	ACT_DOD_PRIMARYATTACK_MP44					= 656

	ACT_DOD_PRIMARYATTACK_PRONE_MP44					= 657

	ACT_DOD_PRIMARYATTACK_GREASE					= 658

	ACT_DOD_PRIMARYATTACK_PRONE_GREASE					= 659

	ACT_DOD_PRIMARYATTACK_PISTOL					= 660

	ACT_DOD_PRIMARYATTACK_PRONE_PISTOL					= 661

	ACT_DOD_PRIMARYATTACK_MG					= 662

	ACT_DOD_PRIMARYATTACK_PRONE_MG					= 663

	ACT_DOD_PRIMARYATTACK_PRONE_DEPLOYED_MG					= 664

	ACT_DOD_PRIMARYATTACK_DEPLOYED_MG					= 665

	ACT_DOD_PRIMARYATTACK_30CAL					= 666

	ACT_DOD_PRIMARYATTACK_PRONE_30CAL					= 667

	ACT_DOD_PRIMARYATTACK_DEPLOYED_30CAL					= 668

	ACT_DOD_PRIMARYATTACK_PRONE_DEPLOYED_30CAL					= 669

	ACT_DOD_PRIMARYATTACK_GREN					= 670

	ACT_DOD_SECONDARYATTACK_GREN					= 671

	ACT_DOD_PRIMARYATTACK_PRONE_GREN					= 672

	ACT_DOD_PRIMARYATTACK_KNIFE					= 673

	ACT_DOD_PRIMARYATTACK_PRONE_KNIFE					= 674

	ACT_DOD_PRIMARYATTACK_SPADE					= 675

	ACT_DOD_PRIMARYATTACK_PRONE_SPADE					= 676

	ACT_DOD_PRIMARYATTACK_BAZOOKA					= 677

	ACT_DOD_PRIMARYATTACK_PRONE_BAZOOKA					= 678

	ACT_DOD_PRIMARYATTACK_PSCHRECK					= 679

	ACT_DOD_PRIMARYATTACK_PRONE_PSCHRECK					= 680

	ACT_DOD_RELOAD_GARAND					= 681

	ACT_DOD_RELOAD_K43					= 682

	ACT_DOD_RELOAD_BAR					= 683

	ACT_DOD_RELOAD_MP40					= 684

	ACT_DOD_RELOAD_MP44					= 685

	ACT_DOD_RELOAD_BOLT					= 686

	ACT_DOD_RELOAD_M1CARBINE					= 687

	ACT_DOD_RELOAD_THOMPSON					= 688

	ACT_DOD_RELOAD_GREASEGUN					= 689

	ACT_DOD_RELOAD_PISTOL					= 690

	ACT_DOD_RELOAD_FG42					= 691

	ACT_DOD_RELOAD_BAZOOKA					= 692

	ACT_DOD_ZOOMLOAD_BAZOOKA					= 693

	ACT_DOD_RELOAD_PSCHRECK					= 694

	ACT_DOD_ZOOMLOAD_PSCHRECK					= 695

	ACT_DOD_RELOAD_DEPLOYED_FG42					= 696

	ACT_DOD_RELOAD_DEPLOYED_30CAL					= 697

	ACT_DOD_RELOAD_DEPLOYED_MG42					= 698

	ACT_DOD_RELOAD_DEPLOYED_MG34					= 699

	ACT_DOD_RELOAD_DEPLOYED_BAR					= 700

	ACT_DOD_RELOAD_PRONE_PISTOL					= 701

	ACT_DOD_RELOAD_PRONE_GARAND					= 702

	ACT_DOD_RELOAD_PRONE_M1CARBINE					= 703

	ACT_DOD_RELOAD_PRONE_BOLT					= 704

	ACT_DOD_RELOAD_PRONE_K43					= 705

	ACT_DOD_RELOAD_PRONE_MP40					= 706

	ACT_DOD_RELOAD_PRONE_MP44					= 707

	ACT_DOD_RELOAD_PRONE_BAR					= 708

	ACT_DOD_RELOAD_PRONE_GREASEGUN					= 709

	ACT_DOD_RELOAD_PRONE_THOMPSON					= 710

	ACT_DOD_RELOAD_PRONE_FG42					= 711

	ACT_DOD_RELOAD_PRONE_BAZOOKA					= 712

	ACT_DOD_ZOOMLOAD_PRONE_BAZOOKA					= 713

	ACT_DOD_RELOAD_PRONE_PSCHRECK					= 714

	ACT_DOD_ZOOMLOAD_PRONE_PSCHRECK					= 715

	ACT_DOD_RELOAD_PRONE_DEPLOYED_BAR					= 716

	ACT_DOD_RELOAD_PRONE_DEPLOYED_FG42					= 717

	ACT_DOD_RELOAD_PRONE_DEPLOYED_30CAL					= 718

	ACT_DOD_RELOAD_PRONE_DEPLOYED_MG42					= 719

	ACT_DOD_RELOAD_PRONE_DEPLOYED_MG34					= 720

	ACT_DOD_PRONE_ZOOM_FORWARD_TOMMY					= 721

	ACT_DOD_PRONE_ZOOM_FORWARD_BOLT					= 722

	ACT_DOD_PRONE_ZOOM_FORWARD_BAZOOKA					= 723

	ACT_DOD_PRONE_ZOOM_FORWARD_PSCHRECK					= 724

	ACT_DOD_HS_STICKTOGETHER					= 725

	ACT_DOD_HS_FALLBACK					= 726

	ACT_DOD_HS_NO					= 727

	ACT_DOD_HS_YES					= 728

	ACT_DOD_HS_SNIPER					= 729

	ACT_DOD_HS_BACKUP					= 730

	ACT_DOD_HS_ENEMYRIGHT					= 731

	ACT_DOD_HS_ENEMYLEFT					= 732

	ACT_DOD_HS_GRENADE					= 733

	ACT_DOD_HS_FLANKLEFT					= 734

	ACT_DOD_HS_MOVEOUT					= 735

	ACT_DOD_HS_FLANKRIGHT					= 736

	ACT_DOD_HS_AREACLEAR					= 737

	ACT_DOD_HS_COVERINGFIRE					= 738

	ACT_DOD_HS_TAKECOVER					= 739

	ACT_DOD_HS_HOLDPOS					= 740

	ACT_DOD_HS_SPREADOUT					= 741

	ACT_DOD_HS_ENEMYSPOTTED					= 742

	ACT_DOD_HS_DISPLACE					= 743

	ACT_DOD_HS_PREPARE					= 744

	ACT_DOD_HS_GOGOGO					= 745

	ACT_DOD_HS_ENEMYAHEAD					= 746

	ACT_DOD_HS_ENEMYBEHIND					= 747

	ACT_DOD_HS_MGAHEAD					= 748

	ACT_DOD_HS_MOVEUPMG					= 749

	ACT_DOD_HS_CEASEFIRE					= 750

	ACT_DOD_HS_USEGRENS					= 751

	ACT_DOD_HS_PRONE_MOVEOUT					= 752

	ACT_DOD_HS_PRONE_FLANKLEFT					= 753

	ACT_DOD_HS_PRONE_FLANKRIGHT					= 754

	ACT_DOD_HS_PRONE_BACKUP					= 755

	ACT_DOD_HS_PRONE_AREACLEAR					= 756

	ACT_DOD_HS_PRONE_FALLBACK					= 757

	ACT_DOD_HS_PRONE_SNIPER					= 758

	ACT_DOD_HS_PRONE_YES					= 759

	ACT_DOD_HS_PRONE_NO					= 760

	ACT_DOD_HS_PRONE_ENEMYLEFT					= 761

	ACT_DOD_HS_PRONE_ENEMYRIGHT					= 762

	ACT_DOD_HS_PRONE_GRENADE					= 763

	ACT_DOD_HS_PRONE_COVERINGFIRE					= 764

	ACT_DOD_HS_PRONE_HOLDPOS					= 765

	ACT_DOD_HS_PRONE_SPREADOUT					= 766

	ACT_DOD_HS_PRONE_STICKTOGETHER					= 767

	ACT_DOD_HS_PRONE_TAKECOVER					= 768

	ACT_DOD_HS_PRONE_ENEMYSPOTTED					= 769

	ACT_DOD_HS_PRONE_DISPLACE					= 770

	ACT_DOD_HS_PRONE_PREPARE					= 771

	ACT_DOD_HS_PRONE_GOGOGO					= 772

	ACT_DOD_HS_PRONE_ENEMYAHEAD					= 773

	ACT_DOD_HS_PRONE_ENEMYBEHIND					= 774

	ACT_DOD_HS_PRONE_MGAHEAD					= 775

	ACT_DOD_HS_PRONE_MOVEUPMG					= 776

	ACT_DOD_HS_PRONE_USEGRENS					= 777

	ACT_DOD_HS_PRONE_CEASEFIRE					= 778

	

	

	ACT_HL2MP_IDLE					= 779

	ACT_HL2MP_RUN					= 780

	ACT_HL2MP_IDLE_CROUCH					= 781

	ACT_HL2MP_WALK_CROUCH					= 782

	ACT_HL2MP_GESTURE_RANGE_ATTACK					= 783

	ACT_HL2MP_GESTURE_RELOAD					= 784

	ACT_HL2MP_JUMP					= 785

	ACT_HL2MP_IDLE_PISTOL					= 786

	ACT_HL2MP_RUN_PISTOL					= 787

	ACT_HL2MP_IDLE_CROUCH_PISTOL					= 788

	ACT_HL2MP_WALK_CROUCH_PISTOL					= 789

	ACT_HL2MP_GESTURE_RANGE_ATTACK_PISTOL					= 790

	ACT_HL2MP_GESTURE_RELOAD_PISTOL					= 791

	ACT_HL2MP_JUMP_PISTOL					= 792

	ACT_HL2MP_IDLE_SMG1					= 793

	ACT_HL2MP_RUN_SMG1					= 794

	ACT_HL2MP_IDLE_CROUCH_SMG1					= 795

	ACT_HL2MP_WALK_CROUCH_SMG1					= 796

	ACT_HL2MP_GESTURE_RANGE_ATTACK_SMG1					= 797

	ACT_HL2MP_GESTURE_RELOAD_SMG1					= 798

	ACT_HL2MP_JUMP_SMG1					= 799

	ACT_HL2MP_IDLE_AR2					= 800

	ACT_HL2MP_RUN_AR2					= 801

	ACT_HL2MP_IDLE_CROUCH_AR2					= 802

	ACT_HL2MP_WALK_CROUCH_AR2					= 803

	ACT_HL2MP_GESTURE_RANGE_ATTACK_AR2					= 804

	ACT_HL2MP_GESTURE_RELOAD_AR2					= 805

	ACT_HL2MP_JUMP_AR2					= 806

	ACT_HL2MP_IDLE_SHOTGUN					= 807

	ACT_HL2MP_RUN_SHOTGUN					= 808

	ACT_HL2MP_IDLE_CROUCH_SHOTGUN					= 809

	ACT_HL2MP_WALK_CROUCH_SHOTGUN					= 810

	ACT_HL2MP_GESTURE_RANGE_ATTACK_SHOTGUN					= 811

	ACT_HL2MP_GESTURE_RELOAD_SHOTGUN					= 812

	ACT_HL2MP_JUMP_SHOTGUN					= 813

	ACT_HL2MP_IDLE_RPG					= 814

	ACT_HL2MP_RUN_RPG					= 815

	ACT_HL2MP_IDLE_CROUCH_RPG					= 816

	ACT_HL2MP_WALK_CROUCH_RPG					= 817

	ACT_HL2MP_GESTURE_RANGE_ATTACK_RPG					= 818

	ACT_HL2MP_GESTURE_RELOAD_RPG					= 819

	ACT_HL2MP_JUMP_RPG					= 820

	ACT_HL2MP_IDLE_GRENADE					= 821

	ACT_HL2MP_RUN_GRENADE					= 822

	ACT_HL2MP_IDLE_CROUCH_GRENADE					= 823

	ACT_HL2MP_WALK_CROUCH_GRENADE					= 824

	ACT_HL2MP_GESTURE_RANGE_ATTACK_GRENADE					= 825

	ACT_HL2MP_GESTURE_RELOAD_GRENADE					= 826

	ACT_HL2MP_JUMP_GRENADE					= 827

	ACT_HL2MP_IDLE_PHYSGUN					= 828

	ACT_HL2MP_RUN_PHYSGUN					= 829

	ACT_HL2MP_IDLE_CROUCH_PHYSGUN					= 830

	ACT_HL2MP_WALK_CROUCH_PHYSGUN					= 831

	ACT_HL2MP_GESTURE_RANGE_ATTACK_PHYSGUN					= 832

	ACT_HL2MP_GESTURE_RELOAD_PHYSGUN					= 833

	ACT_HL2MP_JUMP_PHYSGUN					= 834

	ACT_HL2MP_IDLE_CROSSBOW					= 835

	ACT_HL2MP_RUN_CROSSBOW					= 836

	ACT_HL2MP_IDLE_CROUCH_CROSSBOW					= 837

	ACT_HL2MP_WALK_CROUCH_CROSSBOW					= 838

	ACT_HL2MP_GESTURE_RANGE_ATTACK_CROSSBOW					= 839

	ACT_HL2MP_GESTURE_RELOAD_CROSSBOW					= 840

	ACT_HL2MP_JUMP_CROSSBOW					= 841

	ACT_HL2MP_IDLE_MELEE					= 842

	ACT_HL2MP_RUN_MELEE					= 843

	ACT_HL2MP_IDLE_CROUCH_MELEE					= 844

	ACT_HL2MP_WALK_CROUCH_MELEE					= 845

	ACT_HL2MP_GESTURE_RANGE_ATTACK_MELEE					= 846

	ACT_HL2MP_GESTURE_RELOAD_MELEE					= 847

	ACT_HL2MP_JUMP_MELEE					= 848

	ACT_HL2MP_IDLE_SLAM					= 849

	ACT_HL2MP_RUN_SLAM					= 850

	ACT_HL2MP_IDLE_CROUCH_SLAM					= 851

	ACT_HL2MP_WALK_CROUCH_SLAM					= 852

	ACT_HL2MP_GESTURE_RANGE_ATTACK_SLAM					= 853

	ACT_HL2MP_GESTURE_RELOAD_SLAM					= 854

	ACT_HL2MP_JUMP_SLAM					= 855

	
-- Player animations, for use with _PlayerSetAnimation


	PLAYER_IDLE			= 0
	PLAYER_WALK			= 1
	PLAYER_JUMP			= 2
	PLAYER_SUPERJUMP	= 3
	PLAYER_DIE			= 4
	PLAYER_ATTACK1		= 5  -- From what I can tell this is the only one that actually works :)
	PLAYER_IN_VEHICLE	= 6

	

	
