VEHICLEPADMODEL = "models/props_combine/weaponstripper.mdl"
VEHICLEPADPRICE = 300
_EntPrecacheModel(VEHICLEPADMODEL)

function CreateVehiclePad(userid)
	PlayerLookTrace(userid, 300)
	local prop = _EntCreate("prop_physics")
	if prop > 0 then
		_EntSetKeyValue(prop, "model", VEHICLEPADMODEL)
		_EntSetPos(prop, vecAdd(_TraceEndPos(userid), vector3(0,0,70)))
		_EntSpawn(prop)
		_EntSetName(prop, "unfrozenprop")
		_EntSetMaterial(prop, "gmod/wireframe")
		local n = _PlayerInfo(userid, "team")
		PhysProps[prop] = {}
		PhysProps[prop].Owner = userid
		PhysProps[prop].Team = n
		teams[n].props = teams[n].props+1
		_EntFire(prop, "color", teams[n].color.r.." "..teams[n].color.g.." "..teams[n].color.b, 0)
	end
end

function VehicleSelect(userid, vehicletype)
	for i=109, 121 do
		_GModText_Hide(userid, i, 0.9)
	end
	if teams[_PlayerInfo(userid,"team")].VehicleStock[vehicletype] <= 0 then
		_PrintMessage(userid, 4, "No vehicles of that type available.")
		return
	end
	local tab = _EntitiesFindInSphere(_EntGetPos(userid), 256)
	local vehiclepad = userid
	for i in tab do
		if _EntGetModel(tab[i]) == VEHICLEPADMODEL then vehiclepad = tab[i] end
		if Vehicles[tab[i]] ~= nil then
			_PlaySoundPlayer(userid, "buttons/button8.wav")
			_PrintMessage(userid, 4, "There is a vehicle in the way.")
			return
		end
	end
	_TraceLine(_EntGetPos(vehiclepad), vector3(0,0,1), 750, vehiclepad)
	if _TraceHitNonWorld() then
		if Vehicles[_TraceGetEnt()] ~= nil then
			_PlaySoundPlayer(userid, "buttons/button8.wav")
			_PrintMessage(userid, 4, "There is a vehicle in the way.")
			return
		end
	end
	if vehiclepad == userid then return end
	CreateVehicle(userid, vecAdd(_EntGetPos(vehiclepad), VehicleTypes[vehicletype].CreationOffset), vehicletype)
end

function VehiclePadMenu(userid, vehiclepad)
	if not _PlayerInfo(userid, "alive") then return end
	local menu = JBMenu.CreateMenu(false, "Vehicles", "I'm Chargin' Mah Lazah", "255 255 255", "255 0 255")
	for i in VehicleTypes do
		 if teams[_PlayerInfo(userid,"team")].VehicleStock[i] > 0 then
			JBMenu.AddChoice(menu, "("..teams[_PlayerInfo(userid,"team")].VehicleStock[i].."/"..VehicleTypes[i].Stock..") "..VehicleTypes[i].Name, VehicleTypes[i].Description, "255 255 255", VehicleSelect, userid, i)
		 else
			JBMenu.AddChoice(menu, "("..teams[_PlayerInfo(userid,"team")].VehicleStock[i].."/"..VehicleTypes[i].Stock..") "..VehicleTypes[i].Name, VehicleTypes[i].Description, "255 0 0", VehicleSelect, userid, i)
		 end
	end
	JBMenu.SendMenu(userid, menu)
end
