VehicleTypes["HoverAPC"] = {                 -- The global reference to this type.
Name = "AG Transport APC",                   -- The display name on vehicle menu.
Model = "models/props_vehicles/apc001.mdl",  -- Model. If none, the vehicle will not create.
Description = "Heavy APC with wire-guided energy missile launcher.",   -- Shown on the vehicle menu.
Stock = 1,                                -- How many each team can have at one time.
EntityType = "prop_physics",              -- _EntCreate( ) type. Default is "prop_physics", if not specified.
MaxHealth = 225,                          -- Max HP before destroyed.
DamageMultiply = 0.4,                    -- Damage taken is multiplyed by this amount.
PassengerSlots = 5,                       -- Amount of passengers able to ride in this vehicle.
DriverCamDistance = 256,                  -- Camera distance from vehicle for the driver.
PassengerCamDistance = 0,               -- Camera distance from vehicle for passengers.
CreationOffset = vector3(0,0,70),         -- Offset from vehicle pads.
ExitOffset = vector3(0,0,80),             -- Offset from vehicle that people exit at.

HUD = function(vehicle)
	local SendTo = {}
	if Vehicles[vehicle].Driver > 0 then
		SendTo[table.getn(SendTo)+1] = Vehicles[vehicle].Driver
	end
	local pas = 0
	for i=1, table.getn(Vehicles[vehicle].Passenger) do
		if Vehicles[vehicle].Passenger[i] > 0 then
			SendTo[table.getn(SendTo)+1] = Vehicles[vehicle].Passenger[i]
		end
		if Vehicles[vehicle].Passenger[i] > 1 and i > 1 then
			pas=pas+1
		end
	end

	local ms = "D:* GNR:_ P:"..pas
	if Vehicles[vehicle].Passenger[1] > 0 then
		ms = string.gsub(ms, "GNR:_", "GNR:*")
	end
	for i=1, table.getn(SendTo) do
		_GModRect_Start("gmod/white")
		 _GModRect_SetPos(0.42, 0.85, 0.18, 0.1)
		 _GModRect_SetColor( 0, 0, 0, 100 )
		 _GModRect_SetTime( 9999, 0, 0 )
		_GModRect_Send( SendTo[i], 10000 )
		_GModText_Start( "Default" )
		 _GModText_SetPos( -1, 0.88 )
		 _GModText_SetColor( 255, 0, 0, 255 )
		 _GModText_SetTime( 9999, 0.2, 0.2 )
		 _GModText_SetText( "HP: "..math.ceil(Vehicles[vehicle].Health).."/"..VehicleTypes[Vehicles[vehicle].Type].MaxHealth )
		_GModText_Send( SendTo[i], 10001 )
		_GModText_Start( "Default" )
		 _GModText_SetPos( -1, 0.92 )
		 _GModText_SetColor( 255, 255, 255, 255 )
		 _GModText_SetTime( 9999, 0.2, 0.2 )
		 _GModText_SetText( ms )
		_GModText_Send( SendTo[i], 10002 )
	end
end,

onRemoved = function(vehicle)
	HOVERTANKLASTATTACK[vehicle] = nil
end,

onDestroyed = function(vehicle)
	HOVERTANKLASTATTACK[vehicle] = nil
	_EntEmitSoundEx(vehicle, "ambient/explosions/explode_6.wav", 1.1, 1.0)
	_phys.ApplyTorqueCenter(vehicle, vector3(0, 0, 2750000))
	_phys.EnableGravity(vehicle, false)
	for i=1, 10 do
		local ent = _EntCreate("env_explosion")
		if ent > 0 then
			_EntSetKeyValue(ent, "spawnflags", "17")
			_EntSetPos(ent, _EntGetPos(vehicle))
			_EntSpawn(ent)
			_EntSetParent(ent, vehicle)
			_EntFire(ent, "explode", "", i*0.25)
			_EntFire(ent, "kill", "", (i*0.25)+0.1)
		end
	end
	local ent2 = _EntCreate("env_ar2explosion")
	if ent2 > 0 then
		_EntSetPos(ent2, _EntGetPos(vehicle))
		_EntSpawn(ent2)
		_EntSetParent(ent2, vehicle)
		_EntFire(ent2, "explode", "", 2.45)
		_EntFire(ent2, "kill", "", 2.55)
		local pos = _EntGetPos(vehicle)
		AddTimer(2.4, 1, LuaExplosionEntity, vehicle, 250, 400, 255)
	end
	AddTimer(2.45, 1, _EntEmitSoundEx, vehicle, "npc/combine_gunship/gunship_explode2.wav", 1.5, 1.0)
	_EntFire(vehicle, "break", "", 2.5)
	_EntFire(vehicle, "kill", "", 2.6)
end,

HideHUD = function(userid)
	_GModRect_Hide(userid, 10000, 0.2)
	_GModText_Hide(userid, 10001, 0.2)
	_GModText_Hide(userid, 10002, 0.2)
end,

onDamaged = function(vehicle, attacker, damage)
	if Vehicles[vehicle].Health < VehicleTypes[Vehicles[vehicle].Type].MaxHealth*0.5 and damage > 8 then
		local finalpos = vecAdd(_EntGetPos(vehicle), vector3(math.random(-20, 20), math.random(-20, 20), math.random(15, 20)))
		local effect2 = _EntCreate("point_tesla")
		if effect2 > 0 then
			_EntSetKeyValue(effect2, "m_flRadius", "100")
			_EntSetKeyValue(effect2, "m_SoundName", "DoSpark")
			_EntSetKeyValue(effect2, "texture", "sprites/laserbeam.spr")
			_EntSetKeyValue(effect2, "beamcount_min", "5")
			_EntSetKeyValue(effect2, "beamcount_max", "10")
			_EntSetKeyValue(effect2, "thick_min", "8")
			_EntSetKeyValue(effect2, "thick_max", "22")
			_EntSetKeyValue(effect2, "lifetime_min", "0.5")
			_EntSetKeyValue(effect2, "lifetime_max", "0.8")
			_EntSetKeyValue(effect2, "interval_min", "0.2")
			_EntSetKeyValue(effect2, "interval_max", "0.4")
			_EntSetPos(effect2, finalpos)
			_EntSpawn(effect2)
			_EntActivate(effect2)
			_EntFire(effect2, "TurnOn", "", 0)
			_EntFire(effect2, "TurnOff", "", 0.7)
			_EntFire(effect2, "kill", "", 0.8)
		end
		_EntEmitSound(finalpos, "ambient/levels/labs/electric_explosion"..math.random(1,5)..".wav")
	end
end,

onPassengerAttack = function(vehicle, passenger)
	if passenger ~= 1 then return end
	if _CurTime() > HOVERTANKLASTATTACK[vehicle]+5.0 then
		HOVERTANKLASTATTACK[vehicle] = _CurTime()
	else
		return
	end

	local userid = Vehicles[vehicle].Passenger[1]
	local fireball = _EntCreate("physics_prop")
	local firetrail = _EntCreate("env_smoketrail")
	if fireball > 0 then
		_EntSetPos(fireball, vecAdd(_EntGetPos(vehicle), vector3(0,0,50)))
		_EntSetModel(fireball, "models/weapons/w_missile_closed.mdl")
		_phys.SetMass(fireball, 10)
		_EntSetPos(firetrail, _EntGetPos(fireball))
		_EntSetOwner(fireball, vehicle)
		_EntSpawn(fireball)
		_phys.EnableGravity(fireball, false)
		_EntitySetPhysicsAttacker(fireball, userid)
		_EntSpawn(firetrail)
		_phys.ApplyForceCenter(fireball, vecAdd(vecMul(_PlayerGetShootAng(userid), vector3(2000, 2000, 0)), vector3(0,0,1000)))
		_EntSetParent(firetrail, fireball)
		_EntFire(fireball, "kill", "", 10)
		HoverTankMissileTimers[fireball] = AddTimer(0.05, 200, HoverTankMissileCheckExplode, fireball, userid, vehicle)
		HoverTankMissileCheckExplode(fireball, userid, vehicle)
		_TraceLine(_EntGetPos(vehicle), _PlayerGetShootAng(userid), 4064, vehicle)
		_phys.ApplyForceCenter(prop, vecMul(vecNormalize(vecSub(_TraceEndPos(),_EntGetPos(prop))), vector3(940,940,940)))
		_EntSetAng(fireball, vecNormalize(vecSub(_TraceEndPos(),_EntGetPos(fireball))))
	end
	_EntEmitSound(vehicle, "weapons/rpg/rocketfire1.wav")
end,

onPassengerEnter = function(vehicle, userid)
	local ent = _EntCreate("prop_dynamic_override")
	if ent > 0 then
		_EntSetPos(ent, vecAdd(_EntGetPos(vehicle), vector3(0,0,128)))
		_EntSetModel(ent, "models/weapons/w_missile_closed.mdl")
		_EntSetKeyValue(ent, "rendermode", "5")
		_EntSpawn(ent)
		_EntSetParent(ent, vehicle)
		_EntFire(ent, "alpha", "0", 0)
		_PlayerSpectatorTarget(userid, ent)
	end
end,

onCreated = function(vehicle)
	HOVERTANKLASTATTACK[vehicle] = _CurTime()
end,

onThink = function(vehicle)
	if Vehicles[vehicle].Driver > 0 then
		_EntitySetPhysicsAttacker(vehicle, Vehicles[vehicle].Driver)
		local Ang = _EntGetAngAngle(vehicle)
		local vVec = vector3(0,0,0)
		if Ang.z > 0 and Ang.z < 180 then
			vVec = vecMul(_EntGetForwardVector(vehicle),-425*TICKRATE)
			_phys.ApplyTorqueCenter(vehicle, vVec)
		elseif Ang.z > 180 and Ang.z < 360 then
			vVec = vecMul(_EntGetForwardVector(vehicle),425*TICKRATE)
			_phys.ApplyTorqueCenter(vehicle, vVec)
		end
		if Ang.x > -80 and Ang.x < 0 then
			vVec = vecMul(_EntGetRightVector(vehicle),-425*TICKRATE)
			_phys.ApplyTorqueCenter(vehicle, vVec)
		elseif Ang.x > 0 and Ang.x < 80 then
			vVec = vecMul(_EntGetRightVector(vehicle),425*TICKRATE)
			_phys.ApplyTorqueCenter(vehicle, vVec)
		end
	elseif Vehicles[vehicle].Owner > 0 then
		_EntitySetPhysicsAttacker(vehicle, Vehicles[vehicle].Owner)
	end
	if Vehicles[vehicle].Driver > 0 then
		if onGround(vehicle, 150) and not _PlayerIsKeyDown(Vehicles[vehicle].Driver, IN_DUCK) then
			_phys.ApplyForceCenter(vehicle, vector3(0, 0, 4700*TICKRATE))
		end
	end
end,

onForward = function(vehicle)
	if onGround(vehicle, 175) then
		_phys.ApplyForceCenter(vehicle, vecMul(_EntGetRightVector(vehicle), vector3(-2700*TICKRATE,-2700*TICKRATE,0)))
	end
end,

onBackward = function(vehicle)
	if onGround(vehicle, 175) then
		_phys.ApplyForceCenter(vehicle, vecMul(_EntGetRightVector(vehicle), vector3(2700*TICKRATE,2700*TICKRATE,0)))
	end
end,

onLeft = function(vehicle)
	if onGround(vehicle, 175) then
		_phys.ApplyTorqueCenter(vehicle, vector3(0, 0, 1000*TICKRATE))
	end
end,

onRight = function(vehicle)
	if onGround(vehicle, 175) then
		_phys.ApplyTorqueCenter(vehicle, vector3(0, 0, -1000*TICKRATE))
	end
end
}

_EntPrecacheModel("models/weapons/w_missile_closed.mdl")
HOVERTANKLASTATTACK = {}
HoverTankMissileTimers = {}

function onGround(ent, dist)
	_TraceLine(_EntGetPos(ent), vecMul(_EntGetUpVector(ent), -1), dist, ent)
	return _TraceHit() or _EntGetWaterLevel(ent) > 0
end

function HoverTankMissileCheckExplode(prop, userid, vehicle)
	if not _EntExists(prop) then HaltTimer(HoverTankMissileTimers[prop]) return end
	if not _EntExists(vehicle) then HoverTankMissileExplode(prop, userid) return end
	_TraceLine(_EntGetPos(vehicle), _PlayerGetShootAng(userid), 4064, vehicle)
	_phys.ApplyForceCenter(prop, vecMul(vecNormalize(vecSub(_TraceEndPos(),_EntGetPos(prop))), 140*TICKRATE))

	_TraceLine(_EntGetPos(prop), _EntGetForwardVector(prop), 90, prop)
	if _TraceHit() then
		HoverTankMissileExplode(prop, userid)
	end
end

function HoverTankMissileExplode(prop, userid)
	local ents = _EntitiesFindInSphere(_EntGetPos(prop), 300)
	for i=1, table.getn(ents) do
		if _phys.HasPhysics(ents[i]) then
			_TraceAttack(ents[i], userid, userid, (310-math.abs(vecLength(vecSub(_EntGetPos(prop),_EntGetPos(ents[i])))))*0.45)
		end
	end

	local ent = _EntCreate("env_sprite")
	if ent > 0 then
		_EntSetKeyValue(ent, "model", "sprites/strider_blackball.spr")
		_EntSetKeyValue(ent, "rendermode", "5")
		_EntSetKeyValue(ent, "scale", "0.5")
		_EntSetKeyValue(ent, "spawnflags", "1")
		_EntSetPos(ent, _EntGetPos(prop))
		_EntSpawn(ent)
		_EntFire(ent, "showsprite", "", 0)
		for i=1, 10 do
			_EntFire(ent, "setscale", tostring(i*0.5), i*0.05)
		end
		_EntFire(ent, "hidesprite", "", 1.25)
		_EntFire(ent, "kill", "", 1.26)
		_EntEmitSound(ent, "weapons/physcannon/energy_sing_explosion2.wav")
		local glow = _EntCreate("env_lightglow")
		if glow > 0 then
			_EntSetKeyValue(glow, "rendercolor" , "25 50 255")
			_EntSetKeyValue(glow, "VerticalGlowSize", "110")
			_EntSetKeyValue(glow, "HorizontalGlowSize", "100")
			_EntSetKeyValue(glow, "MinDist", 15)
			_EntSetKeyValue(glow, "MaxDist", 2048)
			_EntSetKeyValue(glow, "OuterMaxDist", 150)
			_EntSetKeyValue(glow, "GlowProxySize", "4")
			_EntSetPos(glow, _EntGetPos(prop))
			_EntSpawn(glow)
			_EntFire(glow, "kill", "", 1.5)
			for y=1, 15 do
				_EntFire(glow, "color", (0).." "..(240-(y*15)).." "..(240-(y*15)), y*0.09)
			end
		end
	end
	_util.ScreenShake(_EntGetPos(prop), math.random(25,55), 180.0, 1.5, 220)
	_EntRemove(prop)
	HaltTimer(HoverTankMissileTimers[prop])
end
