-------------------------
-- STREET WARS --
--   BY JETBOOM  --
-------------------------
SW_VERSION = "BETA"
STARTING_MONEY = 0
TURF = {}
TURF[1] = {}
TURF[1].Name = "Motel"
TURF[1].Radius = 256
TURF[1].Position = vector3(1588, 965, 0)
TURF[2] = {}
TURF[2].Name = "Storage Area"
TURF[2].Radius = 256
TURF[2].Position = vector3(1547, 2581, 0)
TURF[3] = {}
TURF[3].Name = "Construction Yard"
TURF[3].Radius = 256
TURF[3].Position = vector3(-3776, 3872.12, 160)
TURF[4] = {}
TURF[4].Name = "Parking Complex"
TURF[4].Radius = 256
TURF[4].Position = vector3(163.66, -641.50, 288)
TURF[5] = {}
TURF[5].Name = "Garage"
TURF[5].Radius = 100
TURF[5].Position = vector3(-1606.68, 557.57, 0)
TURF[6] = {}
TURF[6].Name = "Gas Station"
TURF[6].Radius = 200
TURF[6].Position = vector3(-296.56, 1290.20, 0)

BUYRANK1 = {}
BUYRANK1[1] = {}
BUYRANK1[1].Name = "Compact Hand-Gun"
BUYRANK1[1].Price = 40
BUYRANK1[1].Script = "weapons/streetwars/p228.lua"
BUYRANK1[2] = {}
BUYRANK1[2].Name = "Glock"
BUYRANK1[2].Price = 60
BUYRANK1[2].Script = "weapons/streetwars/Glock.lua"
BUYRANK2 = {}
--[[
BUYRANK2[1] = {}
BUYRANK2[1].Name = ""
BUYRANK2[1].Price = 
BUYRANK2[1].Script = "weapons"
]]
BUYRANK3 = {}
BUYRANK3[1] = {}
BUYRANK3[1].Name = "Light Sniper Rifle"
BUYRANK3[1].Price = 200
BUYRANK3[1].Script = "weapons/streetwars/Scout.lua"
BUYRANK3[2] = {}
BUYRANK3[2].Name = "Desert Eagle"
BUYRANK3[2].Price = 100
BUYRANK3[2].Script = "weapons/noxctf/weapon_deagle.lua"

BUYRANK4 = {}
BUYRANK4[1] = {}
BUYRANK4[1].Name = "UZI 9mm"
BUYRANK4[1].Price = 150
BUYRANK4[1].Script = "weapons/noxctf/weapon_uzi.lua"

BUYRANK5 = {}
BUYRANK5[1] = {}
BUYRANK5[1].Name = "Shotgun"
BUYRANK5[1].Price = 200
BUYRANK5[1].Script = "weapons/streetwars/M3.lua"

BUYRANK6 = {}
--[[
BUYRANK6[1] = {}
BUYRANK6[1].Name = ""
BUYRANK6[1].Price = 
BUYRANK6[1].Script = "weapons"
]]
BUYRANK7 = {}
--[[
BUYRANK7[1] = {}
BUYRANK7[1].Name = ""
BUYRANK7[1].Price = 
BUYRANK7[1].Script = "weapons"
]]

BUYRANK8 = {}
BUYRANK8[1] = {}
BUYRANK8[1].Name = "C4 Explosive"
BUYRANK8[1].Price = 500
BUYRANK8[1].Script = "weapons/streetwars/weapon_c4.lua"
BUYRANK8[2] = {}
BUYRANK8[2].Name = "Heavy Sniper Rifle"
BUYRANK8[2].Price = 300
BUYRANK8[2].Script = "weapons/streetwars/weapon_snipheavy.lua"

BUYRANK9 = {}
BUYRANK9[1] = {}
BUYRANK9[1].Name = "AK-47 Assault Rifle"
BUYRANK9[1].Price = 450
BUYRANK9[1].Script = "weapons/Counter-Strike/AK-47.lua"

BUYRANK10 = {}
--[[
BUYRANK10[1] = {}
BUYRANK10[1].Name = ""
BUYRANK10[1].Price = 
BUYRANK10[1].Script = "weapons"
]]

for i=1, table.getn(TURF) do
	TURF[i].Team = 0
	TURF[i].Hits = 100
end

players = {}
teamnames = {}
for i=TEAM_BLUE, TEAM_RED do
	teamnames[i] = "lol no team"
end

for i=1, _MaxPlayers() do
	players[i] = {}
	players[i].spawn = 0
	players[i].money = 0
	players[i].experience = 0
	players[i].rank = 1
end

function InitScript()
	--gamerulesStartMap()
	for i=1, _MaxPlayers() do if IsPlayerOnline(i) then eventPlayerActive(_PlayerInfo(i, "name"), i, _PlayerInfo(i, "networkid")) end end
end

function gamerulesThink()
end 

function GiveDefaultItems(userid)
	if _PlayerInfo(userid,"team") < 2 then return end
	_PlayerGiveSWEP(userid, "weapons/streetwars/weapon_combatknife.lua")
	--_PlayerGiveSWEP(userid, "weapons/build/weapon_deagle.lua")
end

function gamerulesStartMap()
	PlayerFreezeAll( false )
	teamnames[TEAM_BLUE] = "Crips"
	teamnames[TEAM_GREEN] = "The Warriors"
	teamnames[TEAM_YELLOW] = "Piss-Ant Little Hicks"
	teamnames[TEAM_RED] = "Corps"
	for i=TEAM_BLUE, TEAM_RED do
		_TeamSetName(i, teamnames[i])
	end
	LoadTurf()
	AddTimer(300, 0, GlobalSave)
end

function PlayerSpawnChooseModel(userid)
	if _PlayerInfo(userid, "team") == TEAM_SPECTATOR then _PlayerSetModel(userid, "models/Player/stalker.mdl") return end
	local team = _PlayerInfo(userid, "team")
	local rank = players[userid].rank
	if team == TEAM_BLUE then
		if rank < 4 then
			_PlayerSetModel(userid, "models/Player/stalker.mdl")
		elseif rank < 7 then
			_PlayerSetModel(userid, "models/Player/charple01.mdl")
		elseif rank < 10 then
			_PlayerSetModel(userid, "models/Player/corpse1.mdl")
		else
			_PlayerSetModel(userid, "models/Player/classic.mdl")
		end
	elseif team == TEAM_GREEN then
		if rank < 4 then
			_PlayerSetModel(userid, "models/Player/male_02.mdl")
		elseif rank < 7 then
			_PlayerSetModel(userid, "models/Player/male_08.mdl")
		elseif rank < 10 then
			_PlayerSetModel(userid, "models/Player/barney.mdl")
		else
			_PlayerSetModel(userid, "models/Player/gordon_classic.mdl")
		end
	elseif team == TEAM_YELLOW then
		if rank < 4 then
			_PlayerSetModel(userid, "models/Player/stripped.mdl")
		elseif rank < 7 then
			_PlayerSetModel(userid, "models/Player/eli.mdl")
		elseif rank < 10 then
			_PlayerSetModel(userid, "models/Player/monk.mdl")
		else
			_PlayerSetModel(userid, "models/Player/breen.mdl")
		end
	elseif team == TEAM_RED then
		if rank < 4 then
			_PlayerSetModel(userid, "models/Player/police.mdl")
		elseif rank < 7 then
			_PlayerSetModel(userid, "models/Player/combine_soldier_prisonguard.mdl")
		elseif rank < 10 then
			_PlayerSetModel(userid, "models/Player/kleiner.mdl")
		else
			_PlayerSetModel(userid, "models/Player/gman_high.mdl")
		end
	end
	_EntFire(userid, "color", TeamColor(team), 0.1)
end

function eventPlayerKilled(killed, attacker, weapon)
	_PlayerAddDeath(killed, 1)
	_file.Write("C:/streetwarprofiles/totalkills.txt", tonumber(_file.Read("C:/streetwarprofiles/totalkills.txt"))+1)
	if killed == attacker  then
		_PlayerAddScore(killed, -1)
	elseif attacker <= _MaxPlayers() and attacker > 0 then
		_PlayerAddScore(attacker, 1)
		players[attacker].money = players[attacker].money+(players[killed].rank*10)+10
		DrawMoney(attacker)
		_PlayerAllowDecalPaint(attacker)
		AddExp(attacker, math.ceil(((players[killed].rank*17.5)-(players[attacker].rank*2.5))*(math.random(100,250)*0.02)))
	else
		_PlayerAddScore(killed, -1)
	end	
end

function AutoMessage(userid, key, timer, x, y, msg, r, g, b)
	_GModText_Start("Default")
		_GModText_SetPos(x, y)
		_GModText_SetColor(r, g, b, 255)
		_GModText_SetTime(timer, 0.25, 0.75)
		_GModText_SetText(msg)
		_GModText_SetDelay(0)
	_GModText_Send(userid, key)
	_GModRect_Start("gmod/white")
		_GModRect_SetPos(x-0.05, y-0.05, string.len(msg)*0.01, 0.1)
		_GModRect_SetColor(0, 0, 0, 200)
		_GModRect_SetTime(timer, 0.25, 0.75)
	_GModRect_Send(userid, key+1)
end

function AddExp(userid, num)
	num = math.clamp(num, 0, 1000)
	if players[userid].rank < 10 then
		players[userid].experience = players[userid].experience+num
		if players[userid].experience >= (players[userid].rank*2000)+(players[userid].rank*250) then
			players[userid].rank = players[userid].rank+1
			PlayerSpawnChooseModel(userid)
			AutoMessage(userid, 100, 5, 0.4, 0.7, "You have advanced to rank "..players[userid].rank.."!!", 255, 25, 25)
		end
		DrawExp(userid)
	end
end

function math.clamp(num, minn, maxn)
	if num < minn then
		return minn
	elseif num > maxn then
		return maxn
	end
	return num
end

function DrawExp(userid)
	_GModText_Start("Default")
	_GModText_SetPos(0.42, 0.9)
	_GModText_SetColor(255, 255, 0, 255)
	_GModText_SetTime(99999, 0.1, 0)
	if players[userid].rank > 9 then
		_GModText_SetText("EXP: MAX")
	else
		_GModText_SetText("EXP: "..players[userid].experience.." / "..(players[userid].rank*2000)+(players[userid].rank*250))
	end
	_GModText_SetDelay(0)
	_GModText_Send(userid, 30)

	_GModText_Start("Default")
	_GModText_SetPos(0.42, 0.95)
	_GModText_SetColor(255, 255, 0, 255)
	_GModText_SetTime(99999, 0, 0)
	_GModText_SetText("Rank: "..players[userid].rank.." / 10")
	_GModText_SetDelay(0)
	_GModText_Send(userid, 31)

	_GModRect_Start("gmod/white")
	_GModRect_SetPos(0.4, 0.88, 0.18, 0.12)
	_GModRect_SetColor(0, 0, 0, 200)
	_GModRect_SetTime(99999, 0, 0)
	_GModRect_Send(userid, 33)
end

function AddMoney(userid, num)
	if num ~= 0 then
		players[userid].money = players[userid].money+num
		DrawMoney(userid)
	end
end

function DrawMoney(userid)
	_GModText_Start("ImpactMassive")
		_GModText_SetPos(0.025, 0.8)
		_GModText_SetColor(255, 255, 255, 255)
		_GModText_SetTime(99999, 0, 0)
		_GModText_SetText("$" .. math.floor(players[userid].money))
	_GModText_Send(userid, 101)
	_GModText_Start("ImpactMassive")
		_GModText_SetPos(0.025, 0.8)
		_GModText_SetColor(0, 255, 0, 220)
		_GModText_SetTime(99999, 0, 0)
		_GModText_SetText("$" .. math.floor(players[userid].money))
	_GModText_SendAnimate(userid, 101, 0.4, 0.4)
end

function DrawHUD(userid)
	DrawExp(userid)
	DrawMoney(userid)
end

function eventPlayerSpawn(userid)
	if players[userid].spawn ~= 0 then
		if TURF[players[userid].spawn].Team ~= _PlayerInfo(userid, "team") then
			players[userid].spawn = 0
		else
			_EntSetPos(userid, vecAdd(vector3(math.random(50, TURF[players[userid].spawn].Radius), math.random(50, TURF[players[userid].spawn].Radius), 10), TURF[players[userid].spawn].Position))
		end
	end
end

function GetPlayerDamageScale( hitgroup ) 
	if hitgroup == HITGROUP_HEAD then
		return 3.0
	end
	return 1.0
end

function eventNPCKilled(Attacker, NPC, Weapon)
end

function sendmessage(userid, key, posx, posy, r, g, b, stime, text)
	_GModText_Start("HudHintTextLarge")
		_GModText_SetPos(posx, posy)
		_GModText_SetColor(r, g, b, 255)
		_GModText_SetTime(stime, 0.5, 1.5)
		_GModText_SetText(text)
		_GModText_SetDelay(0)
	_GModText_Send(userid, key)
end


function message(userid, key, posx, posy, stime, text)
	sendmessage(userid, key, posx, posy, 255, 255, 255, stime, text)
end

function messageMenu(userid, key, posx, posy, stime, text)
	sendmessage(userid, key, posx, posy, 255, 200, 50, stime, text)
end

function messageAttn(userid, key, posx, posy, stime, text)
	sendmessage(userid, key, posx, posy, 255, 0, 0, stime, text)
end

function messageInfo(userid, key, posy, text)
	_GModText_Start("TargetID")
		_GModText_SetPos(-1, posy)
		_GModText_SetColor(255, 255, 255, 255)
		_GModText_SetTime(8, 0.5, 1.5)
		_GModText_SetText(text)
		_GModText_SetDelay(0)
	_GModText_Send(userid, key)
end

function GlobalSave()
	for i=1, _MaxPlayers() do
		if _PlayerInfo(i, "connected") then
			SaveInfo(i)
		end
	end
	for i=1, table.getn(TURF) do
		_file.Write("C:/streetwarprofiles/turf"..i..".txt", TURF[i].Team)
	end
end

function HitTurf(userid, ent)
	userid = tonumber(userid)
	ent = tonumber(ent)
	local n = tonumber(string.sub(_EntGetName(ent), 5))
	if TURF[n].Team ~= _PlayerInfo(userid, "team") then
		TURF[n].Hits = TURF[n].Hits-1
		_PrintMessage(userid, 4, TURF[n].Hits.."/100")
		if TURF[n].Hits <= 0 then 
			TakeOver(userid, n, ent)
		end
	else
		if TURF[n].Hits < 100 then
			TURF[n].Hits = TURF[n].Hits+1
		end
		_PrintMessage(userid, 4, TURF[n].Hits.."/100")
	end
end

function TakeOver(userid, n, ent)
	TURF[n].Team = _PlayerInfo(userid, "team")
	TURF[n].Hits = 100
	_PrintMessageAll(4, "The "..teamnames[_PlayerInfo(userid, "team")].." took over the "..TURF[n].Name.." turf!!")
	_EntFire(ent, "color", TeamColor(TURF[n].Team), 0)
end

function LoadTurf()
	_EntPrecacheModel("models/props_combine/combinethumper002.mdl")
	for i=1, table.getn(TURF) do
		TURF[i].Team = tonumber(_file.Read("C:/streetwarprofiles/turf"..i..".txt"))
		local ent = _EntCreate("prop_dynamic")
		if ent > 0 then
			_EntSetKeyValue(ent, "solid", "6")
			_EntSetModel(ent, "models/props_combine/combinethumper002.mdl")
			_EntSetPos(ent, TURF[i].Position)
			_EntSpawn(ent)
			_EntFire(ent, "color", TeamColor(TURF[i].Team), 0.1)
			_EntSetName(ent, "turf"..i)
		end
	end
end

function onShowHelp ( userid )
	_GModText_Hide( userid, 0, 0.5 )
	_GModText_Hide( userid, 1, 0.5 )
	_GModText_Hide( userid, 2, 0.5 )
	_GModRect_Hide( userid, 0, 0.9 )

	messageMenu(userid,50, 0.30, 0.30, 20, "Street Wars")
	message(userid,51, 0.35, 0.35, 10, "Compete against the other gangs to control turf.")
	message(userid,52, 0.35, 0.38, 11, "Turf means a place to buy equipment and a spawn point.")
	message(userid,53, 0.35, 0.41, 12, "Progress your rank in your gang by killing and taking over turf for experience.")
	message(userid,54, 0.35, 0.44, 13, "Bigger rank means more power in the gang.")
	message(userid,55, 0.35, 0.47, 14, "All information is saved! Gangs, Turf AND player accounts!")
	message(userid,56, 0.35, 0.50, 15, "To take over turf, strike it with a knife until it converts to your gang.")
	message(userid,57, 0.35, 0.53, 16, "It takes a while, so having multiple people do it is a good idea.")
	message(userid,58, 0.35, 0.56, 17, "")
	message(userid,60, 0.35, 0.60, 18, "")
	message(userid,61, 0.35, 0.63, 19, "")
	message(userid,62, 0.35, 0.67, 20, "")
	message(userid,63, 0.35, 0.70, 21, "")
	message(userid,64, 0.35, 0.73, 22, "")
	message(userid,65, 0.35, 0.81, 23, "")
	
	messageAttn(userid,66, 0.30, 0.84, 25, "Press F3 on a turf node to set spawn. Press F4 on a turf node to buy.")
	
	_GModRect_Start( "gmod/white" )
		_GModRect_SetPos(0.2, 0.2, 0.7, 0.7)
		_GModRect_SetColor(0, 0, 0, 150)
		_GModRect_SetTime(25, 0.5, 1.5)
		_GModRect_SetDelay(0)
	_GModRect_Send(userid, 69)
	_PlayerOption( userid, "CloseHelp", 25 )
end

function TeamColor(team)
	if team == TEAM_BLUE then return "0 0 255"
	elseif team == TEAM_GREEN then return "0 255 0"
	elseif team == TEAM_YELLOW then return "255 255 0"
	elseif team == TEAM_RED then return "255 0 0" end
	return "255 255 255"
end

function eventPlayerDisconnect(name, userid, address, steamid, reason)
	if _PlayerInfo(userid, "connected") then
		SaveInfo(userid)
	else
		return
	end
	players[userid].money = STARTING_MONEY
	players[userid].rank = 0
	players[userid].experience = 0
	players[userid].spawn = 0
end

function PickDefaultSpawnTeam(userid)		
	_PlayerChangeTeam(userid, TEAM_SPECTATOR)
	return true
end

function eventPlayerActive(name, userid, steamid)
	_PlayerSetDrawTeamCircle(userid, false)
	LoadInfo(userid)
	onShowTeam(userid)
end

function PickDefaultSpawnTeam(userid)
	_PlayerChangeTeam(userid, TEAM_SPECTATOR)
	return true
end

function onShowTeam(userid)
	-- Title
	_GModText_Start( "ImpactMassive" )
	 _GModText_SetPos( -1, 0.1 )
	 _GModText_SetColor( 255, 200, 0, 205 )
	 _GModText_SetTime( 10, 1.5, 0 )
	 _GModText_SetText( "Street Wars" )
	 _GModText_SetDelay( 1.5 )
	 _GModText_AllowOffscreen( true )
	_GModText_Send( userid, 0 )
	
	_GModText_Start( "ImpactMassive" )
	 _GModText_SetPos( -1, 0.3 )
	 _GModText_SetColor( 255, 200, 0, 205 )
	 _GModText_SetDelay( 1.0 )
	_GModText_SendAnimate( userid, 0, 1.5, 0.7 )

			
	-- credit line
	_GModText_Start( "HudHintTextLarge" )
	 _GModText_SetPos( 0.5, 0.37 )
	 _GModText_SetColor( 255, 255, 255, 255 )
	 _GModText_SetTime( 10, 0.5, 1.5 )
	 _GModText_SetText( "by JetBoom\nThere have been ".._file.Read("C:/streetwarprofiles/totalkills.txt").." people killed since 4/23/06!")
	 _GModText_SetDelay( 1.0 )
	_GModText_Send( userid, 1 )

	
	-- background
	_GModRect_Start( "gmod/white" )
	 _GModRect_SetPos( 0.0, 0.0, 1, 1 )
	 _GModRect_SetColor( 255, 255, 255, 255 )
	 _GModRect_SetTime( 10, 0.5, 2 )
	 _GModRect_SetDelay( 1 )
	_GModRect_Send( userid, 0 )

	_GModRect_Start( "gmod/white" )
	 _GModRect_SetPos( 0.0, 0.3, 1.0, 0.25 )
	 _GModRect_SetColor( 0, 0, 0, 150 )
	 _GModRect_SetDelay( 1 )
	_GModRect_SendAnimate(userid, 0, 0.5, 0.5)
	if _PlayerInfo(userid, "team") == TEAM_SPECTATOR then
	_PlayerOption( userid, "ChooseTeam", 99999 )
	_GModText_Start("Default")
	 _GModText_SetPos(0.01, 0.39)
	 _GModText_SetColor(255, 255, 255, 255) 
	 _GModText_SetTime(99999, 3, 1.0)
	 _GModText_SetText("CHOOSE WISELY! YOU CANNOT CHANGE TEAMS!\n PRESS F1 FOR THE HELP MENU!")
	 _GModText_SetDelay(1.5)
	_GModText_Send(userid, 2)

	_GModText_Start("Default")
	 _GModText_SetPos(0.01, 0.3)
	 _GModText_SetColor(255, 255, 255, 255) 
	 _GModText_SetTime(99999, 3, 1.0)
	 local str = ""
	 for i=TEAM_BLUE, TEAM_RED do
		str = str..(i-1)..") "..teamnames[i].."\n"
	 end
	 _GModText_SetText("Choose your alliegence:\n"..str)
	 _GModText_SetDelay(1.5)
	_GModText_Send(userid, 3)
	end
end

function ChooseTeam( playerid, num, seconds )
	players[playerid].spawn = 0
	_GModRect_Hide( playerid, 0, 0.5 )
	_GModText_Hide( playerid, 1, 0.5 )
	_GModText_Hide( playerid, 2, 0.5 )
	_GModText_Hide( playerid, 3, 0.9 )
	_GModText_Hide( playerid, 4, 0.9 )

	if num < 5 and num > 0 then
		_PlayerChangeTeam(playerid, num+1)
		_PlayerRespawn(playerid)
		_PrintMessageAll(3, _PlayerInfo(playerid,"name").." has joined the "..teamnames[num+1].." gang.")
		_PrintMessageAll(2, _PlayerInfo(playerid,"name").." has joined the "..teamnames[num+1].." gang.")
	else
		_PlayerOption( playerid, "ChooseTeam", 99999 )
	end
end

function onShowSpare1(userid)
	_TraceLine(_PlayerGetShootPos(userid), _PlayerGetShootAng(userid), 256, userid)
	if _TraceHitNonWorld() then
		if string.sub(_EntGetName(_TraceGetEnt()), 1, 4) == "turf" then
			for i=1, table.getn(TURF) do
				if math.floor(_EntGetPos(_TraceGetEnt()).x) == math.floor(TURF[i].Position.x) then
					if _PlayerInfo(userid, "team") == TURF[i].Team then
						players[userid].spawn = i
						_PrintMessage(userid, 3, "You will now spawn in this area, as long as it remains your gang's turf.")
						_PrintMessage(userid, 2, "You will now spawn in this area, as long as it remains your gang's turf.")
					else
						_PrintMessage(userid, 3, "You can't set your spawn in an enemy's turf!")
						_PrintMessage(userid, 2, "You can't set your spawn in an enemy's turf!")
					end
				end
			end
		end
	end
end

function onShowSpare2(userid)
	_TraceLine(_PlayerGetShootPos(userid), _PlayerGetShootAng(userid), 256, userid)
	if _TraceHitNonWorld() then
		if string.sub(_EntGetName(_TraceGetEnt()), 1, 4) == "turf" then
			for i=1, table.getn(TURF) do
				if math.floor(_EntGetPos(_TraceGetEnt()).x) == math.floor(TURF[i].Position.x) then
					if _PlayerInfo(userid, "team") == TURF[i].Team then
						BuyMenu(userid)
					else
						_PrintMessage(userid, 3, "You can't buy things in an enemy's turf!")
						_PrintMessage(userid, 2, "You can't buy things in an enemy's turf!")
					end
				end
			end
		end
	end
end

function BuyMenu(userid)
	if players[userid].rank <= 0 or not _PlayerInfo(userid, "alive") then return end
	local menu = "Choose Item By Rank\n"
	for i=1, players[userid].rank do
		menu = menu..i..") Rank "..i.."\n"
	end
	_GModText_Start("Default")
	 _GModText_SetPos(0.05, 0.2)
	 _GModText_SetColor(255, 255, 255, 255) 
	 _GModText_SetTime(99999, 0.25, 0.25)
	 _GModText_SetText(menu)
	 _GModText_SetDelay(0)
	_GModText_Send(userid, 10)
	_PlayerOption(userid, "ChooseBuyRank", 99999)
end

function ChooseBuyRank(userid, num, seconds)
	_GModText_Hide(userid, 10, 0)
	if num <= players[userid].rank then
		RankSubMenu(userid, num)
	end
end

function RankSubMenu(userid, rank)
	local tab
	local menu = ""
	if rank > 9 then tab = BUYRANK10
	elseif rank > 8 then tab = BUYRANK9
	elseif rank > 7 then tab = BUYRANK8
	elseif rank > 6 then tab = BUYRANK7
	elseif rank > 5 then tab = BUYRANK6
	elseif rank > 4 then tab = BUYRANK5
	elseif rank > 3 then tab = BUYRANK4
	elseif rank > 2 then tab = BUYRANK3
	elseif rank > 1 then tab = BUYRANK2
	elseif rank > 0 then tab = BUYRANK1 else tab = nil end
	if tab == nil then _Msg("Bad tab\n") return end

	for i=1, table.getn(tab) do
		menu = menu..i..") "..tab[i].Name.." - $"..tab[i].Price.."\n"
	end
	_GModText_Start("Default")
	 _GModText_SetPos(0.05, 0.2)
	 _GModText_SetColor(255, 255, 255, 255) 
	 _GModText_SetTime(99999, 0.25, 0.25)
	 _GModText_SetText(menu)
	 _GModText_SetDelay(0)
	_GModText_Send(userid, 10)
	_PlayerOption(userid, "Buy"..rank, 99999)
end

function Buy1(userid, num, seconds)
	_GModText_Hide(userid, 10, 0.25)
	if BUYRANK1[num] == nil then return end
	if players[userid].money >= BUYRANK1[num].Price then
		_PlayerGiveSWEP(userid, BUYRANK1[num].Script)
		players[userid].money = players[userid].money - BUYRANK1[num].Price
		DrawMoney(userid)
	else
		_PrintMessage(userid, 4, "Not enough cash!")
	end
end

function Buy2(userid, num, seconds)
	_GModText_Hide(userid, 10, 0.25)
	if BUYRANK2[num] == nil then return end
	if players[userid].money >= BUYRANK2[num].Price then
		_PlayerGiveSWEP(userid, BUYRANK2[num].Script)
		players[userid].money = players[userid].money - BUYRANK2[num].Price
		DrawMoney(userid)
	else
		_PrintMessage(userid, 4, "Not enough cash!")
	end
end

function Buy3(userid, num, seconds)
	_GModText_Hide(userid, 10, 0.25)
	if BUYRANK3[num] == nil then return end
	if players[userid].money >= BUYRANK3[num].Price then
		_PlayerGiveSWEP(userid, BUYRANK3[num].Script)
		players[userid].money = players[userid].money - BUYRANK3[num].Price
		DrawMoney(userid)
	else
		_PrintMessage(userid, 4, "Not enough cash!")
	end
end

function Buy4(userid, num, seconds)
	_GModText_Hide(userid, 10, 0.25)
	if BUYRANK4[num] == nil then return end
	if players[userid].money >= BUYRANK4[num].Price then
		_PlayerGiveSWEP(userid, BUYRANK4[num].Script)
		players[userid].money = players[userid].money - BUYRANK4[num].Price
		DrawMoney(userid)
	else
		_PrintMessage(userid, 4, "Not enough cash!")
	end
end

function Buy5(userid, num, seconds)
	_GModText_Hide(userid, 10, 0.25)
	if BUYRANK5[num] == nil then return end
	if players[userid].money >= BUYRANK5[num].Price then
		_PlayerGiveSWEP(userid, BUYRANK5[num].Script)
		players[userid].money = players[userid].money - BUYRANK5[num].Price
		DrawMoney(userid)
	else
		_PrintMessage(userid, 4, "Not enough cash!")
	end
end

function Buy6(userid, num, seconds)
	_GModText_Hide(userid, 10, 0.25)
	if BUYRANK6[num] == nil then return end
	if players[userid].money >= BUYRANK6[num].Price then
		_PlayerGiveSWEP(userid, BUYRANK6[num].Script)
		players[userid].money = players[userid].money - BUYRANK6[num].Price
		DrawMoney(userid)
	else
		_PrintMessage(userid, 4, "Not enough cash!")
	end
end

function Buy7(userid, num, seconds)
	_GModText_Hide(userid, 10, 0.25)
	if BUYRANK7[num] == nil then return end
	if players[userid].money >= BUYRANK7[num].Price then
		_PlayerGiveSWEP(userid, BUYRANK7[num].Script)
		players[userid].money = players[userid].money - BUYRANK7[num].Price
		DrawMoney(userid)
	else
		_PrintMessage(userid, 4, "Not enough cash!")
	end
end

function Buy8(userid, num, seconds)
	_GModText_Hide(userid, 10, 0.25)
	if BUYRANK8[num] == nil then return end
	if players[userid].money >= BUYRANK8[num].Price then
		_PlayerGiveSWEP(userid, BUYRANK8[num].Script)
		players[userid].money = players[userid].money - BUYRANK8[num].Price
		DrawMoney(userid)
	else
		_PrintMessage(userid, 4, "Not enough cash!")
	end
end

function Buy9(userid, num, seconds)
	_GModText_Hide(userid, 10, 0.25)
	if BUYRANK9[num] == nil then return end
	if players[userid].money >= BUYRANK9[num].Price then
		_PlayerGiveSWEP(userid, BUYRANK9[num].Script)
		players[userid].money = players[userid].money - BUYRANK9[num].Price
		DrawMoney(userid)
	else
		_PrintMessage(userid, 4, "Not enough cash!")
	end
end

function Buy10(userid, num, seconds)
	_GModText_Hide(userid, 10, 0.25)
	if BUYRANK10[num] == nil then return end
	if players[userid].money >= BUYRANK10[num].Price then
		_PlayerGiveSWEP(userid, BUYRANK10[num].Script)
		players[userid].money = players[userid].money - BUYRANK10[num].Price
		DrawMoney(userid)
	else
		_PrintMessage(userid, 4, "Not enough cash!")
	end
end

function LoadInfo(userid)
	local a = 0
	local b = 0
	if _file.Exists("C:/streetwarprofiles/"..ConvertNet(_PlayerInfo(userid, "networkid"))..".txt") then
		local buff = _file.Read("C:/streetwarprofiles/"..ConvertNet(_PlayerInfo(userid, "networkid"))..".txt")
		a = string.find(buff, ":")
		players[userid].money = tonumber(string.sub(buff, 1, a-1))
		DrawMoney(userid)
		b = string.find(buff, ":", a+1)
		players[userid].experience = tonumber(string.sub(buff, a+1, b-1))
		a = string.find(buff, ":", b+1)
		players[userid].rank = tonumber(string.sub(buff, b+1, a-1))
		_PlayerChangeTeam(userid, tonumber(string.sub(buff, a+1)))
		_PrintMessage(userid, 3, "Your profile has been loaded.\n")
		_PlayerRespawn(userid)
		DrawHUD(userid)
	else
		SaveInfo(userid)
		LoadInfo(userid)
	end
end

function SaveInfo(userid)
	if not _PlayerInfo(userid, "connected") then return end
	local towrite = players[userid].money..":"..players[userid].experience..":"..players[userid].rank..":".._PlayerInfo(userid,"team")
	_file.Write("C:/streetwarprofiles/"..ConvertNet(_PlayerInfo(userid, "networkid"))..".txt", towrite)
	_PrintMessage(userid, 3, "Your profile has been saved.\n")
end

function VecToString(vec)
	return vec.x..","..vec.y..","..vec.z
end

function StringToVec(str)
	local vec = vector3(0, 0, 0)
	local yst = string.find(str, ",")
	local zst = string.find(str, ",", yst+1)
	vec.x = tonumber(string.sub(str, 1, yst-1))
	vec.y = tonumber(string.sub(str, yst+1, zst-1))
	vec.z = tonumber(string.sub(str, zst+1))
return vec
end

function IsInRadius(a, b, dist)
	return math.abs(vecLength(vecSub(_EntGetPos(a),_EntGetPos(b)))) <= dist
end

function ConvertNet(str)
	if str == "UNKNOWN" or str == "STEAM_ID_PENDING" or str == "STEAM_ID_LAN" then return "garbage"
	else
		return string.sub(str, 11)
	end
end
