VehicleTypes["Bomber"] = {
Name = "Bomber",
Model = "models/props_junk/wood_crate002a.mdl",
Description = "Bomber with AMS and carpet bombs.",
Stock = 3,
EntityType = "prop_physics",
MaxHealth = 70,
DamageMultiply = 1.0,
PassengerSlots = 0,
DriverCamDistance = 0,
CreationOffset = vector3(0,0,50),
ExitOffset = vector3(0,0,1),
Lockable = false,

HUD = function(vehicle)
	if Vehicles[vehicle].Driver > 0 then
		_GModRect_Start("gmod/white")
		_GModRect_SetPos(0.42, 0.85, 0.18, 0.1)
		_GModRect_SetColor( 0, 0, 0, 100 )
		_GModRect_SetTime( 10000, 0, 0 )
		_GModRect_Send( Vehicles[vehicle].Driver, 10000 )
		_GModText_Start( "Default" )
		_GModText_SetPos( -1, 0.88 )
		_GModText_SetColor( 255, 0, 0, 255 )
		_GModText_SetTime( 9999, 0.1, 0.1 )
		_GModText_SetText( "HP: "..math.ceil(Vehicles[vehicle].Health).."/"..VehicleTypes[Vehicles[vehicle].Type].MaxHealth )
		_GModText_Send( Vehicles[vehicle].Driver, 10001 )
	end
end,

HideHUD = function(userid)
	_GModRect_Hide(userid, 10000, 0.2)
	_GModText_Hide(userid, 10001, 0.2)
end,

onAttack = function(vehicle)
	if _CurTime() > BOMBERLASTATTACK[vehicle]+5.0 then
		BomberAttack(vehicle)
		AddTimer(0.65, 2, BomberAttack, vehicle)
		BOMBERLASTATTACK[vehicle] = _CurTime()
	end
end,

onRemoved = function(vehicle)
	BOMBERLASTATTACK[vehicle] = nil
end,

onDestroyed = function(vehicle)
	BOMBERLASTATTACK[vehicle] = nil
	_EntEmitSoundEx(vehicle, "ambient/explosions/explode_6.wav", 1.1, 1.0)
	_EntEmitSoundEx(vehicle, "ambient/explosions/explode_5.wav", 1.1, 0.8)
	for i=1, 10 do
		local ent = _EntCreate("env_explosion")
		if ent > 0 then
			_EntSetKeyValue(ent, "spawnflags", "17")
			_EntSetPos(ent, _EntGetPos(vehicle))
			_EntSpawn(ent)
			_EntSetParent(ent, vehicle)
			_EntFire(ent, "explode", "", i*0.25)
			_EntFire(ent, "kill", "", (i*0.25)+0.1)
		end
	end
	_phys.EnableGravity(vehicle, true)
	local ent2 = _EntCreate("env_ar2explosion")
	if ent2 > 0 then
		_EntSetPos(ent2, _EntGetPos(vehicle))
		_EntSpawn(ent2)
		_EntSetParent(ent2, vehicle)
		_EntFire(ent2, "explode", "", 2.45)
		_EntFire(ent2, "kill", "", 2.55)
	end
	AddTimer(2.45, 1, _EntEmitSoundEx, vehicle, "npc/combine_gunship/gunship_explode2.wav", 1.5, 1.0)
	_EntFire(vehicle, "break", "", 2.5)
	_EntFire(vehicle, "kill", "", 2.6)
	_phys.ApplyTorqueCenter(vehicle, vector3(-15000, -15000, -500000))
end,

onDamaged = function(vehicle, attacker, damage)
	if Vehicles[vehicle].Health < VehicleTypes[Vehicles[vehicle].Type].MaxHealth*0.5 and damage > 10 then
		local finalpos = vecAdd(_EntGetPos(vehicle), vector3(math.random(-38, 38), math.random(-38, 38), math.random(-38, 38)))
		local ent = _EntCreate("env_fire_trail")
		if ent > 0 then
			_EntSetPos(ent, finalpos)
			_EntSpawn(ent)
			_EntSetParent(ent, vehicle)
			_EntFire(ent, "kill", "", math.random(3, 5))
		end
		local ent2 = _EntCreate("env_explosion")
		if ent2 > 0 then
			_EntSetKeyValue(ent2, "spawnflags", "17")
			_EntSetPos(ent2, finalpos)
			_EntSpawn(ent2)
			_EntFire(ent2, "explode", "", 0)
			_EntFire(ent2, "kill", "", 0.1)
		end
	end
end,

onCreated = function(vehicle)
	BOMBERLASTATTACK[vehicle] = _CurTime()
	_EntFire(vehicle, "sethealth", "65535", 0)
end,

onThink = function(vehicle)
	local owner = Vehicles[vehicle].Owner
	local driver = Vehicles[vehicle].Driver
	if driver > 0 then
		_EntitySetPhysicsAttacker(vehicle, driver)
		if _EntGetWaterLevel(driver) ~= nil then
			if _EntGetWaterLevel(driver) > 1 then
				if Vehicles[vehicle].Health > 0 then
					VehicleDestroyed(owner, vehicle)
				end
			end
		end
	elseif owner > 0 then
		_EntitySetPhysicsAttacker(vehicle, owner)
	end
end,

onForward = function(vehicle)
	if _PlayerGetShootAng(Vehicles[vehicle].Driver) ~= nil then
		local force = _PlayerGetShootAng(Vehicles[vehicle].Driver)
		force = vecMul(force, vector3(390, 390, 390))
		force.z = force.z + 540
		force = vecMul(force, TICKRATE)
		_phys.ApplyForceCenter(vehicle, force)
	end
end
}

BOMBERLASTATTACK = {}
_EntPrecacheModel("models/props_junk/watermelon01.mdl")
function BomberAttack(vehicle)
	if Vehicles[vehicle] == nil or _EntGetType(vehicle) == "n/a" then return end
	local ent = _EntCreate("prop_physics")
	if ent > 0 then
		_EntSetModel(ent, "models/props_junk/watermelon01.mdl")
		_EntSetPos(ent, vecAdd(_EntGetPos(vehicle), vector3(0,0,-25)))
		_EntSpawn(ent)
		_EntFire(ent, "sethealth", "99999", 0)
		_EntFire(ent, "kill", "", 10)
		_phys.SetMass(ent, 50)
		local trail = _EntCreate("env_smoketrail")
		if trail > 0 then
			_EntSetPos(trail, _EntGetPos(ent))
			_EntSpawn(trail)
			_EntSetParent(trail, ent)
			_EntFire(trail, "kill", "", 10)
		end
		local owna = Vehicles[vehicle].Owner
		BOMBTIMER[ent] = AddTimer(0.1, 95, BombCheckExplode, ent, owna)
		_EntEmitSoundEx(ent, "npc/env_headcrabcanister/incoming.wav", 1.2, 0.65)
	end
	_EntEmitSound(vehicle, "buttons/lever1.wav")
	return true
end

BOMBTIMER = {}
function BombCheckExplode(bomb, userid)
	_EntitySetPhysicsAttacker(bomb, userid)
	_TraceLine(_EntGetPos(bomb), vector3(0,0,-1), 40, bomb)
	if _TraceHit() then
		if _TraceHitNonWorld() then
			if Vehicles[_TraceGetEnt()] then
				if Vehicles[_TraceGetEnt()].Owner == userid then return end
			end
		end
		local ents = _EntitiesFindInSphere(_EntGetPos(bomb), 256)
		for k,i in ents do
			_TraceAttack(i, userid, userid, (256-Distance(_EntGetPos(i), _EntGetPos(bomb)))*0.51)
		end
		NoDamageLuaExplosion(_EntGetPos(bomb))
		_EntFire(bomb, "break", "", 0)
		_EntFire(bomb, "kill", "", 0.05)
		HaltTimer(BOMBTIMER[bomb])
		BOMBTIMER[bomb] = nil
	end
end
