VehicleTypes["Fighter"] = {
Name = "Fighter",
Model = "models/props_junk/wood_crate001a.mdl",
Description = "One man light-fighter.",
Stock = 6,
EntityType = "prop_physics",
MaxHealth = 50,
DamageMultiply = 1.0,
PassengerSlots = 0,
DriverCamDistance = 0,
CreationOffset = vector3(0,0,50),
ExitOffset = vector3(0,0,1),
Lockable = true,

HUD = function(vehicle)
	if Vehicles[vehicle].Driver > 0 then
		_GModRect_Start("gmod/white")
		_GModRect_SetPos(0.42, 0.85, 0.18, 0.1)
		_GModRect_SetColor( 0, 0, 0, 100 )
		_GModRect_SetTime( 10000, 0, 0 )
		_GModRect_Send( Vehicles[vehicle].Driver, 10000 )
		_GModText_Start( "Default" )
		_GModText_SetPos( -1, 0.88 )
		_GModText_SetColor( 255, 0, 0, 255 )
		_GModText_SetTime( 9999, 0.1, 0.1 )
		_GModText_SetText( "HP: "..math.ceil(Vehicles[vehicle].Health).."/"..VehicleTypes[Vehicles[vehicle].Type].MaxHealth )
		_GModText_Send( Vehicles[vehicle].Driver, 10001 )
	end
end,

HideHUD = function(userid)
	_GModRect_Hide(userid, 10000, 0.2)
	_GModText_Hide(userid, 10001, 0.2)
end,

onAttack = function(vehicle)
	if _CurTime() > FIGHTERLASTATTACK[vehicle]+3.5 then
		if FighterAttack(vehicle) then
			FIGHTERLASTATTTACK[vehicle] = _CurTime()
		end
	end
end,

onRemoved = function(vehicle)
	FIGHTERLASTATTACK[vehicle] = nil
	FIGHTERBOOSTER[vehicle] = nil
end,

onJump = function(vehicle)
	if _CurTime() > FIGHTERBOOSTER[vehicle] + 8 then
		FIGHTERBOOSTER[vehicle] = _CurTime()
		AddTimer(0.1, 6, UltraBoost, vehicle)
		_EntEmitSoundEx(vehicle, "ambient/fire/gascan_ignite1.wav", 1, 0.6)
		local tempx = _EntCreate("env_smokestack")
		if tempx > 0 then
			_EntSetKeyValue(tempx, "InitialState", "1")
			_EntSetKeyValue(tempx, "BaseSpread", "2")
			_EntSetKeyValue(tempx, "SpreadSpeed", "8")
			_EntSetKeyValue(tempx, "Speed", "4")
			_EntSetKeyValue(tempx, "startsize", "16")
			_EntSetKeyValue(tempx, "EndSize", "8")
			_EntSetKeyValue(tempx, "Rate", "32")
			_EntSetKeyValue(tempx, "JetLength", "8")
			_EntSetKeyValue(tempx, "SmokeMaterial", "particle/SmokeStack.vmt")
			_EntSetKeyValue(tempx, "twist", "0")
			_EntSetKeyValue(tempx, "roll", "0")
			_EntSetKeyValue(tempx, "rendercolor", TeamColor(Vehicles[vehicle].Team))
			_EntSetKeyValue(tempx, "renderamt", "220")
			_EntSetPos(tempx, _EntGetPos(vehicle))
			_EntSpawn(tempx)
			_EntSetParent(tempx, vehicle)
			_EntFire(tempx, "TurnOn", "", 0)
			_EntFire(tempx, "TurnOff", "", 3)
			_EntFire(tempx, "kill", "", 7)
			local glow = _EntCreate("env_sprite")
			if glow > 0 then
				_EntSetKeyValue(glow, "model", "sprites/blueflare1.spr")
				_EntSetKeyValue(glow, "rendermode", "5")
				_EntSetKeyValue(glow, "rendercolor", "255 200 30")
				_EntSetKeyValue(glow, "scale", "0.75")
				_EntSetKeyValue(glow, "spawnflags", "1")
				_EntSetPos(glow, _EntGetPos(vehicle))
				_EntSpawn(glow)
				_EntSetParent(glow, vehicle)
			end
		end
	end
end,

onDestroyed = function(vehicle)
	FIGHTERLASTATTACK[vehicle] = nil
	_phys.EnableGravity(vehicle, false)
	_EntEmitSoundEx(vehicle, "ambient/explosions/explode_6.wav", 1.1, 1.0)
	_EntEmitSoundEx(vehicle, "ambient/explosions/explode_5.wav", 1.1, 0.8)
	if math.random(1, 10) > 6 then
		for i=1, 10 do
			local ent = _EntCreate("env_explosion")
			if ent > 0 then
				_EntSetKeyValue(ent, "spawnflags", "17")
				_EntSetPos(ent, _EntGetPos(vehicle))
				_EntSpawn(ent)
				_EntSetParent(ent, vehicle)
				_EntFire(ent, "explode", "", i*0.25)
				_EntFire(ent, "kill", "", (i*0.25)+0.1)
			end
		end
		_phys.EnableGravity(vehicle, true)
		local ent2 = _EntCreate("env_ar2explosion")
		if ent2 > 0 then
			_EntSetPos(ent2, _EntGetPos(vehicle))
			_EntSpawn(ent2)
			_EntSetParent(ent2, vehicle)
			_EntFire(ent2, "explode", "", 2.45)
			_EntFire(ent2, "kill", "", 2.55)
		end
		AddTimer(2.45, 1, _EntEmitSoundEx, vehicle, "npc/env_headcrabcanister/explosion.wav", 1.5, 1.0)
		_EntFire(vehicle, "break", "", 2.5)
		_EntFire(vehicle, "kill", "", 2.6)
		_phys.ApplyTorqueCenter(vehicle, vector3(-15000, -15000, -500000))
	else
		NoDamageLuaExplosion(_EntGetPos(vehicle))
		local ent = _EntCreate("env_explosion")
		if ent > 0 then
			_EntSetKeyValue(ent, "spawnflags", "17")
			_EntSetPos(ent, _EntGetPos(vehicle))
			_EntSpawn(ent)
			_EntFire(ent, "explode", "", 0)
			_EntFire(ent, "kill", "", 0.1)
		end
		_EntEmitSoundEx(vehicle, "npc/env_headcrabcanister/explosion.wav", 1.5, 1.0)
		_EntFire(vehicle, "break", "", 0)
		_EntFire(vehicle, "kill", "", 0.1)
	end
end,

onDamaged = function(vehicle, attacker, damage)
	if Vehicles[vehicle].Health < VehicleTypes[Vehicles[vehicle].Type].MaxHealth*0.5 and damage > 10 then
		local finalpos = vecAdd(_EntGetPos(vehicle), vector3(math.random(-38, 38), math.random(-38, 38), math.random(-38, 38)))
		local ent = _EntCreate("env_fire_trail")
		if ent > 0 then
			_EntSetPos(ent, finalpos)
			_EntSpawn(ent)
			_EntSetParent(ent, vehicle)
			_EntFire(ent, "kill", "", math.random(3, 5))
		end
		local ent2 = _EntCreate("env_explosion")
		if ent2 > 0 then
			_EntSetKeyValue(ent2, "spawnflags", "17")
			_EntSetPos(ent2, finalpos)
			_EntSpawn(ent2)
			_EntFire(ent2, "explode", "", 0)
			_EntFire(ent2, "kill", "", 0.1)
		end
	end
end,

onCreated = function(vehicle)
	FIGHTERLASTATTACK[vehicle] = _CurTime()
	FIGHTERBOOSTER[vehicle] = _CurTime()
	_EntFire(vehicle, "sethealth", "65535", 0)
end,

onThink = function(vehicle)
	local owner = Vehicles[vehicle].Owner
	local driver = Vehicles[vehicle].Driver
	if driver > 0 then
		_EntitySetPhysicsAttacker(vehicle, driver)
		if _EntGetWaterLevel(driver) ~= nil then
			if _EntGetWaterLevel(driver) > 1 then
				if Vehicles[vehicle].Health > 0 then
					VehicleDestroyed(owner, vehicle)
				end
			end
		end
	elseif owner > 0 then
		_EntitySetPhysicsAttacker(vehicle, owner)
	end
end,

onForward = function(vehicle)
	if _PlayerGetShootAng(Vehicles[vehicle].Driver) ~= nil then
		local force = _PlayerGetShootAng(Vehicles[vehicle].Driver)
		force = vecMul(force, vector3(800, 800, 700))
		force.z = force.z + 220
		force = vecMul(force, TICKRATE)
		_phys.ApplyForceCenter(vehicle, force)
	end
end
}

FIGHTERLASTATTACK = {}
FIGHTERBOOSTER = {}

function FighterAttack(vehicle)
	if Vehicles[vehicle] == nil or _EntGetType(vehicle) == "n/a" then return end
	local lock = 0
	local rep = 1
	while rep < 50 and lock <= 0 do
		_TraceLine(_EntGetPos(vehicle), _PlayerGetShootAng(Vehicles[vehicle].Driver), rep*64, vehicle)
		local ents = _EntitiesFindInSphere(_TraceEndPos(), 256)
		for k,i in ents do
			if Vehicles[i] then
				if Vehicles[i].Team ~= Vehicles[vehicle].Team then
					if VehicleTypes[Vehicles[i].Type].Lockable then
						lock = i
					end
				end
			end
		end
		rep = rep+1
	end
	Cannon(Vehicles[vehicle].Driver, vehicle, lock)
	FIGHTERLASTATTACK[vehicle] = _CurTime()
	if lock > 0 then
		_PlaySoundPlayer(Vehicles[vehicle].Driver, "buttons/button3.wav")
	end
	return true
end

function UltraBoost(vehicle)
	if Vehicles[vehicle] == nil or _EntGetType(vehicle) == "n/a" then return end
	if Vehicles[vehicle].Driver > 0 then
		if _PlayerGetShootAng(Vehicles[vehicle].Driver) ~= nil then
			_phys.ApplyForceCenter(vehicle, vecMul(_PlayerGetShootAng(Vehicles[vehicle].Driver), 999999))
		end
	else
		_phys.ApplyForceCenter(vehicle, vecMul(_EntGetAng(vehicle), 999999))
	end
end
