VehicleTypes["GunShip"] = {
Name = "Gun Ship",
Model = "models/props_interiors/Furniture_Couch02a.mdl",
Description = "Heavy duty flying vehicle with PPG's.",
Stock = 1,
EntityType = "prop_physics",
MaxHealth = 225,
DamageMultiply = 1.0,
PassengerSlots = 0,
DriverCamDistance = 128,
CreationOffset = vector3(0,0,50),
ExitOffset = vector3(0,0,1),
Lockable = false,

HUD = function(vehicle)
	if Vehicles[vehicle].Driver > 0 then
		_GModRect_Start("gmod/white")
		_GModRect_SetPos(0.42, 0.85, 0.18, 0.1)
		_GModRect_SetColor( 0, 0, 0, 100 )
		_GModRect_SetTime( 10000, 0, 0 )
		_GModRect_Send( Vehicles[vehicle].Driver, 10000 )
		_GModText_Start( "Default" )
		_GModText_SetPos( -1, 0.88 )
		_GModText_SetColor( 255, 0, 0, 255 )
		_GModText_SetTime( 9999, 0.1, 0.1 )
		_GModText_SetText( "HP: "..math.ceil(Vehicles[vehicle].Health).."/"..VehicleTypes[Vehicles[vehicle].Type].MaxHealth )
		_GModText_Send( Vehicles[vehicle].Driver, 10001 )
	end
end,

HideHUD = function(userid)
	_GModRect_Hide(userid, 10000, 0.2)
	_GModText_Hide(userid, 10001, 0.2)
end,

onAttack = function(vehicle)
	if _CurTime() > GUNSHIPLASTATTACK[vehicle]+2.0 then
		GunShipAttack(vehicle)
		GUNSHIPLASTATTACK[vehicle] = _CurTime()
	end
end,

onRemoved = function(vehicle)
	GUNSHIPLASTATTACK[vehicle] = nil
end,

onDestroyed = function(vehicle)
	GUNSHIPLASTATTACK[vehicle] = nil
	AddTimer(1, 2, DelayExplosion, vehicle)
	_EntEmitSoundEx(vehicle, "ambient/explosions/explode_6.wav", 1.1, 1.0)
	for i=1, 3 do
		local ent2 = _EntCreate("env_ar2explosion")
		if ent2 > 0 then
			_EntSetPos(ent2, _EntGetPos(vehicle))
			_EntSpawn(ent2)
			_EntSetParent(ent2, vehicle)
			_EntFire(ent2, "explode", "", i-0.1)
			_EntFire(ent2, "kill", "", i-0.05)
		end
	end
	local ent2 = _EntCreate("env_explosion")
	if ent2 > 0 then
		_EntSetKeyValue(ent2, "spawnflags", "17")
		_EntSetPos(ent2, _EntGetPos(vehicle))
		_EntSetParent(ent2, vehicle)
		_EntSpawn(ent2)
		_EntFire(ent2, "explode", "", 2.9)
		_EntFire(ent2, "kill", "", 3.0)
	end
	AddTimer(1.0, 2, _EntEmitSoundEx, vehicle, "npc/combine_gunship/gunship_explode2.wav", 1.5, 1.0)
	_EntFire(vehicle, "ignite", "", 0)
	_EntFire(vehicle, "break", "", 3.0)
	_EntFire(vehicle, "kill", "", 3.1)
	_phys.ApplyTorqueCenter(vehicle, vector3(-15000, -15000, -500000))
end,

onDamaged = function(vehicle, attacker, damage)
	if Vehicles[vehicle].Health < VehicleTypes[Vehicles[vehicle].Type].MaxHealth*0.5 and damage > 10 then
		local finalpos = vecAdd(_EntGetPos(vehicle), vector3(math.random(-38, 38), math.random(-38, 38), math.random(-38, 38)))
		local ent = _EntCreate("env_fire_trail")
		if ent > 0 then
			_EntSetPos(ent, finalpos)
			_EntSpawn(ent)
			_EntSetParent(ent, vehicle)
			_EntFire(ent, "kill", "", math.random(3, 5))
		end
		local ent2 = _EntCreate("env_explosion")
		if ent2 > 0 then
			_EntSetKeyValue(ent2, "spawnflags", "17")
			_EntSetPos(ent2, finalpos)
			_EntSpawn(ent2)
			_EntFire(ent2, "explode", "", 0)
			_EntFire(ent2, "kill", "", 0.1)
		end
	end
end,

onCreated = function(vehicle)
	GUNSHIPLASTATTACK[vehicle] = _CurTime()
	_EntFire(vehicle, "sethealth", "65535", 0)
	_phys.EnableGravity(vehicle, false)
end,

onThink = function(vehicle)
	if Vehicles[vehicle].Driver > 0 then
		_EntitySetPhysicsAttacker(vehicle, Vehicles[vehicle].Driver)
		if _EntGetWaterLevel(Vehicles[vehicle].Driver) ~= nil then
			if _EntGetWaterLevel(Vehicles[vehicle].Driver) > 1 then
				if Vehicles[vehicle].Health > 0 then
					VehicleDestroyed(Vehicles[vehicle].Owner, vehicle)
				end
			end
		end
	elseif Vehicles[vehicle].Owner > 0 then
		_EntitySetPhysicsAttacker(vehicle, Vehicles[vehicle].Owner)
	end
end,

onForward = function(vehicle)
	if _PlayerGetShootAng(Vehicles[vehicle].Driver) ~= nil then
		_phys.ApplyForceCenter(vehicle, vecMul(vecMul(_PlayerGetShootAng(Vehicles[vehicle].Driver), vector3(490, 490, 490)), TICKRATE))
	end
end
}

GUNSHIPLASTATTACK = {}
function GunShipAttack(vehicle)
	if Vehicles[vehicle] == nil or _EntGetType(vehicle) == "n/a" then return end
	local ent = _EntCreate("grenade_ar2")
	if ent > 0 then
		_EntEmitSound(vehicle, "weapons/mortar/mortar_fire1.wav")
		local ang = _PlayerGetShootAng(Vehicles[vehicle].Driver)
		_EntSetPos(ent, _EntGetPos(vehicle))
		if ang.z > 0 then ang.z = 0 end
		_EntSetVelocity(ent, vecMul(ang, 2000, 2000, 2000))
		_EntSetKeyValue(ent, "iMagnitude", "0")
		_EntSetOwner(ent, vehicle)
		_EntSpawn(ent)
		GUNSHIPTIMER[ent] = AddTimer(0.1, 95, GunShipProjCheckExplode, ent, Vehicles[vehicle].Owner, ang)
	end
	return true
end

GUNSHIPTIMER = {}
function GunShipProjCheckExplode(bomb, userid, ang)
	_TraceLine(_EntGetPos(bomb), vector3(0,0,-1), 50, bomb) local ahit = _TraceHit()
	_TraceLine(_EntGetPos(bomb), ang, 50, bomb) local bhit = _TraceHit()
	if ahit or bhit then
		_EntSetPos(bomb, _TraceEndPos())
		if _TraceHitNonWorld() then
			if Vehicles[_TraceGetEnt()] then
				if Vehicles[_TraceGetEnt()].Owner == userid then return end
			end
		end
		local ents = _EntitiesFindInSphere(_EntGetPos(bomb), 128)
		for k,i in ents do
			_TraceAttack(i, userid, userid, (128-Distance(_EntGetPos(i), _EntGetPos(bomb)))*0.5)
		end
		local ent2 = _EntCreate("env_explosion")
		if ent2 > 0 then
			_EntSetKeyValue(ent2, "spawnflags", "17")
			_EntSetPos(ent2, _EntGetPos(bomb))
			_EntSpawn(ent2)
			_EntFire(ent2, "explode", "", 0.15)
			_EntFire(ent2, "kill", "", 0.16)
		end
		HaltTimer(GUNSHIPTIMER[bomb])
		GUNSHIPTIMER[bomb] = nil
	end
end

function DelayExplosion(ent)
	NoDamageLuaExplosion(_EntGetPos(ent))
end
