function SpawnAllResFiles()
	local results = _file.Find( "maps/*.res" )
	for i=1, table.getn(results) do
		if results[i] ~= "." and results[i] ~= ".." then
			if _file.Exists( "maps/"..results[i]) then
				_file.Delete("maps/"..results[i])
			end
		end
	end
	local result = _file.Find( "maps/*.bsp" )
	for i=1, table.getn(result) do
		if result[i] ~= "." and result[i] ~= ".." then
			if _file.Exists( "maps/"..result[i]) then
				_file.Write("maps/"..string.gsub(result[i], "bsp", "res"), CreateResFileString())
			end
		end
	end
end

function CreateResFileString()
	local str = [["resources"
{
"sound/zombiesurvival/lasthuman_noxious.mp3" "file"
"sound/zombiesurvival/halflife_noxious.mp3" "file"
"sound/lazah.mp3" "file"
"models/noxious/largewall.mdl" "file"
"models/noxious/largewall.phy" "file"
"models/noxious/largewall.vvd" "file"
"models/noxious/largewall.sw.vtx" "file"
"models/noxious/largewall.dx80.vtx" "file"
"models/noxious/largewall.dx90.vtx" "file"
"materials/models/noxious/stonewall.vmt" "file"
"materials/models/noxious/stonewall.vtf" "file"
"sound/nox/vulcan_fire.wav" "file"
"sound/interjection.mp3" "file"
"materials/lm/lm.vmt" "file"
"materials/lm/lm.vtf" "file"
"materials/lm/lm2.vmt" "file"
"materials/lm/lm2.vtf" "file"
"materials/lm/lolban.vmt" "file"
"materials/lm/lolban.vtf" "file"
"materials/zombiesurvival/zssplash_v4.vmt" "file"
"materials/zombiesurvival/zssplash_v4.vtf" "file"
"materials/deathnotify/d_brains.vmt" "file"
"materials/deathnotify/d_brains.vtf" "file"
"materials/deathnotify/d_axe.vtf" "file"
"materials/deathnotify/d_axe.vmt" "file"
"models/peanut/conansword.mdl" "file"
"models/peanut/conansword.vvd" "file"
"models/peanut/conansword.phy" "file"
"models/peanut/conansword.dx80.vtx" "file"
"models/peanut/conansword.dx90.vtx" "file"
"models/peanut/conansword.sw.vtx" "file"
"materials/peanut/conansword.vmt" "file"
"materials/peanut/conansword.vtf" "file"
"sound/lm/lm.wav" "file"
"materials/mage/spellselect.vtf" "file"
"materials/mage/spellselect.vmt" "file"
"materials/mage/spellselect2.vtf" "file"
"materials/mage/spellselect2.vmt" "file"
"materials/darkmage/spellselect.vtf" "file"
"materials/darkmage/spellselect.vmt" "file"
"materials/divinemage/spellselect.vtf" "file"
"materials/divinemage/spellselect.vmt" "file"
"sound/nox/sunburstcluster_explode.wav" "file"
"sound/nox/sunburst_explode.wav" "file"
"sound/leeroyjenkins.wav" "file"
"sound/stfu.wav" "file"
"sound/banned2.wav" "file"
"sound/nox/carjacked.wav" "file"
"sound/nox/DU.wav" "file"
"sound/nox/ET.wav" "file"
"sound/nox/IN.wav" "file"
"sound/nox/CHA.wav" "file"
"sound/nox/KA.wav" "file"
"sound/nox/RU.wav" "file"
"sound/nox/UN.wav" "file"
"sound/nox/ZO.wav" "file"
"sound/nox/invisoff.wav" "file"
"sound/nox/invison.wav" "file"
"sound/nox/shield.wav" "file"
"sound/nox/blink.wav" "file"
"sound/nox/heal.wav" "file"
"sound/nox/slowon.wav" "file"
"sound/nox/slowoff.wav" "file"
"sound/racing11.mp3" "file"
"sound/racing12.mp3" "file"
"sound/racing13.mp3" "file"
"sound/racing14.mp3" "file"
"sound/motdintro.mp3" "file"
"sound/youlose2.wav" "file"
"sound/speach/lag.mp3" "file"
"sound/speach/obeyyourthirst3.wav" "file"
"sound/speach/obeyyourthirst2.wav" "file"
"sound/speach/obeyyourthirst.wav" "file"
"sound/nox/helirotor.wav" "file"
"sound/nox/player_death.wav" "file"
"sound/nox/lightning_impact.wav" "file"
"sound/nox/plasma_explode.wav" "file"
"sound/nox/plasmaturret_fire.wav" "file"
"sound/nox/berserkercharge.wav" "file"
"sound/nox/counterspell.wav" "file"
"sound/nox/inversion.wav" "file"
"sound/nox/explosion01.wav" "file"
"sound/nox/explosion02.wav" "file"
"sound/nox/explosion03.wav" "file"
"sound/nox/explosion04.wav" "file"
"sound/nox/explosion05.wav" "file"
"sound/nox/explosion06.wav" "file"
"sound/stomachram.wav" "file"
"sound/angrykid.wav" "file"
"sound/jbb/enemyscore.mp3" "file"
"sound/jbb/allyscore.mp3" "file"
"sound/jbb/knockout.mp3" "file"
"sound/jbb/respawning.mp3" "file"
"sound/jbb/ballsnatch.mp3" "file"
"materials/nedm.vmt" "file"
"materials/nedm.vtf" "file"
"sound/holyshit.mp3" "file"
"materials/necromancer/spellselect.vtf" "file"
"materials/necromancer/spellselect.vmt" "file"
"materials/deathnotify/d_magegeneric.vtf" "file"
"materials/deathnotify/d_magegeneric.vmt" "file"
"materials/deathnotify/d_sword.vtf" "file"
"materials/deathnotify/d_sword.vmt" "file"
"materials/deathnotify/d_leeroy.vtf" "file"
"materials/deathnotify/d_leeroy.vmt" "file"
"materials/deathnotify/d_darkmagegeneric.vtf" "file"
"materials/deathnotify/d_darkmagegeneric.vmt" "file"
"materials/deathnotify/d_divinemagegeneric.vtf" "file"
"materials/deathnotify/d_divinemagegeneric.vmt" "file"
"materials/deathnotify/d_necromancergeneric.vtf" "file"
"materials/deathnotify/d_necromancergeneric.vmt" "file"
"materials/noxctf/flagicon.vtf" "file"
"materials/noxctf/flagicon.vmt" "file"
"materials/noxctf/noxguilowerleft.vtf" "file"
"materials/noxctf/noxguilowerleft.vmt" "file"
"sound/mario/Death.wav" "file"
"sound/mario/Gamer Over.wav" "file"
"sound/mario/Pipe Warp.wav" "file"
"sound/mario/Power Up.wav" "file"
"sound/mario/Mario Riff.wav" "file"
"sound/mario/Mario Jump.wav" "file"
"sound/mario/Defeat Bowser.wav" "file"
"sound/mario/Stomp2.wav" "file"
"sound/mario/Stomp.wav" "file"
"sound/mario/Item Sprout.wav" "file"
"sound/mario/Thwomp.wav" "file"
"sound/mario/Bump.wav" "file"
"materials/mario/powerup_mushroom.vmt" "file"
"materials/mario/powerup_mushroom.vtf" "file"
"materials/mario/powerup_star.vmt" "file"
"materials/mario/powerup_star.vtf" "file"
"materials/mario/powerup_fireball.vmt" "file"
"materials/mario/powerup_fireball.vtf" "file"
"materials/mario/powerup_hammer.vmt" "file"
"materials/mario/powerup_hammer.vtf" "file"
"materials/mario/powerup_sword.vmt" "file"
"materials/mario/powerup_sword.vtf" "file"
"materials/mario/powerup_raccoon.vmt" "file"
"materials/mario/powerup_raccoon.vtf" "file"
"materials/models/bowser/bigbow00.vtf" "file"
"materials/models/bowser/bigbow00.vmt" "file"
"materials/models/bowser/bigbow01.vtf" "file"
"materials/models/bowser/bigbow01.vmt" "file"
"models/bowser/bowser.mdl" "file"
"models/bowser/bowser.phy" "file"
"models/bowser/bowser.vvd" "file"
"models/bowser/bowser.sw.vtx" "file"
"models/bowser/bowser.dx80.vtx" "file"
"models/bowser/bowser.dx90.vtx" "file"
}
]]
	return str
end

function CreateResFile()
	if _file.Exists("maps/".._GetCurrentMap()..".res") then
		_file.Delete("maps/".._GetCurrentMap()..".res")
	end
	_file.Write("maps/".._GetCurrentMap()..".res", CreateResFileString())
end

AddTimer(5, 1, CreateResFile)