-- JBMenu
-- By JetBoom

if JBMenu ~= nil then return end

JBMenu = {}
JBMenu.Menu = {}

JBMenu.RectStartIndex = 12200
JBMenu.MenuHelpIndex = 12399
JBMenu.MenuHelpRectIndex = 12198
JBMenu.StartIndex = 12400
JBMenu.SubStartIndex = 12500
JBMenu.SelectorIndex = 12599

function JBMenu.DrawMenu(userid)
	local Menu = JBMenu.Players[userid].Menu
	local MenuInfo = JBMenu.Menu[Menu]
	_GModRect_Start("VGUI/screens/vgui_bg")
	 _GModRect_SetPos(0.3, 0.18, 0.4, 0.12)
	 _GModRect_SetColor(150, 120, 120, 255)
	 _GModRect_SetTime(9999, 1, 1)
	_GModRect_Send(userid, JBMenu.RectStartIndex)

	_GModRect_Start("gmod/white")
	 _GModRect_SetPos(0.23, 0.28, 0.54, (MenuInfo.NumChoices*0.044)+0.08)
	 _GModRect_SetColor(255, 255, 255, 190)
	 _GModRect_SetTime(9999, 1, 1)
	_GModRect_Send(userid, JBMenu.RectStartIndex+1)

	_GModRect_Start("gmod/white")
	 _GModRect_SetPos(0.25, 0.3, 0.5, (MenuInfo.NumChoices*0.044)+0.04)
	 _GModRect_SetColor(0, 0, 0, 200)
	 _GModRect_SetTime(9999, 1, 1)
	_GModRect_Send(userid, JBMenu.RectStartIndex+2)

	_GModText_Start( "ImpactMassive" )
	 _GModText_SetPos( -1, 0.2 )
	 local coltab = explode(MenuInfo.NameColor, " ")
	 _GModText_SetColor( coltab[1], coltab[2], coltab[3], 255 )
	 _GModText_SetTime( 99999, 0.5, 0.5 )
	 _GModText_SetText( MenuInfo.Name )
	_GModText_Send( userid, JBMenu.StartIndex )
	_GModText_Start( "Default" )
	 _GModText_SetPos( -1, 0.28 )
	 local coltab2 = explode(MenuInfo.SubNameColor, " ")
	 _GModText_SetColor( coltab2[1], coltab2[2], coltab2[3], 255 )
	 _GModText_SetTime( 99999, 0.5, 0.5 )
	 _GModText_SetText( MenuInfo.SubName )
	_GModText_Send( userid, JBMenu.StartIndex+1 )
	for i=1, MenuInfo.NumChoices do
		local color = explode(MenuInfo.Choices[i].Color, " ")
		_GModText_Start( "Default" )
		 _GModText_SetPos( 0.3, 0.3 + (i*0.032) )
		 _GModText_SetColor( color[1], color[2], color[3], 255 )
		 _GModText_SetTime( 99999, 0.65, 0.5 )
		 _GModText_SetText( MenuInfo.Choices[i].Choice )
		_GModText_Send( userid, JBMenu.StartIndex + 2 + i )
		_GModText_Start( "BudgetLabel" )
		 _GModText_SetPos( 0.3, 0.315 + (i*0.032) )
		 _GModText_SetColor( color[1], color[2], color[3], 255 )
		 _GModText_SetTime( 99999, 0.9, 0.5 )
		 _GModText_SetText( MenuInfo.Choices[i].Description )
		_GModText_Send( userid, JBMenu.SubStartIndex + 2 + i )
	end

	_GModRect_Start("gmod/white")
	 _GModRect_SetPos(0.25, 0.33, 0.5, 0.032)
	 _GModRect_SetColor(200, 200, 100, 100)
	 _GModRect_SetTime(9999, 1, 1)
	_GModRect_Send(userid, JBMenu.SelectorIndex)

	_GModRect_Start("gmod/white")
	 _GModRect_SetPos(0.3, 0.13, 0.4, 0.05)
	 _GModRect_SetColor(0, 0, 0, 200)
	 _GModRect_SetTime(9999, 1, 1)
	_GModRect_Send(userid, JBMenu.MenuHelpRectIndex)

	_GModText_Start( "Default" )
	 _GModText_SetPos( -1, 0.15 )
	 _GModText_SetColor( 255, 255, 255, 255 )
	 _GModText_SetTime( 99999, 0.5, 0.5 )
	 if MenuInfo.Forced then
		 _GModText_SetText( "W - Up | S - Down | Use - Select" )
	 else
		 _GModText_SetText( "W - Up | S - Down | Use - Select | Jump - Exit" )
	 end
	_GModText_Send( userid, JBMenu.MenuHelpIndex )
end

function JBMenu.CreateMenu(forced, menuname, subname, color, subcolor)
	local i = 1
	while JBMenu.Menu[i] ~= nil do i = i + 1 end
	JBMenu.Menu[i] = {}
	JBMenu.Menu[i].Forced = forced
	JBMenu.Menu[i].Name = menuname or ""
	JBMenu.Menu[i].SubName = subname or ""
	JBMenu.Menu[i].NameColor = color or "255 255 255"
	JBMenu.Menu[i].SubNameColor = subcolor or "255 255 255"
	JBMenu.Menu[i].NumChoices = 0
	return i
end

function jbmenu_eventPlayerDisconnect(name, userid, address, steamid, reason)
	if IsPlayerOnline(userid) then
		if JBMenuOn[userid] then
			local menu = JBMenu.Players[userid].Menu or 555
			JBMenu.Players[userid] = nil
			JBMenu.Menu[menu] = nil
		end		
	end
end
HookEvent("eventPlayerDisconnect", jbmenu_eventPlayerDisconnect)

function JBMenu.AddChoice(menu, choice, description, color, func, ...)
	if JBMenu.Menu[menu] then
		if JBMenu.Menu[menu].Choices == nil then
			JBMenu.Menu[menu].Choices = {}
		end
		local i = 1
		while JBMenu.Menu[menu].Choices[i] ~= nil do i = i + 1 end
		JBMenu.Menu[menu].Choices[i] = {}
		JBMenu.Menu[menu].Choices[i].Choice = choice
		JBMenu.Menu[menu].Choices[i].Description = description
		JBMenu.Menu[menu].Choices[i].Color = color
		JBMenu.Menu[menu].Choices[i].Function = func
		JBMenu.Menu[menu].Choices[i].arg = arg
		JBMenu.Menu[menu].NumChoices = JBMenu.Menu[menu].NumChoices + 1
	end
end

JBMenu.Players = {}
JBMenuOn = {}
JBLastExit = {}
for i=1, _MaxPlayers() do
	JBMenuOn[i] = false
	JBLastExit[i] = 0
end

function JBMenu.SendMenu(userid, menu)
	if JBMenuOn[userid] then
		JBMenu.Menu[menu] = nil
		return
	end
	if _CurTime() < JBLastExit[userid]+0.25 then
		JBMenu.Menu[menu] = nil
		return
	end
	JBMenu.Players[userid] = {}
	JBMenu.Players[userid].Menu = menu
	JBMenu.Players[userid].Selection = 1
	JBMenu.Players[userid].LastPress = _CurTime()-1
	JBMenuOn[userid] = true
	JBMenu.DrawMenu(userid)
end

function explode(str, seperator, limit)
	local t={}
	local lim=limit or -1
	local reps=0
	local ll=0

	while true do
		local l=string.find(str,seperator,ll+1,true)
		if l~=nil then
			table.insert(t,string.sub(str,ll,l-1))
			ll=l+1
			reps=reps+1
		else
			table.insert(t,string.sub(str,ll))
			reps=reps+1
			break
		end
        if (reps>=lim and lim~=-1) or reps > 4000 then
			table.insert(t,string.sub(str,ll))
			break
		end
	end
	return t
end

function JBMenu.UpdateSelector(userid)
	local i = JBMenu.Players[userid].Selection
	_GModRect_Start("gmod/white")
	 _GModRect_SetPos(0.25, 0.3 + (i*0.032), 0.5, 0.032)
	 _GModRect_SetColor(200, 200, 100, 100)
	 _GModRect_SetTime(9999, 0, 0)
	_GModRect_SendAnimate(userid, JBMenu.SelectorIndex, 0.25, 0.05)
	JBMenu.Players[userid].LastPress = _CurTime()
end

function JBMenu.HideMenu(userid, menu)
	_GModRect_Hide(userid, JBMenu.SelectorIndex, 0.5)
	_GModRect_Hide(userid, JBMenu.MenuHelpRectIndex, 0.5)
	_GModText_Hide(userid, JBMenu.MenuHelpIndex, 0.4)
	for i=1, 3 do
		_GModRect_Hide(userid, JBMenu.RectStartIndex+i-1, 0.5)
	end
	for i=1, JBMenu.Menu[menu].NumChoices+3 do
		_GModText_Hide(userid, JBMenu.StartIndex+i-1, 0.5)
		_GModText_Hide(userid, JBMenu.SubStartIndex+i-1, 0.5)
	end
end

function JBMenu.CloseMenu(userid, menu)
	if JBMenu.Menu[menu] then
		JBMenu.HideMenu(userid, menu)
		JBMenuOn[userid] = false
		JBLastExit[userid] = _CurTime()
		JBMenu.Players[userid].Menu = 0
		JBMenu.Players[userid].Selection = 1
		JBMenu.Players[userid].LastPress = 0
		JBMenu.Players[userid] = nil
		JBMenu.Menu[menu] = nil
	end
end

function JBMenu_eventKeyPressed(userid, in_key)
	if JBMenuOn[userid] then
		if JBMenu.Players[userid] == nil then
			JBMenuOn[userid] = false
			JBLastExit[userid] = _CurTime()
			return
		end
		local LastPress = JBMenu.Players[userid].LastPress
		if _CurTime() > LastPress+0.18 then
			local Menu = JBMenu.Players[userid].Menu
			if JBMenu.Menu[Menu] == nil then
				JBMenuOn[userid] = false
				JBLastExit[userid] = _CurTime()
				JBMenu.Players[userid] = nil
				return
			end
			local MenuInfo = JBMenu.Menu[Menu]
			local Selection = JBMenu.Players[userid].Selection
			local MaxSelection = MenuInfo.NumChoices
			if in_key == IN_FORWARD then
				if MaxSelection <= 1 then
					_PlaySoundPlayer(userid, "buttons/button10.wav")
					JBMenu.Players[userid].LastPress = _CurTime()
					return
				elseif Selection == 1 then
					JBMenu.Players[userid].Selection = MaxSelection
				else
					JBMenu.Players[userid].Selection = Selection - 1
				end
				_PlaySoundPlayer(userid, "common/bugreporter_succeeded.wav")
				JBMenu.UpdateSelector(userid)
			elseif in_key == IN_BACK then
				if MaxSelection <= 1 then
					_PlaySoundPlayer(userid, "buttons/button10.wav")
					JBMenu.Players[userid].LastPress = _CurTime()
					return
				elseif Selection == MaxSelection then
					JBMenu.Players[userid].Selection = 1
				else
					JBMenu.Players[userid].Selection = Selection + 1
				end
				_PlaySoundPlayer(userid, "common/bugreporter_succeeded.wav")
				JBMenu.UpdateSelector(userid)
			elseif in_key == IN_JUMP then
				if not MenuInfo.Forced then
					JBMenu.CloseMenu(userid, Menu)
				else
					_PlaySoundPlayer(userid, "buttons/button10.wav")
					JBMenu.Players[userid].LastPress = _CurTime()
				end
			elseif in_key == IN_USE then
				_PlaySoundPlayer(userid, "buttons/button3.wav")
				local func = MenuInfo.Choices[Selection].Function
				local args = MenuInfo.Choices[Selection].arg
				JBMenu.CloseMenu(userid, Menu)
				func(unpack(args))
			end
		end
	end
end
JBMenu.Hook = HookEvent("eventKeyPressed", JBMenu_eventKeyPressed)
