LastHeal = 0
LastInvisible = 0

	function onInit( )
	end
	
	function onPickup(playerid)
		_PlayerSetMaxSpeed(playerid, 315)
		_PlayerEnableSprint(playerid, false)
	end

	function Deploy()
		_PlayerSetMaxSpeed(Owner, 315)
		_PlayerEnableSprint(Owner, false)
	end

	function onThink( )
		if _CurTime() > LastHeal+0.5 then
			if vecLength(_EntGetVelocity(Owner)) == 0 then
				if _PlayerInfo(Owner,"health") < 100 then
					_PlayerSetHealth(Owner, _PlayerInfo(Owner,"health")+1)
				end
				LastHeal = _CurTime()
			end
		end
	end

	function onPrimaryAttack()
		if not _PlayerInfo(Owner, "alive") then return end
		_TraceLine(_PlayerGetShootPos(Owner), _PlayerGetShootAng(Owner), 60, Owner)
		_PlayerViewModelSequence(Owner, 171)
		if _TraceHitNonWorld() then
			local tracedVictim = _TraceGetEnt()
			if tracedVictim <= _MaxPlayers() then
				local backpos = vecAdd(vecAdd(_EntGetPos(tracedVictim), vector3(0,0,58)), vecMul(_PlayerGetShootAng(tracedVictim), vector3(-30,-30,0)))
				if math.abs(vecLength(vecSub(_TraceEndPos(), backpos))) < 20 then
					_RunString("_TraceAttack("..tracedVictim..", "..MyIndex..", "..Owner..", "..(150)..")")
				else
					_RunString("_TraceAttack("..tracedVictim..", "..MyIndex..", "..Owner..", "..(20)..")")
				end
			end
			if tracedVictim <= _MaxPlayers() or string.sub(_EntGetType(tracedVictim), 1, 3) == "npc" or _EntGetType(tracedVictim) == "prop_ragdoll" then
				_MakeDecal(math.random(46, 51))
				_EntEmitSound(tracedVictim, "weapons/knife/knife_hit"..math.random( 1, 4 )..".wav")
			else
				_MakeDecal(math.random(72, 74))
				_EntEmitSound(tracedVictim, "weapons/knife/knife_hitwall1.wav")
			end
		elseif _TraceHitWorld() then
			_MakeDecal(math.random(72, 74))
			_EntEmitSound(Owner, "weapons/knife/knife_hitwall1.wav")
		else
			_EntEmitSound(Owner, "weapons/knife/knife_slash"..math.random( 1, 2 )..".wav")
		end
	end

	function onSecondaryAttack()
		if _CurTime() > LastInvisible+9 then
			_RunString("InvisibilitySelf("..Owner..")")
			LastInvisible = _CurTime()
		end
	end

	function onReload()
		return false
	end

	function getWeaponSwapHands()
		return false
	end

	function getWeaponFOV()
		return 75
	end

	function getWeaponSlot()
		return 0	
	end

	function getWeaponSlotPos()
		return 2
	end

	function getFiresUnderwater()
		return true
	end

	function getReloadsSingly()
		return false
	end

	function getDamage()
		return 10;
	end

	function getPrimaryShotDelay()
		return 0.4;
	end
	
	function getPrimaryIsAutomatic()
		return true;
	end
		
	function getBulletSpread()
		return vector3( 0.00, 0.00, 0.00 );
	end

	function getViewKick()
		return vector3( 0.0, 0.0, 0.0);
	end

	function getViewKickRandom()
		return vector3( 0.0, 3.0, 0.0 );
	end
	
	function getNumShotsPrimary()
		return 1;
	end

	function getPrimaryAmmoType()
		return "none";
	end

	function getDamageSecondary()
		return 0
	end

	function getSecondaryShotDelay()
		return 1
	end

	function getSecondaryIsAutomatic()
		return false;
	end

	function getBulletSpreadSecondary()
		return vector3( 0.001, 0.001, 0.001 )
	end

	function getViewKickSecondary()
		return vector3( 0.5, 0.0, 0.0)
	end

	function getViewKickRandomSecondary()
		return vector3( 0.0, 0.0, 0.0 )
	end

	function getNumShotsSecondary()
		return 1
	end

	function getSecondaryAmmoType()
		return "none"
	end

	function getViewModel( )
		return "models/weapons/v_knife_t.mdl"
	end

	function getWorldModel( )
		return "models/weapons/w_knife_ct.mdl"
	end

	function getClassName() 
		return "assassin_knife"
	end

	function getMaxClipPrimary()
		return 1
	end

	function getMaxClipSecondary()
		return -1
	end

	function getDefClipPrimary() -- ammo in gun by default
		return 1
	end

	function getDefClipSecondary()
		return 0
	end

	function getAnimPrefix()
		return "melee"
	end

	function getPrintName()
		return "Assassin Knife"
	end

	function getPrimaryScriptOverride()
		return 2
	end

	function getSecondaryScriptOverride()
		return 3
	end
	
	function getDeathIcon( )
		return "d_knife"
	end
