
-- This script is isolated from all other scripts
-- If you need to include other scripts you should do it manually below


_OpenScript( "functions_vector.lua" );



-- These variables are passed by the engine

MyIndex		=     0; -- Weapon's entity index.
Owner			= 	0; -- The player that owns this weapon
CurrentTime		=	0; -- The current game time


-- Called when the weapon is created.
	
	function onInit( )
		
		_SWEPSetSound( MyIndex, "single_shot", "Weapon_MP5Navy.Single" )
		
	end

	
-- Called every frame

	function onThink( )
			
	end
	
	
	function onPrimaryAttack( )

		end
		
	function onSecondaryAttack( )		
            if ( _PlayerInfo( Owner, "connected" ) == false ) then return; end
		if ( _PlayerInfo( Owner, "alive" ) == false ) then return; end		
		
		-- Send the laser line effect
		
		
	   local vecpos = _PlayerGetShootPos( Owner );
	   local plyang = _PlayerGetShootAng( Owner );
	 
	   _TraceLine( vecpos, plyang, 8000, Owner );
	   
	   local hitpos = _TraceEndPos();
	 
	   if ( _TraceHit() == false )  then
	   
	   hitpos = vecAdd( vecpos, vecMul( plyang, vector3(8000,8000,8000) ) )
	   
	   end
	 
	   
	   
	   vecpos = vecAdd( vecpos, vector3( 0, 0, -20 ) );

		_EffectInit();
		
			_EffectSetEnt( Owner );
			_EffectSetOrigin( hitpos );
			_EffectSetStart( vecpos );
			_EffectSetScale( 15 );
			_EffectSetMagnitude( 3);
		
		_EffectDispatch( "FadingLineTeam" );
		
		_EffectSetMagnitude( 4 );
		_EffectSetScale( 9 );
		_EffectDispatch( "FadingLineTeam" );

	end

	function onReload( )

		return true;

	end

-- Weapon settings.
-- These are only accessed once when setting the weapon up
	
	function getWeaponSwapHands()
		return false;	
	end
	
	function getWeaponFOV()
		return 80;	
	end
	
	function getWeaponSlot()
		return 2;	
	end
	
	function getWeaponSlotPos()
		return 3;	
	end
	
	function getFiresUnderwater()
		return true;
	end
	
	function getReloadsSingly()
		return false;
	end
	
	function getDamage()
		return 51;
	end
	
	function getPrimaryShotDelay()
		return 0.00;
	end
	
	function getSecondaryShotDelay()
		return 0.0;
	end
	
	function getPrimaryIsAutomatic()
		return true;
	end
	
	function getSecondaryIsAutomatic()
		return false;
	end
	
	function getSecondaryIsAutomatic()
		return false;
	end
	
	function getBulletSpread()
		return vector3( 0.005, 0.005, 0.005 );
	end
	
	function getViewKick()
		return vector3( 0.0, 0.0, 0.0);
	end
	
	function getViewKickRandom()
		return vector3( 0.4, 0.4, 0.4 );
	end

	function getViewModel( )
		return "models/weapons/v_smg_mp5.mdl";
	end
	
	function getWorldModel( )
		return "models/weapons/w_smg_mp5.mdl";
	end
	
	function getClassName()
		return "weapon_doom";
	end

	function getPrimaryAmmoType()
		return "pistol";
	end
		
	function getSecondaryAmmoType()
		return "pistol";
	end
	
	-- return -1 if it doesn't use clips
	function getMaxClipPrimary()
		return 300;
	end
	
	function getMaxClipSecondary()
		return -1;
	end
	
	-- ammo in gun by default
	function getDefClipPrimary()
		return 900;
	end
	
	function getDefClipSecondary()
		return -1;
	end

	-- pistol, smg, ar2, shotgun, rpg, phys, crossbow, melee, slam, grenade
	function getAnimPrefix()
		return "smg";
	end

	function getPrintName()
		return "Slim's DOOMS-DAY Gun";
	end
	
	
	-- 0 = Don't override, shoot bullets, make sound and flash
	-- 1 = Don't shoot bullets but do make flash/sounds
	-- 2 = Only play animations
	-- 3 = Don't do anything
	
	function getPrimaryScriptOverride()
		return 0;
	end

	function getSecondaryScriptOverride()
		return 3;
	end

