Stack = {};

function Stack:Create( data )
    local obj = {};
    obj.data = data or {};
    
    setmetatable( obj, self );
    self.__index = self;
    
    return obj;
end

function Stack:Clear( )
    obj.data = {};
end

function Stack:Push( data )
    table.insert( self.data, data );
end

function Stack:GetTop( )
    return table.getn( self.data );
end

function Stack:PopBottom( )
    -- Return nothing if we have no data in the stack.
    if( table.getn( self.data ) <= 0 ) then
        return nil;
    end
    
    local data = self.data[ 1 ];
    table.remove( self.data, 1 );
    return data;
end

function Stack:Pop( )
    
    -- Return nothing if we have no data in the stack.
    if( table.getn( self.data ) <= 0 ) then
        return nil;
    end
    
    local data = self.data[ table.getn( self.data ) ];
    table.remove( self.data, table.getn( self.data ) );
    return data;
end

