function SPRINKLES(userid)
	_PrintMessageAll(4, "Todays Forecast: Partly sunny with a slight chance of raining moneybags")
	_PlaySound("ambient/atmosphere/thunder"..math.random(1,4)..".wav")
	_PlaySound("ambient/atmosphere/thunder"..math.random(1,4)..".wav")
	PlayerLookTrace(userid, 512)
	local pos = _TraceEndPos()
	AddTimer(5, 1, StartMoneyBags, pos)
end

function StartMoneyBags(pos)
	RACEMUSIC=true
	_PrintMessageAll(4, "IT'S RAINING MONEYS!1!")
	AddTimer(0.25, 240, Sprinkler, pos)
end

function Sprinkler(pos)
	local gib = _EntCreate("prop_physics")
	if gib > 0 then
		_EntSetModel(gib, "models/props_junk/garbage_bag001a.mdl")
		_EntSetPos(gib, vecAdd(pos, vector3(math.random(-10,10),math.random(-10,10),0)))
		_EntSetAngAngle(gib, vector3(math.random(0,359), math.random(0,359), math.random(0,359)))
		_EntSetKeyValue(gib, "spawnflags", "4")
		_EntSpawn(gib)
		_EntSetName(gib, "moneybag")
		_phys.ApplyTorqueCenter(gib, vector3(math.random(-10500, 10500), math.random(-10500, 10500), math.random(-3000, 13000)))
		_phys.ApplyForceCenter(gib, vector3(math.random(-8000, 8000), math.random(-8000, 8000), math.random(-3000, 8500)))
		_EntFire(gib, "kill", "", 20)
		_EntFire(gib, "color", "255 255 15", 0)
		_EntEmitSound(gib, "ambient/levels/labs/coinslot1.wav")
		local trail = _EntCreate("env_smoketrail")
		if trail > 0 then
			_EntSetPos(trail, _EntGetPos(gib))
			_EntSetKeyValue(trail, "spawnrate", "22")
			_EntSetKeyValue(trail, "lifetime", "1.2")
			_EntSetKeyValue(trail, "startcolor", "255 255 15")
			_EntSetKeyValue(trail, "endcolor", "255 255 15")
			_EntSetKeyValue(trail, "minspeed", "0")
			_EntSetKeyValue(trail, "maxspeed", "0")
			_EntSetKeyValue(trail, "startsize", "6")
			_EntSetKeyValue(trail, "endsize", "9")
			_EntSetKeyValue(trail, "spawnradius", "2")
			_EntSetKeyValue(trail, "firesprite", "sprites/redglow3.spr")
			_EntSetKeyValue(trail, "smokesprite", "sprites/redglow3.spr")
			_EntSpawn(trail)
			_EntSetParent(trail, gib)
			_EntFire(trail, "kill", "", 5.0)
		end
	end
end
