function onInit()
	_SWEPSetSound( MyIndex, "single_shot", "Weapon_Crossbow.Single" )
end

function onThink()
end

function onPrimaryAttack()
	local Bolt = _EntCreate( "physics_prop" )
		if (Bolt > 0) then
		_EntEmitSound(Owner, "weapons/grenade_launcher1.wav")
		_EntPrecacheModel( "models/mixerman3d/other/arrow.mdl" )
		_EntSetModel(Bolt, "models/mixerman3d/other/arrow.mdl")
		_EntSetPos( Bolt, vecAdd(_PlayerGetShootPos( Owner ),vecMul(_PlayerGetShootAng( Owner ),vector3(60,60,60))))
		_EntSetAng( Bolt, _PlayerGetShootAng(Owner))
		_EntSetOwner( Bolt, Owner )
		_EntSetAng(Bolt, _PlayerGetShootAng(Owner))
		_EntSetKeyValue(Bolt, "ExplodeDamage", "150")
		_EntSetKeyValue(Bolt, "ExplodeRadius", "150")
		_EntSpawn(Bolt)
		if(_PlayerInfo(Owner,"team") == TEAM_BLUE) then
			_EntFire(Bolt, "color", "100 190 255", 0)
		elseif(_PlayerInfo(Owner,"team") == TEAM_RED) then
			_EntFire(Bolt, "color", "255 100 30", 0)
		end
		local vAim = _PlayerGetShootAng( Owner )
		if ( vAim == nil) then	return; end
			vAim.x = vAim.x * 55000
			vAim.y = vAim.y * 55000
			vAim.z = vAim.z * 55000
		_phys.ApplyForceCenter(Bolt, vAim)
		_EntitySetPhysicsAttacker(Bolt, Owner)
		_EntFire(Bolt, "break", "", 2)
		_EntFire(Bolt, "kill", "", 2)
		local fire = _EntCreate("env_fire_trail")
		_EntSetPos(fire, _EntGetPos(Bolt))
		_EntSpawn(fire)
		_EntActivate(fire)
		_EntSetParent(fire, Bolt)
		_SWEPUseAmmo(MyIndex, 0, 1)
		AddTimer(1.9, _EntitySetPhysicsAttacker, Bolt, Owner)
	end
end

function onSecondaryAttack()
end

function onReload()
	return true
end

function getWeaponSwapHands()
	return false
end

function getWeaponFOV()
	return 75
end

function getWeaponSlot()
	return 5
end

function getWeaponSlotPos()
	return 4	
end

function getFiresUnderwater()
	return true
end

function getReloadsSingly()
	return true
end

function getDamage()
	return 100
end

function getPrimaryShotDelay()
	return 4.0
end

function getSecondaryShotDelay()
	return 0.1
end

function getPrimaryIsAutomatic()
	return true
end

function getSecondaryIsAutomatic()
	return false
end

function getPrimaryAmmoType()
	return "XBowBolt"
end

function getSecondaryAmmoType()
	return "none";
end

function getMaxClipPrimary()
	return 1;
end

function getMaxClipSecondary()
	return -1;
end

function getDefClipPrimary()
	return 30;
end

function getDefClipSecondary()
	return -1;
end

function getPrimaryScriptOverride()
	return 2;
end

function getSecondaryScriptOverride()
	return 3;
end

function getBulletSpread()
	return vector3( 0.0, 0.0, 0.0 );
end

function getViewKick()
	return vector3( 0, 0.0, 0.0);
end

function getViewKickRandom()
	return vector3( 0.0, 0.0, 0.0 );
end

function getViewModel( )
	return "models/weapons/v_crossbow.mdl"
end

function getWorldModel( )
	return "models/weapons/w_crossbow.mdl"
end

function getClassName()
	return "weapon_ashxbow"
end

function getAnimPrefix()
	return "crossbow"
end

function getPrintName()
	return "Ash Xbow\nBy JetBoom"
end
