-- By JetBoom
_OpenScript( "includes/tickrate.lua" )
model = "models/peanut/conansword.mdl"

-------------------
-- Non-Edit line --
-------------------

sprinttick = 0
axe = 0
LastTime = 0
LastPos = vector3(0, 0, 0)

    function Holster()
   		if _EntExists(axe) then
			_EntRemove(axe)
			axe = 0
		end
		_PlayerSetDrawViewModel(Owner, true)
    end

    function onRemove( )
		if _EntExists(axe) then
			_EntRemove(axe)
			axe = 0
		end
	end

    function Deploy()
		_PlayerEnableSprint(Owner, false)
		_PlayerSetMaxSpeed(Owner, 315)
		LastTime = LastTime+0.6
    end

    function onInit( )
    end

	function getForce()
		local force = math.abs(vecLength(vecSub(_EntGetPos(axe),LastPos)))
		return force*20
	end

	function isValidTarget(ent)
		local name = _EntGetType(ent)

		if name == "player" or string.find(name, "prop_") ~= nil or string.find(name, "npc_") ~= nil then
			return true
		end
		return false
	end

	function DoAttack()
		local tab = _EntitiesFindInSphere(_EntGetPos(axe), 40)
		for i=1, table.getn(tab) do
			if tab[i] ~= Owner and tab[i] ~= axe and isValidTarget(tab[i]) then
				local force = getForce()/TICKRATE
				if force <= 10 then
					-- do nothing
				else
					if force <= 100 then
						_EntEmitSound(tab[i], "physics/body/body_medium_impact_soft"..math.random(1,7)..".wav")
					elseif force <= 200 then
						_EntEmitSound(tab[i], "physics/body/body_medium_impact_hard"..math.random(1,6)..".wav")
					elseif force <= 500 then
						_EntEmitSound(tab[i], "physics/body/body_medium_break"..math.random(2,4)..".wav")
					elseif force <= 1000 then
						_EntEmitSound(tab[i], "physics/flesh/flesh_bloody_break.wav")
					else
						_EntEmitSound(tab[i], "physics/concrete/boulder_impact_hard"..math.random(1,4)..".wav")
					end
					_RunString("_TraceAttack("..tab[i]..", "..Owner..", "..Owner..", "..(force*0.2)..")")
				end
			end
		end
	end

    function onThink( )
    	if not _EntExists(axe) then 
			_EntPrecacheModel(model)
			axe = _EntCreate("prop_physics")
			if axe > 0 then
				_EntSetKeyValue(axe, "model", model)
				_EntSetOwner(axe, Owner)
				_EntitySetPhysicsAttacker(axe, Owner)
				_EntSetPos(axe, vecAdd(_PlayerGetShootPos( Owner ),vecMul(_PlayerGetShootAng( Owner ),vector3(40,40,40))))
				_EntSetAng(axe, _PlayerGetShootAng(Owner))
				_EntSpawn(axe)
				_phys.EnableGravity(axe, false)
				LastPos = _EntGetPos(axe)
			end
			_PlayerSetDrawViewModel(Owner, false)
		end
		if sprinttick < 5 then
			sprinttick = sprinttick+1
			if sprinttick >= 5 then
				_PlayerEnableSprint(Owner, false)
				_PlayerSetMaxSpeed(Owner, 325)
			end
		end
		LastPos = _EntGetPos(axe)
		_EntitySetPhysicsAttacker(axe, Owner)
		_EntSetPos(axe, vecAdd(vecAdd(_PlayerGetShootPos( Owner ),vecMul(_PlayerGetShootAng( Owner ),vector3(35,35,35))), vector3(0,0,-21)))
		if _PlayerIsKeyDown(Owner, IN_ATTACK) then
			_EntSetAng(axe, vecAdd(vecMul(_PlayerGetShootAng(Owner), vector3(-1,-1,-1)), vector3(0.2,0,0.2)))
			if _CurTime() > LastTime+0.5 then
				DoAttack()
				LastTime = _CurTime()
			end
   	    else
			_EntSetAng(axe, vecMul(_PlayerGetShootAng(Owner), vector3(0,0,0.5)))
   	    end
    end

airdashed=false
nextdash=0
function onSecondaryAttack()
	if _PlayerIsKeyDown(Owner, IN_FORWARD) then
		_TraceLine(_EntGetPos(Owner), vector3(0,0,-1), 16, Owner)
		if _TraceHit() then
			if _CurTime() > nextdash then
				Dash(Owner)
				nextdash = _CurTime()+1.5
			end
		else
			if not airdashed then
				AirDash(Owner)
				airdashed=true
			end
		end
	elseif _PlayerIsKeyDown(Owner, IN_BACK) then
	end
end

function onReload() end
function getWeaponSwapHands() return false end    
function getWeaponFOV() return 60 end    
function getWeaponSlot() return 5 end
function getWeaponSlotPos() return 2 end
function getFiresUnderwater() return true end
function getReloadsSingly() return false end
function getDamage() return 10 end
function getPrimaryShotDelay() return 400 end
function getPrimaryIsAutomatic() return true end
            
    function getBulletSpread()
        return vector3( 0.00, 0.00, 0.00 )
    end
    
    function getViewKick()
        return vector3( 0.0, 0.0, 0.0)
    end
    
    function getViewKickRandom()
        return vector3( 0.0, 0.0, 0.0 )
    end
        
    function getNumShotsPrimary()
        return 1
    end
    
    function getPrimaryAmmoType()
        return "none"
    end

    function getDamageSecondary()
        return 10
    end
    
    function getSecondaryShotDelay()
        return 0
    end
    
    function getSecondaryIsAutomatic()
        return false
    end
    
    function getBulletSpreadSecondary()
        return vector3( 0.001, 0.001, 0.001 )
    end
    
    function getViewKickSecondary()
        return vector3( 0.0, 0.0, 0.0)
    end
    
    function getViewKickRandomSecondary()
        return vector3( 0.5, 0.5, 0.2 )
    end
    
    function getNumShotsSecondary()
        return 1
    end
    
    function getSecondaryAmmoType()
        return "none"
    end

    function getViewModel( )
		return "models/weapons/v_knife_t.mdl"
    end
    
    function getWorldModel( )
 		return "models/weapons/shell.mdl"
    end
function getClassName() return "warrior_axe" end     
function getMaxClipPrimary() return 1 end
function getMaxClipSecondary() return -1 end
function getDefClipPrimary() return 1 end
function getDefClipSecondary() return 0 end
function getAnimPrefix() return "slam" end
function getPrintName() return "Warrior Axe" end
function getDeathIcon() return "d_axe" end
function getPrimaryScriptOverride() return 3 end
function getSecondaryScriptOverride() return 3 end
