LastHeal = 0

	function onPickup(playerid)
		_PlayerSetMaxSpeed(playerid, 150)
		_PlayerEnableSprint(playerid, false)
		_PlayerSetModel(playerid, "models/player/classic.mdl")
	end

	function onThink( )
		if _CurTime() > LastHeal+0.5 then
			if _PlayerInfo(Owner,"health") < 250 then
				_PlayerSetHealth(Owner, _PlayerInfo(Owner,"health")+2)
			end
			LastHeal = _CurTime()
		end
	end

	function Holster()
		_PlayerSetDrawViewModel(Owner, true)
    end

	function Deploy()
		_PlayerSetDrawViewModel(Owner, false)
	end

	function onDrop(playerid)
		_EntEmitSound(playerid, "npc/zombie/zombie_die"..math.random(1,3)..".wav")
		_PlayerSetDrawViewModel(playerid, true)
	end
	
	function onPrimaryAttack( )
		if not _PlayerInfo( Owner, "alive" ) then return end
		local tracedVictim = 0
		_TraceLine( _PlayerGetShootPos( Owner ), _PlayerGetShootAng( Owner ), 65, Owner )
		if _TraceHitNonWorld() then
			tracedVictim = _TraceGetEnt()
			_MakeDecal(math.random(46, 51))
			_EntEmitSound(tracedVictim, "npc/zombie/claw_strike"..math.random( 1, 3 )..".wav")
			if tracedVictim > _MaxPlayers() then
				if _EntGetModel(tracedVictim) == "models/props_lab/monitor01b.mdl" then
					_EntRemove(tracedVictim)
				else
					_phys.ApplyForceCenter(tracedVictim, vecMul( _PlayerGetShootAng(Owner), vector3(60000, 60000, 185000)))
					_EntitySetPhysicsAttacker(tracedVictim, Owner)
				end
			end
			_EffectInit()
			 _EffectSetOrigin(_TraceEndPos())
			 _EffectSetNormal(vecMul(_PlayerGetShootAng(Owner), -1))
			 _EffectSetScale(6)
			 _EffectSetFlags(9)
			_EffectDispatch("bloodspray")
			_RunString("_TraceAttack("..tracedVictim..", "..Owner..", "..Owner..", "..(50)..")")
		elseif _TraceHitWorld() then
			_MakeDecal(math.random(46, 51))
			_EntEmitSound(Owner, "npc/zombie/claw_strike"..math.random( 1, 3 )..".wav")
		else
			_EntEmitSound(Owner, "npc/zombie/claw_miss"..math.random( 1, 2 )..".wav")
		end
	end

	function onSecondaryAttack( )
		_EntEmitSound(Owner, "npc/zombie/zombie_voice_idle"..math.random( 1, 14 )..".wav")
	end

	function onReload( )
		return false
	end

	function getWeaponSwapHands()
		return false	
	end

	function getWeaponFOV()
		return 60
	end

	function getWeaponSlot()
		return 0	
	end

	function getWeaponSlotPos()
		return 2	
	end

	function getFiresUnderwater()
		return true
	end

	function getReloadsSingly()
		return false
	end

	function getDamage()
		return 10
	end

	function getPrimaryShotDelay()
		return 1.0
	end
	
	function getPrimaryIsAutomatic()
		return true
	end
		
	function getBulletSpread()
		return vector3( 0.00, 0.00, 0.00 )
	end

	function getViewKick()
		return vector3( 0.0, 0.0, 0.0)
	end

	function getViewKickRandom()
		return vector3( 0.0, 8.0, 0.0 )
	end
	
	function getNumShotsPrimary()
		return 1
	end

	function getPrimaryAmmoType()
		return "none"
	end

	function getDamageSecondary()
		return 10
	end

	function getSecondaryShotDelay()
		return 2.5
	end

	function getSecondaryIsAutomatic()
		return true
	end

	function getBulletSpreadSecondary()
		return vector3( 0.001, 0.001, 0.001 )
	end

	function getViewKickSecondary()
		return vector3( 0.5, 0.0, 0.0)
	end

	function getViewKickRandomSecondary()
		return vector3( 0.0, 0.0, 0.0 )
	end

	function getNumShotsSecondary()
		return 1
	end

	function getSecondaryAmmoType()
		return "none"
	end

	function getViewModel( )
		return "models/weapons/v_knife_t.mdl"
	end

	function getWorldModel( )
		return "models/weapons/shell.mdl"
	end

	function getClassName() 
		return "zombie_weapon"
	end

	function getMaxClipPrimary()
		return 1
	end

	function getMaxClipSecondary()
		return -1
	end

	function getDefClipPrimary() -- ammo in gun by default
		return 1
	end

	function getDefClipSecondary()
		return 0
	end

	function getAnimPrefix() -- How the player holds the weapon: pistol, smg, ar2, shotgun, rpg, phys, crossbow, melee, slam, grenade
		return "phys"
	end

	function getPrintName()
		return "Zombie"
	end

	function getPrimaryScriptOverride()
		return 2
	end

	function getSecondaryScriptOverride()
		return 2
	end

	function getDeathIcon( )
		return "d_brains"
	end
