
-- This script is isolated from all other scripts
-- If you need to include other scripts you should do it manually below


_OpenScript( "functions_vector.lua" );



-- These variables are passed by the engine

MyIndex		=	0; -- Weapon's entity index.
Owner			= 	0; -- The player that owns this weapon
CurrentTime		=	0; -- The current game time


-- Called when the weapon is created.
	
	function onInit( )
		
		_SWEPSetSound( MyIndex, "single_shot", "Weapon_MAC10.Single" )
		
	end

	
-- Called every frame

	function onThink( )
			
	end
	
	
	function onPrimaryAttack( )
            if ( _PlayerInfo( Owner, "alive" ) == false ) then return; end

		
		-- Make the player fly backwards
		local vPlayerVel = vecMul( _PlayerGetShootAng( Owner ), vector3(-2000, -2000, -2000) );
		_EntSetVelocity( Owner, vPlayerVel );
		
		-- Nice sparky effects
		
		--_EffectInit();
		
		local vSparksVel = vecMul( _PlayerGetShootAng( Owner ), vector3(1000, 1000, 1000) );
		_EffectSetNormal( vSparksVel );
		_EffectSetOrigin( _PlayerGetShootPos( Owner ) );
		_EffectDispatch( "cball_bounce" );
		_EffectDispatch( "cball_bounce" );
		_EffectDispatch( "cball_bounce" );
		
		local vTracerEnd = vecAdd( _PlayerGetShootPos( Owner ), vSparksVel );
		_EffectSetOrigin( vTracerEnd );
		_EffectSetStart( _PlayerGetShootPos( Owner ) );
		_EffectSetScale( 2900 );
		_EffectDispatch( "GaussTracer" );
		_EffectSetScale( 2700 );
		_EffectDispatch( "GaussTracer" );
		_EffectSetScale( 2400 );
		_EffectDispatch( "GaussTracer" );
		
		
		
		_SWEPUseAmmo( MyIndex, 0, 1 );
			
	end
		
	function onSecondaryAttack( )		
		
		if ( _PlayerInfo( Owner, "alive" ) == false ) then return; end

				local entityTraced
				local vecpos = _PlayerGetShootPos( Owner )
				local plyang = _PlayerGetShootAng( Owner )
				_TraceLine( vecpos, plyang, 4096, Owner )
				if ( _TraceHit() == true )  then 
					if _TraceHitNonWorld() then
						entityTraced = _TraceGetEnt()
						_PlayerFreeze(entityTraced, true)
						_EntFire(entityTraced, "color", "340 258 0", 0) 
					end
				end
	
		
		_SWEPUseAmmo( MyIndex, 1, 1 );

	 end

-- Weapon settings.
-- These are only accessed once when setting the weapon up
	
	function getWeaponSwapHands()
		return false;	
	end
	
	function getWeaponFOV()
		return 80;	
	end
	
	function getWeaponSlot()
		return 2;	
	end
	
	function getWeaponSlotPos()
		return 2;	
	end
	
	function getFiresUnderwater()
		return false;
	end
	
	function getReloadsSingly()
		return false;
	end
	
	function getDamage()
		return 40;
	end
	
	function getPrimaryShotDelay()
		return 0.035;
	end
	
	function getSecondaryShotDelay()
		return 0.1;
	end
	
	function getPrimaryIsAutomatic()
		return true;
	end
	
	function getSecondaryIsAutomatic()
		return false;
	end
	
	function getSecondaryIsAutomatic()
		return false;
	end
	
	function getBulletSpread()
		return vector3( 0.01, 0.01, 0.01 );
	end
	
	function getViewKick()
		return vector3( 0.0, 0.0, 0.0);
	end
	
	function getViewKickRandom()
		return vector3( 0.9, 0.9, 0.9 );
	end

	function getViewModel( )
		return "models/weapons/v_physcannon.mdl";
	end
	
	function getWorldModel( )
		return "models/weapons/w_Physics.mdl";
	end
	
	function getClassName()
		return "weapon_bottlerocket";
	end

	function getPrimaryAmmoType()
		return "pistol";
	end
		
	function getSecondaryAmmoType()
		return "pistol";
	end
	
	-- return -1 if it doesn't use clips
	function getMaxClipPrimary()
		return 300;
	end
	
	function getMaxClipSecondary()
		return -1;
	end
	
	-- ammo in gun by default
	function getDefClipPrimary()
		return 120;
	end
	
	function getDefClipSecondary()
		return -1;
	end

	-- pistol, smg, ar2, shotgun, rpg, phys, crossbow, melee, slam, grenade
	function getAnimPrefix()
		return "pistol";
	end

	function getPrintName()
		return "Slim's Bottle-Rocket";
	end
	
	
	-- 0 = Don't override, shoot bullets, make sound and flash
	-- 1 = Don't shoot bullets but do make flash/sounds
	-- 2 = Only play animations
	-- 3 = Don't do anything
	
	function getPrimaryScriptOverride()
		return 0;
	end

	function getSecondaryScriptOverride()
		return 3;
	end


