
-- This script is isolated from all other scripts
-- If you need to include other scripts you should do it manually below


_OpenScript( "functions_vector.lua" );



-- These variables are passed by the engine

MyIndex		=	0; -- Weapon's entity index.
Owner			= 	0; -- The player that owns this weapon
CurrentTime		=	0; -- The current game time


-- Called when the weapon is created.
	
	function onInit( )
		
		_SWEPSetSound( MyIndex, "single_shot", "Weapon_G3SG1.Single" )
		
	end

	
-- Called every frame

	function onThink( )
			
	end
	
	
	function onPrimaryAttack( )
		
		if ( _PlayerInfo( Owner, "alive" ) == false ) then return; end
			
		local iBolt = _EntCreate( "crossbow_bolt" );
		
		if (iBolt > 0) then
			
			_EntSetKeyValue( iBolt, "damage", "500");
			_EntSetPos( iBolt, _PlayerGetShootPos( Owner ) );
			_EntSetAng( iBolt, _PlayerGetShootAng( Owner ) );
			_EntSetOwner( iBolt, Owner );
			
			local vVelocity = vecMul( _PlayerGetShootAng( Owner ), vector3(900, 900, 900) );
			_EntSetVelocity( iBolt, vVelocity );
				
			_EntSpawn( iBolt );
			
		end
		
		
		_SWEPUseAmmo( MyIndex, 0, 1 );
			
	end	
		
	 function onSecondaryAttack( )		
		if zoom then
			zoom = false
			_PlayerStopZooming(Owner)
		else
			zoom = true
			_PlayerSetFOV(Owner, 50, 0)
		end	

	end

	function onReload( )

		return true;

	end

-- Weapon settings.
-- These are only accessed once when setting the weapon up
	
	function getWeaponSwapHands()
		return false;	
	end
	
	function getWeaponFOV()
		return 80;	
	end
	
	function getWeaponSlot()
		return 4;	
	end
	
	function getWeaponSlotPos()
		return 1;	
	end
	
	function getFiresUnderwater()
		return true;
	end
	
	function getReloadsSingly()
		return false;
	end
	
	function getDamage()
		return 500;
	end
	
	function getPrimaryShotDelay()
		return 0.9;
	end
	
	function getSecondaryShotDelay()
		return 0.1;
	end
	
	function getPrimaryIsAutomatic()
		return false;
	end
	
	function getSecondaryIsAutomatic()
		return false;
	end
	
	function getSecondaryIsAutomatic()
		return false;
	end
	
	function getBulletSpread()
		return vector3( 0.001, 0.001, 0.001 );
	end
	
	function getViewKick()
		return vector3( 0, 0.0, 0.0);
	end
	
	function getViewKickRandom()
		return vector3( 1.6, 1.6, 1.6 );
	end

	function getViewModel( )
		return "models/weapons/v_snip_scout.mdl";
	end
	
	function getWorldModel( )
		return "models/weapons/w_snip_scout.mdl";
	end
	
	function getClassName()
		return "weapon_sniper2";
	end

	function getPrimaryAmmoType()
		return "357";
	end
		
	function getSecondaryAmmoType()
		return "357";
	end
	
	-- return -1 if it doesn't use clips
	function getMaxClipPrimary()
		return 5;
	end
	
	function getMaxClipSecondary()
		return -1;
	end
	
	-- ammo in gun by default
	function getDefClipPrimary()
		return 10;
	end
	
	function getDefClipSecondary()
		return -1;
	end

	-- pistol, smg, ar2, shotgun, rpg, phys, crossbow, melee, slam, grenade
	function getAnimPrefix()
		return "ar2";
	end

	function getPrintName()
		return "Slim's Bolt Sniper";
	end
	
	
	-- 0 = Don't override, shoot bullets, make sound and flash
	-- 1 = Don't shoot bullets but do make flash/sounds
	-- 2 = Only play animations
	-- 3 = Don't do anything
	
	function getPrimaryScriptOverride()
		return 0;
	end

	function getSecondaryScriptOverride()
		return 3;
	end

