-- Demolition Derby
-- By JetBoom

MAXRACETIME = 5.0
MAXNUMRACERS = 8
BETDEADLINE = 90
--------------------------------------------------------------

_ServerCommand("gm_sv_allowspawning 0\n")
_ServerCommand("gm_sv_allownpc 0\n")
_ServerCommand("gm_sv_allweapons 0\n")
_ServerCommand("gm_sv_teamplay 1\n")
_ServerCommand("gm_sv_allowmultigun 0\n")
_ServerCommand("gm_sv_allowphysgun 0\n")
_ServerCommand("gm_sv_teamdamage 0\n")
_ServerCommand("gm_sv_playerdamage 1\n")
_ServerCommand("gm_sv_setrules\n")

players = {}
for i=1, _MaxPlayers() do
	players[i] = {}
	players[i].Vehicle = 0
	players[i].Bet = 0
	players[i].BetOn = 0
	players[i].DownTime = 0
end

RacerQueue = {}
Racing = false
LastRace = -BETDEADLINE
PreRaceTimer = -1
RaceTimer = 0
CountDownTime = 10
NumOfRacers = 0

function gamerulesThink()
	if not Racing then
		if table.getn(RacerQueue) >= 2 and PreRaceTimer < 0 then
			PreRaceTimer = AddTimer(1, CountDownTime+1, CountDownTimer)
		end
	else
		for i=1, _MaxPlayers() do
			if players[i].Vehicle > 0 then
				local ang = _EntGetAng(players[i].Vehicle)
				if ang.z < -0.8 or ang.z > 0.9 then
					players[i].DownTime = players[i].DownTime+1*TICKRATE
					if players[i].DownTime > 198 then
						_PlayerKill(i)
					end
				else
					players[i].DownTime = 0
				end
			end
		end
	end
end

function CreateResFileString()
	local str = [["resources"
{
"sound/stfu.wav" "file"
"sound/banned.wav" "file"
"sound/racing11.mp3" "file"
"sound/racing12.mp3" "file"
"sound/racing13.mp3" "file"
"sound/racing14.mp3" "file"
"sound/youlose2.wav" "file"
"sound/speach/obeyyourthirst3.wav" "file"
"sound/speach/obeyyourthirst2.wav" "file"
"sound/speach/obeyyourthirst.wav" "file"
"sound/lm/lm.wav" "file"
"sound/leeroyjenkins.wav" "file"
"sound/motdintro.mp3" "file"
"sound/stomachram.wav" "file"
"materials/nedm.vmt" "file"
"materials/nedm.vtf" "file"
}]]
	return str
end

function CreateResFile()
	_file.Write("maps/".._GetCurrentMap()..".res", CreateResFileString())
end

--[[
function GetStartVector(sender, args)
	if IsJetHeadAdmin then
		StartVector = _PlayerGetShootAng(sender)
	end
end
CONCOMMAND("startvector", GetStartVector)
]]

function gamerulesStartMap()
	_TeamSetName(TEAM_RED, "The Mistempered Crowd")
	_TeamSetName(TEAM_BLUE, "Demolition Derby")
	_TeamSetName(TEAM_GREEN, "Pit Crew")
	_TeamSetName(TEAM_YELLOW, "Stupid Faggots")
	CreateResFile()
	AddTimer(60, 0, BookieRegenerate)
end

function CountDownTimer()
	if table.getn(RacerQueue) < 2 then
		HaltTimer(PreRaceTimer)
		PreRaceTimer = -1
		CountDownTime = 10
		return
	end
	for i=1, _MaxPlayers() do
		if _PlayerInfo(i,"connected") then
			if CountDownTime > 0 then
				_GModText_Start("ImpactMassive")
				 _GModText_SetColor(255, 255, 255, 255)
				 _GModText_SetTime(2, 0, 1)
				 _GModText_SetPos(-1, 0.4)
				 if IsGoingToRace(i) then
					 _GModText_SetText("You are entering in:\n"..CountDownTime)
				 else
		 			 _GModText_SetText("Spectating derby in:\n"..CountDownTime)
				 end
				_GModText_Send(i, 910)
			end
		end
	end
	_PlaySound("hl1/fvox/bell.wav")
	if CountDownTime < 1 and not Racing then
		for i=1, 4000 do
			if string.find(_EntGetType(i), "vehicle") ~= nil then
				_EntRemove(i)
			end
		end
		StartRace()
		_GModText_Start("ImpactMassive")
		 _GModText_SetColor(255, 255, 255, 255)
		 _GModText_SetTime(2, 0, 1)
		 _GModText_SetPos(-1, 0.4)
		 _GModText_SetText("Go!")
		_GModText_Send(0, 910)
	else
		CountDownTime = CountDownTime-1
	end
end

function StartRace()
	Racing = true
	LastRace = _CurTime()
	if MAXRACETIME > 0 then
		RaceTimer = AddTimer(MAXRACETIME*60, 1, FinishRace, 0)
	end
	for i=1, MAXNUMRACERS do
		if _PlayerInfo(RacerQueue[1], "connected") then
			_PlayerChangeTeam(RacerQueue[1], TEAM_BLUE)
			_PlayerRespawn(RacerQueue[1])
			players[RacerQueue[1]].DownTime = 0
			table.remove(RacerQueue, 1)
		end
	end
	HaltTimer(PreRaceTimer)
	PreRaceTimer = -1
	NumOfRacers = _TeamNumPlayers(TEAM_BLUE)
	onShowTeam(0)
end

function IsGoingToRace(userid)
	for i=1, table.getn(RacerQueue) do
		if i > MAXNUMRACERS then return false end
		if RacerQueue[i] == userid then
			return true
		end
	end
	return false
end

function InQueue(userid)
	for i=1, table.getn(RacerQueue) do
		if RacerQueue[i] == userid then
			return true
		end
	end
	return false
end

function IsInRadius(a, b, dist)
	return math.abs(vecLength(vecSub(a,b))) <= dist
end

function DoBet(sender, args)
	if string.len(args) < 5 then return end
	args = string.gsub(args, " all ", " "..players[sender].money.." ")
	args = string.gsub(args, " everything ", " "..players[sender].money.." ")
	if players[sender].BetOn > 0 then _PrintMessage(sender, 3, "All bets are final.") _PrintMessage(sender, 2, "All bets are final.\n") return end
	if not Racing then _PrintMessage(sender, 3, "You can't bet on a non-existant race.") _PrintMessage(sender, 2, "You can't bet on a non-existant race.\n") return end
	if _CurTime() > LastRace+BETDEADLINE then _PrintMessage(sender, 3, "It's too late to make any bets on this race") _PrintMessage(sender, 2, "It's too late to make any bets on this race\n") return end
	local on, name = string.find(args, " on ")
	if on == nil or name == nil then _PrintMessage(sender, 3, "Syntax - I bet # on <name>") _PrintMessage(sender, 2, "Syntax - I bet # on <name>\n") return end
	local money = tonumber(string.sub(args, 1, on-1))
	if money == nil then _PrintMessage(sender, 3, "Syntax - I bet # on <name>") _PrintMessage(sender, 2, "Syntax - I bet # on <name>\n") return end
	local userid = 0
	for i=1, _MaxPlayers() do
		if players[i].Vehicle > 0 then
			if string.find(string.lower(_PlayerInfo(i,"name")), string.lower(string.sub(args, name+1))) ~= nil then
				userid = i
				break
			end
		end
	end

	if money < 10 then _PrintMessage(sender, 3, "You can't bet such a paltry amount of money.") _PrintMessage(sender, 2, "You can't bet such a paltry amount of money.\n") return end
	if money > 5000 then _PrintMessage(sender, 3, "You can only bet $5,000 at a time!") _PrintMessage(sender, 2, "You can only bet $5,000 at a time!") return end
	if money > players[sender].money then _PrintMessage(sender, 3, "You don't have that much money.") _PrintMessage(sender, 2, "You don't have that much money.\n") return end
	if money > tonumber(_file.Read("noxiousprofiles/brbookie.txt")) then _PrintMessage(sender, 3, "The bookie doesn't have that much money.") _PrintMessage(sender, 2, "The bookie doesn't have that much money.\n") return end
	if _PlayerInfo(userid, "team") ~= TEAM_BLUE then _PrintMessage(sender, 3, "You can't bet on someone who isn't racing.") _PrintMessage(sender, 2, "You can't bet on someone who isn't racing.\n") return end
	if _PlayerInfo(sender, "team") == TEAM_BLUE then _PrintMessage(sender, 3, "You can't bet while racing.") _PrintMessage(sender, 2, "You can't bet while racing.\n") return end
	money = math.floor(money)
	players[sender].money = players[sender].money-money
	_file.Write("noxiousprofiles/brbookie.txt", tonumber(_file.Read("noxiousprofiles/brbookie.txt"))-money)
	NDB.drawMoneyAmmount(sender)
	_PrintMessage(sender, 3, "You bet $"..money.." on ".._PlayerInfo(userid,"name").." to win.")
	_PrintMessage(sender, 2, "You bet $"..money.." on ".._PlayerInfo(userid,"name").." to win.\n")
	players[sender].Bet = money
	players[sender].BetOn = userid
end

function FinishRace(winner)
	local winnings = NumOfRacers*75
	if IsPlayer(winner) then
		if players[winner].GoldMember then
			winnings = winnings*1.25
		end
	end
	for i=1, _MaxPlayers() do
		if _PlayerInfo(i, "connected") then
			if players[i].BetOn > 0 then
				if winner == players[i].BetOn then
					NDB.AddMoney(i, players[i].Bet*2, true)
					_PlaySoundPlayer(i, "ambient/levels/labs/coinslot1.wav")
					_EntEmitSound(i, "ambient/levels/labs/coinslot1.wav")
				else
					_PrintMessage(i, 3, "You have lost the money wagered in the bet.")
					_PrintMessage(i, 2, "You have lost the money wagered in the bet.\n")
					_file.Write("noxiousprofiles/brbookie.txt", tonumber(_file.Read("noxiousprofiles/brbookie.txt"))+(players[i].Bet*2))
					local mm = math.random(1, 2)
					if mm < 2 then _EntEmitSound(i, "vo/npc/barney/ba_ohshit03.wav") else _EntEmitSound(i, "vo/citadel/br_ohshit.wav") end
				end
				players[i].BetOn = 0
				players[i].Bet = 0
			end
		end
	end
	_GModText_Start("ImpactMassive")
	 _GModText_SetColor(255, 0, 0, 255)
	 _GModText_SetTime(6, 0, 1)
	 _GModText_SetPos(-1, 0.7)
	 if winner > 0 then
		_GModText_SetText(_PlayerInfo(winner, "name").." has won $"..winnings.."!!")
	 else
		_GModText_SetText("YOU GET NOTHING! YOU LOSE!\nGOOD DAY SIR!!")
		_PlaySound("youlose2.wav")
	 end
	 _GModText_Send(0, 911)
	 if winner > 0 then players[winner].money = players[winner].money+winnings NDB.drawMoneyAmmount(winner) end
	for i=1, _MaxPlayers() do
		if _PlayerInfo(i, "connected") then
			if _PlayerInfo(i, "team") == TEAM_BLUE then
				_PlayerKill(i)
				_PlayerSetScore(i, 0)
				for x=1, table.getn(RacerQueue) do
					if RacerQueue[x] == i then
						table.remove(RacerQueue, x)
						break
					end
				end
			end
		end
	end
	HaltTimer(RaceTimer)
	SetNotRacing()
	PreRaceTimer = -1
	CountDownTime = 10
	NumOfRacers = 0
	NDB.GlobalSave()
end

function CheckHaltRace()
	if Racing then
		if _TeamNumPlayers(TEAM_BLUE) < 1 then
			FinishRace(0)
		elseif _TeamNumPlayers(TEAM_BLUE) < 2 then
			for i=1, _MaxPlayers() do
				if _PlayerInfo(i, "team") == TEAM_BLUE then
					FinishRace(i)
					_PlayerKill(i)
					return
				end
			end
		end
	end
end
AddTimer(1, 0, CheckHaltRace)

function SetNotRacing()
	Racing = false
end

function PickDefaultSpawnTeam(userid)
	_PlayerChangeTeam(userid, TEAM_RED)
	return true
end

function BookieRegenerate()
	_file.Write("noxiousprofiles/brbookie.txt", tonumber(_file.Read("noxiousprofiles/brbookie.txt"))+100)
end

function onTakeDamage(ent, inflictor, attacker, damage)
	if IsPlayer(ent) then
		if damage >= _PlayerInfo(ent, "health")+30 then
			Gib(ent)
		end
	end
end

GibModels = {}
GibModels[1]="models/Gibs/Antlion_gib_medium_1.mdl"
GibModels[2]="models/Gibs/Antlion_gib_small_1.mdl"
GibModels[3]="models/Gibs/Antlion_gib_medium_2.mdl"
GibModels[4]="models/Gibs/Antlion_gib_medium_3.mdl"
GibModels[5]="models/Gibs/Antlion_gib_small_1.mdl"
GibModels[6]="models/Gibs/Antlion_gib_small_2.mdl"

Gibbed = {}
for i=1, _MaxPlayers() do
	Gibbed[i] = false
end

_EntPrecacheModel("models/props_junk/garbage_bag001a.mdl")
function Gib(killed)
	if Gibbed[killed] then return end
	Gibbed[killed] = true
	_TraceLine(_EntGetPos(killed), vector3(0,0,-1), 100, killed)
	if _TraceHit() then
		_MakeDecal(math.random(46,51))
	end

	local gibstospawn = {}
	gibstospawn[1] = "models/gibs/HGIBS.mdl"
	gibstospawn[2] = "models/gibs/HGIBS_rib.mdl"
	gibstospawn[3] = "models/gibs/HGIBS_rib.mdl"
	gibstospawn[5] = "models/gibs/HGIBS_scapula.mdl"
	gibstospawn[6] = "models/gibs/HGIBS_spine.mdl"
	for i=1, 2 do
		 gibstospawn[table.getn(gibstospawn)+1] = GibModels[math.random(1, table.getn(GibModels))]
	end
	for i in gibstospawn do
		local gib = _EntCreate("prop_physics")
		if gib > 0 then
			_EntPrecacheModel(gibstospawn[i])
			_EntSetModel(gib, gibstospawn[i])
			_EntSetKeyValue(gib, "spawnflags", "4")
			_EntSetPos(gib, vecAdd(_EntGetPos(killed), vector3(math.random(-10,10),math.random(-10,10),math.random(10,30))))
			_EntSetAngAngle(gib, vector3(math.random(0,359), math.random(0,359), math.random(0,359)))
			_EntSpawn(gib)
			_phys.ApplyForceCenter(gib, vecMul(_EntGetVelocity(killed), vector3(8,8,8)))
			_phys.ApplyTorqueCenter(gib, vector3(math.random(-10500, 10500), math.random(-10500, 10500), math.random(-3000, 13000)))
			_phys.ApplyForceCenter(gib, vector3(math.random(-8000, 8000), math.random(-8000, 8000), math.random(-3000, 8500)))
			_EntFire(gib, "kill", "", 7.5)
			local trail = _EntCreate("env_smoketrail")
			if trail > 0 then
				_EntSetPos(trail, _EntGetPos(gib))
				_EntSetKeyValue(trail, "spawnrate", "22")
				_EntSetKeyValue(trail, "lifetime", "1.2")
				_EntSetKeyValue(trail, "startcolor", "255 0 0")
				_EntSetKeyValue(trail, "endcolor", "255 0 0")
				_EntSetKeyValue(trail, "minspeed", "0")
				_EntSetKeyValue(trail, "maxspeed", "0")
				_EntSetKeyValue(trail, "startsize", "6")
				_EntSetKeyValue(trail, "endsize", "9")
				_EntSetKeyValue(trail, "spawnradius", "2")
				_EntSetKeyValue(trail, "firesprite", "sprites/redglow3.spr")
				_EntSetKeyValue(trail, "smokesprite", "sprites/redglow3.spr")
				_EntSpawn(trail)
				_EntSetParent(trail, gib)
				_EntFire(trail, "kill", "", 4.0)
			end
		end
	end
	_EntEmitSoundEx(killed, "physics/flesh/flesh_bloody_break.wav", 1.0, 0.75)
	AddTimer(0.1, 1, _PlayerSilentKill, killed, 1.5, true)
end

function eventPlayerSpawn(userid)
	Gibbed[userid] = false
	_GModText_Hide(userid, 1111, 0, 0)
	_GModText_Hide(userid, 5019, 0, 0)
	if _PlayerInfo(userid, "team") == TEAM_RED then
		_GModRect_Hide(userid, 5000, 0, 0)
		_GModRect_Hide(userid, 5109, 0, 0)
		if not IsGoingToRace(userid) then
			_GModText_Start("Default")
			 _GModText_SetColor(255, 0, 0, 255)
			 _GModText_SetTime(9999, 0, 5)
			 _GModText_SetText("F2 = Enter Derby Queue")
			 _GModText_SetPos(-1, 0.025)
			_GModText_Send( userid, 1111)
		end
		return
	end
	if _PlayerInfo(userid, "team") == TEAM_BLUE then
		_PlayerSetHealth(userid, 250)
		local ent = _EntCreate("prop_vehicle_jeep")
		if ent > 0 then
			_EntSetPos(ent, _EntGetPos(userid))
			PlayerMove(userid, vector3(0,0,72))
			_EntSetAng(ent, AngToCarAng(_EntGetAng(userid)))
			_EntSetKeyValue(ent, "model", "models/buggy.mdl")
			_EntSetKeyValue(ent, "vehiclescript", "scripts/vehicles/buggyracer.txt")
			_EntSetKeyValue(ent, "solid", "6")
			_EntSpawn(ent)
			_EntFire(ent, "AddOutput", "PressedAttack !self,TurnOff,,0,-1", 0)
			_EntFire(ent, "AddOutput", "PressedAttack2 !self,TurnOff,,0,-1", 0)
			_EntFire(ent, "AddOutput", "PressedAttack !self,TurnOn,,5,-1", 0)
			_EntFire(ent, "AddOutput", "PressedAttack2 !self,TurnOn,,5,-1", 0)
			players[userid].Vehicle = ent
			_GModText_Start("BrandingSmall")
			 _GModText_SetColor(math.random(75, 255), math.random(75, 255), math.random(75, 255), 255)
			 _GModText_SetTime(9999, 0, 5)
			 _GModText_SetEntityOffset(vector3(-5, -5, 24 ))
			 _GModText_SetEntity(players[userid].Vehicle)
			 _GModText_SetText(_PlayerInfo(userid, "name"))
			_GModText_Send( 0, 750+userid)
		end
	end
end

function eventPlayerUseEntity(userid, entity)
	if IsVehicle(entity) then
		if players[userid].Vehicle == entity or _EntGetName(entity) == "spectatorvehicle" then
			return false
		end
		return true
	end
	return false
end

function eventPlayerDisconnect(name, userid, address, steamid, reason)
	if not IsPlayerOnline(userid) then return end
	if players[userid].Vehicle ~= nil then
		if string.find(_EntGetType(players[userid].Vehicle), "vehicle") ~= nil then
			_EntRemove(players[userid].Vehicle)
			_GModText_Hide(0, 750+userid, 0, 0)
		end
	end
	for i=1, table.getn(RacerQueue) do
		if RacerQueue[i] == userid then
			table.remove(RacerQueue, i)
			onShowTeam(0)
		end
	end
	players[userid].Vehicle = 0
	if players[userid].Bet > 0 then
		_file.Write("noxiousprofiles/brbookie.txt", tonumber(_file.Read("noxiousprofiles/brbookie.txt"))+(players[userid].Bet*2))
		players[userid].Bet = 0
	end
	players[userid].BetOn = 0
end

function eventPlayerKilled(killed, attacker, weapon)
	local count = 0
	local play = 0
	if _EntExists(players[killed].Vehicle) then	
		RemoveVehicle(players[killed].Vehicle)
		_PlayerChangeTeam(killed, TEAM_RED)
		_GModText_Hide(0, 750+killed, 0, 0)
		_PlaySound("jbb/knockout.mp3")
		_PrintMessageAll(3, _PlayerInfo(killed,"name").." has been eliminated!")
	end
	players[killed].Vehicle = 0
	players[killed].Checkpoint = 0
	_PlayerSetScore(killed, 0)
end

function RemoveVehicle(ent)
	_EntFire(ent, "kill", "", 1.0)
end

function onShowSpare2(userid)
	_PrintMessage(userid, 4, "The betting bookie has $".._file.Read("noxiousprofiles/brbookie.txt")..".")
end

function onShowTeam(userid)
	if userid > 0 then
		if _PlayerInfo(userid,"team") ~= TEAM_RED or not _PlayerInfo(userid, "alive") then return end
		if not InQueue(userid) then
			table.insert(RacerQueue, userid)
		end
	end

	for x=1, _MaxPlayers() do
		if IsPlayerOnline(x) then
			for i=1, table.getn(RacerQueue) do
				if RacerQueue[i] == x then
					_GModText_Start("DefaultShadow")
					_GModText_SetTime(9999, 0, 0)
					_GModText_SetPos(-1, 0.025)
					if i <= MAXNUMRACERS then
						_GModText_SetColor(0, 255, 0, 255)
						_GModText_SetText("Slot in Queue: "..i.."/"..table.getn(RacerQueue).."\nYou will enter next round")
					else
						_GModText_SetColor(255, 0, 0, 255)
						_GModText_SetText("Slot in Queue: "..i.."/"..table.getn(RacerQueue).."\nYou will NOT enter next round")
					end
					_GModText_Send( x, 1111)
				end
			end
		end
	end
end

function onShowHelp(userid)
	_GModRect_Start("gmod/white")
	 _GModRect_SetPos(0.0, 0.14, 1.0, 0.35)
	 _GModRect_SetColor(0, 0, 0, 175)
	 _GModRect_SetTime(10, 0.2, 1)
	_GModRect_Send(userid, 49)
	_GModText_Start("Trebuchet24")
	 _GModText_SetPos(-1, 0.16)
	 _GModText_SetColor(255, 255, 255, 255)
	 _GModText_SetTime(10, 0.2, 1.25)
	 _GModText_SetText("Demolition Derby\n a gamemode by JetBoom")
	_GModText_Send(userid, 50)
	_GModText_Start("Default")
	 _GModText_SetPos(-1, 0.3)
	 _GModText_SetColor(90, 90, 255, 240)
	 _GModText_SetTime(10, 0.2, 1.25)
	 _GModText_SetText( "Press F2 to enter the Demolition Derby.\nWin by flipping or pushing off all other cars." )
	_GModText_Send( userid, 51 )
	_GModText_Start("Default")
	 _GModText_SetPos(-1, 0.35)
	 _GModText_SetColor(90, 90, 255, 240)
	 _GModText_SetTime(10, 0.2, 1.25)
	 _GModText_SetText( "This gamemode uses modified jeeps.\n Press F4 to see how much money the betting bookie has.\nSay I bet # on <name> to bet.")
	_GModText_Send( userid, 52 )
end

function eventPlayerActive(name, userid, steamid)
	AddTimer(4.0, 1, onShowHelp, userid)
	for i=1, _MaxPlayers() do
		if players[i].Vehicle > 0 then
			_GModText_Start("BrandingSmall")
			 _GModText_SetColor(math.random(75, 255), math.random(75, 255), math.random(75, 255), 255)
			 _GModText_SetTime(9999, 0, 5)
			 _GModText_SetEntityOffset(vector3(-5, -5, 24 ))
			 _GModText_SetEntity(players[i].Vehicle)
			 _GModText_SetText(_PlayerInfo(i, "name"))
			_GModText_Send( userid, 750+i)
		end
	end
end

function explode(str, seperator, limit)
	local t={}
	local lim=limit or -1
	local reps=0
	local ll=0

	while true do
		local l=string.find(str,seperator,ll+1,true)
		if l~=nil then
			table.insert(t,string.sub(str,ll,l-1))
			ll=l+1
			reps=reps+1
		else
			table.insert(t,string.sub(str,ll))
			reps=reps+1
			break
		end
        if (reps>=lim and lim~=-1) or reps > 4000 then
			table.insert(t,string.sub(str,ll))
			break
		end
	end
	return t
end

--[[
function onGravGunPunt(player, entity)
	if IsVehicle(entity) then
		return players[player].Vehicle == entity
	end
	return true
end
]]

function onGravGunPunt(player, entity)
	return not IsVehicle(entity)
end

function IsVehicle(entity)
	return string.find(_EntGetType(entity), "vehicle") ~= nil
end

function GiveDefaultItems(userid)
	_PlayerGiveItem(userid, "weapon_physcannon")
end

function eventPlayerDuplicateProp(userid, propid)
	return not IsVehicle(propid)
end

function onPlayerRemove(player, entity)
	return not IsVehicle(entity)
end

function GiveOut(num)
	for i=1, _MaxPlayers() do
		if _PlayerInfo(i, "connected") then
			players[i].money = players[i].money + num
			NDB.drawMoneyAmmount(i)
		end
	end
end

function AngToCarAng(userid, vehicle)
	local ang = _EntGetAng(userid)
	local x = ang.x
	local y = ang.y
	ang.y = -x
	ang.x = -y
	ang.z = 0
	--return ang
	return vector3(1,0,0)
end

