-- Mario Battle Bros.
-- BY JETBOOM

-- These 2 variables are for NoXious servers only.
WIN_MONEY = 250
KILL_MONEY = 10
BOWSER_MAXHEALTH = 750
-------------------------------------------------------

BOWSERMODEL = "models/bowser/bowser.mdl"
_EntPrecacheModel(BOWSERMODEL)
_EntPrecacheModel("models/props_junk/wood_crate001a.mdl")
_EntPrecacheModel("models/props_junk/wood_crate002a.mdl")
_EntPrecacheModel("models/noxious/boxlol.mdl")
players = {}
for i=1, _MaxPlayers() do
	players[i] = {}
	players[i].Box = 0
	players[i].LastJump = 0
	players[i].LastFireBall = 0
	players[i].LastStompedOn = 0
	players[i].LastHurtBy = 0
	players[i].LastHurt = 0
	players[i].PowerUp = "nothing"
end
boxowner = {}
PowerUpBlocks = {}
PowerUps = {}
LastSprouts = {}
teams = {}
teams[TEAM_GREEN] = {name="Team Luigi", color={r=25,g=255,b=25}, Bowser=0, BowserSpawn=vector3(-128,0,0), Health=BOWSER_MAXHEALTH}
teams[TEAM_RED] = {name="Team Mario", color={r=255,g=25,b=0}, Bowser=0, BowserSpawn=vector3(128,0,0), Health=BOWSER_MAXHEALTH}

EntOwners={}
oldEntSetOwner = _EntSetOwner
function _EntSetOwner(ent, owner)
	oldEntSetOwner(ent, owner)
	EntOwners[ent] = owner
end

oldEntGetOwner = _EntGetOwner
function _EntGetOwner(ent)
	return EntOwners[ent] or 0
end

function PickDefaultSpawnTeam(userid)
	_PlayerChangeTeam(userid, GetAutoTeam())
	return true
end

function onShowTeam(userid)
	if GetAutoTeam() ~= _PlayerInfo(userid, "team") then
		if players[userid].Box > 0 then
			_EntFire(players[userid].Box, "break", "", 0)
			_EntFire(players[userid].Box, "kill", "", 0.1)
		end
		players[userid].LastJump = 0
		players[userid].LastFireBall = 0
		players[userid].LastStompedOn = 0
		players[userid].LastHurt = 0
		players[userid].LastHurtBy = 0
		players[userid].PowerUp = "nothing"
		Swords[userid] = nil
		_PlayerChangeTeam(userid, GetAutoTeam())
		_PlayerRespawn(userid)
	else
		_PrintMessage(userid, 4, "Teams are already even.")
	end
end

function onShowHelp(userid)
	_GModRect_Start( "mario/marioicon" )
	 _GModRect_SetPos( 0.2, 0.3, 0.0, 0.0 )
	 _GModRect_SetColor( 0, 0, 0, 10 )
	 _GModRect_SetTime( 15, 0, 1 )
	_GModRect_Send( userid, 51 )

	_GModRect_Start( "gmod/white" )
	 _GModRect_SetPos( 0.2, 0.3, 0.6, 0.15 )
	 _GModRect_SetColor( 0, 0, 0, 50 )
	 _GModRect_SetTime( 15, 0, 1 )
	_GModRect_SendAnimate( userid, 51, 1, 0.2 )

	_GModText_Start( "DefaultShadow" )
	 _GModText_SetPos( 0.21, 0.36 )
	 _GModText_SetColor( 255, 255, 255, 255 )
	 _GModText_SetTime( 15, 1, 1 )
	 _GModText_SetText( "Kill the other team's Bowser to win. It's Mario, but in HL2.\n       Script by JetBoom" )
	_GModText_Send( userid, 50 )
	
	_GModText_Start( "Default" )
	 _GModText_SetPos( 0.21, 0.36 )
	 _GModText_SetColor( 255, 40, 0, 255 )
	 _GModText_SetTime( 15, 1, 1 )
	_GModText_SendAnimate( userid, 50, 2, 0.2 )

	_GModText_Start( "ImpactMassive" )
	 _GModText_SetPos( -1, 0.295 )
	 _GModText_SetColor( 255, 255, 255, 0 )
	 _GModText_SetTime( 15, 1, 1 )
	 _GModText_SetText( "[MARIO BROS. BATTLE]" )
	_GModText_Send( userid, 51 )

	_GModText_Start( "ImpactMassive" )
	 _GModText_SetPos( 0.41, 0.295 )
	 _GModText_SetColor( 255, 255, 255, 255 )
	 _GModText_SetTime( 15, 1, 1 )
	_GModText_SendAnimate( userid, 51, 2, 0.2 )
end

function TeamString(intt)
	if intt == TEAM_RED then return "Red"
	elseif intt == TEAM_BLUE then return "Blue"
	elseif intt == TEAM_GREEN then return "Green"
	elseif intt == TEAM_YELLOW then return "Yellow"
	else return "Spectator" end
end

function GetAutoTeam()
	if _TeamNumPlayers(TEAM_RED) > _TeamNumPlayers(TEAM_GREEN) then
		return TEAM_GREEN
	else
		return TEAM_RED
	end
end

BOWSER_MAXHEALTH_P = BOWSER_MAXHEALTH/100
function UpdateGlobalHUD(userid)
	_GModText_Start( "Default" )
	 _GModText_SetPos( 0.005, 0.12 )
	 _GModText_SetColor( 25, 255, 25, 255 )
	 _GModText_SetTime( 99999, 0, 0 )
	 _GModText_SetText( "%"..math.ceil(teams[TEAM_GREEN].Health/BOWSER_MAXHEALTH_P) )
	_GModText_Send( userid, 5109 )
	_GModText_Start( "Default" )
	 _GModText_SetPos( 0.05, 0.12 )
	 _GModText_SetColor( 255, 50, 5, 255 )
	 _GModText_SetTime( 99999, 0, 0 )
	 _GModText_SetText( "%"..math.ceil(teams[TEAM_RED].Health/BOWSER_MAXHEALTH_P) )
	_GModText_Send( userid, 5110 )
end

function StartingHUD(userid)
	_GModText_Start( "Default" )
	 _GModText_SetPos( 0.0, 0.0 )
	 _GModText_SetColor( 255, 255, 255, 255 )
	 _GModText_SetTime( 99999, 0, 0 )
	 _GModText_SetText( "Bowser Health" )
	_GModText_Send( userid, 5105 )
	_GModRect_Start("gmod/white")
	 _GModRect_SetPos(0.0, 0.0, 0.1, 0.16)
	 _GModRect_SetTime(99999, 0, 0)
	 _GModRect_SetColor(0, 0, 0, 200)
	_GModRect_Send(userid, 5106)
	_GModRect_Start("mario/luigiicon")
	 _GModRect_SetPos(0.0, 0.05, 0.03, 0.05)
	 _GModRect_SetTime(99999, 0, 0)
	 _GModRect_SetColor(0, 0, 0, 240)
	_GModRect_Send(userid, 5107)
	_GModRect_Start("mario/marioicon")
	 _GModRect_SetPos(0.06, 0.05, 0.03, 0.05)
	 _GModRect_SetTime(99999, 0, 0)
	 _GModRect_SetColor(0, 0, 0, 240)
	_GModRect_Send(userid, 5108)
	UpdateGlobalHUD(userid)
end

START = false
function gamerulesStartMap()
	if START then return end
	START = true
	PlayerFreezeAll(false)
	_GameSetTargetIDRules(TRGTID_NONE)
	local props = _EntitiesFindByClass("info_target")
	if props ~= nil then
		for lol, i in props do
			if _EntGetName(i) == "redbowser" then
				teams[TEAM_RED].BowserSpawn = _EntGetPos(i)
			elseif _EntGetName(i) == "greenbowser" then
				teams[TEAM_GREEN].BowserSpawn = _EntGetPos(i)
			end
		end
	else
		_Msg("LOL, NO BOWSER SPAWN. WTF ASSHOLE MAP MAKER?!\n")
	end
	for i in teams do
		_TeamSetName(i, teams[i].name or "ROFL NO FUCKING NAME")
	end
	for i in teams do
		local ent = _EntCreate("prop_dynamic_override")
		if ent > 0 then
			_EntSetPos(ent, teams[i].BowserSpawn)
			_EntSetModel(ent, BOWSERMODEL)
			_EntSetKeyValue(ent, "solid", "6")
			_EntSpawn(ent)
			_EntSetName(ent, "bowser")
			_EntFire(ent, "Color", teams[i].color.r.." "..teams[i].color.g.." "..teams[i].color.b, 0)
			teams[i].Bowser = ent
			if i == TEAM_RED then
				_EntSetAng(ent, vector3(-1,0,0))
			end
		end
	end
	GetPowerUpBlocks()
end

function IsInRadius(a, b, dist)
	return Distance(_EntGetPos(a), _EntGetPos(b)) <= dist
end

function Distance(a, b)
	return math.abs(vecLength(vecSub(a,b)))
end

--[[
function GetPowerUpBlocks()
	local ents = _EntitiesFindByClass("func_wall_toggle")
	for i, ent in ents do
		local colon = string.find(_EntGetName(ent), ":powerup")
		if colon ~= nil then
			local powerup = string.sub(_EntGetName(ent), colon+9)
			if powerup ~= nil then
				PowerUpBlocks[ent] = powerup
			end
		end
	end
end
]]

function GetPowerUpBlocks()
	local ents = _EntitiesFindByClass("prop_dynamic")
	for i, ent in ents do
		local colon = string.find(_EntGetName(ent), ":")
		if colon ~= nil then
			local powerup = string.sub(_EntGetName(ent), colon+1)
			if powerup ~= nil then
				_EntSetMaterial(ent, "mario/questionblock_model")
				PowerUpBlocks[ent] = powerup
				LastSprouts[ent] = _CurTime()
			end
		end
	end
end

function eventPlayerActive(name, userid, steamid)
	_EntSetKeyValue(userid, "rendermode", "1")
	StartingHUD(userid)
end

function eventPlayerDisconnect(name, userid, address, steamid, reason)
	if IsPlayerOnline(userid) then
		if players[userid].Box > 0 then
			_EntFire(players[userid].Box, "break", "", 0)
			_EntFire(players[userid].Box, "kill", "", 0.1)
		end
		players[userid].LastJump = 0
		players[userid].LastFireBall = 0
		players[userid].LastStompedOn = 0
		players[userid].LastHurt = 0
		players[userid].LastHurtBy = 0
		players[userid].PowerUp = "nothing"
		Swords[userid] = nil
	end
end

function BowserKilled(team)
	for i=1, _MaxPlayers() do
		if IsPlayerOnline(i) then
			if _PlayerInfo(i, "team") == team then
				_PlaySoundPlayer(i, "mario/Game Over.wav")
				_GModText_Start( "ImpactMassive" )
				 _GModText_SetPos( -1, -1 )
				 _GModText_SetColor( 255, 0, 0, 255 )
				 _GModText_SetTime( 6, 0.5, 1.0 )
				 _GModText_SetText( "Your team's Bowser has been defeated!\nYou lose!" )
				_GModText_Send( i, 5150 )
			else
				_PlaySoundPlayer(i, "mario/Defeat Bowser.wav")
				_GModText_Start( "ImpactMassive" )
				 _GModText_SetPos( -1, -1 )
				 _GModText_SetColor( 0, 255, 0, 255 )
				 _GModText_SetTime( 6, 0.5, 1.0 )
				 _GModText_SetText( "You defeated the other team's Bowser!\nYou win!" )
				_GModText_Send( i, 5150 )
				 if NDB ~= nil then
					NDB.AddMoney(i, WIN_MONEY, false)
				end
			end
			if players[i].Box > 0 then
				_EntFire(players[i].Box, "kill", "", 0.1)
				boxowners[players[i].Box] = nil
				players[i].Box = 0
			end
			players[i].LastJump = 0
			players[i].LastFireBall = 0
			players[i].LastStompedOn = 0
			players[i].LastHurt = 0
			players[i].LastHurtBy = 0
			players[i].PowerUp = "nothing"
			Swords[i] = nil
		end
	end
	AllPlayers(_PlayerRespawn)
	for i in teams do
		if i ~= team then
			_TeamAddScore(i, 1)
		end
		_EntRemove(teams[i].Bowser)
		local ent = _EntCreate("prop_dynamic_override")
		if ent > 0 then
			_EntSetPos(ent, teams[i].BowserSpawn)
			_EntSetModel(ent, BOWSERMODEL)
			_EntSetKeyValue(ent, "solid", "6")
			_EntSpawn(ent)
			_EntSetName(ent, "bowser")
			_EntFire(ent, "Color", teams[i].color.r.." "..teams[i].color.g.." "..teams[i].color.b, 0)
			teams[i].Bowser = ent
			if i == TEAM_RED then
				_EntSetAng(ent, vector3(-1,0,0))
			end
			teams[i].Health = BOWSER_MAXHEALTH
		end
	end
	UpdateGlobalHUD(0)
	if NDB ~= nil then NDB.GlobalSave() end
end

MakeFunction("PlayerHitSomething")
function PlayerHitSomething(Activator, Caller)
	_EntFire(Caller, "sethealth", "99999", 0)
	if Activator == 0 then return end -- Hit solid world
	local userpl = boxowner[Caller]
	if not _PlayerInfo(userpl, "alive") then return end
	if boxowner[Activator] then -- Hit another box
		local hitpl = boxowner[Activator]
		if players[hitpl].PowerUp == "star" then
			if players[userpl].PowerUp == "star" or _PlayerInfo(userpl,"team") == _PlayerInfo(hitpl, "team") then return end
			_TraceAttack(userpl, hitpl, hitpl, 100)
			return
		end
		--_TraceLine(vecAdd(vector3(7,0,0), _EntGetPos(Caller)), vector3(0,0,-1), 35, Caller) local a = _TraceGetEnt() == Activator
		_TraceLine(_EntGetPos(Caller), vector3(0,0,-1), 39, Caller) local b = _TraceGetEnt() == Activator
		--_TraceLine(vecAdd(vector3(-7,0,0), _EntGetPos(Caller)), vector3(0,0,-1), 35, Caller) local c = _TraceGetEnt() == Activator
		if b then
			if _PlayerInfo(hitpl, "team") ~= _PlayerInfo(userpl, "team") then
				if players[hitpl].LastStompedOn < _CurTime()-0.2 then
					if _EntGetPos(Caller).z < _EntGetPos(Activator).z then return end
					_EntEmitSound(userpl, "mario/Stomp.wav")
					players[hitpl].LastStompedOn = _CurTime()
					if _PlayerIsKeyDown(userpl, IN_JUMP) then
						_phys.ApplyForceCenter(Caller, vector3(0, 0, 40000))
					else
						_phys.ApplyForceCenter(Caller, vector3(0, 0, 25000))
					end
					if players[hitpl].PowerUp == "nothing" then
						_TraceAttack(hitpl, userpl, userpl, 100)
					else
						PowerDown(hitpl, true)
						players[hitpl].LastHurtBy = userpl
						players[hitpl].LastHurt = _CurTime()
					end
				end
			end
		end
	elseif _EntGetName(Activator) == "bowser" then
		_TraceLine(vecAdd(vector3(18,0,0), _EntGetPos(Caller)), vector3(0,0,-1), 39, Caller) local q = _TraceGetEnt() == Activator
		_TraceLine(_EntGetPos(Caller), vector3(0,0,-1), 39, Caller) local w = _TraceGetEnt() == Activator
		_TraceLine(vecAdd(vector3(-18,0,0), _EntGetPos(Caller)), vector3(0,0,-1), 39, Caller) local e = _TraceGetEnt() == Activator
		if q or w or e then
			for a in teams do
				if teams[a].Bowser == _TraceGetEnt() then
					if teams[a].Bowser ~= teams[_PlayerInfo(boxowner[Caller], "team")].Bowser then
						_PlaySound("mario/Stomp2.wav")
						if _PlayerIsKeyDown(userpl, IN_JUMP) then
							_phys.ApplyForceCenter(Caller, vector3(0, 0, 40000))
						else
							_phys.ApplyForceCenter(Caller, vector3(0, 0, 25000))
						end
						teams[a].Health = teams[a].Health-20
						UpdateGlobalHUD(0)
						if teams[a].Health <= 0 then
							BowserKilled(a)
						end
					end
				end
			end
		end
	elseif PowerUpBlocks[Activator] then -- Hit a powerup block
		_TraceLine(vecAdd(vector3(18,0,0), _EntGetPos(Caller)), vector3(0,0,1), 39, Caller) local q = _TraceGetEnt() == Activator
		_TraceLine(_EntGetPos(Caller), vector3(0,0,1), 39, Caller) local w = _TraceGetEnt() == Activator
		_TraceLine(vecAdd(vector3(-18,0,0), _EntGetPos(Caller)), vector3(0,0,1), 39, Caller) local e = _TraceGetEnt() == Activator
		if q or w or e then
			PowerUpBlockHit(Activator, userpl)
		end
	end
end

function gamerulesThink()
	for i=1, _MaxPlayers() do
		if players[i].Box > 0 then
			_EntSetPos(i, vecAdd(_EntGetPos(players[i].Box), vector3(0,-350, 8)))
			_TraceLine(_EntGetPos(players[i].Box), vector3(0,0,-1), 38, players[i].Box)
			local hitmul = 1
			if not _TraceHit() then hitmul = 0.33333 end
			if _PlayerIsKeyDown(i, IN_MOVELEFT) then
				_phys.ApplyForceCenter(players[i].Box, vector3(-400*TICKRATE*hitmul, 0, 0))
			elseif _PlayerIsKeyDown(i, IN_MOVERIGHT) then
				_phys.ApplyForceCenter(players[i].Box, vector3(400*TICKRATE*hitmul, 0, 0))
			end
			if _PlayerIsKeyDown(i, IN_ATTACK) then
				if players[i].PowerUp == "sword" then
					if _PlayerGetShootAng(i).x > 0 then
						_phys.ApplyTorqueCenter(players[i].Box, vector3(0, 40*TICKRATE, 0))
					else
						_phys.ApplyTorqueCenter(players[i].Box, vector3(0, -40*TICKRATE	, 0))
					end
				end
			end
		end
	end
end

randompowers = {}
randompowers[1] = "star"
randompowers[2] = "hammer"
randompowers[3] = "fireball"
randompowers[4] = "sword"
randompowers[5] = "sword"
randompowers[6] = "mushroom"
randompowers[7] = "mushroom"
randompowers[8] = "mushroom"
randompowers[9] = "mushroom"

function PowerUpBlockHit(block, userid)
	local pup = PowerUpBlocks[block]
	if _CurTime() < LastSprouts[block] + 10 then return end
	local pos = vecAdd(_EntGetPos(block), vector3(0,0,64))
	for _, ent in _EntitiesFindInSphere(pos, 64) do
		if _EntGetType(ent) == "env_sprite" then return end
	end
	_EntFire(block, "FireUser1", "", 0)
	_EntSetMaterial(block, "mario/block_model")
	_EntEmitSound(block, "mario/Item sprout.wav")
	-- MakePowerUp(pup, pos, block)
	MakePowerUp(randompowers[math.random(1, table.getn(randompowers))], pos, block)
end

function MakePowerUp(pup, pos, block)
	local ent = _EntCreate("env_sprite")
	if ent > 0 then
		_EntSetKeyValue(ent, "model", "mario/powerup_"..pup..".vmt")
		_EntSetKeyValue(ent, "rendermode", "5")
		_EntSetKeyValue(ent, "scale", "0.5")
		_EntSetKeyValue(ent, "spawnflags", "1")
		_EntSetPos(ent, pos)
		_EntSpawn(ent)
		_EntFire(ent, "showsprite", "", 0)
		PowerUps[ent] = {}
		PowerUps[ent].pup = pup
		PowerUps[ent].pos = pos
		PowerUps[ent].Block = block
	end
end

function CheckPowerUpsHit()
	for i in PowerUps do
		local ents = _EntitiesFindInSphere(PowerUps[i].pos, 28)
		local p = false
		for a, x in ents do
			if boxowner[x] then
				if p then break end
				if players[boxowner[x]].PowerUp ~= "nothing" then
					PowerDown(boxowner[x], false)
				end
				p = true
				_RunString(PowerUps[i].pup.."("..boxowner[x]..")")
				_EntFire(PowerUps[i].Block, "FireUser2", "", 0)
			end
		end
		if p then
			_EntRemove(i)
			LastSprouts[PowerUps[i].Block] = _CurTime()
			AddTimer(10, 1, _EntSetMaterial, PowerUps[i].Block, "mario/questionblock_model")
			PowerUps[i] = nil
		end
	end
end
AddTimer(0.25, 0, CheckPowerUpsHit)

function eventPropBreak(breakerid, propid)
	if boxowner[propid] then
		players[boxowner[propid]].Box = 0
		boxowner[propid] = nil
	end
end

function eventKeyPressed(userid, in_key)
	if in_key == IN_JUMP then
		if players[userid].Box > 0 then
			if players[userid].LastJump < _CurTime()-0.25 then
				_TraceLine(vecAdd(vector3(20,0,0), _EntGetPos(players[userid].Box)), vector3(0,0,-1), 40, players[userid].Box) local a = _TraceHit()
				_TraceLine(_EntGetPos(players[userid].Box), vector3(0,0,-1), 40, players[userid].Box) local b = _TraceHit()
				_TraceLine(vecAdd(vector3(-20,0,0), _EntGetPos(players[userid].Box)), vector3(0,0,-1), 40, players[userid].Box) local c = _TraceHit()
				if a or b or c then
					_phys.ApplyForceCenter(players[userid].Box, vector3(0, 0, 20000))
					players[userid].LastJump = _CurTime()
					_EntEmitSound(userid, "mario/Mario Jump.wav")
				end
			end
		end
	elseif in_key == IN_ATTACK then
		if players[userid].PowerUp == "fireball" then
			if players[userid].LastFireBall < _CurTime()-1.5 then
				players[userid].LastFireBall = _CurTime()
				DoFireBall(userid)
			end
		elseif players[userid].PowerUp == "hammer" then
			if players[userid].LastFireBall < _CurTime()-2.5 then
				players[userid].LastFireBall = _CurTime()
				DoAxe(userid)
			end
		end
	--elseif in_key == IN_ATTACK2 then
	end
end

function eventPlayerKilled(killed, attacker, weapon)
	if players[killed].Box > 0 then
		_EntFire(players[killed].Box, "break", "", 0)
		_EntFire(players[killed].Box, "kill", "", 0.1)
		players[killed].LastJump = 0
		players[killed].LastFireBall = 0
		players[killed].LastStompedOn = 0
		players[killed].LastHurt = 0
		players[killed].LastHurtBy = 0
		players[killed].PowerUp = "nothing"
		Swords[killed] = nil
		_PlaySoundPlayer(killed, "mario/Death.wav")
		if _EntGetType(attacker) == "player" and attacker ~= killed then
			_PlayerAddScore(attacker, 1)
			if NDB then NDB.AddMoney(attacker, KILL_MONEY, false) end
		elseif attacker == killed then
			_PlayerAddScore(killed, -1)
		end
		--AddTimer(0.1, 1, _PlayerSilentKill, killed, 1, true)
		_PlayerSilentKill(killed, 1, true)
	end
	_PlayerAddDeath(killed, 1)
end

function eventPlayerSpawn(userid)
	_PlayerLockInPlace(userid, true)
	_PlayerFreeze(userid)
	_EntFire(userid, "alpha", "0", 0)
	if players[userid].Box > 0 then return end
	local box = _EntCreate("prop_physics")
	if box > 0 then
		_EntSetPos(box, vecAdd(_EntGetPos(userid), vector3(0,0,64)))
		_EntSetModel(box, "models/props_junk/wood_crate001a.mdl")
		_EntSetKeyValue(box, "rendermode", "5")
		_EntSetKeyValue(box, "physdamagescale", "1000")
		_EntSpawn(box)
		players[userid].Box = box
		boxowner[box] = userid
		_EntFire(box, "sethealth", "99999", 0)
		_EntSetPos(userid, vecAdd(_EntGetPos(box), vector3(0,-350, 16)))
		local color = teams[_PlayerInfo(userid,"team")].color
		_EntFire(box, "Color", color.r.." "..color.g.." "..color.b, 0)
		OutputEntityReps(box, "onhealthchanged", "PlayerHitSomething", 0, -1)
	end
	_PlaySoundPlayer(userid, "mario/Mario Riff.wav")
end

function GiveDefaultItems(userid) end

function FellDown(ent, trigger)
	if not boxowner[ent] then return end
	local owner = boxowner[ent]
	if players[owner].PowerUp ~= "star" then
		if _CurTime() < players[owner].LastHurt + 3 and players[owner].LastHurtBy > 0 then
			_TraceAttack(owner, players[owner].LastHurtBy, players[owner].LastHurtBy, 1000)
		else
			_PlayerKill(owner)
		end
	end
end

function Hurt(ent, trigger, amount)
	if not boxowner[ent] then return end
	local owner = boxowner[ent]
	if players[owner].LastHurt < _CurTime()-0.5 then
		if players[owner].PowerUp ~= "star" then
			PowerDown(owner, true)
			_TraceAttack(owner, owner, owner, amount)
			players[owner].LastHurt = _CurTime()
		end
	end
end

function PowerDown(userid, damaged)
	if players[userid].PowerUp == "nothing" or players[userid].Box <= 0 then return end
	if players[userid].PowerUp == "sword" or players[userid].PowerUp == "fireball" or players[userid].PowerUp == "hammer" then
		if damaged then
			_EntEmitSound(userid, "mario/Pipe Warp.wav")
			Flash(players[userid].Box)
		end
		_EntRemove(Swords[userid])
		Swords[userid] = nil
	elseif players[userid].PowerUp == "mushroom" then
		if damaged then
			_EntEmitSound(userid, "mario/Pipe Warp.wav")
			Flash(players[userid].Box)
		end
		_EntSetModel(players[userid].Box, "models/props_junk/wood_crate001a.mdl")
	elseif players[userid].PowerUp == "star" then
		return
	end
	players[userid].PowerUp = "nothing"
end

function Flash(ent)
	if _EntExists(ent) then
		_EntFire(ent, "alpha", "25", 0.1)
		_EntFire(ent, "alpha", "255", 0.2)
		_EntFire(ent, "alpha", "25", 0.3)
		_EntFire(ent, "alpha", "255", 0.4)
		_EntFire(ent, "alhha", "25", 0.5)
		_EntFire(ent, "alpha", "255", 0.6)
		_EntFire(ent, "alpha", "25", 0.7)
		_EntFire(ent, "alpha", "255", 0.8)
	end
end

Swords={}
_EntPrecacheModel("models/peanut/conansword.mdl")
function sword(userid)
	if players[userid].Box <= 0 then return end
	if players[userid].PowerUp ~= "nothing" then return end
	_EntEmitSound(userid, "mario/Power Up.wav")
	_EntEmitSound(userid, "physics/metal/sawblade_stick"..math.random(1,3)..".wav")
	local ent = _EntCreate("prop_dynamic_override")
	if ent > 0 then
		_EntSetModel(ent, "models/peanut/conansword.mdl")
		_EntSetPos(ent, vecAdd(_EntGetPos(players[userid].Box), vector3(0,0,38)))
		_EntSetAngAngle(ent, vector3(-0, -90, -180))
		_EntSetKeyValue(ent, "solid", "6")
		_EntSetParent(ent, players[userid].Box)
		_EntSpawn(ent)
		_EntSetOwner(ent, players[userid].Box)
		Swords[userid] = ent
		players[userid].PowerUp = "sword"
		local col = teams[_PlayerInfo(userid,"team")].color
		col = col.r.." "..col.g.." "..col.b
		_EntFire(players[userid].Box, "Color", "25 25 25", 0.1)
		_EntFire(players[userid].Box, "Color", col, 0.2)
		_EntFire(players[userid].Box, "Color", "25 25 25", 0.3)
		_EntFire(players[userid].Box, "Color", col, 0.4)
		_EntFire(players[userid].Box, "Color", "25 25 25", 0.5)
		_EntFire(players[userid].Box, "Color", col, 0.6)
		_EntFire(players[userid].Box, "Color", "25 25 25", 0.7)
		_EntFire(players[userid].Box, "Color", col, 0.8)
	end
end

function star(userid)
	if players[userid].Box <= 0 then return end
	if players[userid].PowerUp ~= "nothing" then return end
	_EntEmitSound(userid, "mario/Power Up.wav")
	local col = teams[_PlayerInfo(userid,"team")].color
	players[userid].PowerUp = "star"
	local starcols = {}
	starcols[1] = "255 0 75"
	starcols[2] = "255 255 255"
	starcols[3] = "0 255 255"
	col = col.r.." "..col.g.." "..col.b
	_EntSetMaterial(players[userid].Box, "gmod/shiny")
	for i=1, 90 do
		_EntFire(players[userid].Box, "Color", starcols[math.random(1, 3)], 0.1 * i)
	end
	_EntFire(players[userid].Box, "Color", "25 25 25", 9.1)
	_EntFire(players[userid].Box, "Color", col, 9.2)
	_EntFire(players[userid].Box, "Color", "25 25 25", 9.3)
	_EntFire(players[userid].Box, "Color", col, 9.4)
	_EntFire(players[userid].Box, "Color", "25 25 25", 9.5)
	_EntFire(players[userid].Box, "Color", col, 9.6)
	_EntFire(players[userid].Box, "Color", "25 25 25", 9.7)
	_EntFire(players[userid].Box, "Color", col, 9.8)
	_EntFire(players[userid].Box, "Color", "25 25 25", 9.9)
	_EntFire(players[userid].Box, "Color", col, 10)

	local tempx = _EntCreate("env_smokestack")
	if tempx > 0 then
		_EntSetKeyValue(tempx, "InitialState", "1")
		_EntSetKeyValue(tempx, "BaseSpread", "1")
		_EntSetKeyValue(tempx, "SpreadSpeed", "8")
		_EntSetKeyValue(tempx, "Speed", "4")
		_EntSetKeyValue(tempx, "startsize", "16")
		_EntSetKeyValue(tempx, "EndSize", "8")
		_EntSetKeyValue(tempx, "Rate", "32")
		_EntSetKeyValue(tempx, "JetLength", "8")
		_EntSetKeyValue(tempx, "SmokeMaterial", "particle/SmokeStack.vmt")
		_EntSetKeyValue(tempx, "twist", "1")
		_EntSetKeyValue(tempx, "roll", "0")
		_EntSetKeyValue(tempx, "rendercolor", "255 255 255")
		_EntSetKeyValue(tempx, "renderamt", "220")
		_EntSetPos(tempx, _EntGetPos(players[userid].Box))
		_EntSpawn(tempx)
		_EntSetParent(tempx, players[userid].Box)
		_EntFire(tempx, "TurnOn", "", 0)
		_EntFire(tempx, "TurnOff", "", 10)
		_EntFire(tempx, "kill", "", 15)
	end

	AddTimer(10.1, 1, DeStar, userid)
end

function DeStar(userid)
	if players[userid].PowerUp == "star" then
		players[userid].PowerUp = "nothing"
		_EntRemove(Swords[userid])
		Swords[userid] = nil
		_EntSetMaterial(players[userid].Box, "")
	end
end

_EntPrecacheModel("models/mixerman3d/weapons/axe01.mdl")
function axe(userid)
	if players[userid].Box <= 0 then return end
	if players[userid].PowerUp ~= "nothing" then return end
	_EntEmitSound(userid, "mario/Power Up.wav")
	_EntEmitSound(userid, "physics/metal/sawblade_stick"..math.random(1,3)..".wav")
	local ent = _EntCreate("prop_dynamic_override")
	if ent > 0 then
		_EntSetModel(ent, "models/mixerman3d/weapons/axe01.mdl")
		_EntSetPos(ent, vecAdd(_EntGetPos(players[userid].Box), vector3(0,0,43)))
		_EntSetAngAngle(ent, vector3(90, 0, 90))
		_EntSetKeyValue(ent, "solid", "0")
		_EntSetParent(ent, players[userid].Box)
		_EntSpawn(ent)
		_EntSetOwner(ent, players[userid].Box)
		Swords[userid] = ent
		players[userid].PowerUp = "hammer"
		local col = teams[_PlayerInfo(userid,"team")].color
		col = col.r.." "..col.g.." "..col.b
		_EntFire(players[userid].Box, "Color", "25 25 25", 0.1)
		_EntFire(players[userid].Box, "Color", col, 0.2)
		_EntFire(players[userid].Box, "Color", "25 25 25", 0.3)
		_EntFire(players[userid].Box, "Color", col, 0.4)
		_EntFire(players[userid].Box, "Color", "25 25 25", 0.5)
		_EntFire(players[userid].Box, "Color", col, 0.6)
		_EntFire(players[userid].Box, "Color", "25 25 25", 0.7)
		_EntFire(players[userid].Box, "Color", col, 0.8)
	end
end
hammer = axe

_EntPrecacheModel("models/props/de_dust/du_crate_96x96.mdl")
function mushroom(userid)
	if players[userid].Box <= 0 then return end
	if players[userid].PowerUp ~= "nothing" then return end
	_EntEmitSound(userid, "mario/Power Up.wav")
	players[userid].PowerUp = "mushroom"
	local col = teams[_PlayerInfo(userid,"team")].color
	col = col.r.." "..col.g.." "..col.b
	local mass = _phys.GetMass(players[userid].Box)
	_EntSetModel(players[userid].Box, "models/props/de_dust/du_crate_96x96.mdl")
	_EntFire(players[userid].Box, "Color", "25 25 25", 0.1)
	_EntFire(players[userid].Box, "Color", col, 0.2)
	_EntFire(players[userid].Box, "Color", "25 25 25", 0.3)
	_EntFire(players[userid].Box, "Color", col, 0.4)
	_EntFire(players[userid].Box, "Color", "25 25 25", 0.5)
	_EntFire(players[userid].Box, "Color", col, 0.6)
	_EntFire(players[userid].Box, "Color", "25 25 25", 0.7)
	_EntFire(players[userid].Box, "Color", col, 0.8)
	_phys.SetMass(players[userid].Box, mass)
end

function fireball(userid)
	if players[userid].Box <= 0 then return end
	if players[userid].PowerUp ~= "nothing" then return end
	_EntEmitSound(userid, "mario/Power Up.wav")
	local ent = _EntCreate("env_fire_trail")
	if ent > 0 then
		_EntSetPos(ent, _EntGetPos(players[userid].Box))
		_EntSetParent(ent, players[userid].Box)
		_EntSpawn(ent)
		Swords[userid] = ent
		players[userid].PowerUp = "fireball"
		local col = teams[_PlayerInfo(userid,"team")].color
		col = col.r.." "..col.g.." "..col.b
		_EntFire(players[userid].Box, "Color", "25 25 25", 0.1)
		_EntFire(players[userid].Box, "Color", col, 0.2)
		_EntFire(players[userid].Box, "Color", "25 25 25", 0.3)
		_EntFire(players[userid].Box, "Color", col, 0.4)
		_EntFire(players[userid].Box, "Color", "25 25 25", 0.5)
		_EntFire(players[userid].Box, "Color", col, 0.6)
		_EntFire(players[userid].Box, "Color", "25 25 25", 0.7)
		_EntFire(players[userid].Box, "Color", col, 0.8)
	end
end

function DoAxe(userid)
	if players[userid].Box <= 0 then return end
	PlayerLookTrace(userid, 4096)
	local mt0 = -35000
	local dir = _PlayerGetShootAng(userid)
	if dir.x > 0 then mt0 = 35000 end
	local ent = _EntCreate("prop_physics")
	if ent > 0 then
		_EntSetModel(ent, "models/mixerman3d/weapons/axe01.mdl")
		_EntSetAngAngle(ent, vector3(90, 0, 90))
		_EntSetPos(ent,  vecAdd(_EntGetPos(players[userid].Box), vector3(0,0,43)))
		oldEntSetOwner(ent, players[userid].Box)
		EntOwners[ent] = userid
		_EntSetKeyValue(ent, "physdamagescale", "50000")
		_EntSpawn(ent)
		OutputEntity(ent, "onhealthchanged", "AxeHit", 0)
		_EntSetName(ent, "axe")
		_phys.ApplyForceCenter(ent, vector3(mt0, 0, 40000))
		_phys.ApplyTorqueCenter(ent, vector3(0, mt0, 0))
		_EntFire(ent, "kill", "", 10)
	end
	_EntEmitSound(userid, "ambient/machines/catapult_throw.wav")
end

MakeFunction("AxeHit")
function AxeHit(Activator, Caller)
	if Activator == 0 then return end
	if string.find(_EntGetType(Activator), "func_") ~= nil then return end
	local userid = _EntGetOwner(Caller)
	if boxowner[Activator] then
		if _PlayerInfo(boxowner[Activator], "team") ~= _PlayerInfo(userid, "team") then
			players[boxowner[Activator]].LastHurtBy = userid
			players[boxowner[Activator]].LastHurt = _CurTime()
			if players[boxowner[Activator]].PowerUp == "nothing" then
				_TraceAttack(boxowner[Activator], userid, userid, 35)
			else
				PowerDown(boxowner[Activator], true)
			end
		end
		_EntEmitSound(Activator, "physics/wood/wood_box_break1.wav")
		_EntRemove(Caller)
	elseif _EntGetName(Activator) == "bowser" then
		for a in teams do
			if teams[a].Bowser ~= teams[_PlayerInfo(userid, "team")].Bowser then
				teams[a].Health = teams[a].Health-20
				UpdateGlobalHUD(0)
				if teams[a].Health <= 0 then
					BowserKilled(a)
				end
			end
		end
		_EntEmitSound(Activator, "physics/wood/wood_box_break1.wav")
		_EntRemove(Caller)
	end
end

_EntPrecacheModel("models/bm/basketball.mdl")
function DoFireBall(userid)
	if players[userid].Box <= 0 then return end
	_TraceLine(_EntGetPos(players[userid].Box), vector3(0,0,-1), 40, players[userid].Box)
	local onground = 0
	if _TraceHit() then onground = -3000 end
	PlayerLookTrace(userid, 4096)
	local mt0 = -5500
	local dir = _PlayerGetShootAng(userid)
	if dir.x > 0 then mt0 = 5500 end
	local ent = _EntCreate("prop_physics")
	if ent > 0 then
		_EntSetModel(ent, "models/bm/basketball.mdl")
		_EntSetPos(ent, _EntGetPos(players[userid].Box))
		oldEntSetOwner(ent, players[userid].Box)
		EntOwners[ent] = userid
		_EntSetKeyValue(ent, "physdamagescale", "500")
		_EntSpawn(ent)
		OutputEntityReps(ent, "onhealthchanged", "FireBallExplode", 0, -1)
		_EntSetMaterial(ent, "models/props_lab/Tank_Glass001")
		_EntSetName(ent, "fireball")
		local fire = _EntCreate("env_fire_trail")
		if fire > 0 then
			_EntSetPos(fire, _EntGetPos(ent))
			_EntSpawn(fire)
			_EntSetParent(fire, ent)
		end
		_phys.ApplyForceCenter(ent, vector3(mt0, 0, onground))
		_EntFire(ent, "kill", "", 3)
	end
	_EntEmitSound(userid, "mario/Fireball.wav")
end

MakeFunction("FireBallExplode")
function FireBallExplode(Activator, i)
	if Activator == 0 then return end
	if string.find(_EntGetType(Activator), "func_") ~= nil then return end
	local userid = _EntGetOwner(i)
	for p, x in _EntitiesFindInSphere(_EntGetPos(i), 40) do
		if boxowner[x] then
			if _PlayerInfo(boxowner[x], "team") ~= _PlayerInfo(userid, "team") then
				if players[boxowner[x]].PowerUp ~= "star" then
					players[boxowner[x]].LastHurtBy = userid
					players[boxowner[x]].LastHurt = _CurTime()
					_TraceAttack(boxowner[x], userid, userid, 25)
				end
			end
		elseif _EntGetName(x) == "bowser" then
			for a in teams do
				if teams[a].Bowser ~= teams[_PlayerInfo(userid, "team")].Bowser then
					teams[a].Health = teams[a].Health-10
					UpdateGlobalHUD(0)
					if teams[a].Health <= 0 then
						BowserKilled(a)
					end
				end
			end
		end
	end
	local ent = _EntCreate("env_sprite")
	if ent > 0 then
		_EntSetKeyValue(ent, "model", "sprites/splodesprite.spr")
		_EntSetKeyValue(ent, "rendermode", "5")
		_EntSetKeyValue(ent, "scale", "0.2")
		_EntSetKeyValue(ent, "spawnflags", "1")
		_EntSetPos(ent, _EntGetPos(i))
		_EntSpawn(ent)
		_EntFire(ent, "showsprite", "", 0)
		_EntFire(ent, "setscale", "0.3", 0.1)
		_EntFire(ent, "setscale", "0.4", 0.2)
		_EntFire(ent, "setscale", "0.5", 0.3)
		_EntFire(ent, "hidesprite", "", 0.4)
		_EntFire(ent, "kill", "", 0.5)
	end
	_EntEmitSound(i, "mario/Bump.wav")
	_EntRemove(i)
end
