-- NoX Arena
-- By JetBoom
_OpenScript("noxiouscore.lua")

function SwapLocation(userid)
	if not _PlayerInfo(userid, "alive") then return end
	PlayerLookTrace(userid, 1800)
	if _TraceHitNonWorld() then
		local traced = _TraceGetEnt()
		if IsPlayer(traced) then
			if _PlayerInfo(traced, "team") ~= _PlayerInfo(userid, "team") and _PlayerInfo(traced,"team") ~= TEAM_RED then
				local pos = _EntGetPos(traced)
				local vel = _EntGetVelocity(traced)
				_EntSetPos(traced, _EntGetPos(userid))
				_EntSetVelocity(traced, _EntGetVelocity(userid))
				_EntSetPos(userid, pos)
				_EntSetVelocity(userid, vel)
				_EffectInit()
				 _EffectSetEnt(userid or 255)
				 _EffectSetOrigin(vecAdd(_EntGetPos(userid), vector3(0,0,36)))
				 _EffectSetStart(vecAdd(_EntGetPos(traced), vector3(0,0,36)))
				 _EffectSetScale(5)
				 _EffectSetMagnitude(1.0)
				_EffectDispatch("FadingLineTeam")
				local ent = _EntCreate("env_sprite")
				if ent > 0 then
					_EntSetKeyValue(ent, "model", "sprites/redglow3.spr")
					_EntSetKeyValue(ent, "rendermode", "5")
					_EntSetKeyValue(ent, "scale", "0.5")
					_EntSetKeyValue(ent, "spawnflags", "5")
					_EntSetPos(ent, vecAdd(_EntGetPos(traced), vector3(0,0,36)))
					_EntSpawn(ent)
					_EntFire(ent, "showsprite", "", 0)
					_EntFire(ent, "hidesprite", "", 1.0)
					_EntFire(ent, "kill", "", 1.1)
					_EntEmitSound(ent, "nox/blink.wav")
				end
				ent = _EntCreate("env_sprite")
				if ent > 0 then
					_EntSetKeyValue(ent, "model", "sprites/redglow3.spr")
					_EntSetKeyValue(ent, "rendermode", "5")
					_EntSetKeyValue(ent, "scale", "0.5")
					_EntSetKeyValue(ent, "spawnflags", "5")
					_EntSetPos(ent, vecAdd(_EntGetPos(userid), vector3(0,0,36)))
					_EntSpawn(ent)
					_EntFire(ent, "showsprite", "", 0)
					_EntFire(ent, "hidesprite", "", 1.0)
					_EntFire(ent, "kill", "", 1.1)
					_EntEmitSound(ent, "nox/blink.wav")
				end
			end
		end
	end
end

_ServerCommand("gm_sv_allowspawning 0\n")
_ServerCommand("gm_sv_allownpc 0\n")
_ServerCommand("gm_sv_allweapons 0\n")
_ServerCommand("gm_sv_teamplay 1\n")
_ServerCommand("gm_sv_allowmultigun 0\n")
_ServerCommand("gm_sv_allowphysgun 0\n")
_ServerCommand("gm_sv_teamdamage 0\n")
_ServerCommand("gm_sv_playerdamage 1\n")
_ServerCommand("gm_sv_pvpdamage 1\n")
_ServerCommand("gm_sv_setrules\n")

Fighting = false
BETDEADLINE=25
FIGHTERQUEUE = {}
LASTFIGHT = -BETDEADLINE
PREFIGHTTIMER = -1
FIGHTTIMER = 0
CountDownTime = 10
Tick = 0
MAXNUMFIGHTERS=10
NumOfFighters=0
MAXFIGHTTIME=4

players = {}
for i=1, _MaxPlayers() do
	players[i] = {}
	players[i].money = 0
	players[i].Invisible = false
	players[i].Class = 1
	players[i].Certifications = "gunslinger"
	players[i].Bet = 0
	players[i].BetOn = 0
end

function gamerulesThink()
	if not Fighting then
		if table.getn(FIGHTERQUEUE) >= 2 and PREFIGHTTIMER < 0 then
			PREFIGHTTIMER = AddTimer(1, CountDownTime+1, CountDownTimer)
		end
	end
end

function CountDownTimer()
	if table.getn(FIGHTERQUEUE) < 2 then
		HaltTimer(PREFIGHTTIMER)
		PREFIGHTTIMER = -1
		CountDownTime = 10
		return
	end
	for i=1, _MaxPlayers() do
		if _PlayerInfo(i,"connected") then
			if CountDownTime > 0 then
				_GModText_Start("ImpactMassive")
				 _GModText_SetTime(2, 0, 1)
				 _GModText_SetPos(-1, 0.4)
				 if IsGoingToFight(i) then
					 _GModText_SetText("You are fighting in:\n"..CountDownTime)
					 _GModText_SetColor(255, 0, 0, 255)
				 else
		 			 _GModText_SetText("Spectating battle in:\n"..CountDownTime)
					 _GModText_SetColor(255, 255, 255, 255)
				 end
				_GModText_Send(i, 910)
			end
		end
	end
	_PlaySound("hl1/fvox/bell.wav")
	if CountDownTime < 1 and not Fighting then
		StartFight()
		_GModText_Start("ImpactMassive")
		 _GModText_SetColor(255, 255, 255, 255)
		 _GModText_SetTime(2, 0, 1)
		 _GModText_SetPos(-1, 0.4)
		 _GModText_SetText("\n\nBATTLE BEGIN")
		_GModText_Send(0, 910)
	else
		CountDownTime = CountDownTime-1
		--if CountDownTime == 10 then _PlaySound("fightcountdown.mp3") end
	end
end

function StartFight()
	NumOfFighters=table.getn(FIGHTERQUEUE)
	if NumOfFighters > MAXNUMFIGHTERS then NumOfFighters = MAXNUMFIGHTERS end
	Fighting = true
	if MAXFIGHTTIME > 0 then
		FIGHTTIMER = AddTimer(MAXFIGHTTIME*60, 1, FinishRound, 0)
	end
	for i=1, NumOfFighters do
		if _PlayerInfo(FIGHTERQUEUE[1], "connected") then
			if _TeamNumPlayers(TEAM_GREEN) < NumOfFighters/2 then
				_PlayerChangeTeam(FIGHTERQUEUE[1], TEAM_GREEN)
			else
				_PlayerChangeTeam(FIGHTERQUEUE[1], TEAM_YELLOW)
			end
			_PlayerRespawn(FIGHTERQUEUE[1])
			table.remove(FIGHTERQUEUE, 1)
		end
	end
	HaltTimer(PREFIGHTTIMER)
	PREFIGHTTIMER = -1
	onShowTeam(0)
	LASTFIGHT = _CurTime()
	local lives = math.floor((_TeamNumPlayers(TEAM_YELLOW) + _TeamNumPlayers(TEAM_GREEN)) * 0.5)
	TeamLives[TEAM_YELLOW] = lives
	TeamLives[TEAM_GREEN] = lives
	DrawTeamLives(0)
end

function DrawTeamLives(userid)
	_GModText_Start("ImpactMassive")
	 _GModText_SetColor(0, 255, 0, 255)
	 _GModText_SetTime(9999, 0, 0)
	 _GModText_SetPos(0.45, 0.01)
	 _GModText_SetText(TeamLives[TEAM_GREEN])
	_GModText_Send(userid, 9308)
	_GModText_Start("ImpactMassive")
	 _GModText_SetColor(255, 255, 0, 255)
	 _GModText_SetTime(9999, 0, 0)
	 _GModText_SetPos(0.54, 0.01)
	 _GModText_SetText(TeamLives[TEAM_YELLOW])
	_GModText_Send(userid, 9309)
end

function BookieRegenerate()
	_file.Write("noxiousprofiles/brbookie.txt", tonumber(_file.Read("noxiousprofiles/brbookie.txt"))+100)
end

START = false
function gamerulesStartMap()
	if START then return end
	START = true
	PlayerFreezeAll(false)
	_TeamSetName(TEAM_RED, "The Mistempered Crowd")
	_TeamSetName(TEAM_BLUE, "Pen0r")
	_TeamSetName(TEAM_GREEN, "TEH GREEN TeaM")
	_TeamSetName(TEAM_YELLOW, "TEH YELLOW TeaM")
	_GameSetTargetIDRules(TRGTID_TEAMONLY)

	_ServerCommand("sk_zombie_health 400\n")
	_ServerCommand("sk_zombie_dmg_both_slash 50\n")
	_ServerCommand("sk_zombie_dmg_one_slash 35\n")

	_EntPrecacheModel("models/weapons/v_smg_mac10.mdl")
	_EntPrecacheModel("models/weapons/w_smg_mac10.mdl")
	_EntPrecacheModel("models/weapons/w_shot_m3super90.mdl")
	_EntPrecacheModel("models/weapons/v_shot_m3super90.mdl")
	_EntPrecacheModel("models/weapons/w_pist_deagle.mdl")
	_EntPrecacheModel("models/weapons/v_pist_deagle.mdl")
	_EntPrecacheModel("models/peanut/conansword.mdl")
	_EntPrecacheModel("models/weapons/v_stunbaton.mdl")
	_EntPrecacheModel("models/weapons/w_stunbaton.mdl")
	_EntPrecacheModel("models/mixerman3d/weapons/axe01.mdl")
	_EntPrecacheModel("models/weapons/w_rif_ak47.mdl")
	_EntPrecacheModel("models/weapons/v_rif_ak47.mdl")
	_EntPrecacheModel("models/weapons/w_pist_p228.mdl")
	_EntPrecacheModel("models/weapons/v_pist_p228.mdl")
	_EntPrecacheModel("models/weapons/w_knife_ct.mdl")
	_EntPrecacheModel("models/weapons/v_knife_t.mdl")

	_EntPrecacheModel("models/Roller_Spikes.mdl")
	_EntPrecacheModel("models/player/gman_high.mdl")
	_EntPrecacheModel("models/player/barney.mdl")
	_EntPrecacheModel("models/player/alyx.mdl")
	_EntPrecacheModel("models/player/breen.mdl")
	_EntPrecacheModel("models/player/combine_soldier.mdl")
	_EntPrecacheModel("models/player/combine_soldier_prisonguard.mdl")
	_EntPrecacheModel("models/player/combine_super_soldier.mdl")
	_EntPrecacheModel("models/player/eli.mdl")
	_EntPrecacheModel("models/player/classic.mdl")
	_EntPrecacheModel("models/player/corpse1.mdl")
	_EntPrecacheModel("models/player/female_04.mdl")
	_EntPrecacheModel("models/player/female_06.mdl")
	_EntPrecacheModel("models/player/male_02.mdl")
	_EntPrecacheModel("models/player/male_03.mdl")
	_EntPrecacheModel("models/player/male_08.mdl")
	_EntPrecacheModel("models/player/monk.mdl")
	_EntPrecacheModel("models/player/mossman.mdl")
	_EntPrecacheModel("models/player/odessa.mdl")
	_EntPrecacheModel("models/player/stripped.mdl")
	_EntPrecacheModel("models/player/stalker.mdl")
	_EntPrecacheModel("models/player/kleiner.mdl")
	_EntPrecacheModel("models/player/female_07.mdl")
	_EntPrecacheModel("models/player/charple01.mdl")
	_EntPrecacheModel("models/headcrabclassic.mdl")
	_EntPrecacheModel("models/player/Police.mdl")
	_EntPrecacheModel("models/Player/gordon_classic.mdl")
	_EntPrecacheModel("models/headcrabblack.mdl")
	_EntPrecacheModel("models/headcrab.mdl")

	CreateResFile()
	AddTimer(60, 0, BookieRegenerate)
end

function PickDefaultSpawnTeam(userid)
	_PlayerChangeTeam(userid, TEAM_RED)
	return true
end

function GiveDefaultItems(userid)
	if _PlayerInfo(userid, "team") == TEAM_RED then _PlayerGiveItem(userid, "weapon_physcannon") return end
	_PlayerGiveItem(userid, "weapon_physcannon")
	for i=1, table.getn(Classes[players[userid].Class].SWEPs) do
		_PlayerGiveSWEP(userid, Classes[players[userid].Class].SWEPs[i])
	end
end

function CreateResFile()
	_file.Write("maps/".._GetCurrentMap()..".res", CreateResFileString())
end

function eventPlayerSpawn(userid)
	if _PlayerInfo(userid, "team") ~= TEAM_RED then
		_GModText_Hide(userid, 1111, 0, 0)
		_GModText_Hide(userid, 5019, 0, 0)
	end
	Gibbed[userid] = false
	_PlayerSetDrawViewModel(userid, true)
	_player.ShouldDropWeapon(userid, false)
	_EntSetMaxHealth(userid, Classes[players[userid].Class].Health)
	_PlayerSetHealth(userid, Classes[players[userid].Class].Health)
	_PlayerSetArmor(userid, Classes[players[userid].Class].Armor)
	_EntFire(userid, "color", TeamColor(_PlayerInfo(userid,"team")), 0)
	_GModRect_Hide(userid, 1800, 0, 0)
	_GModRect_Hide(userid, 1801, 0, 0)
end

teamcolor = {}
teamcolor[TEAM_RED] = {r=255,g=25,b=10}
teamcolor[TEAM_GREEN] = {r=15,g=255,b=15}
teamcolor[TEAM_YELLOW] = {r=255,g=240,b=20}
function TeamColor(num)
	return teamcolor[num].r.." "..teamcolor[num].g.." "..teamcolor[num].b
end

function eventKeyPressed(userid, in_key)
	if players[userid].Invisible then
		if in_key == IN_ATTACK then
			local unin = true
			if Classes[players[userid].Class].Name == "mage" then
				unin = not _PlayerIsKeyDown(userid, IN_ATTACK2)
			end
			if unin then
				players[userid].Invisible = false
				_EntEmitSound(userid, "nox/invisoff.wav")
				_GModRect_Hide(userid, 9109, 0)
				_EntFire(userid, "alpha", "255", 0)
				_PlayerSetDrawWorldModel(userid, true)
			end
		end
	end
end

function onTakeDamage(ent, inflictor, attacker, damage)
	if IsPlayer(ent) then
		if players[ent].Invisible then
			players[ent].Invisible = false
			_EntFire(ent, "alpha", "255", 0)
			_EntEmitSound(ent, "nox/invisoff.wav")
			_GModRect_Hide(ent, 9109, 0)
			_PlayerSetDrawWorldModel(ent, true)
		end
		if damage >= _PlayerInfo(ent, "health")+30 then
			if _PlayerInfo(ent, "armor") < 10 then
				if IsPlayer(attacker) then
					if _PlayerInfo(attacker, "team") ~= _PlayerInfo(ent, "team") or ent == attacker then
						Gib(ent)
					end
				else
					Gib(ent)
				end
			end
		end
	end
end

function math.frandom(minn, maxn)
	minn = minn * 100
	maxn = maxn * 100
	return math.random(minn, maxn)*0.01
end

Killed = {}
Killed[TEAM_GREEN] = {}
Killed[TEAM_YELLOW] = {}
TeamLives = {}
TeamLives[TEAM_GREEN] = 1
TeamLives[TEAM_YELLOW] = 1
function eventPlayerKilled(killed, attacker, weapon)
	if IsPlayer(attacker) then
		if killed ~= attacker then
			if _PlayerInfo(killed, "team") ~= TEAM_RED then
				NDB.AddMoney(attacker, 25 + Classes[players[killed].Class].KillBonus)
				_PlayerAddScore(attacker, 1)
			end
		else
			_PlayerAddScore(killed, -1)
		end
	end
	_EntEmitSoundEx(killed, "nox/player_death.wav", 1.3, 1.0)
	local team = _PlayerInfo(killed, "team")
	local otherteam = _PlayerInfo(attacker, "team")

	if team == TEAM_RED then return end
	if Fighting then
		if TeamLives[team] > 0 then
			TeamLives[team] = TeamLives[team] - 1
			AddTimer(2.5, 1, _PlayerRespawn, killed)
			DrawTeamLives(0)
		else
			_PlayerChangeTeam(killed, TEAM_RED)
			DrawTeamLives(0)
			if Killed[team] ~= nil then
				table.insert(Killed[team], _PlayerInfo(killed,"networkid"))
			end
			if _TeamNumPlayers(TEAM_GREEN) <= 0 then
				FinishRound(TEAM_YELLOW)
			elseif _TeamNumPlayers(TEAM_YELLOW) <= 0 then
				FinishRound(TEAM_GREEN)
			end
		end
		_PlayerAddDeath(killed, 1)
		_PlaySound("jbb/knockout.mp3")
	end
end

function eventPlayerDisconnect(name, userid, address, steamid, reason)
	if not IsPlayerOnline(userid) then return end
	for i=1, table.getn(FIGHTERQUEUE) do
		if FIGHTERQUEUE[i] == userid then
			table.remove(FIGHTERQUEUE, i)
			onShowTeam(0)
		end
	end
	if players[userid].Bet > 0 then
		_file.Write("noxiousprofiles/brbookie.txt", tonumber(_file.Read("noxiousprofiles/brbookie.txt"))+(players[userid].Bet*2))
		players[userid].Bet = 0
	end
	players[userid].BetOn = 0
	local team = _PlayerInfo(userid, "team")
	local otherteam = 0
	if team == TEAM_GREEN then otherteam = TEAM_YELLOW else otherteam = TEAM_GREEN end
	if Fighting then
		if _TeamNumPlayers(TEAM_GREEN) <= 0 then
			FinishRound(TEAM_YELLOW)
		elseif _TeamNumPlayers(TEAM_YELLOW) <= 0 then
			FinishRound(TEAM_GREEN)
		end
	end
end

function DoBet(sender, args)
	if string.len(args) < 5 then return end
	args = string.gsub(args, " all ", " "..players[sender].money.." ")
	args = string.gsub(args, " everything ", " "..players[sender].money.." ")
	if players[sender].BetOn > 0 then _PrintMessage(sender, 3, "All bets are final.") _PrintMessage(sender, 2, "All bets are final.\n") return end
	if not Fighting then _PrintMessage(sender, 3, "You can't bet on a non-existant fight.") _PrintMessage(sender, 2, "You can't bet on a non-existant fight.\n") return end
	if _CurTime() > LASTFIGHT+BETDEADLINE then _PrintMessage(sender, 3, "It's too late to make any bets on this fight.") _PrintMessage(sender, 2, "It's too late to make any bets on this fight.\n") return end
	local on, name = string.find(args, " on ")
	if on == nil or name == nil then _PrintMessage(sender, 3, "Syntax - I bet # on <team color>") _PrintMessage(sender, 2, "Syntax - I bet # on <team color>\n") return end
	local money = tonumber(string.sub(args, 1, on-1))
	if money == nil then _PrintMessage(sender, 3, "Syntax - I bet # on <team color>") _PrintMessage(sender, 2, "Syntax - I bet # on <team color>\n") return end
	local userid = string.lower(string.sub(args, name+1))
	if userid ~= "green" and userid ~= "yellow" then
		_PrintMessage(sender, 3, "Can only bet on green or yellow.")
		_PrintMessage(sender, 2, "Can only bet on green or yellow.\n")
		return
	end

	if money < 10 then _PrintMessage(sender, 3, "You can't bet such a paltry amount of money.") _PrintMessage(sender, 2, "You can't bet such a paltry amount of money.\n") return end
	if money > 2000 then _PrintMessage(sender, 3, "You can only bet $2,000 at a time!") _PrintMessage(sender, 2, "You can only bet $2,000 at a time!") return end
	if money > players[sender].money then _PrintMessage(sender, 3, "You don't have that much money.") _PrintMessage(sender, 2, "You don't have that much money.\n") return end
	if money > tonumber(_file.Read("noxiousprofiles/brbookie.txt")) then _PrintMessage(sender, 3, "The bookie doesn't have that much money.") _PrintMessage(sender, 2, "The bookie doesn't have that much money.\n") return end
	if _PlayerInfo(sender, "team") ~= TEAM_RED then _PrintMessage(sender, 3, "You can't bet while fighting.") _PrintMessage(sender, 2, "You can't bet while fighting.\n") return end
	money = math.floor(money)
	players[sender].money = players[sender].money-money
	_file.Write("noxiousprofiles/brbookie.txt", tonumber(_file.Read("noxiousprofiles/brbookie.txt"))-money)
	NDB.drawMoneyAmmount(sender)
	_PrintMessage(sender, 3, "You bet $"..money.." on "..userid.." to win.")
	_PrintMessage(sender, 2, "You bet $"..money.." on "..userid.." to win.\n")
	players[sender].Bet = money
	if userid == "yellow" then
		players[sender].BetOn = TEAM_YELLOW
	elseif userid == "green" then
		players[sender].BetOn = TEAM_GREEN
	end
end

function ClassMenu(userid, class)
	if _PlayerInfo(userid, "team") ~= TEAM_RED or IsGoingToFight(userid) then return end
	if players[userid].Class == class then
		_PrintMessage(userid, 4, "You are already a "..Classes[class].DisplayName.."!")
	elseif Certified(userid, Classes[class].Name) then
		players[userid].Class = class
		_PlayerRespawn(userid)
		_PrintMessage(userid, 4, "You are now a "..Classes[class].DisplayName.."!")
	elseif players[userid].money >= Classes[class].Value then
		players[userid].money = players[userid].money-Classes[class].Value
		players[userid].Class = class
		players[userid].Certifications = players[userid].Certifications.." "..Classes[class].Name
		NDB.SaveInfo(userid)
		_PlayerRespawn(userid)
		_PrintMessage(userid, 4, "You are now a certified "..Classes[class].DisplayName.."!")
		NDB.drawMoneyAmmount(userid)
	else
		_PrintMessage(userid, 4, "You don't have enough cash.")
	end
end

function onShowSpare1(userid)
	if _PlayerInfo(userid, "team") ~= TEAM_RED or IsGoingToFight(userid) then return end
	local menu = JBMenu.CreateMenu(false, "Class Menu", "", "255 255 255", "255 255 255")
	JBMenu.AddChoice(menu, "Class Catalog", "Purchase certifications.", "0 255 0", BuyClasses, userid)
	JBMenu.AddChoice(menu, "Your Classes", "Certifications you have purchased.", "0 255 0", CurrentClasses, userid)
	JBLastExit[userid] = _CurTime()-1
	JBMenu.SendMenu(userid, menu)
end

function BuyClasses(userid)
	local menu = JBMenu.CreateMenu(false, "Buy Classes", "", "255 255 255", "255 255 255")
	for i=1, table.getn(Classes) do
		if not Certified(userid, Classes[i].Name) then
			if not Classes[i].Hidden then
				if Classes[i].Value > players[userid].money then
					JBMenu.AddChoice(menu, "($"..Classes[i].Value..") "..Classes[i].DisplayName, Classes[i].Desc, "255 0 0", ClassMenu, userid, i)
				else
					JBMenu.AddChoice(menu, "($"..Classes[i].Value..") "..Classes[i].DisplayName, Classes[i].Desc, "0 255 0", ClassMenu, userid, i)
				end
			end
		end
	end
	JBMenu.AddChoice(menu, "", "<-- Back", "255 255 255", onShowSpare1, userid)
	JBLastExit[userid] = _CurTime()-1
	JBMenu.SendMenu(userid, menu)
end

function CurrentClasses(userid)
	local menu = JBMenu.CreateMenu(false, "Your Classes", "", "255 255 255", "255 255 255")
	for i=1, table.getn(Classes) do
		if Classes[i].Hidden then
			if Certified(userid, Classes[i].Name) then
				JBMenu.AddChoice(menu, "(HIDDEN) "..Classes[i].DisplayName, Classes[i].Desc, "255 255 0", ClassMenu, userid, i)
			end
		elseif Certified(userid, Classes[i].Name) then
			JBMenu.AddChoice(menu, "(CERTIFIED) "..Classes[i].DisplayName, Classes[i].Desc, "255 255 255", ClassMenu, userid, i)
		end
	end
	JBMenu.AddChoice(menu, "", "<-- Back", "255 255 255", onShowSpare1, userid)
	JBLastExit[userid] = _CurTime()-1
	JBMenu.SendMenu(userid, menu)
end

function IsGoingToFight(userid)
	for i=1, table.getn(FIGHTERQUEUE) do
		if i > MAXNUMFIGHTERS then return false end
		if FIGHTERQUEUE[i] == userid then
			return true
		end
	end
	return false
end

function InQueue(userid)
	for i=1, table.getn(FIGHTERQUEUE) do
		if FIGHTERQUEUE[i] == userid then
			return true
		end
	end
	return false
end

function FinishRound(team)
	local winnings = NumOfFighters*25
	for i=1, _MaxPlayers() do
		if _PlayerInfo(i, "connected") then
			if players[i].BetOn > 0 then
				if team == players[i].BetOn then
					players[i].money = players[i].money+(players[i].Bet*2)
					_PrintMessage(i, 3, (players[i].Bet*2).." has been deposited to you for winning the bet.")
					_PrintMessage(i, 2, (players[i].Bet*2).." has been deposited to you for winning the bet.\n")
					NDB.drawMoneyAmmount(i)
					_PlaySoundPlayer(i, "ambient/levels/labs/coinslot1.wav")
					_EntEmitSound(i, "ambient/levels/labs/coinslot1.wav")
				else
					_PrintMessage(i, 3, "You have lost the money wagered in the bet.")
					_PrintMessage(i, 2, "You have lost the money wagered in the bet.\n")
					_file.Write("noxiousprofiles/brbookie.txt", tonumber(_file.Read("noxiousprofiles/brbookie.txt"))+(players[i].Bet*2))
					local mm = math.random(1, 2)
					if mm < 2 then _EntEmitSound(i, "vo/npc/barney/ba_ohshit03.wav") else _EntEmitSound(i, "vo/citadel/br_ohshit.wav") end
				end
				players[i].BetOn = 0
				players[i].Bet = 0
			end
			if _PlayerInfo(i, "team") == team then
				if players[i].GoldMember then
					players[i].money = players[i].money+(winnings*1.25)
				else
					players[i].money = players[i].money+winnings
				end
				NDB.drawMoneyAmmount(i)
				AddTimer(2.5, 1, _PlayerChangeTeam, i, TEAM_RED)
				AddTimer(3, 1, _PlayerRespawn, i)
			end
		end
	end
	for j,k in Killed[team] do
		for o=1, _MaxPlayers() do
			if IsPlayerOnline(o) then
				if _PlayerInfo(o, "networkid") == k then
					if players[o].GoldMember then
						players[o].money = players[o].money+(winnings*1.25)
					else
						players[o].money = players[o].money+winnings
					end	
					NDB.drawMoneyAmmount(o)
				end
			end
		end
	end
	_GModText_Start("ImpactMassive")
	 _GModText_SetColor(255, 255, 255, 255)
	 _GModText_SetTime(4, 0, 1)
	 _GModText_SetPos(-1, 0.25)
	 if team > 0 then
		_GModText_SetText("All "..TeamString(team).." players won $"..winnings.."!!")
		_PlaySound("jbb/allyscore.mp3")
	else
		_GModText_SetText("You lose.\nYou get nothing.\nGOOD DAY SIR!")
		_PlaySound("youlose2.wav")
	 end
	 _GModText_Send(0, 909)

	HaltTimer(FIGHTTIMER)
	Fighting = false
	PREFIGHTTIMER = -1
	CountDownTime = 10
	NumOfFighters = 0
	NDB.GlobalSave()
	Killed[TEAM_GREEN] = {}
	Killed[TEAM_YELLOW] = {}
end

function onShowSpare2(userid)
	_PrintMessage(userid, 4, "The betting bookie has $".._file.Read("noxiousprofiles/brbookie.txt")..".")
end

function onShowTeam(userid)
	if userid > 0 then
		if _PlayerInfo(userid,"team") ~= TEAM_RED or not _PlayerInfo(userid, "alive") then return end
		if not InQueue(userid) then
			table.insert(FIGHTERQUEUE, userid)
		end
	end

	for x=1, _MaxPlayers() do
		if IsPlayerOnline(x) then
			for i=1, table.getn(FIGHTERQUEUE) do
				if FIGHTERQUEUE[i] == x then
					_GModText_Start("DefaultShadow")
					_GModText_SetTime(9999, 0, 0)
					_GModText_SetPos(-1, 0.2)
					if i <= MAXNUMFIGHTERS then
						_GModText_SetColor(0, 255, 0, 255)
						_GModText_SetText("Slot in Queue: "..i.."/"..table.getn(FIGHTERQUEUE).."\nYou will fight next round.")
					else
						_GModText_SetColor(255, 0, 0, 255)
						_GModText_SetText("Slot in Queue: "..i.."/"..table.getn(FIGHTERQUEUE).."\nYou will NOT fight next round.")
					end
					_GModText_Send( x, 1111)
				end
			end
		end
	end
end

function onShowHelp(userid)
	_GModRect_Start("gmod/white")
	 _GModRect_SetPos(0.0, 0.14, 1.0, 0.35)
	 _GModRect_SetColor(0, 0, 0, 175)
	 _GModRect_SetTime(10, 0.2, 1)
	_GModRect_Send(userid, 49)
	_GModText_Start("Trebuchet24")
	 _GModText_SetPos(-1, 0.16)
	 _GModText_SetColor(255, 255, 255, 255)
	 _GModText_SetTime(10, 0.2, 1.25)
	 _GModText_SetText("NoXious Arena\n a gamemode by JetBoom")
	_GModText_Send(userid, 50)
	_GModText_Start("Default")
	 _GModText_SetPos(-1, 0.3)
	 _GModText_SetColor(90, 90, 255, 240)
	 _GModText_SetTime(10, 0.2, 1.25)
	 _GModText_SetText( "Press F2 to enter your name into the queue.\nFight begins when current one is done." )
	_GModText_Send( userid, 51 )
	_GModText_Start("Default")
	 _GModText_SetPos(-1, 0.35)
	 _GModText_SetColor(90, 90, 255, 240)
	 _GModText_SetTime(10, 0.2, 1.25)
	 _GModText_SetText( "All data is used from NoXious CTF.\n Press F4 to see how much money the betting bookie has.\nSay I bet # on <team color> to bet.")
	_GModText_Send( userid, 52 )
end

function TeamString(intt)
	if intt == TEAM_RED then return "Red"
	elseif intt == TEAM_BLUE then return "Blue"
	elseif intt == TEAM_GREEN then return "Green"
	elseif intt == TEAM_YELLOW then return "Yellow"
	else return "Spectator" end
end

function eventPlayerActive(name, userid, steamid)
	_GModRect_Start("gmod/white")
	 _GModRect_SetPos(0.43, 0, 0.15, 0.09)
	 _GModRect_SetColor(0, 0, 0, 175)
	 _GModRect_SetTime(99999, 0, 0)
	_GModRect_Send(userid, 2149)
	_GModText_Start("Default")
	 _GModText_SetColor(255, 255, 255, 255)
	 _GModText_SetTime(99999, 0, 0)
	 _GModText_SetPos(-1, 0.02)
	 _GModText_SetText("Lives")
	_GModText_Send(userid, 9307)
	DrawTeamLives(userid)
	AddTimer(4.0, 1, onShowHelp, userid)
	_EntSetKeyValue(userid, "rendermode", "1")
	players[userid].money = 50
	players[userid].Class = 1
	players[userid].Certifications = "gunslinger"
end

function explode(str, seperator, limit)
	local t={}
	local lim=limit or -1
	local reps=0
	local ll=0

	while true do
		local l=string.find(str,seperator,ll+1,true)
		if l~=nil then
			table.insert(t,string.sub(str,ll,l-1))
			ll=l+1
			reps=reps+1
		else
			table.insert(t,string.sub(str,ll))
			reps=reps+1
			break
		end
        if (reps>=lim and lim~=-1) or reps > 4000 then
			table.insert(t,string.sub(str,ll))
			break
		end
	end
	return t
end

function DamagelessExplosion(targ, tim)
	local ent = _EntCreate("env_explosion")
	if ent > 0 then
		_EntSetPos(ent, _EntGetPos(targ))
		_EntSetKeyValue(ent, "spawnflags", "65")
		_EntSpawn(ent)
		_EntFire(ent, "explode", "", tim)
		_EntFire(ent, "kill", "", tim+0.05)
	end
end

function DoExplode(Owner)
	if not _PlayerInfo(Owner, "alive") then return end
	_EntEmitSoundEx(Owner, "ambient/explosions/explode_"..math.random(1,9)..".wav", 1.5, 0.9)
	_EntEmitSoundEx(Owner, "ambient/explosions/explode_"..math.random(1,9)..".wav", 1.0, 1.1)
	_util.ScreenShake(_EntGetPos(Owner), 50, 475, 3, 550)
	_PlayerGod(Owner, true)
	local ents = _EntitiesFindInSphere(_EntGetPos(Owner), 330)
	local damage = 0
	for i=1, table.getn(ents) do
		if _phys.HasPhysics(ents[i]) then
			if IsPlayer(ents[i]) then
				if _PlayerInfo(ents[i], "connected") then
					if _PlayerInfo(ents[i], "team") ~= _PlayerInfo(Owner, "team") then
						_EntSetVelocity(ents[i], vecAdd(vector3(math.random(-1000, 1000), math.random(-1000, 1000), math.random(500, 1500)), _EntGetVelocity(ents[i])))
					end
					damage = 355-(math.abs(vecLength(vecSub(_EntGetPos(Owner),_EntGetPos(ents[i])))))
					if damage >= _PlayerInfo(ents[i], "health") then damage = 2000 end
					_RunString("_TraceAttack("..ents[i]..", "..Owner..", "..Owner..", "..damage..")")
				end
			else
				damage = 355-(math.abs(vecLength(vecSub(_EntGetPos(Owner),_EntGetPos(ents[i])))))
				_RunString("_TraceAttack("..ents[i]..", "..Owner..", "..Owner..", "..damage..")")
			end
		end
	end
	local x = -90
	local y = -90
	local ent = 0
	for i=1, 3 do
		if x ~= 0 then
			ent = 0
			ent = _EntCreate("env_explosion")
			if ent > 0 then
				_EntSetPos(ent, vecAdd(vector3(x, 0, 0), _EntGetPos(Owner)))
				_EntSetKeyValue(ent, "spawnflags", "65")
				_EntSpawn(ent)
				_EntFire(ent, "explode", "", 0)
				_EntFire(ent, "kill", "", 0.15)
			end
		end
		x = x + 90
	end
	for ii=1, 3 do
		if y ~= 0 then
			ent = 0
			ent = _EntCreate("env_explosion")
			if ent > 0 then
				_EntSetPos(ent, vecAdd(vector3(0, y, 0), _EntGetPos(Owner)))
				_EntSetKeyValue(ent, "spawnflags", "65")
				_EntSpawn(ent)
				_EntFire(ent, "explode", "", 0)
				_EntFire(ent, "kill", "", 0.15)
			end
		end
		y = y + 90
	end
	_PlayerGod(Owner, false)
	_TraceAttack(Owner, Owner, Owner, 3000)
	Gib(Owner)
end
