function Distance(a, b)
	return math.abs(vecLength(vecSub(a, b)))
end

function NoDamageLuaExplosion(pos)
local glow = _EntCreate("env_lightglow")
	if glow > 0 then
		_EntSetKeyValue(glow, "rendercolor" , "255 255 200")
		_EntSetKeyValue(glow, "VerticalGlowSize", "130")
		_EntSetKeyValue(glow, "HorizontalGlowSize", "130")
		_EntSetKeyValue(glow, "MinDist", 15)
		_EntSetKeyValue(glow, "MaxDist", 4096)
		_EntSetKeyValue(glow, "OuterMaxDist", 190)
		_EntSetKeyValue(glow, "GlowProxySize", "5")
		_EntSetPos(glow, vecAdd(pos, vector3(0,0,20)))
		_EntSpawn(glow)
		_EntFire(glow, "kill", "", 1.5)
		for y=1, 15 do
			_EntFire(glow, "color", 240-(y*15).." "..(240-(y*15)).." "..(150-(y*10)), y*0.09)
		end
	end
	local expl = _EntCreate("env_explosion")
	if expl > 0 then
		_EntSetPos(expl, pos)
		_EntSetKeyValue(expl, "spawnflags", "65")
		_EntSpawn(expl)
		_EntFire(expl, "explode", "", 0)
		_EntFire(expl, "kill", "", 0.05)
		_EntEmitSoundEx(expl, "ambient/explosions/explode_"..math.random(1,9)..".wav", 1.5, 1)
	end
	for i=1, math.random(3, 5) do
		local ent = _EntCreate("prop_physics_multiplayer")
		if ent > 0 then
			_EntSetPos(ent, pos)
			_EntSetModel(ent, "models/weapons/w_bugbait.mdl")
			_EntSetKeyValue(ent, "spawnflags", "516")
			_EntSpawn(ent)
			_EntFire(ent, "alpha", "0", 0)
			_phys.ApplyForceCenter(ent, vector3(math.random(-1500, 1500), math.random(-1500, 1500), math.random(1000, 4000)))
			local trail = _EntCreate("env_fire_trail")
			if trail > 0 then
				_EntSetPos(trail, _EntGetPos(ent))
				_EntSpawn(trail)
				_EntSetParent(trail, ent)
			end
			_EntFire(ent, "kill", "", 5)
		end
	end
	_util.ScreenShake(pos, 120, 120, 1.25, 250)
end

function LuaExplosionEntity(ent, damage, radius, owner)
	LuaExplosion(_EntGetPos(ent), damage, radius, owner)
end

_EntPrecacheModel("models/weapons/w_bugbait.mdl")
function LuaExplosion(pos, damage, radius, owner)
	if damage < 0 then damage = 0 end
	if radius < 1 then radius = 1 end
	local ents = _EntitiesFindInSphere(pos, radius)
	for i in ents do
		_TraceAttack(ents[i], owner, owner, damage-Distance(pos, _EntGetPos(ents[i])))
	end
	local glow = _EntCreate("env_lightglow")
	if glow > 0 then
		_EntSetKeyValue(glow, "rendercolor" , "255 255 200")
		_EntSetKeyValue(glow, "VerticalGlowSize", "130")
		_EntSetKeyValue(glow, "HorizontalGlowSize", "130")
		_EntSetKeyValue(glow, "MinDist", radius*0.1)
		_EntSetKeyValue(glow, "MaxDist", radius*6)
		_EntSetKeyValue(glow, "OuterMaxDist", radius)
		_EntSetKeyValue(glow, "GlowProxySize", "5")
		_EntSetPos(glow, vecAdd(pos, vector3(0,0,20)))
		_EntSpawn(glow)
		_EntFire(glow, "kill", "", 1.5)
		for y=1, 15 do
			_EntFire(glow, "color", 240-(y*15).." "..(240-(y*15)).." "..(150-(y*10)), y*0.09)
		end
	end
	local expl = _EntCreate("env_explosion")
	if expl > 0 then
		_EntSetPos(expl, pos)
		_EntSetKeyValue(expl, "spawnflags", "65")
		_EntSpawn(expl)
		_EntFire(expl, "explode", "", 0)
		_EntFire(expl, "kill", "", 0.05)
		_EntEmitSoundEx(expl, "ambient/explosions/explode_"..math.random(1,9)..".wav", 1.5, 1)
	end
	if damage > 30 then
		for i=1, math.random(3, 5) do
			local ent = _EntCreate("prop_physics")
			if ent > 0 then
				_EntSetPos(ent, pos)
				_EntSetModel(ent, "models/weapons/w_bugbait.mdl")
				_EntSetKeyValue(ent, "spawnflags", "516")
				_EntSpawn(ent)
				_phys.ApplyForceCenter(ent, vector3(math.random(-1500, 1500), math.random(-1500, 1500), math.random(1000, 4000)))
				local trail = _EntCreate("env_fire_trail")
				if trail > 0 then
					_EntSetPos(trail, _EntGetPos(ent))
					_EntSpawn(trail)
					_EntSetParent(trail, ent)
					_EntFire(trail, "kill", "", 4.5)
				end
				_EntFire(ent, "kill", "", 5)
			end
		end
	end
	_util.ScreenShake(pos, damage*0.5, damage*2, 1.25, radius*1.25)
end
