VehicleTypes["Bomber"] = {              -- The global reference to this type.
Name = "Bomber",                        -- The display name on vehicle menu.
Model = "models/combine_dropship.mdl",    -- Model. If none, the vehicle will not create.
Description = "More advanced bomber then the Helicopter.", -- Shown on the vehicle menu.
Stock = 1,                                  -- How many each team can have at one time.
EntityType = "prop_physics",                -- _EntCreate( ) type. Default is "prop_physics", if not specified.
MaxHealth = 100,                            -- Max HP before destroyed.
DamageMultiply = 0.3,                       -- Damage taken is multiplyed by this amount.
PassengerSlots = 1,                         -- Amount of passengers able to ride in this vehicle.
DriverCamDistance = 256,                    -- Camera distance from vehicle for the driver.
--DriverCamOffset = vector3(0,0,40),          -- Camera offset.
PassengerCamDistance = 0,                   -- Camera distance from vehicle for passengers.
--PassengerCamOffset = vector3(0,0,-40),      -- Camera offset.
CreationOffset = vector3(0,0,150),          -- Offset from vehicle pads.
ExitOffset = vector3(0,50,35),              -- Offset from vehicle that people exit at.

HUD = function(vehicle)
	local SendTo = {}
	if Vehicles[vehicle].Driver > 0 then
		SendTo[table.getn(SendTo)+1] = Vehicles[vehicle].Driver
	end
	for i=1, table.getn(Vehicles[vehicle].Passenger) do
		if Vehicles[vehicle].Passenger[i] > 0 then
			SendTo[table.getn(SendTo)+1] = Vehicles[vehicle].Passenger[i]
		end
	end

	local ms = "P:* BOMB:_"
	if Vehicles[vehicle].Passenger[1] > 0 then
		ms = string.gsub(ms, "BOMB:_", "BOMB:*")
	end
	for i=1, table.getn(SendTo) do
		_GModRect_Start("gmod/white")
		 _GModRect_SetPos(0.42, 0.85, 0.18, 0.1)
		 _GModRect_SetColor( 0, 0, 0, 100 )
		 _GModRect_SetTime( 9999, 0, 0 )
		_GModRect_Send( SendTo[i], 10000 )
		_GModText_Start( "Default" )
		 _GModText_SetPos( -1, 0.88 )
		 _GModText_SetColor( 255, 0, 0, 255 )
		 _GModText_SetTime( 9999, 0.1, 0.1 )
		 _GModText_SetText( "HP: "..math.ceil(Vehicles[vehicle].Health).."/"..VehicleTypes[Vehicles[vehicle].Type].MaxHealth )
		_GModText_Send( SendTo[i], 10001 )
		_GModText_Start( "Default" )
		 _GModText_SetPos( -1, 0.92 )
		 _GModText_SetColor( 255, 255, 255, 255 )
		 _GModText_SetTime( 9999, 0, 0 )
		 _GModText_SetText( ms )
		_GModText_Send( SendTo[i], 10002 )
	end
end,

HideHUD = function(userid)
	_GModRect_Hide(userid, 10000, 0.2)
	_GModText_Hide(userid, 10001, 0.2)
	_GModText_Hide(userid, 10002, 0.2)
end,

onDestroyed = function(vehicle)
	BOMBERLASTBOMB[vehicle] = nil
	_EntEmitSoundEx(vehicle, "ambient/explosions/explode_6.wav", 1.1, 1.0)
	_EntEmitSoundEx(vehicle, "ambient/explosions/explode_5.wav", 1.1, 0.8)
	for i=1, 10 do
		local ent = _EntCreate("env_explosion")
		if ent > 0 then
			_EntSetKeyValue(ent, "spawnflags", "17")
			_EntSetPos(ent, _EntGetPos(vehicle))
			_EntSpawn(ent)
			_EntSetParent(ent, vehicle)
			_EntFire(ent, "explode", "", i*0.25)
			_EntFire(ent, "kill", "", (i*0.25)+0.1)
		end
	end
	_phys.EnableGravity(vehicle, true)
	local ent2 = _EntCreate("env_ar2explosion")
	if ent2 > 0 then
		_EntSetPos(ent2, _EntGetPos(vehicle))
		_EntSpawn(ent2)
		_EntSetParent(ent2, vehicle)
		_EntFire(ent2, "explode", "", 2.45)
		_EntFire(ent2, "kill", "", 2.55)
	end
	AddTimer(2.45, 1, _EntEmitSoundEx, vehicle, "npc/combine_gunship/gunship_explode2.wav", 1.5, 1.0)
	_EntFire(vehicle, "break", "", 2.5)
	_EntFire(vehicle, "kill", "", 2.6)
	_phys.ApplyTorqueCenter(vehicle, vector3(-15000, -15000, -600000))
end,

onDamaged = function(vehicle, attacker, damage)
	if Vehicles[vehicle].Health < VehicleTypes[Vehicles[vehicle].Type].MaxHealth*0.5 and damage > 20 then
		local finalpos = vecAdd(_EntGetPos(vehicle), vector3(math.random(-50, 50), math.random(-50, 50), math.random(15, 50)))
		local ent = _EntCreate("env_fire_trail")
		if ent > 0 then
			_EntSetPos(ent, finalpos)
			_EntSpawn(ent)
			_EntSetParent(ent, vehicle)
			_EntFire(ent, "kill", "", math.random(3, 5))
		end
		local ent2 = _EntCreate("env_explosion")
		if ent2 > 0 then
			_EntSetKeyValue(ent2, "spawnflags", "17")
			_EntSetPos(ent2, finalpos)
			_EntSpawn(ent2)
			_EntFire(ent2, "explode", "", 0)
			_EntFire(ent2, "kill", "", 0.1)
		end
	end
end,

onCreated = function(vehicle)
	BOMBERLASTBOMB[vehicle] = _CurTime()
	_phys.EnableGravity(vehicle, false)
	AddTimer(3, 1, _phys.EnableGravity, vehicle, true)
end,

onDriverEnter = function(vehicle)
	_phys.EnableGravity(vehicle, false)
end,

onDriverExit = function(vehicle)
	_phys.EnableGravity(vehicle, true)
end,

onThink = function(vehicle)
	if Vehicles[vehicle].Driver > 0 then
		_EntitySetPhysicsAttacker(vehicle, Vehicles[vehicle].Driver)
		local Ang = _EntGetAngAngle(vehicle)
		local vVec = vector3(0,0,0)
		if Ang.z > 0 and Ang.z < 180 then
			vVec = vecMul(_EntGetForwardVector(vehicle),vector3(-225,-225,-225))
			_phys.ApplyTorqueCenter(vehicle, vVec)
		elseif Ang.z > 180 and Ang.z < 360 then
			vVec = vecMul(_EntGetForwardVector(vehicle),vector3(225,225,225))
			_phys.ApplyTorqueCenter(vehicle, vVec)
		end
		if Ang.x > -80 and Ang.x < 0 then
			vVec = vecMul(_EntGetRightVector(vehicle),vector3(-225,-225,-225))
			_phys.ApplyTorqueCenter(vehicle, vVec)
		elseif Ang.x > 0 and Ang.x < 80 then
			vVec = vecMul(_EntGetRightVector(vehicle),vector3(225,225,225))
			_phys.ApplyTorqueCenter(vehicle, vVec)
		end
	elseif Vehicles[vehicle].Owner > 0 then
		_EntitySetPhysicsAttacker(vehicle, Vehicles[vehicle].Owner)
	end
end,

onForward = function(vehicle)
	_phys.ApplyForceCenter(vehicle, vecMul(_EntGetAng(vehicle), vector3(1000,1000,0)))
end,

onBackward = function(vehicle)
	_phys.ApplyForceCenter(vehicle, vecMul(_EntGetAng(vehicle), vector3(-1000,-1000,0)))
end,

onLeft = function(vehicle)
	_phys.ApplyTorqueCenter(vehicle, vector3(0, 0, 1000))
end,

onRight = function(vehicle)
	_phys.ApplyTorqueCenter(vehicle, vector3(0, 0, -1000))
end,

onJump = function(vehicle)
	_phys.ApplyForceCenter(vehicle, vecMul(_EntGetUpVector(vehicle), vector3(0,0,500)))
end,

onDuck = function(vehicle)
	_phys.ApplyForceCenter(vehicle, vecMul(_EntGetUpVector(vehicle), vector3(0,0,-500)))
end,

onPassengerAttack = function(vehicle, passenger)
	passenger = Vehicles[vehicle].Passenger[passenger]
	if _CurTime() > BOMBERLASTBOMB[vehicle]+5.0 then
		_EntEmitSoundEx(vehicle, "npc/attack_helicopter/aheli_mine_drop1.wav", 1.25, 1.0)
		BOMBERLASTBOMB[vehicle] = _CurTime()
		AddTimer(0.5, 3, DoBomb, vehicle, passenger)
	end
end
}

function DoBomb(vehicle, passenger)
	if Vehicles[vehicle] == nil then return end
	local ent = _EntCreate("prop_physics")
	if ent > 0 then
		_EntSetModel(ent, "models/roller.mdl")
		_EntSetPos(ent, vecAdd(_EntGetPos(vehicle), vector3(0,0,-30)))
		_EntSetOwner(ent, vehicle)
		_EntSpawn(ent)
		_EntitySetPhysicsAttacker(ent, passenger)
		_EntEmitSoundEx(ent, "weapons/mortar/mortar_shell_incomming1.wav", 1.1, 0.8)
		_EntEmitSound(vehicle, "weapons/slam/throw.wav")
		_EntSetMaterial(ent, "models/props_lab/Tank_Glass001")
		FireBallTimers[ent] = AddTimer(0.05, 100, FireBallCheckExplode, ent, ent, passenger or Vehicles[vehicle].Driver or Vehicles[vehicle].Owner)
	end
end

_EntPrecacheModel("models/roller.mdl")
BOMBERLASTBOMB = {}
