VehicleTypes["Fighter"] = {
Name = "Light Fighter",
Model = "models/MortarSynth_Base.mdl",
Description = "One-man fighter.",
Stock = 2,
EntityType = "prop_physics",
MaxHealth = 50,
DamageMultiply = 1.0,
PassengerSlots = 0,
DriverCamDistance = 128,
PassengerCamDistance = 0,
CreationOffset = vector3(0,0,30),
ExitOffset = vector3(0,0,50),

HUD = function(vehicle)
	local SendTo = -1
	if Vehicles[vehicle].Driver > 0 then
		SendTo = Vehicles[vehicle].Driver
	end
	if SendTo <= 0 then return end
	local ms = "MG"
	if FIGHTERMODE[vehicle] then ms = "Missile" end
	_GModRect_Start("gmod/white")
	 _GModRect_SetPos(0.42, 0.85, 0.18, 0.1)
	 _GModRect_SetColor( 0, 0, 0, 100 )
	 _GModRect_SetTime( 9999, 0, 0 )
	_GModRect_Send( SendTo, 10000 )
	_GModText_Start( "Default" )
	 _GModText_SetPos( -1, 0.88 )
	 _GModText_SetColor( 255, 0, 0, 255 )
	 _GModText_SetTime( 9999, 0.2, 0.2 )
	 _GModText_SetText( "HP: "..math.ceil(Vehicles[vehicle].Health).."/"..VehicleTypes[Vehicles[vehicle].Type].MaxHealth )
	_GModText_Send( SendTo, 10001 )
	_GModText_Start( "Default" )
	 _GModText_SetPos( -1, 0.92 )
	 _GModText_SetColor( 255, 255, 255, 255 )
	 _GModText_SetTime( 9999, 0, 0 )
	 _GModText_SetText( ms )
	_GModText_Send( SendTo, 10002 )
end,

onDestroyed = function(vehicle)
	_EntEmitSoundEx(vehicle, "ambient/explosions/explode_5.wav", 1.1, 0.8)
	local ent = _EntCreate("env_explosion")
	if ent > 0 then
		_EntSetKeyValue(ent, "spawnflags", "17")
		_EntSetPos(ent, _EntGetPos(vehicle))
		_EntSpawn(ent)
		_EntSetParent(ent, vehicle)
		_EntFire(ent, "explode", "", 0.25)
		_EntFire(ent, "kill", "", 0.26)
	end
	local ent3 = _EntCreate("env_smoketrail")
	if ent3 > 0 then
		_EntSetPos(ent3, _EntGetPos(vehicle))
		_EntSpawn(ent3)
		_EntSetParent(ent3, vehicle)
		_EntFire(ent3, "kill", "", 5.0)
	end
	FIGHTERCRASHCHECKS[vehicle] = AddTimer(0.1, 0, FighterCheckCrashed, vehicle)
	FIGHTERLASTATTACK[vehicle] = nil
	if _EntGetType(FIGHTERTRAILS[vehicle]) == "env_smoketrail" then
		_EntFire(FIGHTERTRAILS[vehicle], "kill", "", 0)
	end
	FIGHTERTRAILS[vehicle] = nil
	FIGHTERMODE[vehicle] = nil
	FIGHTERLASTSWITCH[vehicle] = nil
	_phys.EnableGravity(vehicle, true)
end,

HideHUD = function(userid)
	_GModRect_Hide(userid, 10000, 0.2)
	_GModText_Hide(userid, 10001, 0.2)
	_GModText_Hide(userid, 10002, 0.2)
end,

onDamaged = function(vehicle, attacker, damage)
	if Vehicles[vehicle].Health < VehicleTypes[Vehicles[vehicle].Type].MaxHealth*0.5 and damage > 10 then
		local finalpos = vecAdd(_EntGetPos(vehicle), vector3(math.random(-10, 10), math.random(-10, 10), math.random(-10, 10)))
		local ent = _EntCreate("env_fire_trail")
		if ent > 0 then
			_EntSetPos(ent, finalpos)
			_EntSpawn(ent)
			_EntSetParent(ent, vehicle)
			_EntFire(ent, "kill", "", math.random(3, 5))
		end
		local ent2 = _EntCreate("env_explosion")
		if ent2 > 0 then
			_EntSetKeyValue(ent2, "spawnflags", "17")
			_EntSetPos(ent2, finalpos)
			_EntSpawn(ent2)
			_EntFire(ent2, "explode", "", 0)
			_EntFire(ent2, "kill", "", 0.1)
		end
	end
end,

onDriverEnter = function(vehicle)
	_phys.EnableGravity(vehicle, false)
end,

onDriverExit = function(vehicle)
	_phys.EnableGravity(vehicle, true)
end,

onCreated = function(vehicle)
	FIGHTERLASTATTACK[vehicle] = _CurTime()
	FIGHTERLASTSWITCH[vehicle] = _CurTime()
	FIGHTERMODE[vehicle] = true
	local trail = _EntCreate("env_smoketrail")
	_phys.SetMass(vehicle, 100)
	if trail > 0 then
		_EntSetPos(trail, _EntGetPos(vehicle))
		_EntSetKeyValue(trail, "spawnrate", "25")
		_EntSetKeyValue(trail, "lifetime", "1.0")
		_EntSetKeyValue(trail, "startcolor", "170 0 0")
		_EntSetKeyValue(trail, "endcolor", "170 0 0")
		_EntSetKeyValue(trail, "minspeed", "0")
		_EntSetKeyValue(trail, "maxspeed", "0")
		_EntSetKeyValue(trail, "startsize", "6")
		_EntSetKeyValue(trail, "endsize", "4")
		_EntSetKeyValue(trail, "spawnradius", "1")
		_EntSetKeyValue(trail, "firesprite", "sprites/redglow3.spr")
		_EntSetKeyValue(trail, "smokesprite", "sprites/redglow3.spr")
		_EntSpawn(trail)
		_EntSetParent(trail, vehicle)
		FIGHTERTRAILS[vehicle] = trail
	end
end,

onThink = function(vehicle)
	if Vehicles[vehicle].Driver > 0 then
		_EntitySetPhysicsAttacker(vehicle, Vehicles[vehicle].Driver)
		local Ang = _PlayerGetShootAng(Vehicles[vehicle].Driver)
		_phys.ApplyTorqueCenter(vehicle, vecMul(vector3(140, 0, 140), vecSub(Ang, _EntGetAng(vehicle))))
		--[[
		local Ang = _PlayerGetShootAng(Vehicles[vehicle].Driver)
		_phys.ApplyTorqueCenter(vehicle, vecMul(vector3(0, 0, 140), vecSub(Ang, _EntGetForwardVector(vehicle))))
		_phys.ApplyTorqueCenter(vehicle, vecMul(vector3(140, 0, 0), vecSub(Ang, _EntGetRightVector(vehicle))))
		]]
	elseif Vehicles[vehicle].Owner > 0 then
		_EntitySetPhysicsAttacker(vehicle, Vehicles[vehicle].Owner)
	end
end,

onForward = function(vehicle)
	_phys.ApplyForceCenter(vehicle, vecMul(_PlayerGetShootAng(Vehicles[vehicle].Driver), vector3(1700, 1700, 1900)))
end,

onLeft = function(vehicle)
	_phys.ApplyTorqueCenter(vehicle, vector3(100, 0, 0))
end,

onRight = function(vehicle)
	_phys.ApplyTorqueCenter(vehicle, vector3(-100, 0, 0))
end,

onJump = function(vehicle)
	if _CurTime() > FIGHTERLASTSWITCH[vehicle]+2.0 then
		FIGHTERMODE[vehicle] = not FIGHTERMODE[vehicle]
		VehicleTypes["Fighter"].HUD(vehicle)
		_PlaySoundPlayer(Vehicles[vehicle].Driver, "weapons/smg1/switch_burst.wav")
		FIGHTERLASTSWITCH[vehicle] = _CurTime()
	end
end,

onAttack = function(vehicle)
	if FIGHTERMODE[vehicle] then
		if _CurTime() > FIGHTERLASTATTACK[vehicle]+4.0 then
			if FighterMissile(vehicle) then
				FIGHTERLASTATTACK[vehicle] = _CurTime()
			end
		end
	else
		if _CurTime() > FIGHTERLASTATTACK[vehicle]+0.1 then
			FighterMachineguns(vehicle)
			FIGHTERLASTATTACK[vehicle] = _CurTime()
		end
	end
end
}

FIGHTERLASTATTACK = {}
FIGHTERTRAILS = {}
FIGHTERLASTSWITCH = {}
FIGHTERMODE = {}
--[[
function FighterMissile(vehicle)
	local userid = Vehicles[vehicle].Driver
	local missile = _EntCreate("physics_prop")
	local missiletrail = _EntCreate("env_smoketrail")
	if missile > 0 then
		_EntSetPos(missile, _EntSetPos(missile, vecAdd(_EntGetPos(vehicle),vecMul(_PlayerGetShootAng(userid),vector3(20,20,20)))))
		_EntSetModel(missile, "models/weapons/w_missile_closed.mdl")
		_phys.SetMass(missile, 10)
		_EntSetPos(missiletrail, _EntGetPos(missile))
		_EntSetOwner(missile, vehicle)
		_EntSpawn(missile)
		_phys.EnableGravity(missile, false)
		_EntitySetPhysicsAttacker(missile, userid)
		_EntSpawn(missiletrail)
		_TraceLine(_EntGetPos(vehicle), _PlayerGetShootAng(userid), 4064, vehicle)
		_EntSetAng(missile, vecNormalize(vecSub(_EntGetPos(missile), _TraceEndPos())))
		_phys.ApplyForceCenter(missile, vecMul(_PlayerGetShootAng(userid), vector3(2000, 2000, 2000)))
		_EntSetParent(missiletrail, missile)
		_EntFire(missile, "kill", "", 10)
		FireBallTimers[missile] = AddTimer(0.05, 100, FireBallCheckExplode, missile, missiletrail, userid)
	end
	_EntEmitSound(vehicle, "weapons/stinger_fire1.wav")
end
]]

FIGHTERBULLETDAMAGE = 4

function FighterMachineguns(vehicle)
	if Vehicles[vehicle] == nil or _EntGetType(vehicle) == "n/a" then return end
	_TraceLine(_EntGetPos(vehicle), _PlayerGetShootAng(Vehicles[vehicle].Driver), 150, vehicle)
	_EffectInit()
	 _EffectSetEnt(Vehicles[vehicle].Driver or 255)
	 _EffectSetOrigin(_EntGetPos(vehicle))
	 _EffectSetStart(_TraceEndPos())
	 _EffectSetScale(40)
	 _EffectSetMagnitude(0.25)
	_EffectDispatch("FadingLineTeamSolid")
	_TraceLine(_EntGetPos(vehicle), _PlayerGetShootAng(Vehicles[vehicle].Driver), 2000, vehicle)
	if _TraceHitNonWorld() then
		if IsPlayer(_TraceGetEnt()) then
			_EntEmitSound(_TraceGetEnt(), "physics/flesh/flesh_impact_bullet"..math.random(1,5)..".wav")
			_MakeDecal(math.random(20,24))
		else
			local ent = _EntCreate("info_target")
			if ent > 0 then
				_EntSetPos(ent, _TraceEndPos())
				_EntSpawn(ent)
				_EntEmitSound(ent, "physics/concrete/concrete_impact_bullet"..math.random(1,4)..".wav")
				_EntFire(ent, "kill", "", 0.1)
			end
			_MakeDecal(math.random(0,4))
		end
		_TraceAttack(_TraceGetEnt(), Vehicles[vehicle].Driver or Vehicles[vehicle].Owner, Vehicles[vehicle].Driver or Vehicles[vehicle].Owner, FIGHTERBULLETDAMAGE)
	elseif _TraceHit() then
		local ent = _EntCreate("info_target")
		if ent > 0 then
			_EntSetPos(ent, _TraceEndPos())
			_EntSpawn(ent)
			_EntEmitSound(ent, "physics/concrete/concrete_impact_bullet"..math.random(1,4)..".wav")
			_EntFire(ent, "kill", "", 0.1)
		end
		_MakeDecal(math.random(0,4))
	end
	_EntEmitSoundEx(vehicle, "weapons/ar2/fire1.wav", 1.0, math.frandom(0.85, 1.15))
end

--[[
function FighterMissile(vehicle)
	local userid = Vehicles[vehicle].Driver or 0
	if not _PlayerInfo(userid, "alive") or not _PlayerInfo(userid, "connected") then return false end
	_TraceLine(_EntGetPos(vehicle), _PlayerGetShootAng(userid), 1500, vehicle)
	local x = table.getn(Sprites)+1
	Sprites[x] = {}
	Sprites[x].Target = -1
	Sprites[x].Owner = userid
	Sprites[x].Sprites = 0
	local ents = _EntitiesFindInSphere(_TraceEndPos(), 364)
	for i=1, table.getn(ents) do
		if ents[i] <= _MaxPlayers() then
			if _PlayerInfo(ents[i], "team") ~= _PlayerInfo(userid, "team") then
				Sprites[x].Target = ents[i]
				break
			end
		elseif Vehicles[ents[i] ] ~= nil then
			if Vehicles[ents[i] ].Team ~= Vehicles[vehicle].Team then
				Sprites[x].Target = ents[i]
				break
			end
		end
	end
	if Sprites[x].Target <= 0 then
		Sprites[x] = nil
		return false
	end
	local fireball = _EntCreate("physics_prop")
	local firetrail = _EntCreate( "env_fire_trail" )
	_EntPrecacheModel( "models/props/cs_italy/orange.mdl" )
	if fireball > 0 then
		_EntSetPos(fireball, _EntSetPos(fireball, vecAdd(_EntGetPos(vehicle),vecMul(_PlayerGetShootAng(userid),vector3(20,20,20)))))
		_EntSetModel(fireball, "models/props/cs_italy/orange.mdl")
		_phys.SetMass(fireball, 10)
		_EntSetPos(firetrail, _EntGetPos(fireball))
		_EntSpawn(fireball)
		_EntSetOwner(fireball, vehicle)
		_EntitySetPhysicsAttacker(fireball, userid)
		_EntSpawn(firetrail)
		_EntSetName(fireball, "firesprite:"..x)
		_phys.ApplyForceCenter(fireball, vecMul(_PlayerGetShootAng(userid),vector3(2000,2000,2000)))
		_phys.EnableGravity(fireball, false)
		_EntSetParent(firetrail, fireball)
		_EntFire(fireball, "sethealth", "99999", 0)
		_EntFire(fireball, "kill", "", 7.5)
		_EntFire(firetrail, "kill", "", 7.9)
		Sprites[x].Sprites = fireball
	end
	Sprites[x].Timer = AddTimer(0.1, 0, SpriteTimer, x)
	_EntEmitSound(vehicle, "weapons/stinger_fire1.wav")
	return true
end
]]

function FighterMissile(vehicle)
	local userid = Vehicles[vehicle].Driver or 0
	if not _PlayerInfo(userid, "alive") or not _PlayerInfo(userid, "connected") then return false end
	_TraceLine(_EntGetPos(vehicle), _PlayerGetShootAng(userid), 600, vehicle)
	local x = table.getn(Sprites)+1
	Sprites[x] = {}
	Sprites[x].Target = -1
	Sprites[x].Owner = userid
	Sprites[x].Sprites = 0
	local ents = _EntitiesFindInSphere(_TraceEndPos(), 364)
	for i=1, table.getn(ents) do
		if ents[i] <= _MaxPlayers() then
			if _PlayerInfo(ents[i], "team") ~= _PlayerInfo(userid, "team") then
				Sprites[x].Target = ents[i]
				break
			end
		elseif Vehicles[ents[i]] ~= nil then
			if Vehicles[ents[i]].Team ~= Vehicles[vehicle].Team then
				Sprites[x].Target = ents[i]
				break
			end
		end
	end
	if Sprites[x].Target <= 0 then
		Sprites[x] = nil
		return false
	end
	local fireball = _EntCreate("physics_prop")
	local firetrail = _EntCreate( "env_fire_trail" )
	_EntPrecacheModel( "models/props/cs_italy/orange.mdl" )
	if fireball > 0 then
		_EntSetPos(fireball, _EntSetPos(fireball, vecAdd(_EntGetPos(vehicle),vecMul(_PlayerGetShootAng(userid),vector3(20,20,20)))))
		_EntSetModel(fireball, "models/props/cs_italy/orange.mdl")
		_phys.SetMass(fireball, 10)
		_EntSetPos(firetrail, _EntGetPos(fireball))
		_EntSpawn(fireball)
		_EntSetOwner(fireball, vehicle)
		_EntitySetPhysicsAttacker(fireball, userid)
		_EntSpawn(firetrail)
		_EntSetName(fireball, "firesprite:"..x)
		_phys.ApplyForceCenter(fireball, vecMul(_PlayerGetShootAng(userid),vector3(2000,2000,2000)))
		_phys.EnableGravity(fireball, false)
		_EntSetParent(firetrail, fireball)
		_EntFire(fireball, "sethealth", "99999", 0)
		_EntFire(fireball, "kill", "", 7.5)
		_EntFire(firetrail, "kill", "", 7.9)
		Sprites[x].Sprites = fireball
	end
	Sprites[x].Timer = AddTimer(0.1, 0, SpriteTimer, x)
	_EntEmitSound(vehicle, "weapons/stinger_fire1.wav")
	return true
end

FIGHTERCRASHCHECKS = {}
function FighterCheckCrashed(vehicle)
	if not _EntExists(vehicle) then HaltTimer(FIGHTERCRASHCHECKS[vehicle]) FIGHTERCRASHCHECKS[vehicle] = nil return end
	_TraceLine(_EntGetPos(vehicle), vector3(0,0,-1), 200, vehicle)
	if _TraceHit() then
		_EntEmitSoundEx(vehicle, "npc/combine_gunship/gunship_explode2.wav", 1.5, 1.0)
		AR2Explosion(_EntGetPos(vehicle))
		_EntFire(vehicle, "break", "", 0.2)
		_EntFire(vehicle, "kill", "", 0.3)
		HaltTimer(FIGHTERCRASHCHECKS[vehicle])
		FIGHTERCRASHCHECKS[vehicle] = nil
	end
end
