VehicleTypes["Rover"] = {                 -- The global reference to this type.
Name = "Assault Rover",                           -- The display name on vehicle menu.
Model = "models/props_vehicles/car002a.mdl",  -- Model. If none, the vehicle will not create.
Description = "Land vehicle with 2 gunner positions.",   -- Shown on the vehicle menu.
Stock = 2,                                -- How many each team can have at one time.
EntityType = "prop_physics",              -- _EntCreate( ) type. Default is "prop_physics", if not specified.
MaxHealth = 150,                          -- Max HP before destroyed.
DamageMultiply = 0.4,                     -- Damage taken is multiplyed by this amount.
PassengerSlots = 2,                       -- Amount of passengers able to ride in this vehicle.
DriverCamDistance = 256,                  -- Camera distance from vehicle for the driver.
PassengerCamDistance = 0,               -- Camera distance from vehicle for passengers.
CreationOffset = vector3(0,0,60),         -- Offset from vehicle pads.
ExitOffset = vector3(0,0,40),             -- Offset from vehicle that people exit at.

HUD = function(vehicle)
	local SendTo = {}
	if Vehicles[vehicle].Driver > 0 then
		SendTo[table.getn(SendTo)+1] = Vehicles[vehicle].Driver
	end
	for i=1, table.getn(Vehicles[vehicle].Passenger) do
		if Vehicles[vehicle].Passenger[i] > 0 then
			SendTo[table.getn(SendTo)+1] = Vehicles[vehicle].Passenger[i]
		end
	end

	local ms = "D:* GNR1:_ GNR2:_"
	if Vehicles[vehicle].Passenger[1] > 0 then
		ms = string.gsub(ms, "GNR1:_", "GNR1:*")
	end
	if Vehicles[vehicle].Passenger[2] > 0 then
		ms = string.gsub(ms, "GNR2:_", "GNR2:*")
	end
	for i=1, table.getn(SendTo) do
		_GModRect_Start("gmod/white")
		 _GModRect_SetPos(0.42, 0.85, 0.18, 0.1)
		 _GModRect_SetColor( 0, 0, 0, 100 )
		 _GModRect_SetTime( 9999, 0, 0 )
		_GModRect_Send( SendTo[i], 10000 )
		_GModText_Start( "Default" )
		 _GModText_SetPos( -1, 0.88 )
		 _GModText_SetColor( 255, 0, 0, 255 )
		 _GModText_SetTime( 9999, 0.2, 0.2 )
		 _GModText_SetText( "HP: "..math.ceil(Vehicles[vehicle].Health).."/"..VehicleTypes[Vehicles[vehicle].Type].MaxHealth )
		_GModText_Send( SendTo[i], 10001 )
		_GModText_Start( "Default" )
		 _GModText_SetPos( -1, 0.92 )
		 _GModText_SetColor( 255, 255, 255, 255 )
		 _GModText_SetTime( 9999, 0.2, 0.2 )
		 _GModText_SetText( ms )
		_GModText_Send( SendTo[i], 10002 )
	end
end,

onRemoved = function(vehicle)
	ROVERLASTATTACK[vehicle] = nil
	ROVERLASTATTACK2[vehicle] = nil
	ROVERLASTJUMP[vehicle] = nil
end,

onDestroyed = function(vehicle)
	ROVERLASTATTACK[vehicle] = nil
	ROVERLASTATTACK2[vehicle] = nil
	ROVERLASTJUMP[vehicle] = nil
	_EntEmitSoundEx(vehicle, "ambient/explosions/explode_6.wav", 1.1, 1.0)
	_EntEmitSoundEx(vehicle, "ambient/explosions/explode_5.wav", 1.1, 0.8)
	_phys.ApplyForceCenter(vehicle, vector3(math.random(-500000,500000), math.random(-500000,500000), 5000000))
	_phys.ApplyTorqueCenter(vehicle, vector3(0, 0, 750000))
	for i=1, 10 do
		local ent = _EntCreate("env_explosion")
		if ent > 0 then
			_EntSetKeyValue(ent, "spawnflags", "17")
			_EntSetPos(ent, _EntGetPos(vehicle))
			_EntSpawn(ent)
			_EntSetParent(ent, vehicle)
			_EntFire(ent, "explode", "", i*0.25)
			_EntFire(ent, "kill", "", (i*0.25)+0.1)
		end
	end
	local ent2 = _EntCreate("env_ar2explosion")
	if ent2 > 0 then
		_EntSetPos(ent2, _EntGetPos(vehicle))
		_EntSpawn(ent2)
		_EntSetParent(ent2, vehicle)
		_EntFire(ent2, "explode", "", 2.45)
		_EntFire(ent2, "kill", "", 2.55)
		local pos = _EntGetPos(vehicle)
		AddTimer(2.4, 1, LuaExplosionEntity, vehicle, 200, 400, 255)
	end
	AddTimer(2.45, 1, _EntEmitSoundEx, vehicle, "npc/combine_gunship/gunship_explode2.wav", 1.5, 1.0)
	_EntFire(vehicle, "break", "", 2.5)
	_EntFire(vehicle, "kill", "", 2.6)
end,

HideHUD = function(userid)
	_GModRect_Hide(userid, 10000, 0.2)
	_GModText_Hide(userid, 10001, 0.2)
	_GModText_Hide(userid, 10002, 0.2)
end,

onPassengerEnter = function(vehicle, userid)
	local ent = _EntCreate("prop_dynamic_override")
	if ent > 0 then
		_EntSetPos(ent, vecAdd(_EntGetPos(vehicle), vector3(0,0,30)))
		_EntSetModel(ent, "models/weapons/w_missile_closed.mdl")
		_EntSetKeyValue(ent, "rendermode", "5")
		_EntSpawn(ent)
		_EntSetParent(ent, vehicle)
		_EntFire(ent, "alpha", "0", 0)
		_PlayerSpectatorTarget(userid, ent)
	end
end,

onDamaged = function(vehicle, attacker, damage)
	if Vehicles[vehicle].Health < VehicleTypes[Vehicles[vehicle].Type].MaxHealth*0.5 and damage > 10 then
		local finalpos = vecAdd(_EntGetPos(vehicle), vector3(math.random(-20, 20), math.random(-20, 20), math.random(15, 20)))
		local ent = _EntCreate("env_fire_trail")
		if ent > 0 then
			_EntSetPos(ent, finalpos)
			_EntSpawn(ent)
			_EntSetParent(ent, vehicle)
			_EntFire(ent, "kill", "", math.random(3, 5))
		end
		local ent2 = _EntCreate("env_explosion")
		if ent2 > 0 then
			_EntSetKeyValue(ent2, "spawnflags", "17")
			_EntSetPos(ent2, finalpos)
			_EntSpawn(ent2)
			_EntFire(ent2, "explode", "", 0)
			_EntFire(ent2, "kill", "", 0.1)
		end
	end
end,

onPassengerAttack = function(vehicle, passenger)
	if _CurTime() > ROVERLASTATTACK[vehicle]+3.0 and passenger == 1 then
		ROVERLASTATTACK[vehicle] = _CurTime()
	elseif _CurTime() > ROVERLASTATTACK2[vehicle]+3.0 and passenger == 2 then
		ROVERLASTATTACK2[vehicle] = _CurTime()
	else
		return
	end

	local userid = Vehicles[vehicle].Passenger[passenger]
	local fireball = _EntCreate("physics_prop")
	local firetrail = _EntCreate("env_fire_trail")
	if fireball > 0 then
		_EntSetPos(fireball, vecAdd(_EntGetPos(vehicle), vecMul( _PlayerGetShootAng(userid), vector3(35,35,35))))
		_EntSetModel(fireball, "models/Roller.mdl")
		_phys.SetMass(fireball, 10)
		_EntSetPos(firetrail, _EntGetPos(fireball))
		oldEntSetOwner(fireball, vehicle)
		EntOwners[fireball] = userid
		_EntSetKeyValue(fireball, "physdamagescale", "500")
		_EntSpawn(fireball)
		_EntitySetPhysicsAttacker(fireball, userid)
		_EntSpawn(firetrail)
		_EntSetMaterial(fireball, "models/props_lab/Tank_Glass001")
		_phys.ApplyForceCenter(fireball, vecAdd(vecMul(_PlayerGetShootAng(userid), 90000), vector3(0,0,8500)))
		_EntSetParent(firetrail, fireball)
		_EntFire(fireball, "sethealth", "9999", 0)
		_EntFire(fireball, "kill", "", 10)
		OutputEntity(fireball, "onhealthchanged", "MeteorExplode", 0)
		OutputEntity(fireball, "onphysgunpickup", "MeteorExplode", 0.25)
	end
	_EntEmitSound(vehicle, "weapons/grenade_launcher1.wav")
end,

onCreated = function(vehicle)
	ROVERLASTATTACK[vehicle] = _CurTime()
	ROVERLASTATTACK2[vehicle] = _CurTime()
	ROVERLASTJUMP[vehicle] = _CurTime()
end,

onThink = function(vehicle)
	local owner = Vehicles[vehicle].Owner
	local driver = Vehicles[vehicle].Driver
	if driver > 0 then
		if _EntGetWaterLevel(driver) ~= nil then
			if _EntGetWaterLevel(driver) > 0 then
				if Vehicles[vehicle].Health > 0 then
					VehicleDestroyed(owner, vehicle)
				end
			end
		end
		_EntitySetPhysicsAttacker(vehicle, driver)
	elseif owner > 0 then
		_EntitySetPhysicsAttacker(vehicle, owner)
	end
end,

onForward = function(vehicle)
	_phys.ApplyForceCenter(vehicle, vecMul(_EntGetAng(vehicle), vector3(20000*TICKRATE,20000*TICKRATE,0)))
end,

onBackward = function(vehicle)
	_phys.ApplyForceCenter(vehicle, vecMul(_EntGetAng(vehicle), vector3(-20000*TICKRATE,-20000*TICKRATE,0)))
end,

onLeft = function(vehicle)
	if _PlayerIsKeyDown(Vehicles[vehicle].Driver, IN_FORWARD) or _PlayerIsKeyDown(Vehicles[vehicle].Driver, IN_BACK) then
		_phys.ApplyTorqueCenter(vehicle, vector3(0, 0, 15000*TICKRATE))
	end
end,

onRight = function(vehicle)
	if _PlayerIsKeyDown(Vehicles[vehicle].Driver, IN_FORWARD) or _PlayerIsKeyDown(Vehicles[vehicle].Driver, IN_BACK) then
		_phys.ApplyTorqueCenter(vehicle, vector3(0, 0, -15000*TICKRATE))
	end
end,

onJump = function(vehicle)
	if _CurTime() > ROVERLASTJUMP[vehicle]+5.0 then
		_TraceLine(_EntGetPos(vehicle), vector3(0,0,-1), 100, vehicle)
		if _TraceHit() then
			_phys.ApplyForceCenter(vehicle, vecMul(_EntGetAng(vehicle), vector3(950000,950000,0)))
			ROVERLASTJUMP[vehicle] = _CurTime()
			_EntEmitSound(vehicle, "ambient/fire/gascan_ignite1.wav")
		end
	end
end
}

_EntPrecacheModel("models/props/cs_italy/orange.mdl")
ROVERLASTATTACK = {}
ROVERLASTATTACK2 = {}
ROVERLASTJUMP = {}
