_ServerCommand("gm_sv_allowspawning 0\n")
_ServerCommand("gm_sv_allownpc 0\n")
_ServerCommand("gm_sv_allweapons 0\n")
_ServerCommand("gm_sv_teamplay 1\n")
_ServerCommand("gm_sv_allowmultigun 0\n")
_ServerCommand("gm_sv_teamdamage 0\n")
_ServerCommand("gm_sv_setrules\n")
_EntPrecacheModel("models/player/kleiner.mdl")
_EntPrecacheModel("models/player/combine_soldier.mdl")
_TeamSetName(TEAM_RED, "MingeBags")
_TeamSetName(TEAM_BLUE, "Noob Haters")

	function GetAutoTeam()
		if _TeamNumPlayers(TEAM_RED) > _TeamNumPlayers(TEAM_BLUE) then
			return TEAM_BLUE
		else
			return TEAM_RED
		end
	end

	function gamerulesThink()
	end

	function GiveDefaultItems(playerid)
		_PlayerGiveItem(playerid, "weapon_physcannon")
		_PlayerGiveItem(playerid, "weapon_crowbar")
	end

	function gamerulesStartMap()
	end

	function PlayerSpawnChooseModel(playerid)
		if _PlayerInfo(playerid, "team") == TEAM_RED then
			_PlayerSetModel(playerid, "models/Player/Kleiner.mdl")
		else
			_PlayerSetModel(playerid, "models/Player/combine_soldier.mdl")
		end
	end

	function PickDefaultSpawnTeam(userid)
		_PlayerChangeTeam(userid, GetAutoTeam())
		return true
	end

	function eventPlayerKilled(killed, attacker, weapon)
		if IsPlayer(attacker) then
			_PlayerAddScore(attacker, 1)
		end
		if _PlayerInfo(killed, "team") == TEAM_RED then
			_PlayerChangeTeam(killed, TEAM_BLUE)
		else
			_PlayerChangeTeam(killed, TEAM_RED)
		end
		if not EndGame then
			CheckWinner()	
		end
	end

	function eventPlayerDisconnect (name, userid, address, steamid, reason)
		if not EndGame then
			CheckWinner()	
		end
	end

	function CheckWinner()
		if _TeamNumPlayers(TEAM_BLUE) + _TeamNumPlayers(TEAM_RED) > 1 then
			if _TeamNumPlayers(TEAM_BLUE) <= 0 then
				Winner(TEAM_RED)
			elseif _TeamNumPlayers(TEAM_RED) <= 0 then
				Winner(TEAM_BLUE)
			end
		end
	end

	EndGame = false
	function Winner(team)
		_PlaySound("npc/strider/fire.wav")
		local player = 0
		local maxscore = 0
		for i=1, _MaxPlayers() do
			if IsPlayerOnline(i) then
				if _PlayerInfo(i, "kills") > maxscore then
					player = i
					maxscore = _PlayerInfo(i, "kills")
				end
			end
		end
		_GModText_Start("ImpactMassive")
		 _GModText_SetPos(-1, 0.4)
		 _GModText_SetTime(5, 0.2, 1.25)
		if team == TEAM_RED then
			_GModText_SetText( "MINGEBAGS WIN!\nTop: ".._PlayerInfo(player, "name") )
			_GModText_SetColor(255, 0, 0, 240)
		else
			_GModText_SetColor(10, 20, 255, 240)
			_GModText_SetText( "NOOB HATERS WIN!\nTop: ".._PlayerInfo(player, "name") )
		end
		_GModText_Send( 0, 4111 )
		EndGame = true
		AddTimer(7, 1, Shuffle)
	end

	function Shuffle()
		EndGame = false
		for i=1, _MaxPlayers() do
			if _PlayerInfo(i, "connected") then
				_PlayerChangeTeam(i, GetAutoTeam())
				PlayerSpawnChooseModel(i)
				_PlayerRespawn(i)
				_PlayerAddScore(i, -_PlayerInfo(i,"kills"))
			end
		end
	end

	function canPlayerHaveItem( playerid, itemname )
		return itemname == "weapon_physcannon" or itemname == "weapon_crowbar"
	end

	function onShowHelp(userid)
		_GModRect_Start("gmod/white")
		 _GModRect_SetPos(0.0, 0.14, 1.0, 0.24)
		 _GModRect_SetColor(0, 0, 0, 175)
		 _GModRect_SetTime(10, 0.2, 1)
		_GModRect_Send(userid, 49)
		_GModText_Start("Trebuchet24")
		 _GModText_SetPos(-1, 0.16)
		 _GModText_SetColor(255, 255, 255, 255)
		 _GModText_SetTime(10, 0.2, 1.25)
		 _GModText_SetText("Riptide\n a mini-gamemode by JetBoom")
		_GModText_Send(userid, 50)
		_GModText_Start("Default")
		 _GModText_SetPos(-1, 0.3)
		 _GModText_SetColor(90, 90, 255, 240)
		 _GModText_SetTime(10, 0.2, 1.25)
		 _GModText_SetText( "Recruit the entire opposite team by killing them.\nGame ends when no one is on the other team." )
		_GModText_Send( userid, 51 )
		_GModText_Start("Default")
		 _GModText_SetPos(0, 0)
		 _GModText_SetColor(255, 255, 255, 255)
		 _GModText_SetTime(10, 0.2, 1.25)
		 _GModText_SetText("F1 Menu")
		_GModText_Send(userid, 52)
	end
	
	for i=1, _MaxPlayers() do
	if _PlayerInfo(i, "connected") then
		_PlayerChangeTeam(i, GetAutoTeam())
		PlayerSpawnChooseModel(i)
		_PlayerRespawn(i)
	end
end
