VehicleTypes["FlakTank"] = {
Name = "Flak Tank",
Model = "models/props_c17/FurnitureDresser001a.mdl",
Description = "Tank designed for Anti-Air and water battles.",
Stock = 2,
EntityType = "prop_physics",
MaxHealth = 125,
DamageMultiply = 1.0,
PassengerSlots = 0,
DriverCamDistance = 0,
CreationOffset = vector3(0,0,75),
ExitOffset = vector3(0,0,25),
Lockable = false,

HUD = function(vehicle)
	if Vehicles[vehicle].Driver > 0 then
		_GModRect_Start("gmod/white")
		_GModRect_SetPos(0.42, 0.85, 0.18, 0.1)
		_GModRect_SetColor( 0, 0, 0, 100 )
		_GModRect_SetTime( 10000, 0, 0 )
		_GModRect_Send( Vehicles[vehicle].Driver, 10000 )
		_GModText_Start( "Default" )
		_GModText_SetPos( -1, 0.88 )
		_GModText_SetColor( 255, 0, 0, 255 )
		_GModText_SetTime( 9999, 0.1, 0.1 )
		_GModText_SetText( "HP: "..math.ceil(Vehicles[vehicle].Health).."/"..VehicleTypes[Vehicles[vehicle].Type].MaxHealth )
		_GModText_Send( Vehicles[vehicle].Driver, 10001 )
	end
end,

HideHUD = function(userid)
	_GModRect_Hide(userid, 10000, 0.2)
	_GModText_Hide(userid, 10001, 0.2)
end,

onAttack = function(vehicle)
	if _CurTime() > FLAKTANKLASTATTACK[vehicle]+5.0 then
		FLAKTANKLASTATTACK[vehicle] = _CurTime()
		FlakTankAttack(vehicle)
		AddTimer(0.25, 2, FlakTankAttack, vehicle)
	end
end,

onRemoved = function(vehicle)
	FLAKTANKLASTATTACK[vehicle] = nil
end,

onDestroyed = function(vehicle)
	AddTimer(2.4, 1, DelayExplosion, vehicle)
	AddTimer(2.4, 1, _EntEmitSoundEx, vehicle, "npc/env_headcrabcanister/explosion.wav", 1.5, 1.0)
	_EntFire(vehicle, "ignite", "", 0)
	_EntFire(vehicle, "ignite", "", 0.5)
	_EntFire(vehicle, "break", "", 2.5)
	_EntFire(vehicle, "kill", "", 2.6)
end,

onDamaged = function(vehicle, attacker, damage)
	if Vehicles[vehicle].Health < VehicleTypes[Vehicles[vehicle].Type].MaxHealth*0.5 and damage > 10 then
		local finalpos = vecAdd(_EntGetPos(vehicle), vector3(math.random(-38, 38), math.random(-38, 38), math.random(-38, 38)))
		local ent = _EntCreate("env_fire_trail")
		if ent > 0 then
			_EntSetPos(ent, finalpos)
			_EntSpawn(ent)
			_EntSetParent(ent, vehicle)
			_EntFire(ent, "kill", "", math.random(3, 5))
		end
		local ent2 = _EntCreate("env_explosion")
		if ent2 > 0 then
			_EntSetKeyValue(ent2, "spawnflags", "17")
			_EntSetPos(ent2, finalpos)
			_EntSpawn(ent2)
			_EntFire(ent2, "explode", "", 0)
			_EntFire(ent2, "kill", "", 0.1)
		end
	end
end,

onCreated = function(vehicle)
	FLAKTANKLASTATTACK[vehicle] = _CurTime()
	_EntFire(vehicle, "sethealth", "65535", 0)
end,

onThink = function(vehicle)
	if Vehicles[vehicle].Driver > 0 then
		_EntitySetPhysicsAttacker(vehicle, Vehicles[vehicle].Driver)
	elseif Vehicles[vehicle].Owner > 0 then
		_EntitySetPhysicsAttacker(vehicle, Vehicles[vehicle].Owner)
	end
end,

onForward = function(vehicle)
	if _PlayerGetShootAng(Vehicles[vehicle].Driver) ~= nil then
		local force = _PlayerGetShootAng(Vehicles[vehicle].Driver)
		force = vecMul(force, vector3(1000, 1000, 0))
		force.z = 315
		force = vecMul(force, TICKRATE)
		_phys.ApplyForceCenter(vehicle, force)
	end
end,

onBackward = function(vehicle)
	if _PlayerGetShootAng(Vehicles[vehicle].Driver) ~= nil then
		local force = _PlayerGetShootAng(Vehicles[vehicle].Driver)
		force = vecMul(force, vector3(-1000, -1000, 0))
		force.z = 315
		force = vecMul(force, TICKRATE)
		_phys.ApplyForceCenter(vehicle, force)
	end
end
}

FLAKTANKLASTATTACK = {}
FLAKTANKPROJECTILETIMERS = {}

_EntPrecacheModel("models/props_junk/sawblade001a.mdl")
function FlakTankAttack(vehicle)
	if Vehicles[vehicle] == nil or _EntGetType(vehicle) == "n/a" then return end
	local ent = _EntCreate("prop_physics")
	if ent > 0 then
		_EntSetModel(ent, "models/props_junk/sawblade001a.mdl")
		_EntSetPos(ent, vecAdd(_EntGetPos(vehicle), vector3(0,0,35)))
		local ang = _PlayerGetShootAng(Vehicles[vehicle].Driver)
		_EntSetAng(ent, ang)
		_EntSpawn(ent)
		_phys.ApplyForceCenter(ent, vector3(math.random(-6000, 6000), math.random(-6000, 6000), 400))
		_EntFire(ent, "kill", "", 10)
		_phys.EnableGravity(ent, false)
		_EntEmitSoundEx(vehicle, "weapons/rpg/rocketfire1.wav", 1.4, 1)
		_EntEmitSoundEx(ent, "weapons/mortar/mortar_shell_incomming1.wav", 1.4, 1.0)
		local trail = _EntCreate("env_fire_trail")
		if trail > 0 then
			_EntSetPos(trail, _EntGetPos(ent))
			_EntSpawn(trail)
			_EntSetParent(trail, ent)
			_EntFire(trail, "kill", "", 9.95)
		end
		FLAKTANKPROJECTILETIMERS[ent] = AddTimer(0.1, 95, FlakTankProjCheckExplode, ent, Vehicles[vehicle].Owner, ang, vehicle)
	end
end

function FlakTankProjCheckExplode(prop, userid, ang, ignore)
	_EntitySetPhysicsAttacker(prop, userid)
	local force = vecMul(ang, vector3(5500, 5500, 5500))
	_phys.ApplyForceCenter(prop, vecMul(vecAdd(force, vector3(math.random(-2000, 2000), math.random(-2000, 2000), math.random(-2000, 2000))), TICKRATE))
	local hit = false
	_TraceLine(_EntGetPos(prop), ang, 80, prop)
	if _TraceHit() then
		if _TraceHitNonWorld() then
			if _TraceGetEnt() ~= ignore then
				hit = true
			end
		else
			hit = true
		end
	end
	local ents = _EntitiesFindInSphere(_EntGetPos(prop), 256)
	for k,i in ents do
		if Vehicles[i] then
			if Vehicles[i].Team ~= _PlayerInfo(userid, "team") then
				hit = true
			end
		end
	end
	if hit then
		local ents2 = _EntitiesFindInSphere(_EntGetPos(prop), 312)
		for k,i in ents2 do
			_TraceAttack(i, userid, userid, (312 - Distance(_EntGetPos(prop), _EntGetPos(i)))*0.08, "antivehicle")
		end
		local expl = _EntCreate("env_explosion")
		if expl > 0 then
			_EntSetPos(expl, _EntGetPos(prop))
			_EntSetKeyValue(expl, "spawnflags", "65")
			_EntSpawn(expl)
			_EntFire(expl, "explode", "", 0)
			_EntFire(expl, "kill", "", 0.05)
			_EntEmitSoundEx(expl, "ambient/explosions/explode_"..math.random(1,9)..".wav", 1.5, 1)
		end
		for i=1, 3 do
			local exp2 = _EntCreate("env_explosion")
			if exp2 > 0 then
				_EntSetPos(exp2, vecAdd(_EntGetPos(prop), vector3(math.random(-256, 256), math.random(-256, 256), math.random(-256, 256))))
				_EntSetKeyValue(exp2, "spawnflags", "65")
				_EntSpawn(exp2)
				_EntFire(exp2, "explode", "", i*0.1)
				_EntFire(exp2, "kill", "", (i*0.1)+0.05)
			end
		end
		_EntFire(prop, "break", "", 0)
		_EntFire(prop, "kill", "", 0.05)
		HaltTimer(FLAKTANKPROJECTILETIMERS[prop])
		FLAKTANKPROJECTILETIMERS[prop] = nil
	end
end
