Hats = {}
Hats.Players = {}
Hats.Models = {}
Hats.Models["models/props/cs_office/Snowman_hat.mdl"] = true
Hats.Models["models/Combine_Helicopter/helicopter_bomb01.mdl"] = true

function Hats.CreateHat(userid, hat)
	if not _PlayerInfo(userid, "alive") then return end
	if _PlayerInfo(userid, "team") < 2 then return end
	if not Hats.Models[hat] then return end
	if Hats.Players[userid] then Hats.RemoveHat(userid) return end
	local ent = _EntCreate("prop_dynamic_override")
	if ent > 0 then
		_EntPrecacheModel(hat)
		_EntSetModel(ent, hat)
		_EntSetPos(ent, vecAdd(_EntGetPos(userid), vector3(0,0,66)))
		_EntSetAng(ent, vecMul(_EntGetAng(userid), vector3(1,1,0)))
		_EntSetName(ent, "hat")
		_EntSetKeyValue(ent, "rendermode", "5")
		_EntSpawn(ent)
		_EntSetParent(ent, userid)
		_EntSetSolid(ent, SOLID_NONE)
		_EntKeyValue(ent, "setcolor", "255 0 0", 0)
		_EntSetMaterial(ent, "models/debug/debugwhite")
		Hats.Players[userid] = ent
	end
end

function Hats.RemoveHat(userid)
	local hat = Hats.Players[userid] or 0
	if _EntGetName(hat) == "hat" then
		_EntRemove(hat)
	end
	Hats.Players[userid] = nil
end

