-- Lua Mouse
-- Coded by JetBoom

MOUSEINDEX = 31998
MOUSEHELPINDEX = 31999
-- ================================= --

Mouse = {}
for i=1, _MaxPlayers() do
	Mouse[i] = {}
	Mouse[i].On = false
	Mouse[i].x = 0.5
	Mouse[i].y = 0.5
	Mouse[i].Data = ""
end

-- Returns true if the mouse is dist away from position (x, y)
function MouseNear(userid, dist, x, y)
	return Mouse[userid].On and math.abs(Mouse[userid].x - x) <= dist and math.abs(Mouse[userid].y - y) <= dist
end

-- Keeps the mouse on the screen.
function Cap(number)
	if number < 0.0 then number = 0.0 elseif number > 1.0 then number = 1.0 end
	return number
end

function mouse_eventKeyPressed(userid, in_key)
	if Mouse[userid].On then
		if in_key == IN_FORWARD then		
			Mouse[userid].y = Cap(Mouse[userid].y - 0.025)
		elseif in_key == IN_BACK then
			Mouse[userid].y = Cap(Mouse[userid].y + 0.025)
		elseif in_key == IN_MOVELEFT then
			Mouse[userid].x = Cap(Mouse[userid].x - 0.025)
		elseif in_key == IN_MOVERIGHT then
			Mouse[userid].x = Cap(Mouse[userid].x + 0.025)
		end
		if in_key == IN_JUMP or in_key == IN_USE then
			eventMouseClicked(userid, Mouse[userid].x, Mouse[userid].y)
			return
		end
		UpdateMouse(userid)
	end
end
HookEvent("eventKeyPressed", mouse_eventKeyPressed)

-- An overwrittable event.
function eventMouseClicked(userid, x, y)
end

-- This is the function your script(s) should call. x and y are optional. If not specified, the middle of the screen is used.
function MouseOn(userid, x, y)
	Mouse[userid].On = true
	if x then
		Mouse[userid].x = x
	end
	if y then
		Mouse[userid].y = y
	end
	DrawMouseHelp(userid)
	_PlayerLockInPlace(userid, true)
	UpdateMouse(userid)
	_PlayerOption(userid, "MouseQuick", 1999)
end

function MouseQuick(userid, num, seconds)
	Mouse[userid].y = 0.25+(num*0.029)
	UpdateMouse(userid)
	_PlayerOption(userid, "MouseQuick", 1999)
end

-- Turns off and resets the Lua mouse
function MouseOff(userid, keeppos)
	Mouse[userid].On = false
	if not keeppos then
		Mouse[userid].x = 0.5
		Mouse[userid].y = 0.5
	end
	HideMouse(userid)
	HideMouseHelp(userid)
	_PlayerLockInPlace(userid, false)
	_PlayerOption(userid, "MouseQuick", 0.01)
end

function HideMouse(userid)
	_GModRect_Hide(userid, MOUSEINDEX, 0.0)
end

function DrawMouseHelp(userid)
	_GModText_Start("Default")
	 _GModText_SetPos(-1, 0.01)
	 _GModText_SetColor(255, 0, 0, 255)
	 _GModText_SetTime(9999, 0.4, 0.4)
	 _GModText_SetText("[Mouse Mode]\nUse your directional keys to move the mouse.\n JUMP key to click.")
	_GModText_Send(userid, MOUSEHELPINDEX)
end

function HideMouseHelp(userid)
	_GModText_Hide(userid, MOUSEHELPINDEX, 0.25)
end

function UpdateMouse(userid)
	_GModRect_Start("VGUI/mouse")
	 _GModRect_SetPos(Mouse[userid].x, Mouse[userid].y, 0.025, 0.025)
	 _GModRect_SetColor(255, 0, 0, 225)
	 _GModRect_SetTime(99999, 0, 0)
	_GModRect_Send(userid, MOUSEINDEX)
end

function mouse_eventPlayerDisconnect(name, userid, address, steamid, reason)
	if IsPlayerOnline(userid) then
		Mouse[userid].On = false
		Mouse[userid].x = 0.5
		Mouse[userid].y = 0.5
		Mouse[userid].Data = ""
	end
end
HookEvent("eventPlayerDisconnect", mouse_eventPlayerDisconnect)
