-- NoXious Spell Core-System
-- By JetBoom

for i=1, _MaxPlayers() do
	players[i].Invisible = false
end

_ServerCommand("sk_antlionguard_health 500\nsk_antlionguard_dmg_shove 50\nsk_antlionguard_dmg_charge 85\n")

if Vehicles == nil then Vehicles = {} end

EntOwners={}
oldEntSetOwner = _EntSetOwner
function _EntSetOwner(ent, owner)
	oldEntSetOwner(ent, owner)
	EntOwners[ent] = owner
end

oldEntGetOwner = _EntGetOwner
function _EntGetOwner(ent)
	return EntOwners[ent] or 0
end
			  
SPELL_DEATHRAY = 1
SPELL_SHIELD = 2
SPELL_LIGHTNING = 3
SPELL_BLINK = 4
SPELL_PROTRUSION = 5
SPELL_MORTAR = 6
SPELL_INVISIBILITY = 7
SPELL_HEAL = 8
SPELL_SHOCK = 9
SPELL_METEOR = 10
SPELL_INVERSION = 11
SPELL_TELEPORT = 12
SPELL_ENERGYBOLT = 13
SPELL_COUNTERSPELL = 14
SPELL_REPEL = 15
SPELL_SLOW = 16

-- Dark Mage Spells
SPELL_FLAMESTRIKE = 17
SPELL_RESURRECT = 18
SPELL_ACIDSTORM = 19
SPELL_FIRESPRITES = 20
SPELL_TYPHOON = 21
SPELL_LEECH = 22
SPELL_BARRIER = 23
SPELL_JOLT = 24

-- Divine Mage Spells
SPELL_DIVINEBOLT = 25
SPELL_SANCTUARY = 26
SPELL_PIXIESWARM = 27
SPELL_TOSS = 28
SPELL_MASSHEAL = 29
SPELL_LEVITATE = 30
SPELL_SUNBURST = 31
SPELL_RESURRECT2 = 32

-- Necromancer Spells
SPELL_BLOODWELL = 33
SPELL_POWERWELL = 34
SPELL_CORPSEEXPLODE = 35
SPELL_RAISEUNDEAD = 36
SPELL_PARALYZE = 37
SPELL_EXPLOSION = 38
SPELL_SWAPLOCATION = 39
SPELL_HEX = 40

-- Kyuukyoku Gikou

function AirHike(userid)
	local vec = _EntGetVelocity(userid)
	_EntSetVelocity(userid, vector3(vec.x, vec.y, 500))
end

function Dash(userid)
	local vec = vecMul(_PlayerGetShootAng(userid), vector3(750,750,0)) vec.z = 250
	_EntSetVelocity(userid, vec)
	_PlayerGod(userid, true)
	AddTimer(0.4, 1, _PlayerGod, userid, false)
end

function AirDash(userid)
	local vec = vecMul(_PlayerGetShootAng(userid), vector3(750,750,0)) vec.z = 100
	_EntSetVelocity(userid, vec)
	_PlayerGod(userid, true)
	AddTimer(0.4, 1, _PlayerGod, userid, false)
end

function ConcentratedBolt(userid)
	if not _PlayerInfo(userid, "alive") then return end
	local ang = _PlayerGetShootAng(userid)
	if ang == nil then return end
	local ent = _EntCreate("crossbow_bolt")
	if ent > 0 then
		_EntSetOwner(ent, userid)
		_EntSetPos(ent, _PlayerGetShootPos(userid))
		_EntSetKeyValue(ent, "damage", "10")
		_EntSetAng(ent, ang)
		_EntSetVelocity(ent, vecMul(ang, vector3(1000, 1000, 1000)))
		_EntSpawn(ent)
	end
end

function OrbExplosion(pos, delay)
	local explosion = _EntCreate("prop_combine_ball")
	if explosion > 0 then
		_EntSetPos(explosion, pos)
		_EntSpawn(explosion)
		_EntFire(explosion, "explode", "", delay)
		_EntRemove(explosion)
		_EntFire(explosion, "kill", "", delay+0.05)
	end
end

function NovaBolt(userid)
	if not _PlayerInfo(userid, "alive") then return end
	PlayerLookTrace(userid, 1000)
	local ranx = math.frandom(-0.5, 0.5)
	local rany = math.frandom(-0.5, 0.5)
	for i=1, 19 do
		local ent = _EntCreate("crossbow_bolt")
		if ent > 0 then
			_EntSetOwner(ent, userid)
			_EntSetPos(ent, _TraceEndPos())
			_EntSetKeyValue(ent, "damage", "15")
			_EntSetAng(ent, vector3(ranx,rany,(i*0.1)-1))
			_EntSetVelocity(ent, vecMul(vector3(ranx,rany,(i*0.1)-1), vector3(700, 700, 700)))
			_EntSpawn(ent)
		end
		local sound = _EntCreate("info_target")
		if sound > 0 then
			_EntSetPos(sound, _TraceEndPos())
			_EntSpawn(sound)
			_EntFire(sound, "kill", "", 0.5)
			_EntEmitSound(sound, "npc/vort/attack_shoot.wav")
		end
	end
end

function Protrusion(userid)
	if not _PlayerInfo(userid, "alive") then return end
	_TraceLine(_EntGetPos(userid), vector3(0,0,-1), 200, userid)
	if not _TraceHit() then return end
	local ang = vecMul(_PlayerGetShootAng(userid), vector3(1,1,0))
	local basepos = _TraceEndPos()
	local pos = {}
	for i=1, math.random(12, 16) do
		pos[i] = basepos
		basepos = vecAdd(vecAdd(basepos, vecMul(ang, vector3(math.random(20, 45), math.random(20, 45), 0))), vector3(math.random(-10, 10), math.random(-10, 10), 0))
	end
	for k,i in pos do
		local ent = _EntCreate("crossbow_bolt")
		local ranx = math.random(-100, 100)
		local rany = math.random(-100, 100)
		if ent > 0 then
			_EntSetPos(ent, vecAdd(i, vector3(0,0,5)))
			_EntSetAng(ent, vector3(ranx*0.01,rany*0.01,0))
			_EntSetVelocity(ent, vector3(ranx,rany,750))
			_EntSetKeyValue(ent, "damage", "24")
			_EntSetOwner(ent, userid)
			_EntSpawn(ent)
			_phys.EnableGravity(ent, true)
		end
	end
	_EntEmitSound(userid, "physics/metal/metal_sheet_impact_bullet"..math.random(1,2)..".wav")
end

function IsVisible(posa, posb, ignore)
	return true
	--[[local dis = Distance(posa, posb)
	if dis == 0 then return true end
	_TraceLine(posa, vecNormalize(vecSub(posb,posa)), dis, ignore)
	return not _TraceHitWorld()
	]]
end

--[[
for i=1, 5 do _EntPrecacheModel("models/props_debris/wood_board0"..i.."a.mdl") end
function Protrusion(userid)
	if not _PlayerInfo(userid, "alive") then return end
	_TraceLine(_EntGetPos(userid), vector3(0,0,-1), 200, userid)
	if not _TraceHit() then return end
	local ang = vecMul(_PlayerGetShootAng(userid), vector3(1,1,0))
	local basepos = _TraceEndPos()
	local pos = {}
	for i=1, math.random(8, 12) do
		pos[i] = basepos
		basepos = vecAdd(vecAdd(basepos, vecMul(ang, vector3(math.random(20, 60), math.random(20, 60), 0))), vector3(math.random(-15, 15), math.random(-15, 15), 0))
	end
	local x = 1
	for k,i in pos do
		_TraceLine(i, vector3(0,0,1), 120, userid)
		if _TraceHitNonWorld() then
			_TraceAttack(_TraceGetEnt(), userid, userid, math.random(21, 26))
		end
		local ent = _EntCreate("prop_dynamic_override")
		if ent > 0 then
			_EntSetModel(ent, "models/props_debris/wood_board0"..math.random(1,5).."a.mdl")
			_EntSetPos(ent, vecAdd(i, vector3(0,0,15)))
			_EntSetAng(ent, vecMul(_PlayerGetShootAng(userid), vector3(1,1,0)))
			_EntSetKeyValue(ent, "rendermode", "1")
			_EntSpawn(ent)
			_EntFire(ent, "color", "0 100 255", 0)
			_EntFire(ent, "alpha", "190", 0)
			_EntFire(ent, "kill", "", x*0.11)
			_EntEmitSound(ent, "physics/metal/metal_sheet_impact_bullet"..math.random(1,2)..".wav")
			x=x+1
		end
	end
end
]]

function RaiseUndead(userid)
	if not _PlayerInfo(userid, "alive") then return end
	PlayerLookTrace(userid, 750)
	local ents = _EntitiesFindInSphere(_TraceEndPos(), 300)
	for i,k in ents do
		if IsPlayer(k) then
			if not _PlayerInfo(k, "alive") and not Gibbed[k] then
				local ent = _EntCreate("npc_antlionguard")
				if ent > 0 then
					_EntSetKeyValue(ent, "spawnflags", 8192+512)
					_EntSetPos(ent, _EntGetPos(k))
					_EntSpawn(ent)
					_EntFire(ent, "sethealth", "0", 20)
					local color = TeamColor(_PlayerInfo(userid,"team")) or "255 255 255"
					_EntFire(ent, "color", color, 0)
					_EntFire(ent, "sethealth", "325", 0)
				end
				local newpos = _EntGetPos(k)
				for i=1, 12 do
				local ent = _EntCreate("env_sprite")
				if ent > 0 then
					_EntSetKeyValue(ent, "model", "sprites/redglow3.spr")
					_EntSetKeyValue(ent, "rendermode", "5")
					_EntSetKeyValue(ent, "scale", tostring(4.5-(i*0.2)))
					_EntSetKeyValue(ent, "spawnflags", "1")
					_EntSetPos(ent, newpos)
					_EntSpawn(ent)
					_EntFire(ent, "kill", "", 2.6-(i*0.1))
					if i == 3 then _EntEmitSound(ent, "weapons/physcannon/energy_sing_flyby"..math.random(1,2)..".wav")
					elseif i == 1 then _EntEmitSound(ent, "weapons/physcannon/energy_sing_explosion2.wav") end
				end
					newpos = vecAdd(newpos, vector3(math.random(-15*i, 15*i), math.random(-15*i, 15*i), 50))
				end
				Gib(k)
			end
		end
	end
end

Projectiles = {}
function eventPropBreak(breaker, prop)
	if Projectiles[prop] then
		Projectiles[prop].Function(prop)
		Projectiles[prop] = nil
		_EntFire(prop, "kill", "", 0)
	end
end

function PowerWell(userid)
	if not _PlayerInfo(userid, "alive") then return end
	PlayerLookTrace(userid, 750)
	local ents = _EntitiesFindInSphere(_TraceEndPos(), 300)
	for i,k in ents do
		if IsPlayer(k) then
			if not _PlayerInfo(k, "alive") and not Gibbed[k] then
				local posi = _EntGetPos(k)
				AddTimer(0.5, 20, DoPowerWell, posi, userid)
				local trail = _EntCreate("env_smoketrail")
				if trail > 0 then
					_EntSetPos(trail, vecAdd(_EntGetPos(k), vector3(0,0,32)))
					_EntSetKeyValue(trail, "spawnrate", "70")
					_EntSetKeyValue(trail, "lifetime", "5")
					_EntSetKeyValue(trail, "startcolor", "255 255 0")
					_EntSetKeyValue(trail, "endcolor", "255 255 0")
					_EntSetKeyValue(trail, "minspeed", "10")
					_EntSetKeyValue(trail, "maxspeed", "80")
					_EntSetKeyValue(trail, "startsize", "16")
					_EntSetKeyValue(trail, "endsize", "33")
					_EntSetKeyValue(trail, "spawnradius", "50")
					_EntSetKeyValue(trail, "firesprite", "sprites/redglow3.spr")
					_EntSetKeyValue(trail, "smokesprite", "sprites/redglow3.spr")
					_EntSpawn(trail)
					_EntFire(trail, "kill", "", 10.0)
					_EntEmitSoundEx(trail, "ambient/water/water_pump_drainin1.wav", 1.25, 1.1)
				end
				WellParticles(posi, "255 255 20")
				Gib(k)
				return
			end
		end
	end
end

function DoPowerWell(pos, owner)
	local ents = _EntitiesFindInSphere(pos, 195)
	for i,k in ents do
		if owner ~= k then
			if _phys.HasPhysics(k) then
				if IsVisible(pos, _EntGetPos(k), owner) then
					_TraceAttack(k, owner, owner, 20)
				end
			end
		end
	end
end

function BloodWell(userid)
	if not _PlayerInfo(userid, "alive") then return end
	_PlayerViewModelSequence(userid, 171) _PlayerSetWeaponSequence(userid, 16)
	PlayerLookTrace(userid, 500)
	local ents = _EntitiesFindInSphere(_TraceEndPos(), 250)
	for i,k in ents do
		if IsPlayer(k) then
			if IsVisible(_PlayerGetShootPos(userid), _EntGetPos(k), userid) and not _PlayerInfo(k, "alive") and not Gibbed[k] then
				local posi = _EntGetPos(k)
				AddTimer(0.5, 10, DoBloodWell, posi, _PlayerInfo(userid, "team"))
				local trail = _EntCreate("env_smoketrail")
				if trail > 0 then
					_EntSetPos(trail, _EntGetPos(k))
					_EntSetKeyValue(trail, "spawnrate", "70")
					_EntSetKeyValue(trail, "lifetime", "6.0")
					_EntSetKeyValue(trail, "startcolor", "255 0 0")
					_EntSetKeyValue(trail, "endcolor", "255 0 0")
					_EntSetKeyValue(trail, "minspeed", "30")
					_EntSetKeyValue(trail, "maxspeed", "70")
					_EntSetKeyValue(trail, "startsize", "14")
					_EntSetKeyValue(trail, "endsize", "35")
					_EntSetKeyValue(trail, "spawnradius", "60")
					_EntSetKeyValue(trail, "firesprite", "sprites/redglow3.spr")
					_EntSetKeyValue(trail, "smokesprite", "sprites/redglow3.spr")
					_EntSpawn(trail)
					_EntFire(trail, "kill", "", 5.0)
					_EntEmitSoundEx(trail, "npc/waste_scanner/grenade_fire.wav", 1.25, 1.0)
					_EntEmitSoundEx(trail, "ambient/water/water_pump_drainin1.wav", 1.25, 1.1)
				end
				WellParticles(posi, "255 0 0")
				_TraceAttack(k, userid, userid, 100)
				_EffectInit()
				 _EffectSetEnt(userid or 255)
				 _EffectSetOrigin(vecAdd(_EntGetPos(userid), vector3(0,0,36)))
				 _EffectSetStart(vecAdd(_EntGetPos(k), vector3(0,0,36)))
				 _EffectSetScale(5)
				 _EffectSetMagnitude(1.0)
				_EffectDispatch("FadingLineTeam")
			end
		end
	end
end

function DoBloodWell(pos, team)
	local ents = _EntitiesFindInSphere(pos, 190)
	for i,k in ents do
		if IsPlayer(k) then
			if _PlayerInfo(k, "alive") and _PlayerInfo(k, "team") == team then
				local health = _PlayerInfo(k, "health")+20
				if health > Classes[players[k].Class].Health then
					_PlayerSetHealth(k, Classes[players[k].Class].Health)
				else
					_PlayerSetHealth(k, health)
				end
			end
		end
	end
end

function Explosion(userid)
	if not _PlayerInfo(userid, "alive") then return end
	_PlayerViewModelSequence(userid, 171) _PlayerSetWeaponSequence(userid, 16)
	local ents = _EntitiesFindInSphere(_EntGetPos(userid), 175)
	for i, ent in ents do
		if _phys.HasPhysics(ent) then
			if ent ~= userid then
				_TraceAttack(ent, userid, userid, (180-Distance(_EntGetPos(userid), _EntGetPos(ent)))*0.475)
			end
		end
	end
	DamagelessExplosion(userid, 0)
	OrbExplosion(vecAdd(_EntGetPos(userid), vector3(48, 0, 0)), 0)
	OrbExplosion(vecAdd(_EntGetPos(userid), vector3(-48, 0, 0)), 0)
end

function Hex(userid)
	if not _PlayerInfo(userid, "alive") then return end
	_PlayerViewModelSequence(userid, 171) _PlayerSetWeaponSequence(userid, 16)
	PlayerLookTrace(userid, 1500)
	if _TraceHitNonWorld() then
		local traced = _TraceGetEnt()
		if IsPlayer(traced) then
			if _PlayerInfo(traced, "team") ~= _PlayerInfo(userid, "team") then
				local health = _PlayerInfo(traced, "health")
				_TraceAttack(traced, userid, userid, health/2)
				_EntEmitSound(traced, "beams/beamstart5.wav")
				if Hexed[traced] then return end
				Hexed[traced] = true
				AddTimer(5, 1, UnHex, traced)
			end
		end
	end
	_EffectInit()
	 _EffectSetEnt(userid or 255)
	 _EffectSetOrigin(_TraceEndPos())
	 _EffectSetStart(vecAdd(_TraceEndPos(), vector3(0,0,144)))
	 _EffectSetScale(3)
	 _EffectSetMagnitude(2.0)
	_EffectDispatch("FadingLineTeam")
	_EffectInit()
	 _EffectSetEnt(userid or 255)
	 _EffectSetOrigin(vecAdd(_TraceEndPos(), vector3(0,72,72)))
	 _EffectSetStart(vecAdd(_TraceEndPos(), vector3(0,-72,72)))
	 _EffectSetScale(3)
	 _EffectSetMagnitude(2.0)
	_EffectDispatch("FadingLineTeam")
	_EffectInit()
	 _EffectSetEnt(userid or 255)
	 _EffectSetOrigin(vecAdd(_TraceEndPos(), vector3(72,0,72)))
	 _EffectSetStart(vecAdd(_TraceEndPos(), vector3(-72,0,72)))
	 _EffectSetScale(3)
	 _EffectSetMagnitude(2.0)
	_EffectDispatch("FadingLineTeam")
end

Hexed = {}
function UnHex(userid)
	if Hexed[userid] then
		local health = _PlayerInfo(userid,"health")*2
		if health > Classes[players[userid].Class].Health then
			_PlayerSetHealth(userid, Classes[players[userid].Class].Health)
		else
			_PlayerSetHealth(userid, health)
		end
		Hexed[userid] = nil
	end
end

function hexkilled(killed, attacker, weapon)
	if Hexed[killed] then
		Hexed[killed] = nil
	end
end
HookEvent("eventPlayerKilled", hexkilled)

function SwapLocation(userid)
	if not _PlayerInfo(userid, "alive") then return end
	_PlayerViewModelSequence(userid, 171) _PlayerSetWeaponSequence(userid, 16)
	PlayerLookTrace(userid, 1800)
	if _TraceHitNonWorld() then
		local traced = _TraceGetEnt()
		if IsPlayer(traced) then
			if _PlayerInfo(traced, "team") ~= _PlayerInfo(userid, "team") then
				local pos = _EntGetPos(traced)
				local vel = _EntGetVelocity(traced)
				_EntSetPos(traced, _EntGetPos(userid))
				_EntSetVelocity(traced, _EntGetVelocity(userid))
				_EntSetPos(userid, pos)
				_EntSetVelocity(userid, vel)
				_EffectInit()
				 _EffectSetEnt(userid or 255)
				 _EffectSetOrigin(vecAdd(_EntGetPos(userid), vector3(0,0,36)))
				 _EffectSetStart(vecAdd(_EntGetPos(traced), vector3(0,0,36)))
				 _EffectSetScale(5)
				 _EffectSetMagnitude(1.0)
				_EffectDispatch("FadingLineTeam")
				local ent = _EntCreate("env_sprite")
				if ent > 0 then
					_EntSetKeyValue(ent, "model", "sprites/redglow3.spr")
					_EntSetKeyValue(ent, "rendermode", "5")
					_EntSetKeyValue(ent, "scale", "0.5")
					_EntSetKeyValue(ent, "spawnflags", "5")
					_EntSetPos(ent, vecAdd(_EntGetPos(traced), vector3(0,0,36)))
					_EntSpawn(ent)
					_EntFire(ent, "showsprite", "", 0)
					_EntFire(ent, "hidesprite", "", 1.0)
					_EntFire(ent, "kill", "", 1.1)
					_EntEmitSound(ent, "nox/blink.wav")
				end
				ent = _EntCreate("env_sprite")
				if ent > 0 then
					_EntSetKeyValue(ent, "model", "sprites/redglow3.spr")
					_EntSetKeyValue(ent, "rendermode", "5")
					_EntSetKeyValue(ent, "scale", "0.5")
					_EntSetKeyValue(ent, "spawnflags", "5")
					_EntSetPos(ent, vecAdd(_EntGetPos(userid), vector3(0,0,36)))
					_EntSpawn(ent)
					_EntFire(ent, "showsprite", "", 0)
					_EntFire(ent, "hidesprite", "", 1.0)
					_EntFire(ent, "kill", "", 1.1)
					_EntEmitSound(ent, "nox/blink.wav")
				end
			end
		end
	end
end

function CorpseExplode(userid)
	if not _PlayerInfo(userid, "alive") then return end
	_PlayerViewModelSequence(userid, 171) _PlayerSetWeaponSequence(userid, 16)
	PlayerLookTrace(userid, 1250)
	for i,k in _EntitiesFindInSphere(_TraceEndPos(), 350) do
		if _EntGetType(k) == "player" then
			if not _PlayerInfo(k, "alive") and not Gibbed[k] then
				local pos = _EntGetPos(k)
				local ents = _EntitiesFindInSphere(pos, 350)
				Gib(k)
				for x=1, table.getn(ents) do
					if _phys.HasPhysics(ents[x]) then
						if IsVisible(_EntGetPos(k), _EntGetPos(ents[x]), userid) then
							_TraceAttack(ents[x], userid, userid, (355-Distance(_EntGetPos(k), _EntGetPos(ents[x])))*0.4, "antivehicle")
						end
					end
				end
				NoDamageLuaExplosion(pos)
				AR2Explosion(pos)
				OrbExplosion(pos)
				_EntEmitSound(k, "npc/env_headcrabcanister/explosion.wav")
			end
		end
	end
end

function CastSpell4(spell, userid)
	if spell == SPELL_BLOODWELL then
		PlaySmartSound(userid, "nox/du.wav")
		AddTimer(0.125, 1, PlaySmartSound, userid, "nox/un.wav")
		AddTimer(0.25, 1, PlaySmartSound, userid, "nox/du.wav")
		AddTimer(0.375, 1, BloodWell, userid)
	elseif spell == SPELL_POWERWELL then
		PlaySmartSound(userid, "nox/du.wav")
		AddTimer(0.125, 1, PlaySmartSound, userid, "nox/ru.wav")
		AddTimer(0.25, 1, PlaySmartSound, userid, "nox/cha.wav")
		AddTimer(0.375, 1, PlaySmartSound, userid, "nox/cha.wav")
		AddTimer(0.5, 1, PowerWell, userid, 1)
	elseif spell == SPELL_CORPSEEXPLODE then
		PlaySmartSound(userid, "nox/zo.wav")
		AddTimer(0.125, 1, PlaySmartSound, userid, "nox/in.wav")
		AddTimer(0.25, 1, PlaySmartSound, userid, "nox/ru.wav")
		AddTimer(0.375, 1, CorpseExplode, userid, 1)
	elseif spell == SPELL_RAISEUNDEAD then
		PlaySmartSound(userid, "nox/zo.wav")
		AddTimer(0.125, 1, PlaySmartSound, userid, "nox/ru.wav")
		AddTimer(0.25, 1, PlaySmartSound, userid, "nox/zo.wav")
		AddTimer(0.375, 1, PlaySmartSound, userid, "nox/cha.wav")
		AddTimer(0.5, 1, RaiseUndead, userid, 1)
	elseif spell == SPELL_PARALYZE then
		PlaySmartSound(userid, "nox/zo.wav")
		AddTimer(0.125, 1, PlaySmartSound, userid, "nox/zo.wav")
		AddTimer(0.25, 1, PlaySmartSound, userid, "nox/zo.wav")
		AddTimer(0.375, 1, PlaySmartSound, userid, "nox/zo.wav")
		AddTimer(0.5, 1, Paralyze, userid, 1)
	elseif spell == SPELL_EXPLOSION then
		PlaySmartSound(userid, "nox/in.wav")
		AddTimer(0.125, 1, PlaySmartSound, userid, "nox/ru.wav")
		AddTimer(0.25, 1, PlaySmartSound, userid, "nox/et.wav")
		AddTimer(0.375, 1, Explosion, userid, 1)
	elseif spell == SPELL_SWAPLOCATION then
		PlaySmartSound(userid, "nox/cha.wav")
		AddTimer(0.125, 1, PlaySmartSound, userid, "nox/et.wav")
		AddTimer(0.25, 1, SwapLocation, userid, 1)
	elseif spell == SPELL_HEX then
		PlaySmartSound(userid, "nox/du.wav")
		AddTimer(0.125, 1, PlaySmartSound, userid, "nox/cha.wav")
		AddTimer(0.25, 1, Hex, userid, 1)
	end
end

function CastSpell(spell, userid)
	if spell == SPELL_DEATHRAY then
		PlaySmartSound(userid, "nox/du.wav")
		AddTimer(0.125, 2, PlaySmartSound, userid, "nox/du.wav")
		AddTimer(0.375, 1, DeathRay, userid)
	elseif spell == SPELL_SHIELD then
		PlaySmartSound(userid, "nox/un.wav")
		AddTimer(0.125, 1, PlaySmartSound, userid, "nox/et.wav")
		AddTimer(0.25, 1, PlaySmartSound, userid, "nox/zo.wav")
		AddTimer(0.375, 1, PlaySmartSound, userid, "nox/cha.wav")
		AddTimer(0.5, 1, PlaySmartSound, userid, "nox/in.wav")
		AddTimer(0.625, 1, PlaySmartSound, userid, "nox/ka.wav")
		AddTimer(0.75, 1, PlaySmartSound, userid, "nox/cha.wav")
		AddTimer(0.825, 1, Shield, userid)
	elseif spell == SPELL_LIGHTNING then
		PlaySmartSound(userid, "nox/du.wav")
		AddTimer(0.125, 1, PlaySmartSound, userid, "nox/in.wav")
		AddTimer(0.25, 1, Lightning, userid)
	elseif spell == SPELL_BLINK then
		PlaySmartSound(userid, "nox/cha.wav")
		AddTimer(0.125, 1, PlaySmartSound, userid, "nox/un.wav")
		AddTimer(0.25, 1, Blink, userid)
	elseif spell == SPELL_PROTRUSION then
		PlaySmartSound(userid, "nox/zo.wav")
		AddTimer(0.125, 1, PlaySmartSound, userid, "nox/zo.wav")
		AddTimer(0.25, 1, PlaySmartSound, userid, "nox/un.wav")
		AddTimer(0.375, 1, Protrusion, userid)
	elseif spell == SPELL_MORTAR then
		PlaySmartSound(userid, "nox/zo.wav")
		AddTimer(0.125, 1, PlaySmartSound, userid, "nox/zo.wav")
		AddTimer(0.25, 1, PlaySmartSound, userid, "nox/un.wav")
		AddTimer(0.375, 1, PlaySmartSound, userid, "nox/ru.wav")
		AddTimer(0.5, 1, PlaySmartSound, userid, "nox/cha.wav")
		--AddTimer(0.625, 1, Mortar, userid)
		AddTimer(0.625, 1, AirHike, userid)
	elseif spell == SPELL_INVISIBILITY then
		PlaySmartSound(userid, "nox/et.wav")
		AddTimer(0.125, 1, PlaySmartSound, userid, "nox/cha.wav")
		AddTimer(0.25, 1, PlaySmartSound, userid, "nox/et.wav")
		AddTimer(0.375, 1, PlaySmartSound, userid, "nox/cha.wav")
		AddTimer(0.5, 1, Invisibility, userid)
	elseif spell == SPELL_HEAL then
		PlaySmartSound(userid, "nox/du.wav")
		AddTimer(0.125, 1, PlaySmartSound, userid, "nox/un.wav")
		AddTimer(0.25, 1, PlaySmartSound, userid, "nox/ru.wav")
		AddTimer(0.375, 1, Heal, userid)
	elseif spell == SPELL_SHOCK then
		PlaySmartSound(userid, "nox/du.wav")
		AddTimer(0.125, 1, PlaySmartSound, userid, "nox/et.wav")
		AddTimer(0.25, 1, PlaySmartSound, userid, "nox/cha.wav")
		AddTimer(0.375, 1, Shock, userid)
	elseif spell == SPELL_METEOR then
		PlaySmartSound(userid, "nox/ru.wav")
		AddTimer(0.125, 1, PlaySmartSound, userid, "nox/ru.wav")
		AddTimer(0.25, 1, Meteor, userid)
	elseif spell == SPELL_INVERSION then
		PlaySmartSound(userid, "nox/ka.wav")
		AddTimer(0.08, 1, PlaySmartSound, userid, "nox/in.wav")
		AddTimer(0.1, 1, Inversion, userid)
	elseif spell == SPELL_TELEPORT then
		PlaySmartSound(userid, "nox/cha.wav")
		AddTimer(0.125, 1, PlaySmartSound, userid, "nox/in.wav")
		AddTimer(0.25, 1, Teleport, userid)
	elseif spell == SPELL_ENERGYBOLT then
		PlaySmartSound(userid, "nox/ka.wav")
		AddTimer(0.125, 1, PlaySmartSound, userid, "nox/cha.wav")
		AddTimer(0.25, 1, PlaySmartSound, userid, "nox/zo.wav")
		AddTimer(0.375, 1, EnergyBolt, userid)
	elseif spell == SPELL_COUNTERSPELL then
		PlaySmartSound(userid, "nox/zo.wav")
		AddTimer(0.1, 1, CounterSpell, userid)
	elseif spell == SPELL_REPEL then
		PlaySmartSound(userid, "nox/cha.wav")
		AddTimer(0.125, 1, PlaySmartSound, userid, "nox/et.wav")
		AddTimer(0.25, 1, PlaySmartSound, userid, "nox/zo.wav")
		AddTimer(0.375, 1, PlaySmartSound, userid, "nox/zo.wav")
		AddTimer(0.45, 1, Repel, userid)
	elseif spell == SPELL_SLOW then
		PlaySmartSound(userid, "nox/zo.wav")
		AddTimer(0.125, 1, PlaySmartSound, userid, "nox/zo.wav")
		AddTimer(0.25, 1, PlaySmartSound, userid, "nox/zo.wav")
		AddTimer(0.375, 1, Slow, userid)
	end
end

function CastSpell2(spell, userid)
	if spell == SPELL_FLAMESTRIKE then
		PlaySmartSoundSlow(userid, "nox/ru.wav")
		AddTimer(0.15, 1, PlaySmartSoundSlow, userid, "nox/zo.wav")
		AddTimer(0.3, 1, FlameStrike, userid)
	elseif spell == SPELL_RESURRECT then
		PlaySmartSoundSlow(userid, "nox/du.wav")
		AddTimer(0.15, 1, PlaySmartSoundSlow, userid, "nox/ru.wav")
		AddTimer(0.3, 1, Resurrect, userid)
	elseif spell == SPELL_ACIDSTORM then
		PlaySmartSoundSlow(userid, "nox/in.wav")
		AddTimer(0.15, 1, PlaySmartSoundSlow, userid, "nox/ru.wav")
		AddTimer(0.3, 1, PlaySmartSoundSlow, userid, "nox/ka.wav")
		AddTimer(0.45, 1, AcidStorm, userid)
	elseif spell == SPELL_FIRESPRITES then
		PlaySmartSoundSlow(userid, "nox/zo.wav")
		AddTimer(0.15, 1, PlaySmartSoundSlow, userid, "nox/in.wav")
		AddTimer(0.3, 1, PlaySmartSoundSlow, userid, "nox/ru.wav")
		AddTimer(0.45, 1, FireSprites, userid)
		AddTimer(0.6, 1, FireSprites, userid)
	elseif spell == SPELL_TYPHOON then
		PlaySmartSoundSlow(userid, "nox/et.wav")
		AddTimer(0.15, 1, PlaySmartSoundSlow, userid, "nox/cha.wav")
		AddTimer(0.3, 1, PlaySmartSoundSlow, userid, "nox/ka.wav")
		AddTimer(0.45, 1, PlaySmartSoundSlow, userid, "nox/in.wav")
		AddTimer(0.6, 1, PlaySmartSoundSlow, userid, "nox/in.wav")
		AddTimer(0.75, 1, PlaySmartSoundSlow, userid, "nox/et.wav")
		AddTimer(0.9, 1, PlaySmartSoundSlow, userid, "nox/ru.wav")
		AddTimer(1.05, 1, Typhoon, userid)
	elseif spell == SPELL_LEECH then
		PlaySmartSoundSlow(userid, "nox/du.wav")
		AddTimer(0.15, 1, PlaySmartSoundSlow, userid, "nox/ru.wav")
		AddTimer(0.3, 1, Leech, userid)
	elseif spell == SPELL_BARRIER then
		PlaySmartSoundSlow(userid, "nox/ka.wav")
		AddTimer(0.15, 1, PlaySmartSoundSlow, userid, "nox/cha.wav")
		AddTimer(0.3, 1, PlaySmartSoundSlow, userid, "nox/ka.wav")
		AddTimer(0.45, 1, Barrier, userid)
	elseif spell == SPELL_JOLT then
		PlaySmartSoundSlow(userid, "nox/du.wav")
		AddTimer(0.15, 1, PlaySmartSoundSlow, userid, "nox/zo.wav")
		AddTimer(0.3, 1, PlaySmartSoundSlow, userid, "nox/in.wav")
		AddTimer(0.45, 1, Jolt, userid)
	end
end

function CastSpell3(spell, userid)
	if spell == SPELL_DIVINEBOLT then
		PlaySmartSound(userid, "nox/et.wav")
		AddTimer(0.125, 1, PlaySmartSound, userid, "nox/du.wav")
		AddTimer(0.25, 1, PlaySmartSound, userid, "nox/in.wav")
		AddTimer(0.375, 1, DivineBolt, userid)
		--[[
	elseif spell == SPELL_MAGICARROW then
		PlaySmartSound(userid, "nox/zo.wav")
		AddTimer(0.125, 1, PlaySmartSound, userid, "nox/ru.wav")
		AddTimer(0.25, 1, PlaySmartSound, userid, "nox/zo.wav")
		AddTimer(0.375, 1, PlaySmartSound, userid, "nox/cha.wav")
		AddTimer(0.5, 1, CreateArrow, userid, 1)
		--AddTimer(0.5, 1, MagicArrow, userid)
		]]
	elseif spell == SPELL_SANCTUARY then
		PlaySmartSound(userid, "nox/zo.wav")
		AddTimer(0.125, 1, PlaySmartSound, userid, "nox/ru.wav")
		AddTimer(0.25, 1, PlaySmartSound, userid, "nox/in.wav")
		AddTimer(0.375, 1, PlaySmartSound, userid, "nox/zo.wav")
		AddTimer(0.5, 1, PlaySmartSound, userid, "nox/cha.wav")
		AddTimer(0.625, 1, PlaySmartSound, userid, "nox/cha.wav")
		AddTimer(0.75, 1, Sanctuary, userid, 1)
	elseif spell == SPELL_PIXIESWARM then
		PlaySmartSound(userid, "nox/cha.wav")
		AddTimer(0.125, 1, PlaySmartSound, userid, "nox/ka.wav")
		AddTimer(0.25, 1, PlaySmartSound, userid, "nox/zo.wav")
		AddTimer(0.375, 1, PlaySmartSound, userid, "nox/cha.wav")
		AddTimer(0.5, 1, PixieSwarm, userid)
	elseif spell == SPELL_TOSS then
		PlaySmartSound(userid, "nox/ru.wav")
		AddTimer(0.125, 1, PlaySmartSound, userid, "nox/zo.wav")
		AddTimer(0.25, 1, Toss, userid)
	elseif spell == SPELL_MASSHEAL then
		PlaySmartSound(userid, "nox/du.wav")
		AddTimer(0.125, 1, PlaySmartSound, userid, "nox/cha.wav")
		AddTimer(0.25, 1, PlaySmartSound, userid, "nox/et.wav")
		AddTimer(0.375, 1, PlaySmartSound, userid, "nox/un.wav")
		AddTimer(0.5, 1, MassHeal, userid)
	elseif spell == SPELL_LEVITATE then
		PlaySmartSound(userid, "nox/ka.wav")
		AddTimer(0.125, 1, PlaySmartSound, userid, "nox/ru.wav")
		AddTimer(0.25, 1, PlaySmartSound, userid, "nox/zo.wav")
		AddTimer(0.375, 1, Levitate, userid)
	elseif spell == SPELL_RESURRECT2 then
		PlaySmartSound(userid, "nox/du.wav")
		AddTimer(0.125, 1, PlaySmartSound, userid, "nox/ru.wav")
		AddTimer(0.375, 1, Resurrect, userid)
	elseif spell == SPELL_SUNBURST then
		PlaySmartSound(userid, "nox/zo.wav")
		AddTimer(0.125, 1, PlaySmartSound, userid, "nox/zo.wav")
		AddTimer(0.25, 1, PlaySmartSound, userid, "nox/in.wav")
		AddTimer(0.375, 1, PlaySmartSound, userid, "nox/cha.wav")
		AddTimer(0.5, 1, SunBurst, userid)
	end
end

_EntPrecacheModel("models/mixerman3d/weapons/axe01.mdl")
BSTimers = {}
function PixieSwarm(userid)
	if not _PlayerInfo(userid, "alive") or not _PlayerInfo(userid, "connected") then return end
	_PlayerViewModelSequence(userid, 171) _PlayerSetWeaponSequence(userid, 16)
	for o=1, 6 do
		local axe = _EntCreate("prop_physics_multiplayer")
		if axe > 0 then
			_EntSetKeyValue(axe, "model", "models/weapons/w_knife_t.mdl")
			_EntSetOwner(axe, userid)
			_EntitySetPhysicsAttacker(axe, userid)
			_EntSetPos(axe, vecAdd(_PlayerGetShootPos(userid), vecMul( _PlayerGetShootAng(userid), vector3(25,25,25))))
			_EntSetAng(axe, vecAdd(_PlayerGetShootAng(userid), vector3(math.random(-90,90),math.random(-90,90),math.random(-90,90))))
			_EntSetKeyValue(axe, "rendermode", "5")
			_EntSpawn(axe)
			_EntFire(axe, "alpha", "0", 0)
			_EntSetName(axe, "pixies")
			_EntFire(axe, "kill", "", 8)
			_phys.EnableGravity(axe, false)
			_phys.SetMass(axe, 26)
			_phys.ApplyTorqueCenter(axe, vector3(1500,1500,2000))
			AttatchTrail(axe, "255 100 30")
			local glow = _EntCreate("env_sprite")
			if glow > 0 then
				_EntSetKeyValue(glow, "model", "sprites/blueflare1.spr")
				_EntSetKeyValue(glow, "rendermode", "5")
				_EntSetKeyValue(glow, "rendercolor", "255 200 30")
				_EntSetKeyValue(glow, "scale", "0.5")
				_EntSetKeyValue(glow, "spawnflags", "1")
				_EntSetPos(glow, _EntGetPos(axe))
				_EntSpawn(glow)
				_EntSetParent(glow, axe)
			end
			BSTimers[axe] = AddTimer(0.1, 0, BladeSpiritsTimer, axe)
		end
	end
	_EntEmitSound(userid, "weapons/flaregun/fire.wav")
end

-- I DID USE IT, LAUGH!
function AttatchTrail(entity, color)
	local Nade = _EntCreate("npc_grenade_frag")
	if Nade > 0 then
		_EntSetPos( Nade, vector3(0,0,-10000) )
		_EntSpawn( Nade )
		local Trails = _EntitiesFindByClass("env_spritetrail")
		for t in Trails do
			if _EntGetParent(Trails[t]) == Nade then
				_EntSetParent( Trails[t], entity )
				_EntFire(Trails[t], "color", color, 0)
				_EntFire( Nade, "kill", "", 0.05)
			end
		end
	end
end

function AttatchTrail2(entity, color, killtime)
	local Nade = _EntCreate("npc_grenade_frag")
	if Nade > 0 then
		_EntSetPos( Nade, vector3(0,0,-10000) )
		_EntSpawn( Nade )
		local Trails = _EntitiesFindByClass("env_spritetrail")
		for t in Trails do
			if _EntGetParent(Trails[t]) == Nade then
				_EntSetParent( Trails[t], entity )
				_EntFire(Trails[t], "color", color, 0)
				_EntFire(Trails[t], "kill", "", killtime)
				_EntFire( Nade, "kill", "", 0.05)
			end
		end
	end
end

function BladeSpiritsTimer(axe)
	local userid = _EntGetOwner(axe) or 0
	if _EntGetName(axe) ~= "pixies" then HaltTimer(BSTimers[axe]) BSTimers[axe] = nil return end
	if not _PlayerInfo(userid, "alive") or not _PlayerInfo(userid, "connected") then return end
	_EntitySetPhysicsAttacker( axe, userid )
	local entvec = vecNormalize(vecSub(vecAdd(_EntGetPos(userid), vector3(0,0,48)), _EntGetPos(axe)))
	_phys.ApplyForceCenter(axe, vecMul(entvec, 9000))
end

function SunBurst(userid)
	if not _PlayerInfo(userid, "alive") or not _PlayerInfo(userid, "connected") then return end
	_PlayerViewModelSequence(userid, 171) _PlayerSetWeaponSequence(userid, 16)
	local sunburst = _EntCreate("physics_prop")
	local trail = _EntCreate( "env_fire_trail" )
	_EntPrecacheModel( "models/props/cs_italy/orange.mdl" )			
	if sunburst > 0 then
		_EntSetPos(sunburst, vecAdd( _PlayerGetShootPos(userid), vecMul( _PlayerGetShootAng(userid), vector3(80,80,80))))
		_EntSetModel(sunburst, "models/props/cs_italy/orange.mdl")
		_phys.SetMass(sunburst, 10)
		_EntSetPos(trail, _EntGetPos(sunburst))
		_EntSpawn(sunburst)
		_phys.EnableGravity(sunburst, false)
		_EntFire(sunburst, "sethealth", "99999", 0)
		_EntSetOwner(sunburst, userid)
		_EntitySetPhysicsAttacker(sunburst, userid)
		_EntSpawn(trail)
		local fireforce = vecMul(_PlayerGetShootAng(userid), vector3(20000, 20000, 20000))
        _phys.ApplyForceCenter(sunburst, fireforce)
		_EntSetName(sunburst, "sunburst")
		_EntSetParent(trail, sunburst)
		_EntFire(trail, "kill", "", 2.25)
		local glow = _EntCreate("env_sprite")
		if glow > 0 then
			_EntSetKeyValue(glow, "model", "sprites/animglow01.spr")
			_EntSetKeyValue(glow, "rendermode", "5")
			_EntSetKeyValue(glow, "scale", "2.5")
			_EntSetKeyValue(glow, "spawnflags", "1")
			_EntSetPos(glow, _EntGetPos(sunburst))
			_EntSpawn(glow)
			_EntFire(glow, "showsprite", "", 0)
			_EntSetParent(glow, sunburst)
			AddTimer(2.25, 1, SunBurstExplode, sunburst, glow)
			SBTrackTimers[sunburst] = AddTimer(0.05, 0, SunBurstTrack, sunburst)
			_EntFire(glow, "kill", "", 2.5)
			_EntFire(sunburst, "kill", "", 2.5)
		end
	end
end

function SunBurstExplode(prop, glow)
	local userid = _EntGetOwner(prop) or 0
	_phys.EnableMotion(prop, false)
	_EntFire(glow, "setscale", "2.1", 0)
	_EntFire(glow, "setscale", "2.2", 0.1)
	_EntFire(glow, "setscale", "2.3", 0.2)
	_EntFire(glow, "setscale", "2.4", 0.3)
	_EntFire(glow, "setscale", "2.5", 0.4)
	_EntFire(glow, "setscale", "2.1", 0.5)
	_EntFire(glow, "setscale", "1.0", 0.6)
	_EntFire(glow, "setscale", "0.5", 0.7)
	_EntFire(glow, "kill", "", 0.8)
	_EntFire(prop, "kill", "", 0.85)
	_EntEmitSound(prop, "nox/sunburst_explode.wav")
	local tab = _EntitiesFindInSphere(_EntGetPos(prop), 150)
	for i=1, table.getn(tab) do
		local target = tab[i]
		local damage = (155-Distance(_EntGetPos(prop), _EntGetPos(target)))*0.35
		if Vehicles[target] then damage = damage+10 end
		--_TraceAttack(target, userid, userid, damage)
		_TraceAttack(target, userid, userid, damage*0.5)
		local lowdamage = math.ceil(damage*0.15)
		AddTimer(0.15, 5, _TraceAttack, target, userid, userid, lowdamage)
		if Vehicles[target] or IsPlayer(target) then
			local trail = _EntCreate("env_fire_trail")
			if trail > 0 then
				_EntSetPos(trail, vecAdd(_EntGetPos(target), vector3(0,0,26)))
				_EntSpawn(trail)
				_EntSetParent(trail, target)
				_EntFire(trail, "kill", "", 0.75)
			end
		end
	end
	for i=1, 7 do
		local fireball = _EntCreate("physics_prop")
		_EntPrecacheModel("models/props/cs_italy/orange.mdl")
		if fireball > 0 then
			_EntSetPos(fireball, vecAdd(_EntGetPos(prop), vector3(math.random(-20, 20), math.random(-20, 20), 0)))
			_EntSetModel(fireball, "models/props/cs_italy/orange.mdl")
			_phys.SetMass(fireball, 10)
			_EntSpawn(fireball)
			_EntSetOwner(fireball, userid)
			_EntitySetPhysicsAttacker(fireball, userid)
			_EntSetName(fireball, "sunburstcluster")
			_phys.ApplyForceCenter(fireball, vector3(math.random(-1000, 1000), math.random(-1000, 1000), 0))
			_EntFire(fireball, "sethealth", "99999", 0)
			_EntFire(fireball, "kill", "", 2.1)
			local trail = _EntCreate("env_fire_trail")
			if trail > 0 then
				_EntSetPos(trail, _EntGetPos(fireball))
				_EntSpawn(trail)
				_EntSetParent(trail, fireball)
				AddTimer(math.frandom(1.0, 2.0), 1, SunBurstClusterExplode, fireball)
			end
		end
	end
end

SBTrackTimers = {}
function SunBurstTrack(sunburst)
	local userid = _EntGetOwner(sunburst) or 0
	if not _PlayerInfo(userid, "alive") or not _PlayerInfo(userid, "connected") or _EntGetName(sunburst) ~= "sunburst" then HaltTimer(SBTrackTimers[sunburst]) SBTrackTimers[sunburst] = nil return end
	PlayerLookTrace(userid, 9999)
	_phys.ApplyForceCenter(sunburst, vecMul(vecNormalize(vecSub(_TraceEndPos(),_EntGetPos(sunburst))), vector3(300,300,350)))
end

function SunBurstClusterExplode(prop)
	local userid = _EntGetOwner(prop) or 0
	_EntEmitSound(prop, "nox/sunburstcluster_explode.wav")
	local tab = _EntitiesFindInSphere(_EntGetPos(prop), 200)
	for i=1, table.getn(tab) do
		local target = tab[i]
		local damage = (200-Distance(_EntGetPos(prop), _EntGetPos(target)))*0.15
		if Vehicles[target] then damage = damage+8 end
		--_TraceAttack(target, userid, userid, damage)
		_TraceAttack(target, userid, userid, damage*0.5)
		local lowdamage = math.ceil(damage*0.12)
		AddTimer(0.15, 5, _TraceAttack, target, userid, userid, lowdamage)
		if Vehicles[target] or IsPlayer(target) then
			local trail = _EntCreate("env_fire_trail")
			if trail > 0 then
				_EntSetPos(trail, vecAdd(_EntGetPos(target), vector3(0,0,26)))
				_EntSpawn(trail)
				_EntSetParent(trail, target)
				_EntFire(trail, "kill", "", 0.75)
			end
		end
	end
	local glow = _EntCreate("env_sprite")
	if glow > 0 then
		_EntSetKeyValue(glow, "model", "sprites/animglow01.spr")
		_EntSetKeyValue(glow, "rendermode", "5")
		_EntSetKeyValue(glow, "scale", "1.0")
		_EntSetKeyValue(glow, "spawnflags", "1")
		_EntSetPos(glow, _EntGetPos(prop))
		_EntSpawn(glow)
		_EntFire(glow, "showsprite", "", 0)
		_EntFire(glow, "kill", "", 1)
	end
	_EntFire(prop, "kill", "", 0)
end

function math.frandom(minn, maxn)
	minn = minn * 100
	maxn = maxn * 100
	return math.random(minn, maxn)*0.01
end

function DivineBolt(userid)
	if not _PlayerInfo(userid, "alive") or not IsPlayerOnline(userid) then return end
	_PlayerViewModelSequence(userid, 171) _PlayerSetWeaponSequence(userid, 16)
	PlayerLookTrace(userid, 1200)
	local ent = _EntCreate("env_sprite")
	if ent > 0 then
		_EntSetKeyValue(ent, "model", "sprites/blueflare1.spr")
		_EntSetKeyValue(ent, "rendermode", "5")
		_EntSetKeyValue(ent, "scale", "3")
		_EntSetKeyValue(ent, "spawnflags", "1")
		_EntSetPos(ent, _TraceEndPos())
		_EntSpawn(ent)
		_EntFire(ent, "kill", "", 1.5)
		_EntEmitSound(ent, "weapons/physcannon/energy_sing_flyby"..math.random(1,2)..".wav")
		local pos = _TraceEndPos()
		AddTimer(0.7, 1, DivineBoltHit, pos, userid)
	end
end

function Sanctuary(userid)
	if not _PlayerInfo(userid, "alive") or not IsPlayerOnline(userid) then return end
	_PlayerViewModelSequence(userid, 171) _PlayerSetWeaponSequence(userid, 16)
	local pos = _EntGetPos(userid)
	WellParticles(pos, "255 255 255")
	WellParticles(pos, "255 255 255")
	WellParticles(pos, "175 255 255")
	local team = _PlayerInfo(userid, "team")
	AddTimer(0.1, 50, SanctuaryTimer, pos, team)
	local ent = _EntCreate("info_target")
	if ent > 0 then
		_EntSetPos(ent, pos)
		_EntSpawn(ent)
		_EntEmitSoundEx(ent, "weapons/physcannon/physcannon_charge.wav", 1, 0.25)
		_EntFire(ent, "kill", "", 5)
	end
end

function SanctuaryTimer(pos, team)
	for _, ent in _EntitiesFindInSphere(pos, 190) do
		if _EntGetType(ent) == "player" then
			if _PlayerInfo(ent, "alive") then
				if _PlayerInfo(ent, "team") == team then
					local health = _PlayerInfo(ent, "health")
					_PlayerSetHealth(ent, _PlayerInfo(ent, "health")+1)
					if _PlayerInfo(ent, "health") > _EntGetMaxHealth(ent) then
						_PlayerSetHealth(ent, _EntGetMaxHealth(ent))
					end
				else
					_EntSetVelocity(ent, vecAdd(_EntGetVelocity(ent), vecMul(vecNormalize(vecSub(_EntGetPos(ent), pos)), 325)))
				end
			end
		end
	end
end

function DivineBoltHit(basepos, userid)
	local damage = 18
	local entities = _EntitiesFindInSphere(basepos, 150)
	for i in entities do
		if IsPlayer(entities[i]) then
			if _PlayerInfo(entities[i], "team") ~= _PlayerInfo(userid, "team") then
				damage = damage + math.random(13, 17)
			end
		end
	end
	for i in entities do
		if entities[i] ~= userid then
			_TraceAttack(entities[i], userid, userid, math.frandom(0.9, 1.1)*damage)
		end
	end
	local newpos = basepos
	for i=1, 21 do
		local ent = _EntCreate("env_sprite")
		if ent > 0 then
			_EntSetKeyValue(ent, "model", "sprites/blueflare1.spr")
			_EntSetKeyValue(ent, "rendermode", "5")
			_EntSetKeyValue(ent, "scale", tostring(4.5-(i*0.2)))
			_EntSetKeyValue(ent, "spawnflags", "1")
			_EntSetPos(ent, newpos)
			_EntSpawn(ent)
			_EntFire(ent, "kill", "", 2.6-(i*0.1))
			if i == 3 then _EntEmitSound(ent, "weapons/physcannon/energy_sing_flyby"..math.random(1,2)..".wav")
			elseif i == 1 then _EntEmitSound(ent, "weapons/physcannon/energy_sing_explosion2.wav") end
		end
		newpos = vecAdd(newpos, vector3(math.random(-15*i, 15*i), math.random(-15*i, 15*i), 50))
	end
end

function MassHeal(userid)
	if not _PlayerInfo(userid, "alive") or not _PlayerInfo(userid, "connected") then return end
	_PlayerViewModelSequence(userid, 171) _PlayerSetWeaponSequence(userid, 16)
	local ownerhealed = false
	local entities = _EntitiesFindInSphere(_EntGetPos(userid), 225)
	for i=1, table.getn(entities) do
		local targ = userid
		local addedhealth = 0
		if IsPlayer(entities[i]) then
			if _PlayerInfo(entities[i], "team") == _PlayerInfo(userid, "team") then
				targ = entities[i]
				local health = _PlayerInfo(targ, "health")
				_PlayerSetHealth(targ, _PlayerInfo(targ, "health")+30)
				if _PlayerInfo(targ, "health") > _EntGetMaxHealth(targ) then
					_PlayerSetHealth(targ, _EntGetMaxHealth(targ))
				end
				addedhealth = _PlayerInfo(targ, "health")-health
				if targ ~= userid then
					_GModText_Start( "Default" )
					 _GModText_SetPos( 0.0, 0.0 )
					 _GModText_SetColor( 0, 230, 0, 255 )
					 _GModText_SetTime( 0.75, 0.2, 0.2 )
					 _GModText_SetAdditive(true)
					 _GModText_SetEntity(targ)
					 _GModText_SetEntityOffset(vector3(math.random(-25,25),math.random(-25,25),math.random(40,50)))
					 _GModText_SetText( "+ "..addedhealth)
					_GModText_Send(userid, userid+targ+math.random(10000,22000))
				end
				_EntEmitSound(targ, "nox/heal.wav")
				local trail = _EntCreate("env_smoketrail")
				if trail > 0 then
					_EntSetPos(trail, vecAdd(_EntGetPos(targ), vector3(0,0,32)))
					_EntSetKeyValue(trail, "spawnrate", "70")
					_EntSetKeyValue(trail, "lifetime", "1")
					_EntSetKeyValue(trail, "startcolor", "0 255 0")
					_EntSetKeyValue(trail, "endcolor", "0 255 0")
					_EntSetKeyValue(trail, "minspeed", "10")
					_EntSetKeyValue(trail, "maxspeed", "80")
					_EntSetKeyValue(trail, "startsize", "8")
					_EntSetKeyValue(trail, "endsize", "12")
					_EntSetKeyValue(trail, "spawnradius", "16")
					_EntSetKeyValue(trail, "firesprite", "sprites/redglow3.spr")
					_EntSetKeyValue(trail, "smokesprite", "sprites/redglow3.spr")
					_EntSpawn(trail)
					_EntSetParent(trail, targ)
					_EntFire(trail, "kill", "", 1.0)
				end
				AttatchTrail2(targ, "0 255 0", 2)
			end
		end
	end
end

function Toss(userid)
	if not _PlayerInfo(userid, "alive") or not _PlayerInfo(userid, "connected") then return end
	_PlayerViewModelSequence(userid, 171) _PlayerSetWeaponSequence(userid, 16)
	PlayerLookTrace(userid, 100)
	if _TraceHitNonWorld() then
		if IsPlayer(_TraceGetEnt()) then
			if _PlayerInfo(_TraceGetEnt(), "team") ~= _PlayerInfo(userid, "team") then
				local addedVec = vecAdd(vecMul(_EntGetVelocity(_TraceGetEnt()), 0.5), vector3(0,0,500))
				_EntSetVelocity(_TraceGetEnt(), vecAdd(vecMul(_PlayerGetShootAng(userid), vector3(1000, 1000, 1000)), addedVec))
				_EntEmitSound(_TraceGetEnt(), "weapons/physcannon/energy_sing_flyby"..math.random(1,2)..".wav")
				local trail = _EntCreate("env_fire_trail")
				if trail > 0 then
					_EntSetPos(trail, _TraceEndPos())
					_EntSpawn(trail)
					_EntSetParent(trail, _TraceGetEnt())
					_EntFire(trail, "kill", "", 2.0)
				end
				AttatchTrail(_TraceGetEnt(), "255 255 0")
			end
		end
	end
end

LevitateTimers = {}
function Levitate(userid)
	if not _PlayerInfo(userid, "alive") or not _PlayerInfo(userid, "connected") then return end
	if LevitateTimers[userid] ~= nil then
		HaltTimer(LevitateTimers[userid])
		LevitateTimers[userid] = nil
	end
	AttatchTrail2(userid, "255 255 255", 12)
	local tempx = _EntCreate("env_smokestack")
	if tempx > 0 then
		_EntSetKeyValue(tempx, "InitialState", "1")
		_EntSetKeyValue(tempx, "BaseSpread", "12")
		_EntSetKeyValue(tempx, "SpreadSpeed", "8")
		_EntSetKeyValue(tempx, "Speed", "8")
		_EntSetKeyValue(tempx, "startsize", "4")
		_EntSetKeyValue(tempx, "EndSize", "8")
		_EntSetKeyValue(tempx, "Rate", "24")
		_EntSetKeyValue(tempx, "JetLength", "8")
		_EntSetKeyValue(tempx, "SmokeMaterial", "particle/SmokeStack.vmt")
		_EntSetKeyValue(tempx, "twist", "-360")
		_EntSetKeyValue(tempx, "roll", "1")
		_EntSetKeyValue(tempx, "rendercolor", "255 255 255")
		_EntSetKeyValue(tempx, "renderamt", "220")
		_EntSetPos(tempx, _EntGetPos(userid))
		_EntSpawn(tempx)
		_EntSetParent(tempx, userid)
		_EntFire(tempx, "TurnOn", "", 0)
		_EntFire(tempx, "TurnOff", "", 10)
		_EntFire(tempx, "kill", "", 15)
	end
	LevitateTimers[userid] = AddTimer(0.05, 200, doLevitate, userid)
	_EntEmitSound(userid, "weapons/physcannon/energy_bounce2.wav")
end

function WellParticles(pos, color)
	local tempx = _EntCreate("env_smokestack")
	if tempx > 0 then
		_EntSetKeyValue(tempx, "InitialState", "1")
		_EntSetKeyValue(tempx, "BaseSpread", "200")
		_EntSetKeyValue(tempx, "SpreadSpeed", "1")
		_EntSetKeyValue(tempx, "Speed", "64")
		_EntSetKeyValue(tempx, "startsize", "8")
		_EntSetKeyValue(tempx, "EndSize", "28")
		_EntSetKeyValue(tempx, "Rate", "64")
		_EntSetKeyValue(tempx, "JetLength", "100")
		_EntSetKeyValue(tempx, "SmokeMaterial", "particle/SmokeStack.vmt")
		_EntSetKeyValue(tempx, "twist", "500")
		_EntSetKeyValue(tempx, "roll", "360")
		_EntSetKeyValue(tempx, "rendercolor", color)
		_EntSetKeyValue(tempx, "renderamt", "220")
		_EntSetPos(tempx, pos)
		_EntSpawn(tempx)
		_EntFire(tempx, "TurnOn", "", 0)
		_EntFire(tempx, "TurnOff", "", 5)
		_EntFire(tempx, "kill", "", 15)
	end
	tempx = _EntCreate("env_smokestack")
	if tempx > 0 then
		_EntSetAng(tempx, vector3(0,0,-1))
		_EntSetKeyValue(tempx, "InitialState", "1")
		_EntSetKeyValue(tempx, "BaseSpread", "64")
		_EntSetKeyValue(tempx, "SpreadSpeed", "64")
		_EntSetKeyValue(tempx, "Speed", "64")
		_EntSetKeyValue(tempx, "startsize", "8")
		_EntSetKeyValue(tempx, "EndSize", "32")
		_EntSetKeyValue(tempx, "Rate", "32")
		_EntSetKeyValue(tempx, "JetLength", "300")
		_EntSetKeyValue(tempx, "SmokeMaterial", "particle/SmokeStack.vmt")
		_EntSetKeyValue(tempx, "twist", "1000")
		_EntSetKeyValue(tempx, "roll", "200")
		_EntSetKeyValue(tempx, "rendercolor", color)
		_EntSetKeyValue(tempx, "renderamt", "220")
		_EntSetPos(tempx, pos)
		_EntSpawn(tempx)
		_EntFire(tempx, "TurnOn", "", 0)
		_EntFire(tempx, "TurnOff", "", 4.5)
		_EntFire(tempx, "kill", "", 15)
	end
end

function doLevitate(userid)
	if not _PlayerInfo(userid, "alive") or not IsPlayerOnline(userid) then
		HaltTimer(LevitateTimers[userid])
		LevitateTimers[userid] = nil
		return
	end
	_TraceLine(_EntGetPos(userid), vector3(0,0,-1), 375, userid)
	if _TraceHit() then
		local vVel = _EntGetVelocity(userid)
		_TraceLine(_EntGetPos(userid), vector3(0,0,-1), 250, userid)
		if _TraceHit() then
			vVel.z = 250
		elseif vVel.z < 0 then
			vVel.z = 2
		end
		_EntSetVelocity(userid, vVel)
	end
end

function PlaySmartSound(userid, sound)
	if _PlayerInfo(userid, "alive") then
		_EntEmitSound(userid, sound)
	end
end

function PlaySmartSoundSlow(userid, sound)
	if _PlayerInfo(userid, "alive") then
		_EntEmitSoundEx(userid, sound, 1.0, 0.75)
	end
end

function Distance(a, b)
	if a.x == b.x and a.y == b.y and a.z == b.z then return 0 end
	return math.abs(vecLength(vecSub(a, b)))
end

function FlameStrike(userid)
	if not _PlayerInfo(userid, "alive") or not _PlayerInfo(userid, "connected") then return end
	_PlayerViewModelSequence(userid, 171) _PlayerSetWeaponSequence(userid, 16)
	_TraceLine(_PlayerGetShootPos(userid), _PlayerGetShootAng(userid), 1250, userid)
	local tab = _EntitiesFindInSphere(_TraceEndPos(), 150)
	for i,target in tab do
		if _phys.HasPhysics(target) then
			local damage = (165-Distance(_TraceEndPos(), _EntGetPos(target)))*0.35
			_TraceAttack(target, userid, userid, damage*0.5)
			local lowdamage = math.ceil(damage*0.1)
			AddTimer(0.15, 5, _TraceAttack, target, userid, userid, lowdamage)
			if Vehicles[target] or IsPlayer(target) then
				local trail = _EntCreate("env_fire_trail")
				if trail > 0 then
					_EntSetPos(trail, vecAdd(_EntGetPos(target), vector3(0,0,26)))
					_EntSpawn(trail)
					_EntSetParent(trail, target)
					_EntFire(trail, "kill", "", 0.75)
				end
			end
		end
	end
	for i=1, 3 do
		local ent = _EntCreate("env_sprite")
		if ent > 0 then
			_EntSetKeyValue(ent, "model", "sprites/fire.spr")
			_EntSetKeyValue(ent, "rendermode", "5")
			_EntSetKeyValue(ent, "scale", "1.0")
			_EntSetKeyValue(ent, "spawnflags", "1")
			_EntSetPos(ent, vecAdd(vector3(0,0,(i*35)), _TraceEndPos()))
			_EntSpawn(ent)
			_EntFire(ent, "showsprite", "", 0)
			_EntFire(ent, "setscale", "1.5", 0.25)
			_EntFire(ent, "setscale", "1.8", 0.5)
			_EntFire(ent, "setscale", "2.25", 0.75)
			_EntFire(ent, "setscale", "3.0", 1.0)
			_EntFire(ent, "setscale", "2.25", 1.25)
			_EntFire(ent, "setscale", "1.8", 1.5)
			_EntFire(ent, "setscale", "0.5", 1.75)
			_EntFire(ent, "hidesprite", "", 1.9)
			_EntFire(ent, "kill", "", 2.0)
			if i == 1 then _EntEmitSound(ent, "ambient/explosions/explode_7.wav") end
		end
	end
end

function Resurrect(userid)
	if not _PlayerInfo(userid, "alive") or not _PlayerInfo(userid, "connected") then return end
	_PlayerViewModelSequence(userid, 171) _PlayerSetWeaponSequence(userid, 16)
	_TraceLine(_PlayerGetShootPos(userid), _PlayerGetShootAng(userid), 250, userid)
	_EffectInit()
	 _EffectSetEnt(userid or 255)
	 _EffectSetOrigin(_PlayerGetShootPos(userid))
	 _EffectSetStart(_TraceEndPos())
	 _EffectSetScale(3)
	 _EffectSetMagnitude(3.0)
	_EffectDispatch("FadingLineTeamSolid")
	_EntEmitSound(userid, "ambient/levels/labs/teleport_preblast_suckin1.wav")
	local tab = _EntitiesFindInSphere(_TraceEndPos(), 256)
	for i=1, table.getn(tab) do
		if IsPlayer(tab[i]) then
			if _PlayerInfo(tab[i], "team") == _PlayerInfo(userid, "team") and not _PlayerInfo(tab[i], "alive") and not Gibbed[tab[i]] then
				local deadpos = _EntGetPos(tab[i])
				_PlayerRespawn(tab[i])
				_PlayerSetHealth(tab[i], 10)
				_EntSetPos(tab[i], deadpos)
				_EntEmitSound(tab[i], "ambient/energy/whiteflash.wav")
				_EffectInit()
				 _EffectSetEnt(userid or 255)
				 _EffectSetOrigin(vecAdd(deadpos, vector3(0,0,-50)))
				 _EffectSetStart(vecAdd(deadpos, vector3(0,0,5000)))
				 _EffectSetScale(70)
				 _EffectSetMagnitude(3.0)
				_EffectDispatch("FadingLineTeamSolid")
			end
		end
	end
end

function AcidStorm(userid)
	if not _PlayerInfo(userid, "alive") or not _PlayerInfo(userid, "connected") then return end
	_PlayerViewModelSequence(userid, 171) _PlayerSetWeaponSequence(userid, 16)
	_TraceLine(_PlayerGetShootPos(userid), _PlayerGetShootAng(userid), 1250, userid)
	_TraceLine(_TraceEndPos(), vector3(0,0,1), 4064, userid)
	local skypos = _TraceEndPos()
	local timepos = vecAdd(_TraceEndPos(), vector3(0,0,-8))
	AddTimer(0.05, 80, AcidDroplet, userid, timepos)
	local ent = _EntCreate("info_target")
	if ent > 0 then
		_EntSetPos(ent, _TraceEndPos())
		_EntSpawn(ent)
		_EntEmitSoundEx(ent, "ambient/atmosphere/thunder"..math.random(1,4)..".wav", 5.0, 1.0)
		_EntEmitSoundEx(ent, "ambient/atmosphere/thunder"..math.random(1,4)..".wav", 5.0, 0.9)
		_EntFire(ent, "kill", "", 0.75)
	end
	AR2Explosion(skypos)
	AddTimer(1, 2, AR2Explosion, skypos)
end

function AcidDroplet(userid, startpos)
	_TraceLine(startpos, vector3(0,0,-1), 4064, userid)
	local groundpos = _TraceEndPos()
	groundpos = vecAdd(groundpos, vector3(math.random(-50, 50), math.random(-50, 50), 0))
	startpos = vecAdd(startpos, vector3(math.random(-250, 250), math.random(-250, 250), 0))

	_EffectInit()
	 _EffectSetEnt(255)
	 _EffectSetOrigin(groundpos)
	 _EffectSetStart(startpos)
	 _EffectSetScale(8)
	 _EffectSetMagnitude(0.35)
	_EffectDispatch("FadingLineSolid")

	_TraceLine(startpos, vecNormalize(vecSub(groundpos, startpos)), 4064, userid)
	if _TraceHitNonWorld() then
		_RunString("_TraceAttack(".._TraceGetEnt()..", "..userid..", "..userid..", "..math.random(25, 30)..", 'weak')")
		if _TraceGetEnt() <= _MaxPlayers() then
			_EntEmitSound(_TraceGetEnt(), "player/pl_burnpain"..math.random(1,3)..".wav")
		end
	end
	
end

function AR2Explosion(pos)
	local ent = _EntCreate("env_ar2explosion")
	if ent > 0 then
		_EntSetPos(ent, pos)
		_EntSpawn(ent)
		_EntFire(ent, "explode", "", 0)
		_EntFire(ent, "kill", "", 0.25)
	end
end

function vecAverage(v1, v2)
	return vector3((v1.x+v2.x)/2, (v1.y+v2.y)/2, (v1.z+v2.z)/2)
end

Sprites = {}
function FireSprites(userid)
	if not _PlayerInfo(userid, "alive") or not _PlayerInfo(userid, "connected") then return end
	_PlayerViewModelSequence(userid, 171) _PlayerSetWeaponSequence(userid, 16)
	_TraceLine(_PlayerGetShootPos(userid), _PlayerGetShootAng(userid), 4064, userid)
	if not _TraceHit() then _TraceLine(_TraceEndPos(), _PlayerGetShootAng(userid), 4064, userid) end
	_EntEmitSound(userid, "ambient/fire/ignite.wav")
	local x = table.getn(Sprites)+1
	Sprites[x] = {}
	Sprites[x].Target = -1
	Sprites[x].Owner = userid
	Sprites[x].Sprites = 0
	local ents = _EntitiesFindInSphere(_TraceEndPos(), 364)
	for i=1, table.getn(ents) do
		if ents[i] <= _MaxPlayers() then
			if _PlayerInfo(ents[i], "team") ~= _PlayerInfo(userid, "team") then
				Sprites[x].Target = ents[i]
				break
			end
		end
	end

	local fireball = _EntCreate("rpg_missile")
	if fireball > 0 then
		_EntSetPos(fireball, vecAdd(_PlayerGetShootPos(userid), vecMul(_PlayerGetShootAng(userid), vector3(80,80,0))))
		local trail = _EntCreate("env_fire_trail")
		if trail > 0 then
			_EntSetPos(trail, _EntGetPos(fireball))
			_EntSpawn(trail)
			_EntSetParent(trail, fireball)
			_EntFire(trail, "kill", "", 10.0)
		end
		_EntSetKeyValue(fireball, "damage", "0")
		_EntSpawn(fireball)
		_EntSetOwner(fireball, userid)
		_EntSetName(fireball, "firesprite:"..x)
		_EntSetAng(fireball, vector3(0,0,1))
		_EntSetVelocity(fireball, vector3(0,0,1400))
		Sprites[x].Sprites = fireball
		AttatchTrail(fireball, "255 255 0")
	end
	Sprites[x].Timer = AddTimer(0.075, 0, SpriteTimer, x)
end

function SpriteTimer(x)
	if _EntGetType(Sprites[x].Sprites) ~= "rpg_missile" then HaltTimer(Sprites[x].Timer) Sprites[x] = nil return end
	if _EntExists(Sprites[x].Sprites) and string.sub(_EntGetName(Sprites[x].Sprites), 1, 10) == "firesprite" and Sprites[x].Sprites > 0 then
		if Sprites[x].Target <= 0 then
			local ents = _EntitiesFindInSphere(_EntGetPos(Sprites[x].Sprites), 512)
			for z in ents do
				if IsPlayer(ents[z]) then
					if _PlayerInfo(ents[z], "team") ~= _PlayerInfo(Sprites[x].Owner, "team") then
						Sprites[x].Target = ents[z]
					end
				end
			end
		end
		if Vehicles then
			if not _PlayerInfo(Sprites[x].Target, "alive") and Vehicles[Sprites[x].Target] == nil then Sprites[x].Target = -1 end
		else
			if not _PlayerInfo(Sprites[x].Target, "alive") or Sprites[x].Target == Sprites[x].Owner then Sprites[x].Target = -1 end
		end
		if Sprites[x].Target > 0 then
			local radtouse = 64
			if Vehicles then
				if Vehicles[Sprites[x].Target] ~= nil then radtouse = 128 end
			end
			if IsInRadius(Sprites[x].Sprites, Sprites[x].Target, radtouse) then
				SpriteExplode(Sprites[x].Sprites, Sprites[x].Owner, x)
				HaltTimer(Sprites[x].Timer)
				Sprites[x] = nil
				return
			end
		end
		if Sprites[x].Target > 0 then
			if IsInRadius(Sprites[x].Sprites, Sprites[x].Target, 256) then
				_EntSetAng(Sprites[x].Sprites, vecAverage(_EntGetAng(Sprites[x].Sprites), vecNormalize(vecSub(_EntGetPos(Sprites[x].Target), _EntGetPos(Sprites[x].Sprites)))))
			else
				_EntSetAng(Sprites[x].Sprites, vecAverage(_EntGetAng(Sprites[x].Sprites), vecAverage(_EntGetAng(Sprites[x].Sprites), vecAverage(_EntGetAng(Sprites[x].Sprites), vecNormalize(vecSub(_EntGetPos(Sprites[x].Target), _EntGetPos(Sprites[x].Sprites)))))))
			end
			_EntSetVelocity(Sprites[x].Sprites, vecMul(_EntGetAng(Sprites[x].Sprites), vector3(900,900,900)))
		end
		_TraceLine(_EntGetPos(Sprites[x].Sprites), _EntGetAng(Sprites[x].Sprites), 90, Sprites[x].Sprites)
		if _TraceHit() then
			--_EntSetPos(Sprites[x].Sprites, _TraceEndPos())
			SpriteExplode(Sprites[x].Sprites, Sprites[x].Owner, x)
			HaltTimer(Sprites[x].Timer)
			Sprites[x] = nil
		end
	end
end

function SpriteExplode(prop, userid, x)
	local ents = _EntitiesFindInSphere(_EntGetPos(prop), 165)
	for i in ents do
		if _phys.HasPhysics(ents[i]) then
			if IsVisible(_EntGetPos(prop), _EntGetPos(ents[i]), prop) then
				if Vehicles then
					if Vehicles[ents[i]] ~= nil then
						_TraceAttack(ents[i], userid, userid, 50)
					else
						_TraceAttack(ents[i], userid, userid, (90-(math.abs(vecLength(vecSub(_EntGetPos(prop),_EntGetPos(ents[i])))))*0.4)*0.3)
					end
				else
					_TraceAttack(ents[i], userid, userid, (90-(math.abs(vecLength(vecSub(_EntGetPos(prop),_EntGetPos(ents[i])))))*0.4)*0.3)
				end
			end
		end
	end
	local ent = _EntCreate("env_sprite")
	if ent > 0 then
		_EntSetKeyValue(ent, "model", "sprites/splodesprite.spr")
		_EntSetKeyValue(ent, "rendermode", "5")
		_EntSetKeyValue(ent, "scale", "0.5")
		_EntSetKeyValue(ent, "spawnflags", "1")
		_EntSetPos(ent, _EntGetPos(prop))
		_EntSpawn(ent)
		_EntFire(ent, "showsprite", "", 0)
		_EntFire(ent, "setscale", "0.5", 0.25)
		_EntFire(ent, "setscale", "0.65", 0.5)
		_EntFire(ent, "setscale", "0.85", 0.75)
		_EntFire(ent, "setscale", "1.0", 1.0)
		_EntFire(ent, "setscale", "0.75", 1.25)
		_EntFire(ent, "setscale", "0.5", 1.5)
		_EntFire(ent, "setscale", "0.125", 1.75)
		_EntFire(ent, "hidesprite", "", 1.9)
		_EntFire(ent, "kill", "", 2.0)
	end	
	_util.ScreenShake(_EntGetPos(prop), math.random(15,35), 160.0, 1.15, 140)
	if x then
		_EntSetVelocity(Sprites[x].Sprites, vecMul(_EntGetAng(Sprites[x].Sprites), vector3(10000,10000,10000)))
	end
end

function FirelessExplode(prop, userid)
	local ents = _EntitiesFindInSphere(_EntGetPos(prop), 165)
	for i=1, table.getn(ents) do
		if _phys.HasPhysics(ents[i]) then
			_TraceAttack(ents[i], userid, userid, (90-(math.abs(vecLength(vecSub(_EntGetPos(prop),_EntGetPos(ents[i])))))*0.4)*0.375)
		end
	end
	
	-- Fireless explosion.
	local exp = _EntCreate("env_explosion")
	if exp > 0 then
		_EntSetKeyValue(exp, "spawnflags", "17")
		_EntSetPos(exp, _EntGetPos(prop))
		_EntSpawn(exp)
		_EntFire(exp, "explode", "", 0)
		_EntFire(exp, "kill", "", 0.1)
	end
	_util.ScreenShake(_EntGetPos(prop), math.random(15,35), 160.0, 1.15, 140)
end

function Typhoon(userid)
	if not _PlayerInfo(userid, "alive") or not _PlayerInfo(userid, "connected") then return end
	_PlayerViewModelSequence(userid, 171) _PlayerSetWeaponSequence(userid, 16)
	_TraceLine(vecAdd(_EntGetPos(userid), vector3(0,0,16)), vector3(0,0,-1), 4064, userid)
	local posit = _TraceEndPos()
	TyphoonWinds(userid, posit)
	local tempent = _EntCreate("info_target")
	if tempent > 0 then
		_EntSetPos(tempent, posit)
		_EntSpawn(tempent)
		_EntFire(tempent, "kill", "", 0.5)
	end
	_EntEmitSoundEx(tempent, "ambient/wind/windgust_strong.wav", 5.0, 1.0)
	_EntEmitSound(tempent, "ambient/wind/windgust.wav")
	AddTimer(0.5, 20, TyphoonWinds, userid, posit)
	_PlayerFreeze(userid, true)
	_PlayerLockInPlace(userid, true)
	AddTimer(12, 1, _PlayerFreeze, userid, false)
	AddTimer(12, 1, _PlayerLockInPlace, userid, false)
	local tempx = _EntCreate("env_smokestack")
	if tempx > 0 then
		_EntSetKeyValue(tempx, "InitialState", "0" )
		_EntSetKeyValue(tempx, "BaseSpread", "512" )
		_EntSetKeyValue(tempx, "SpreadSpeed", "512" )
		_EntSetKeyValue(tempx, "Speed", "512" )
		_EntSetKeyValue(tempx, "startsize", "64" )
		_EntSetKeyValue(tempx, "EndSize", "128" )
		_EntSetKeyValue(tempx, "Rate", "55" )
		_EntSetKeyValue(tempx, "JetLength", "1500" )
		_EntSetKeyValue(tempx, "SmokeMaterial", "particle/SmokeStack.vmt" )
		_EntSetKeyValue(tempx, "twist", "512" )
		_EntSetKeyValue(tempx, "roll", "64" )
		_EntSetKeyValue(tempx, "rendercolor", "50 50 50")
		_EntSetKeyValue(tempx, "renderamt", "210" )
		_EntSetPos(tempx, _EntGetPos(userid))
		_EntSpawn(tempx)
		_EntFire(tempx, "TurnOn", "", 0)
		_EntFire(tempx, "TurnOff", "", 12)
		_EntFire(tempx, "kill", "", 15)
	end
	tempx = _EntCreate("env_smokestack")
	if tempx > 0 then
		_EntSetAng(tempx, vector3(0,0,-1))
		_EntSetKeyValue(tempx, "InitialState", "0" )
		_EntSetKeyValue(tempx, "BaseSpread", "256" )
		_EntSetKeyValue(tempx, "SpreadSpeed", "64" )
		_EntSetKeyValue(tempx, "Speed", "200" )
		_EntSetKeyValue(tempx, "startsize", "120" )
		_EntSetKeyValue(tempx, "EndSize", "160" )
		_EntSetKeyValue(tempx, "Rate", "25" )
		_EntSetKeyValue(tempx, "JetLength", "1500" )
		_EntSetKeyValue(tempx, "SmokeMaterial", "particle/SmokeStack.vmt" )
		_EntSetKeyValue(tempx, "twist", "512" )
		_EntSetKeyValue(tempx, "roll", "64" )
		_EntSetKeyValue(tempx, "rendercolor", "100 100 100")
		_EntSetKeyValue(tempx, "renderamt", "210" )
		_EntSetPos(tempx, _EntGetPos(userid))
		_EntSpawn(tempx)
		_EntFire(tempx, "TurnOn", "", 0)
		_EntFire(tempx, "TurnOff", "", 12)
		_EntFire(tempx, "kill", "", 15)
	end
end

function TyphoonWinds(userid, basepos)
	for i=1, 5 do
		local endpos = vecAdd(basepos, vector3(0, 0, (i*250)-250))
		local ranpos = vecAdd(endpos, vector3(math.random(-225, 225), math.random(-225, 225), 0))
		for _, ent in _EntitiesFindInSphere(endpos, 400) do
			if ent ~= userid and _phys.HasPhysics(ent) then
				_TraceAttack(ent, userid, userid, (405-Distance(ranpos, _EntGetPos(ent)))*0.01)
				if IsPlayer(ent) then
					if _PlayerInfo(ent, "team") ~= _PlayerInfo(userid, "team") then
						local ppos = _EntGetPos(ent)
						_EntSetVelocity(ent, vecAdd(vecAdd(_EntGetVelocity(ent), vector3(0, 0, 110)), vecMul(vecNormalize(vecSub(ppos, ranpos)), -75)))
					end
				elseif _EntGetName(ent) ~= "frozenprop" and _phys.HasPhysics(ent) then
					local ppos = _EntGetPos(ent)
					_phys.ApplyForceCenter(ent, vecAdd(vector3(0, 0, _phys.GetMass(ent) * 120), vecMul(vecNormalize(vecSub(ppos, ranpos)), _phys.GetMass(ent) * -190)))
				end
			end
		end
	end
end

function Leech(userid)
	if not _PlayerInfo(userid, "alive") or not _PlayerInfo(userid, "connected") then return end
	_PlayerViewModelSequence(userid, 171) _PlayerSetWeaponSequence(userid, 16)
	_TraceLine(_PlayerGetShootPos(userid), _PlayerGetShootAng(userid), 1000, userid)

	local tempent = _EntCreate("info_target")
	if tempent > 0 then
		_EntSetPos(tempent, _TraceEndPos())
		_EntSetName(tempent, _PlayerInfo(userid, "name").."temptar")
		_EntSpawn(tempent)
		_EntFire(tempent, "kill", "", 0.6)
	end

	if _TraceHitNonWorld() then
		if _phys.HasPhysics(_TraceGetEnt()) then
			_EntEmitSound(_TraceGetEnt(), "weapons/physcannon/energy_disintegrate5.wav")
			_TraceAttack(_TraceGetEnt(), userid, userid, 50)
			if _TraceGetEnt() <= _MaxPlayers() then
				if _PlayerInfo(_TraceGetEnt(), "team") ~= _PlayerInfo(userid, "team") then
					_PlayerSetHealth(userid, _PlayerInfo(userid, "health")+50)
					if _PlayerInfo(userid, "health") > _EntGetMaxHealth(userid) then
						_PlayerSetHealth(userid, _EntGetMaxHealth(userid))
					end
				end
			end
		end
	else
		_EntEmitSound(tempent, "weapons/physcannon/energy_disintegrate5.wav")
	end

	local laser = _EntCreate("env_laser")
	if laser > 0 then
		_EntSetPos(laser, _PlayerGetShootPos(userid))
		_EntSetKeyValue(laser, "renderamt", "170")
		_EntSetKeyValue(laser, "rendercolor", "255 0 0")
		_EntSetKeyValue(laser, "width", "4")
		_EntSetKeyValue(laser, "texture", "sprites/laserbeam.spr")
		_EntSetKeyValue(laser, "TextureScroll", "35")
		_EntSetKeyValue(laser, "damage", "0")
		_EntSetKeyValue(laser, "renderfx", "0")
		_EntSetKeyValue(laser, "TextureScroll", "35")
		_EntSetKeyValue(laser, "LaserTarget", _PlayerInfo(userid, "name").."temptar")
		_EntSetKeyValue(laser, "NoiseAmplitude", "2")
		_EntSetKeyValue(laser, "spawnflags", "33")
		_EntSpawn(laser)
		_EntFire(laser, "kill", "", 0.45)
	end
end

_EntPrecacheModel("models/props_lab/blastdoor001a.mdl")
function Barrier(userid)
	if not _PlayerInfo(userid, "alive") or not _PlayerInfo(userid, "connected") then return end
	_PlayerViewModelSequence(userid, 171) _PlayerSetWeaponSequence(userid, 16)
	local shield = _EntCreate("prop_physics")
	if shield > 0 then
		_EntSetKeyValue(shield, "model", "models/props_lab/blastdoor001a.mdl")
		_EntSetOwner(shield, userid)
		_EntitySetPhysicsAttacker(shield, userid)
		_EntSetPos(shield, vecAdd(_EntGetPos(userid), vecMul(_PlayerGetShootAng(userid),vector3(40,40,40))))
		_EntSetAng(shield, _PlayerGetShootAng(userid))
		_EntSpawn(shield)
		_phys.EnableGravity(shield, false)
		_phys.EnableMotion(shield, false)
		_EntSetMaterial(shield, "models/props_lab/Tank_Glass001")
		_EntFire(shield, "color", "0 0 255", 0)
		_EntSetCollisionGroup(shield, COLLISION_GROUP_PROJECTILE)
		_EntFire(shield, "break", "", 3.5)
		_EntFire(shield, "kill", "", 3.55)
	end
end

function JoltTimer(userid, targ, laser, tesla)
	if _EntGetType(targ) ~= "info_target" then return end
	_EntSetPos(targ, vecAdd(_EntGetPos(targ), vector3(math.random(-30, 30), math.random(-30, 30), 0)))
	_EntSetPos(laser, vecAdd(_EntGetPos(laser), vector3(math.random(-30, 30), math.random(-30, 30), 0)))
	if math.random(1, 10) > 8 then
		_EntFire(tesla, "DoSpark", "", 0)
	end
	_TraceLine(_EntGetPos(laser), vecNormalize(vecSub(_EntGetPos(targ), _EntGetPos(laser))), 9999, userid)
	if _TraceHitNonWorld() then
		if _phys.HasPhysics(_TraceGetEnt()) then
			local bonus = _EntGetWaterLevel(_TraceGetEnt())*7
			_RunString("_TraceAttack(".._TraceGetEnt()..", "..userid..", "..userid..", "..math.random(21, 27)+bonus..", 'weak')")
		end
	end
end

function Jolt(userid)
	if not _PlayerInfo(userid, "alive") or not _PlayerInfo(userid, "connected") then return end
	_PlayerViewModelSequence(userid, 171) _PlayerSetWeaponSequence(userid, 16)
	for o=1, 6 do
		_TraceLine(_PlayerGetShootPos(userid), _PlayerGetShootAng(userid), 1000, userid)
		_TraceLine(_TraceEndPos(), vector3(0,0,1), 9999, userid)
		local toppos = vecAdd(_TraceEndPos(), vector3(math.random(-100, 100), math.random(-100, 100), -5))
		_TraceLine(toppos, vector3(0,0,-1), 9999, userid)
		local bottompos = vecAdd(_TraceEndPos(), vector3(math.random(-100, 100), math.random(-100, 100), 0))
		local rand = math.random(1, 9999)

		local info = _EntCreate("info_target")
		if info > 0 then
			_EntSetPos(info, bottompos)
			_EntSpawn(info)
			_EntSetName(info, _PlayerInfo(userid, "name").."tempjolttarget"..rand)
			_EntFire(info, "kill", "", 1.25)
			_EntEmitSound(info, "nox/lightning_impact.wav")
			_EntEmitSound(info, "ambient/levels/labs/electric_explosion"..math.random(1,5)..".wav")
		end

		local laser = _EntCreate("env_laser")
		if laser > 0 then
			_EntSetPos(laser, toppos)
			_EntSetKeyValue(laser, "renderamt", "255")
			_EntSetKeyValue(laser, "rendercolor", "255 50 10")
			_EntSetKeyValue(laser, "width", "38")
			_EntSetKeyValue(laser, "texture", "sprites/bluelight1.spr")
			_EntSetKeyValue(laser, "TextureScroll", "10")
			_EntSetKeyValue(laser, "damage", "0")
			_EntSetKeyValue(laser, "renderfx", "15")
			_EntSetKeyValue(laser, "LaserTarget", _PlayerInfo(userid, "name").."tempjolttarget"..rand)
			_EntSetKeyValue(laser, "NoiseAmplitude", "4")
			_EntSetKeyValue(laser, "spawnflags", "33")
			_EntSpawn(laser)
			_EntSetName(laser, _PlayerInfo(userid, "name").."tempjoltstart"..rand)
			_EntSetOwner(laser, userid)
			_EntFire(laser, "kill", "", 2.0)
		end
		local effect2 = _EntCreate("point_tesla")
		if effect2 > 0 then
			_EntSetKeyValue(effect2, "m_flRadius", "90")
			_EntSetKeyValue(effect2, "m_SoundName", "DoSpark")
			_EntSetKeyValue(effect2, "m_Color", "255 255 255")
			_EntSetKeyValue(effect2, "texture", "effects/laser1.vmt")
			_EntSetKeyValue(effect2, "beamcount_min", "8")
			_EntSetKeyValue(effect2, "beamcount_max", "12")
			_EntSetKeyValue(effect2, "thick_min", "7")
			_EntSetKeyValue(effect2, "thick_max", "16")
			_EntSetKeyValue(effect2, "lifetime_min", "0.3")
			_EntSetKeyValue(effect2, "lifetime_max", "0.9")
			_EntSetKeyValue(effect2, "interval_min", "0.05")
			_EntSetKeyValue(effect2, "interval_max", "0.2")
			_EntSetPos(effect2, _EntGetPos(info))
			_EntSetParent(effect2, info)
			_EntSpawn(effect2)
		end
		if laser > 0 and info > 0 and effect2 > 0 then
			AddTimer(0.05, 40, JoltTimer, userid, info, laser, effect2)
		end
	end
end

function StaticBall(userid)
	if not _PlayerInfo(userid, "alive") or not _PlayerInfo(userid, "connected") then return end
	local fireball = _EntCreate("physics_prop")
	_EntPrecacheModel("models/props/cs_italy/orange.mdl")
	if fireball > 0 then
		_EntSetPos(fireball, _PlayerGetShootPos(userid))
		_EntSetAng(fireball, _PlayerGetShootAng(userid))
		_EntSetModel(fireball, "models/props/cs_italy/orange.mdl")
		_EntSetName(fireball, "energybolt")
		_EntSetOwner(fireball, userid)
		_EntSpawn(fireball)
		_EntSetMaterial(prop, "gmod/shiny")
		_EntitySetPhysicsAttacker(fireball, userid)
        _phys.ApplyForceCenter(fireball, vecMul(_PlayerGetShootAng(userid), vector3(70000, 70000, 70000)))
		_phys.EnableGravity(fireball, false)
		_EntFire(fireball, "sethealth", "99999", 0)
		_EntFire(fireball, "kill", "", 6)
		_EntSetMaterial(fireball, "models/props_combine/com_shield001a")
		local effect2 = _EntCreate("point_tesla")
		if effect2 > 0 then
			_EntSetKeyValue(effect2, "m_flRadius", "64")
			_EntSetKeyValue(effect2, "m_SoundName", "DoSpark")
			_EntSetKeyValue(effect2, "texture", "sprites/laserbeam.spr")
			_EntSetKeyValue(effect2, "beamcount_min", "1")
			_EntSetKeyValue(effect2, "beamcount_max", "5")
			_EntSetKeyValue(effect2, "thick_min", "16")
			_EntSetKeyValue(effect2, "thick_max", "24")
			_EntSetKeyValue(effect2, "lifetime_min", "0.2")
			_EntSetKeyValue(effect2, "lifetime_max", "0.5")
			_EntSetKeyValue(effect2, "interval_min", "0.1")
			_EntSetKeyValue(effect2, "interval_max", "0.3")
			_EntSetPos(effect2, _EntGetPos(fireball))
			_EntSpawn(effect2)
			_EntSetParent(effect2, fireball)
			_EntActivate(effect2)
			_EntFire(effect2, "TurnOn", "", 0)
			_EntFire(effect2, "kill", "", 5.9)
		end
		FireBallTimers[fireball] = AddTimer(0.2, 25, StaticBallCheckHit, fireball, userid)
	end
end

EnergyBolts = {}
function EnergyBolt(userid)
	if not _PlayerInfo(userid, "alive") or not _PlayerInfo(userid, "connected") then return end
	_PlayerViewModelSequence(userid, 171) _PlayerSetWeaponSequence(userid, 16)
	_EntEmitSoundEx(userid, "ambient/levels/labs/electric_explosion1.wav", 1, 0.85)
	local ang = _PlayerGetShootAng(userid)
	local pos = _PlayerGetShootPos(userid)
	if pos == nil or ang == nil then return end
	local i = table.getn(EnergyBolts)+1
	EnergyBolts[i] = {}
	EnergyBolts[i].pos = pos
	EnergyBolts[i].ang = ang
	EnergyBolts[i].owner = userid
	EnergyBolts[i].timer = AddTimer(0.075, 0, EnergyBoltTick, i)
	EnergyBolts[i].reps = 0
	local lock = 0
	local rep = 1
	while rep < 50 and lock <= 0 do
		_TraceLine(pos, ang, rep*64, userid)
		local ents = _EntitiesFindInSphere(_TraceEndPos(), 128)
		for k,i in ents do
			if _EntGetType(i) == "player" then
				if _PlayerInfo(i,"team") ~= _PlayerInfo(userid,"team") and _PlayerInfo(i,"alive") then
					lock = i
				end
			end
		end
		rep = rep+1
	end
	EnergyBolts[i].target = lock
end

function EnergyBoltTick(i)
	_TraceLine(EnergyBolts[i].pos, EnergyBolts[i].ang, 50000, EnergyBolts[i].owner)
	if not _TraceHit() then
		HaltTimer(EnergyBolts[i].timer)
		EnergyBolts[i] = nil
		return
	else
		_TraceLine(EnergyBolts[i].pos, EnergyBolts[i].ang, 125, EnergyBolts[i].owner)
		if _TraceHit() then
			for _, ent in _EntitiesFindInSphere(_TraceEndPos(), 50) do
				if _phys.HasPhysics(ent) then
					_TraceAttack(ent, EnergyBolts[i].owner, EnergyBolts[i].owner, math.random(18, 24))
				end
			end
			EnergyBoltExplodeEffects(i)
			HaltTimer(EnergyBolts[i].timer)
			EnergyBolts[i] = nil
			return
		else
			local hitz = false
			for _, ent in _EntitiesFindInSphere(EnergyBolts[i].pos, 22) do
				if ent ~= EnergyBolts[i].owner and IsPlayerOnline(ent) then
					_TraceAttack(ent, EnergyBolts[i].owner, EnergyBolts[i].owner, math.random(18, 24))
					hitz = true
				end
			end
			if hitz then
				EnergyBoltExplodeEffects(i)
				HaltTimer(EnergyBolts[i].timer)
				EnergyBolts[i] = nil
				return
			end
			local ent = _EntCreate("env_sprite")
			if ent > 0 then
				_EntSetKeyValue(ent, "model", "sprites/blueglow1.spr")
				_EntSetKeyValue(ent, "rendermode", "5")
				_EntSetKeyValue(ent, "scale", "0.9")
				_EntSetKeyValue(ent, "spawnflags", "1")
				_EntSetPos(ent, EnergyBolts[i].pos)
				_EntSpawn(ent)
				_EntFire(ent, "showsprite", "", 0)
				_EntFire(ent, "setscale", "0.2", 0.1)
				_EntFire(ent, "kill", "", 0.6)
			end
			EnergyBolts[i].pos = vecAdd(EnergyBolts[i].pos, vecMul(EnergyBolts[i].ang, vector3(80,80,80)))
			if EnergyBolts[i].target > 0 and EnergyBolts[i].reps < 66 then
				if _PlayerInfo(EnergyBolts[i].target, "alive") then
					if Distance(_EntGetPos(EnergyBolts[i].target), EnergyBolts[i].pos) < 64 then
						EnergyBolts[i].ang = vecAverage(EnergyBolts[i].ang, vecNormalize(vecSub(vecAdd(_EntGetPos(EnergyBolts[i].target), vector3(0,0,48)), EnergyBolts[i].pos)))
					else
						EnergyBolts[i].ang = vecAverage(EnergyBolts[i].ang, vecAverage(EnergyBolts[i].ang, vecAverage( EnergyBolts[i].ang, vecNormalize(vecSub(vecAdd(_EntGetPos(EnergyBolts[i].target), vector3(0,0,48)), EnergyBolts[i].pos)))))
					end
					EnergyBolts[i].reps = EnergyBolts[i].reps+1
				else
					EnergyBolts[i].target = 0
				end
			end
		end
	end
end

function EnergyBoltExplodeEffects(i)
	local effect = _EntCreate("env_explosion")
	if effect > 0 then
		_EntSetKeyValue(effect, "iMagnitute", "1")
		_EntSetKeyValue(effect, "spawnflags", "349")
		_EntSetKeyValue(effect, "fireballsprite", "sprites/blueflare1.spr")
		_EntSetPos(effect, EnergyBolts[i].pos)
		_EntSpawn(effect)
		_EntFire(effect, "Explode", "", 0)
		_EntFire(effect, "kill", "", 0.1)
	end
	local effect2 = _EntCreate("point_tesla")
	if effect2 > 0 then
		_EntSetKeyValue(effect2, "m_flRadius", "50")
		_EntSetKeyValue(effect2, "m_SoundName", "DoSpark")
		_EntSetKeyValue(effect2, "m_Color", "255 255 255")
		_EntSetKeyValue(effect2, "texture", "effects/laser1.vmt")
		_EntSetKeyValue(effect2, "beamcount_min", "8")
		_EntSetKeyValue(effect2, "beamcount_max", "12")
		_EntSetKeyValue(effect2, "thick_min", "2")
		_EntSetKeyValue(effect2, "thick_max", "12")
		_EntSetKeyValue(effect2, "lifetime_min", "0.3")
		_EntSetKeyValue(effect2, "lifetime_max", "0.9")
		_EntSetKeyValue(effect2, "interval_min", "0.1")
		_EntSetKeyValue(effect2, "interval_max", "0.25")
		_EntSetPos(effect2, _TraceEndPos())
		_EntSpawn(effect2)
		_EntEmitSound(effect2, "ambient/levels/labs/electric_explosion"..math.random(1,5)..".wav")
		_EntFire(effect2, "DoSpark", "", 0.1)
		_EntFire(effect2, "DoSpark", "", 0.2)
		_EntFire(effect2, "kill", "", 0.4)
	end
	_EffectInit()
	_EffectSetOrigin(EnergyBolts[i].pos)
	_EffectSetStart(EnergyBolts[i].pos)
	_EffectSetScale(70)
	_EffectSetMagnitude(10)
	_EffectSetRadius(10)
	_EffectDispatch("cball_explode")
	_EffectDispatch("cball_explode")
end

function Effect(owner, typeof, pos, scale, mag, radius, normal)
	_EffectInit()
	 _EffectSetEnt(owner)
	 _EffectSetOrigin(pos)
	 if normal then _EffectSetNormal(normal) end
	 _EffectSetStart(pos)
	 _EffectSetScale(scale)
	 _EffectSetMagnitude(mag)
	 _EffectSetRadius(radius)
	_EffectDispatch(typeof)
end

function StaticBallCheckHit(prop, userid)
	if not _EntGetName(prop) == "energybolt" then HaltTimer(FireBallTimers[prop]) return end
	_TraceLine(_EntGetPos(prop), _EntGetForwardVector(prop), 60, prop)
	if _TraceHitWorld() then
		HaltTimer(FireBallTimers[prop])
		local effect = _EntCreate("env_explosion")
		if effect > 0 then
			_EntSetKeyValue(effect, "iMagnitute", "1")
			_EntSetKeyValue(effect, "spawnflags", "349")
			_EntSetKeyValue(effect, "fireballsprite", "sprites/blueflare1.spr")
			_EntSetPos(effect, _EntGetPos(prop))
			_EntSpawn(effect)
			_EntFire(effect, "Explode", "", 0)
			_EntFire(effect, "kill", "", 0.1)
		end
		local effect2 = _EntCreate("point_tesla")
		if effect2 > 0 then
			_EntSetKeyValue(effect2, "m_flRadius", "50")
			_EntSetKeyValue(effect2, "m_SoundName", "DoSpark")
			_EntSetKeyValue(effect2, "texture", "sprites/laserbeam.spr")
			_EntSetKeyValue(effect2, "beamcount_min", "1")
			_EntSetKeyValue(effect2, "beamcount_max", "5")
			_EntSetKeyValue(effect2, "thick_min", "5")
			_EntSetKeyValue(effect2, "thick_max", "12")
			_EntSetKeyValue(effect2, "lifetime_min", "0.2")
			_EntSetKeyValue(effect2, "lifetime_max", "0.5")
			_EntSetKeyValue(effect2, "interval_min", "0.1")
			_EntSetKeyValue(effect2, "interval_max", "0.3")
			_EntSetPos(effect2, vecAdd(_EntGetPos(prop), vector3(0,0,32)))
			_EntSpawn(effect2)
			_EntFire(effect2, "TurnOn", "", 0)
			_EntFire(effect2, "TurnOff", "", 0.5)
			_EntFire(effect2, "kill", "", 0.6)
		end
		_EntEmitSound(prop, "ambient/levels/labs/electric_explosion"..math.random(1,5)..".wav")
		_EntRemove(prop)
		return
	end
	local tab = _EntitiesFindInSphere(_EntGetPos(prop), 120)
	local tempent
	local num
	local laser
	for i=1, table.getn(tab) do
		if tab[i] ~= userid and tab[i] ~= prop and ValidFireBall(tab[i]) then
			_TraceAttack(tab[i], userid, userid, math.random(8,13))
			--_phys.EnableMotion(prop, false)
			tempent = _EntCreate("info_target")
			num = math.random(1, 9999)
			if tempent > 0 then
				_EntSetPos(tempent, _EntGetPos(tab[i]))
				_EntSetName(tempent, _PlayerInfo(userid, "name").."tempenergytarget"..num)
				_EntSpawn(tempent)
				_EntFire(tempent, "kill", "", 0.41)
			end
		if i < 5 then
			laser = _EntCreate("env_laser")
				if laser > 0 then
					_EntSetPos(laser, vecAdd(_EntGetPos(prop), vector3(0,0,-15)))
					_EntSetKeyValue(laser, "renderamt", "170")
					_EntSetKeyValue(laser, "rendercolor", "190 200 255")
					_EntSetKeyValue(laser, "width", "2")
					_EntSetKeyValue(laser, "texture", "sprites/laserbeam.spr")
					_EntSetKeyValue(laser, "TextureScroll", "35")
					_EntSetKeyValue(laser, "damage", "0")
					_EntSetKeyValue(laser, "renderfx", "0")
					_EntSetKeyValue(laser, "TextureScroll", "80")
					_EntSetKeyValue(laser, "LaserTarget", _PlayerInfo(userid, "name").."tempenergytarget"..num)
					_EntSetKeyValue(laser, "NoiseAmplitude", "2")
					_EntSetKeyValue(laser, "spawnflags", "1")
					_EntSpawn(laser)
					_EntSetOwner(laser, userid)
					_EntFire(laser, "kill", "", 0.2)
				end
			end
			laser = 0
		end
		tempent = 0
		num = 0
	end
end

function DeathRay(userid)
	if not _PlayerInfo(userid, "alive") or not _PlayerInfo(userid, "connected") then return end
	_PlayerViewModelSequence(userid, 171) _PlayerSetWeaponSequence(userid, 16)
	_TraceLine(_PlayerGetShootPos(userid), _PlayerGetShootAng(userid), 4064, userid)

	local tempent = _EntCreate("info_target")
	if tempent > 0 then
		_EntSetPos(tempent, _TraceEndPos())
		_EntSetName(tempent, _PlayerInfo(userid, "name").."temptarget")
		_EntSpawn(tempent)
		_EntFire(tempent, "kill", "", 0.35)
	end
	local effect2 = _EntCreate("point_tesla")
	if effect2 > 0 then
		_EntSetKeyValue(effect2, "m_flRadius", "60")
		_EntSetKeyValue(effect2, "m_SoundName", "DoSpark")
		_EntSetKeyValue(effect2, "m_Color", "255 0 255")
		_EntSetKeyValue(effect2, "texture", "effects/laser1.vmt")
		_EntSetKeyValue(effect2, "beamcount_min", "10")
		_EntSetKeyValue(effect2, "beamcount_max", "16")
		_EntSetKeyValue(effect2, "thick_min", "13")
		_EntSetKeyValue(effect2, "thick_max", "32")
		_EntSetKeyValue(effect2, "lifetime_min", "0.2")
		_EntSetKeyValue(effect2, "lifetime_max", "0.6")
		_EntSetKeyValue(effect2, "interval_min", "0.1")
		_EntSetKeyValue(effect2, "interval_max", "0.25")
		_EntSetPos(effect2, _TraceEndPos())
		_EntSpawn(effect2)
		_EntFire(effect2, "DoSpark", "", 0.1)
		_EntFire(effect2, "DoSpark", "", 0.3)
		_EntFire(effect2, "DoSpark", "", 0.2)
		_EntFire(effect2, "kill", "", 0.4)
	end

	if _TraceHitNonWorld() then
		if _phys.HasPhysics(_TraceGetEnt()) then
			_EntEmitSound(_TraceGetEnt(), "weapons/physcannon/energy_disintegrate5.wav")
			_TraceAttack(_TraceGetEnt(), userid, userid, math.random(60,75), "bullet")
		end
	else
		_EntEmitSound(tempent, "weapons/physcannon/energy_disintegrate5.wav")
	end

	local laser = _EntCreate("env_laser")
	if laser > 0 then
		_EntSetPos(laser, _PlayerGetShootPos(userid))
		_EntSetKeyValue(laser, "renderamt", "170")
		_EntSetKeyValue(laser, "rendercolor", "255 0 255")
		_EntSetKeyValue(laser, "width", "6")
		_EntSetKeyValue(laser, "texture", "sprites/laserbeam.spr")
		_EntSetKeyValue(laser, "TextureScroll", "35")
		_EntSetKeyValue(laser, "damage", "0")
		_EntSetKeyValue(laser, "renderfx", "0")
		_EntSetKeyValue(laser, "TextureScroll", "35")
		_EntSetKeyValue(laser, "LaserTarget", _PlayerInfo(userid, "name").."temptarget")
		_EntSetKeyValue(laser, "NoiseAmplitude", "1")
		_EntSetKeyValue(laser, "spawnflags", "33")
		_EntSpawn(laser)
		_EntFire(laser, "kill", "", 0.3)
	end
	local normal = vecNormalize(vecSub(_EntGetPos(userid), _TraceEndPos()))
	Effect(userid, "cball_bounce", _TraceEndPos(), 40, 1.5, 40, normal)
	Effect(userid, "ThumperDust", _TraceEndPos(), 40, 1.5, 40, normal)
end

MakeFunction("MeteorExplode")
function MeteorExplode(Activator, Caller)
	if _EntGetType(Caller) ~= "prop_physics" then return end
	local prop = Caller
	local userid = _EntGetOwner(Caller)
	local ents = _EntitiesFindInSphere(_EntGetPos(prop), 165)
	for i, ent in ents do
		if _phys.HasPhysics(ent) then
			_TraceAttack(ent, userid, userid, (170-Distance(_EntGetPos(prop), _EntGetPos(ent)))*0.45)
		end
	end
	NoDamageLuaExplosion(_EntGetPos(prop))
	for i=1, 3 do
		local ent = _EntCreate("env_sprite")
		if ent > 0 then
			_EntSetKeyValue(ent, "model", "sprites/fire.spr")
			_EntSetKeyValue(ent, "rendermode", "5")
			_EntSetKeyValue(ent, "scale", "1.0")
			_EntSetKeyValue(ent, "spawnflags", "1")
			_EntSetPos(ent, vecAdd(vector3(0,0,(i*35)), _EntGetPos(prop)))
			_EntSpawn(ent)
			_EntFire(ent, "showsprite", "", 0)
			_EntFire(ent, "setscale", "1.5", 0.25)
			_EntFire(ent, "setscale", "1.8", 0.5)
			_EntFire(ent, "setscale", "2.25", 0.75)
			_EntFire(ent, "setscale", "3.0", 1.0)
			_EntFire(ent, "setscale", "2.25", 1.25)
			_EntFire(ent, "setscale", "1.8", 1.5)
			_EntFire(ent, "setscale", "0.5", 1.75)
			_EntFire(ent, "hidesprite", "", 1.9)
			_EntFire(ent, "kill", "", 2.0)
		end
	end
	_util.ScreenShake(_EntGetPos(prop), math.random(15,35), 160.0, 1.15, 140)
	local ppos = vecAdd(_EntGetPos(prop), vector3(0,0,100))
	Effect(userid, "HelicopterMegaBomb", _EntGetPos(prop), 40, 2, 40)
	_EntRemove(prop)
	for i=1, math.random(5, 7) do
		local pos = vecAdd(ppos, vector3(math.random(-150, 150), math.random(-150, 150), 0))
		_TraceLine(pos, vector3(0,0,-1), 185, prop)
		if _TraceHit() then
			local ent = _EntCreate("env_fire")
			if ent > 0 then
				_EntSetPos(ent, _TraceEndPos())
				_EntSetKeyValue(ent, "health", math.random(3, 6))
				_EntSetKeyValue(ent, "firesize", math.random(52, 92))
				_EntSetKeyValue(ent, "damagescale", math.random(15, 25))
				_EntSetKeyValue(ent, "spawnflags", "2")
				_EntSpawn(ent)
				_EntFire(ent, "Enable", "", 0)
				_EntFire(ent, "StartFire", "", 0.1)
				_EntFire(ent, "kill", "", 6.5)
			end
		end
	end
end

MakeFunction("SlowHit")
function SlowHit(Activator, Caller)
	if _EntGetType(Caller) ~= "prop_physics" then return end
	if _EntGetType(Activator) ~= "player" then _EntRemove(Caller) return end
	local userid = _EntGetOwner(Caller)
	if _PlayerInfo(Activator, "team") ~= _PlayerInfo(userid, "team") then
		_EntEmitSound(Activator, "nox/slowon.wav")
		local trail = _EntCreate("env_smoketrail")
		if trail > 0 then
			_EntSetPos(trail, vecAdd(_EntGetPos(Activator), vector3(0,0,32)))
			_EntSetKeyValue(trail, "spawnrate", "70")
			_EntSetKeyValue(trail, "lifetime", "1")
			_EntSetKeyValue(trail, "startcolor", "255 255 0")
			_EntSetKeyValue(trail, "endcolor", "255 255 0")
			_EntSetKeyValue(trail, "minspeed", "10")
			_EntSetKeyValue(trail, "maxspeed", "80")
			_EntSetKeyValue(trail, "startsize", "8")
			_EntSetKeyValue(trail, "endsize", "12")
			_EntSetKeyValue(trail, "spawnradius", "16")
			_EntSetKeyValue(trail, "firesprite", "sprites/redglow3.spr")
			_EntSetKeyValue(trail, "smokesprite", "sprites/redglow3.spr")
			_EntSpawn(trail)
			_EntSetParent(trail, Activator)
			_EntFire(trail, "kill", "", 4.0)
		end
		_PlayerEnableSprint(Activator, false)
		local classname = Classes[players[Activator].Class].Name
		if classname == "juggernaut" or classname == "zombie" then
			return
		end
		if classname == "warrior" or classname == "dragoon" then
			_PlayerSetMaxSpeed(Activator, 240)
			AddTimer(4, 1, _PlayerSetMaxSpeed, Activator, 315)
		else
			AddTimer(4, 1, _PlayerEnableSprint, Activator, true)
		end
		AddTimer(4, 1, PlaySmartSound, Activator, "nox/slowoff.wav")
	end
	_EntRemove(Caller)
end

_EntPrecacheModel("models/Combine_Helicopter/helicopter_bomb01.mdl")
function FireBall(userid)
	if not _PlayerInfo(userid, "alive") or not _PlayerInfo(userid, "connected") then return end
	_PlayerViewModelSequence(userid, 171) _PlayerSetWeaponSequence(userid, 16)
	_PlayerFreeze(userid, false)
	local fireball = _EntCreate("prop_physics")
	if fireball > 0 then
		_EntSetPos(fireball, vecAdd( _PlayerGetShootPos(userid), vecMul( _PlayerGetShootAng(userid), vector3(20,20,20))))
		_EntSetModel(fireball, "models/Combine_Helicopter/helicopter_bomb01.mdl")
		_EntSetOwner(fireball, userid)
		_EntSetKeyValue(fireball, "minhealthdmg", "300")
		_EntSetKeyValue(fireball, "physdamagescale", "7500")
		_EntSetKeyValue(fireball, "rendercolor", "255 120 20")
		_EntSpawn(fireball)
		_EntSetName(fireball, "fireball")
		_EntFire(fireball, "DisableFloating", "", 0)
		OutputEntity(fireball, "onhealthchanged", "FireBallHit", 0)
		_EntSetMaterial(fireball, "gmod/shiny")
		_phys.ApplyForceCenter(fireball, vecMul(_PlayerGetShootAng(userid), vector3(150000, 150000, 150000)))
		_EntFire(fireball, "kill", "", 15)
		_EntitySetPhysicsAttacker(fireball, userid)
		local ent = _EntCreate("env_embers")
		if ent > 0 then
			_EntSetPos(ent, _EntGetPos(fireball))
			_EntSetKeyValue(ent, "particletype", "2")
			_EntSetKeyValue(ent, "density", "50")
			_EntSetKeyValue(ent, "spawnflags", "1")
			_EntSetKeyValue(ent, "lifetime", "4")
			_EntSetKeyValue(ent, "speed", "32")
			_EntSetKeyValue(ent, "rendercolor", "255 255 255")
			_EntSpawn(ent)
			_EntSetParent(ent, fireball)
		end
	end
end

MakeFunction("FireBallHit")
function FireBallHit(Activator, Caller)
	if _EntGetType(Caller) ~= "prop_physics" then return end
	local prop = Caller
	local userid = _EntGetOwner(Caller)
	local proppos = _EntGetPos(prop)
	for _, ent in _EntitiesFindInSphere(proppos, 256) do
		if _phys.HasPhysics(ent) then
			_TraceAttack(ent, prop, userid, (270-Distance(proppos, _EntGetPos(ent)))*0.4)
		end
	end
	_util.ScreenShake(proppos, math.random(15,35), 160.0, 1.15, 140)
	_EntEmitSoundEx(prop, "nox/explosion0"..math.random(4,6)..".wav", 1.5, 1.0)
	_EntFire(prop, "kill", "", 0)
end

function PreFireBall(userid)
	_PlayerFreeze(userid, true)
	_PlayerViewModelSequence(userid, 171) _PlayerSetWeaponSequence(userid, 16)
	local ent = _EntCreate("env_sprite")
	if ent > 0 then
		_EntSetKeyValue(ent, "model", "sprites/redglow3.spr")
		_EntSetKeyValue(ent, "rendermode", "5")
		_EntSetKeyValue(ent, "scale", "0.1")
		_EntSetKeyValue(ent, "spawnflags", "1")
		_EntSetPos(ent, _PlayerGetShootPos(userid))
		_EntSpawn(ent)
		_EntSetParent(ent, userid)
		_EntFire(ent, "kill", "", 1.0)
		for i=1, 10 do
			_EntFire(ent, "setscale", i*0.2, i*0.15)
		end
		--_EntEmitSound(userid, )
	end
	AddTimer(1.5, 1, FireBall, userid)
end

function Meteor(userid)
	if not _PlayerInfo(userid, "alive") or not _PlayerInfo(userid, "connected") then return end
	_PlayerViewModelSequence(userid, 171) _PlayerSetWeaponSequence(userid, 16)
	_TraceLine(_PlayerGetShootPos(userid), _PlayerGetShootAng(userid), 800, userid)
	local shotpos
	local toppos
	local bottompos
	local hitent
	if _TraceHitNonWorld() then
		hitent = _TraceGetEnt()
		shotpos = _EntGetPos(hitent)
		_TraceLine(shotpos, vector3(0,0,-1), 4064, hitent)
		bottompos = _TraceEndPos()
		_TraceSetMask(MASK_SOLID_BRUSHONLY)
		_TraceLine(shotpos, vector3(0,0,1), 4064, hitent)
		toppos = _TraceEndPos()
	else
		shotpos = _TraceEndPos()
		_TraceSetMask(MASK_SOLID_BRUSHONLY)
		_TraceLine(shotpos, vector3(0,0,1), 4064, userid)
		toppos = _TraceEndPos()
		_TraceLine(toppos, vector3(0,0,-1), 4064, userid)
		if _TraceHitNonWorld() then
			hitent = _TraceGetEnt()
			bottompos = _EntGetPos(hitent)
		else
			bottompos = _TraceEndPos()
		end
	end
	local fireball = _EntCreate("physics_prop")
	local firetrail = _EntCreate( "env_fire_trail" )
	_EntPrecacheModel( "models/Roller.mdl" )			
	if fireball > 0 then
		_EntSetPos(fireball, vecAdd(toppos, vector3(0,0,-15)))
		_EntSetModel(fireball, "models/roller.mdl")
		_phys.SetMass(fireball, 100)
		_EntSetPos(firetrail, _EntGetPos(fireball))
		_EntSpawn(fireball)
		_EntSetOwner(fireball, userid)
		_EntSetKeyValue(fireball, "minhealthdmg", "200")
		_EntSetKeyValue(fireball, "physdamagescale", "500")
		_EntSpawn(firetrail)
        _phys.ApplyForceCenter(fireball, vector3(0, 0, -17500))
		_EntitySetPhysicsAttacker(fireball, userid)
		_EntSetAngAngle(fireball, vector3(0,0,-90))
		_EntSetParent(firetrail, fireball)
		_EntFire(fireball, "sethealth", "99999", 0)
		_EntFire(fireball, "kill", "", 20)
		_EntFire(firetrail, "kill", "", 19.95)
		_EntSetMaterial(fireball, "models/props_lab/Tank_Glass001")
		OutputEntity(fireball, "onhealthchanged", "MeteorExplode", 0)
		OutputEntity(fireball, "onphysgunpickup", "MeteorExplode", 0.01)
	end
end

function ParalyzeHit(Activator, Caller)
	if _EntGetType(Caller) ~= "prop_physics" then return end
	if _EntGetType(Activator) ~= "player" then _EntRemove(Caller) return end
	local userid = _EntGetOwner(Caller)
	if _PlayerInfo(Activator, "team") ~= _PlayerInfo(userid, "team") then
		_EntEmitSound(Activator, "doors/heavy_metal_stop1.wav")
		AddTimer(3.35, 1, _PlayerFreeze, Activator, false)
		_PlayerFreeze(Activator, true)
		local vec = _EntGetPos(Activator)
		local Bars = function(x, y, z)
			_EffectInit()
			 _EffectSetEnt(userid or 255)
			 _EffectSetOrigin(vector3(x,y,z))
			 _EffectSetStart(vecAdd(vector3(x,y,z), vector3(0,0,90)))
			 _EffectSetScale(3)
			 _EffectSetMagnitude(3.0)
			_EffectDispatch("FadingLineTeamSolid")
		end
		Bars(vec.x-48, vec.y-48, vec.z)
		Bars(vec.x-48, vec.y, vec.z)
		Bars(vec.x-48, vec.y+48, vec.z)
		Bars(vec.x+48, vec.y-48, vec.z)
		Bars(vec.x+48, vec.y, vec.z)
		Bars(vec.x+48, vec.y+48, vec.z)
		Bars(vec.x, vec.y-48, vec.z)
		Bars(vec.x, vec.y+48, vec.z)
	end
	_EntRemove(Caller)
end

function Paralyze(userid)
	if not _PlayerInfo(userid, "alive") or not _PlayerInfo(userid, "connected") then return end
	_PlayerViewModelSequence(userid, 171) _PlayerSetWeaponSequence(userid, 16)
	local fireball = _EntCreate("physics_prop")
	_EntPrecacheModel( "models/props/cs_italy/orange.mdl" )
	if fireball > 0 then
		_EntSetPos(fireball, vecAdd( _PlayerGetShootPos(userid), vecMul( _PlayerGetShootAng(userid), vector3(20,20,20))))
		_EntSetModel(fireball, "models/props/cs_italy/orange.mdl")
		_phys.SetMass(fireball, 10)
		_EntSetOwner(fireball, userid)
		_EntSetKeyValue(fireball, "minhealthdmg", "400")
		_EntSetKeyValue(fireball, "physdamagescale", "7500")
		_EntSpawn(fireball)
		_EntSetName(fireball, "paralyzeball")
		_EntitySetPhysicsAttacker(fireball, userid)
		_phys.EnableGravity(fireball, false)
		_phys.ApplyForceCenter(fireball, vecMul(_PlayerGetShootAng(userid), vector3(100000, 100000, 100000)))
		_EntFire(fireball, "sethealth", "9999", 0)
		_EntFire(fireball, "kill", "", 10)
		local trail = _EntCreate("env_smoketrail")
		if trail > 0 then
			_EntSetPos(trail, _EntGetPos(fireball))
			_EntSetKeyValue(trail, "spawnrate", "25")
			_EntSetKeyValue(trail, "lifetime", "1.0")
			_EntSetKeyValue(trail, "startcolor", "255 255 0")
			_EntSetKeyValue(trail, "endcolor", "255 255 0")
			_EntSetKeyValue(trail, "minspeed", "0")
			_EntSetKeyValue(trail, "maxspeed", "10")
			_EntSetKeyValue(trail, "startsize", "9")
			_EntSetKeyValue(trail, "endsize", "14")
			_EntSetKeyValue(trail, "spawnradius", "6")
			_EntSetKeyValue(trail, "firesprite", "sprites/redglow3.spr")
			_EntSetKeyValue(trail, "smokesprite", "sprites/redglow3.spr")
			_EntSpawn(trail)
			_EntSetParent(trail, fireball)
			_EntFire(trail, "kill", "", 5.0)
		end
		_EntFire(fireball, "DisableFloating", "", 0)
		OutputEntity(fireball, "onhealthchanged", "ParalyzeHit", "0")
	end
end
MakeFunction("ParalyzeHit")

function Slow(userid)
	if not _PlayerInfo(userid, "alive") or not _PlayerInfo(userid, "connected") then return end
	_PlayerViewModelSequence(userid, 171) _PlayerSetWeaponSequence(userid, 16)
	local fireball = _EntCreate("physics_prop")
	_EntPrecacheModel( "models/props/cs_italy/orange.mdl" )
	if fireball > 0 then
		_EntSetPos(fireball, vecAdd( _PlayerGetShootPos(userid), vecMul( _PlayerGetShootAng(userid), vector3(20,20,20))))
		_EntSetModel(fireball, "models/props/cs_italy/orange.mdl")
		_phys.SetMass(fireball, 10)
		_EntSetOwner(fireball, userid)
		_EntSetKeyValue(fireball, "minhealthdmg", "300")
		_EntSetKeyValue(fireball, "physdamagescale", "7500")
		_EntSpawn(fireball)
		_EntFire(fireball, "DisableFloating", "", 0)
		_EntitySetPhysicsAttacker(fireball, userid)
		_phys.EnableGravity(fireball, false)
		_phys.ApplyForceCenter(fireball, vecMul(_PlayerGetShootAng(userid), vector3(100000, 100000, 100000)))
		_EntFire(fireball, "sethealth", "9999", 0)
		_EntFire(fireball, "kill", "", 10)
		AttatchTrail(fireball, "255 255 25")
		OutputEntity(fireball, "onhealthchanged", "SlowHit", 0)
	end
end

function ValidFireBall(ent)
	local nam = _EntGetType(ent)
	return string.find(nam, "prop_") ~= nil or string.find(nam, "npc_") ~= nil or nam == "player"
end

function CounterSpell(userid)
	if not _PlayerInfo(userid, "alive") or not _PlayerInfo(userid, "connected") then return end
	_PlayerViewModelSequence(userid, 171) _PlayerSetWeaponSequence(userid, 16)
	_EntEmitSound(userid, "nox/counterspell.wav")
	local tab = _EntitiesFindInSphere(_EntGetPos(userid), 500)
	for i=1, table.getn(tab) do
		if _EntGetName(tab[i]) == "magicarrow" or _EntGetName(tab[i]) == "sunburst" or _EntGetName(tab[i]) == "sunburstcluster" then
			PlayerMove(tab[i], vector3(5000,5000,6000))
		elseif (string.lower(_EntGetModel(tab[i])) == "models/roller.mdl" or _EntGetName(tab[i]) == "fireball" or string.lower(_EntGetModel(tab[i])) == "models/roller_spikes.mdl") and _EntGetName(tab[i]) ~= "flag" then
			_EntRemove(tab[i])			
		elseif string.lower(_EntGetModel(tab[i])) == "models/props/cs_italy/orange.mdl" then
			PlayerMove(tab[i], vector3(5000,5000,6000))
		elseif string.sub(_EntGetName(tab[i]), 1, 11) == "firesprite:" then
			local x = tonumber(string.sub(_EntGetName(tab[i]), 12))
			_EntSetVelocity(Sprites[x].Sprites, vector3(0,0,-10000))
			SpriteExplode(Sprites[x].Sprites, userid)
			HaltTimer(Sprites[x].Timer)
			Sprites[x] = nil
		elseif _EntGetName(tab[i]) == "pixies" then
			_EntRemove(tab[i])
		end
	end
	for i in EnergyBolts do
		if Distance(EnergyBolts[i].pos, _EntGetPos(userid)) < 401 then
			if _PlayerInfo(EnergyBolts[i].owner,"team") ~= _PlayerInfo(userid,"team") then
				EnergyBoltExplodeEffects(i)
				HaltTimer(EnergyBolts[i].timer)
				EnergyBolts[i] = nil
			end
		end
	end
end

function Inversion(userid)
	if not _PlayerInfo(userid, "alive") or not _PlayerInfo(userid, "connected") then return end
	_PlayerViewModelSequence(userid, 171) _PlayerSetWeaponSequence(userid, 16)
	local tab = _EntitiesFindInSphere(_EntGetPos(userid), 500)
	for i=1, table.getn(tab) do
		if _EntGetName(tab[i]) == "magicarrow" or _EntGetName(tab[i]) == "sunburst" or _EntGetName(tab[i]) == "sunburstcluster" then
			for p = 1, 3 do
				_phys.ApplyForceCenter(tab[i], vecMul(_PlayerGetShootAng(userid), vector3(80000,80000,80000)))
			end
			_EntEmitSound(tab[i], "nox/inversion.wav")
			_EntSetOwner(tab[i], userid)
			Effect(userid, "cball_bounce", _EntGetPos(tab[i]), 40, 1.5, 40, vecNormalize(vecSub(_EntGetPos(userid), _EntGetPos(tab[i]))))
		elseif (string.lower(_EntGetModel(tab[i])) == "models/roller.mdl" or _EntGetName(tab[i]) == "fireball" or string.lower(_EntGetModel(tab[i])) == "models/roller_spikes.mdl") and _EntGetName(tab[i]) ~= "flag" then
			for p = 1, 3 do
				_phys.ApplyForceCenter(tab[i], vecMul(_PlayerGetShootAng(userid), vector3(95000,95000,95000)))
			end
			_EntEmitSound(tab[i], "nox/inversion.wav")
			_EntSetOwner(tab[i], userid)
			Effect(userid, "cball_bounce", _EntGetPos(tab[i]), 40, 1.5, 40, vecNormalize(vecSub(_EntGetPos(userid), _EntGetPos(tab[i]))))
		elseif string.lower(_EntGetModel(tab[i])) == "models/props/cs_italy/orange.mdl" then
			for p = 1, 3 do
				_phys.ApplyForceCenter(tab[i], vecMul(_PlayerGetShootAng(userid), vector3(90000,90000,90000)))
			end
			_EntEmitSound(tab[i], "nox/inversion.wav")
			_EntSetOwner(tab[i], userid)
			Effect(userid, "cball_bounce", _EntGetPos(tab[i]), 40, 1.5, 40, vecNormalize(vecSub(_EntGetPos(userid), _EntGetPos(tab[i]))))
		elseif string.sub(_EntGetName(tab[i]), 1, 11) == "firesprite:" then
			local x = tonumber(string.sub(_EntGetName(tab[i]), 12))
			Sprites[x].Target = Sprites[x].Owner
			Sprites[x].Owner = userid
			_EntSetAng(tab[i], vecMul(_EntGetAng(tab[i]), -1))
			_EntSetVelocity(tab[i], vecMul(_EntGetVelocity(tab[i]), -1))
			_EntEmitSound(tab[i], "nox/inversion.wav")
			_EntSetOwner(tab[i], userid)
			Effect(userid, "cball_bounce", _EntGetPos(tab[i]), 40, 1.5, 40, vecNormalize(vecSub(_EntGetPos(userid), _EntGetPos(tab[i]))))
		elseif _EntGetName(tab[i]) == "pixies" then
			_EntSetOwner(tab[i], userid)
			_EntEmitSound(tab[i], "nox/inversion.wav")
			Effect(userid, "cball_bounce", _EntGetPos(tab[i]), 40, 1.5, 40)
		end
	end
	for i in EnergyBolts do
		if Distance(EnergyBolts[i].pos, _EntGetPos(userid)) < 401 then
			if _PlayerInfo(EnergyBolts[i].owner,"team") ~= _PlayerInfo(userid,"team") then
				EnergyBolts[i].ang = vecMul(EnergyBolts[i].ang, -1)
				EnergyBolts[i].target = EnergyBolts[i].owner
				EnergyBolts[i].owner = userid
				EnergyBolts[i].reps = 0
				_EntEmitSound(userid, "nox/inversion.wav")
				Effect(userid, "cball_bounce", EnergyBolts[i].pos, 30, 1, 30)
			end
		end
	end
end

function Repel(userid)
	if not _PlayerInfo(userid, "alive") or not _PlayerInfo(userid, "connected") then return end
	_PlayerViewModelSequence(userid, 171) _PlayerSetWeaponSequence(userid, 16)
	for _, ent in _EntitiesFindInSphere(_EntGetPos(userid), 400) do
		if _EntGetType(ent) == "player" then
			if _PlayerInfo(ent, "team") ~= _PlayerInfo(userid, "team") then
				local entvec = vecNormalize(vecSub(_EntGetPos(userid), _EntGetPos(ent)))
				local forcevec = vecAdd(vecMul(entvec,vector3(-500,-500,-600)), vector3(0,0,300))
				_EntSetVelocity(ent, vecAdd(vecMul(_EntGetVelocity(ent), 0.6), forcevec))
				Effect(userid, "cball_bounce", _EntGetPos(ent), 60, 1, 60, vecNormalize(vecSub(_EntGetPos(userid), _EntGetPos(ent))))
			end
		elseif _EntGetName(ent) ~= "flag" and _EntGetName(ent) ~= "frozenprop" and _phys.HasPhysics(ent) then
			local entvec = vecNormalize(vecSub(_EntGetPos(userid),_EntGetPos(ent)))
            local forcevec = vecMul(entvec, vector3(-27000,-27000,-30000))
            _phys.ApplyForceCenter(ent, forcevec)
			Effect(userid, "cball_bounce", _EntGetPos(ent), 60, 1, 60, vecNormalize(vecSub(_EntGetPos(userid), _EntGetPos(ent))))
		end
	end
end

function Lightning(userid)
	if not _PlayerInfo(userid, "alive") or not _PlayerInfo(userid, "connected") then return end
	_PlayerViewModelSequence(userid, 171) _PlayerSetWeaponSequence(userid, 16)
	_TraceLine(_PlayerGetShootPos(userid), _PlayerGetShootAng(userid), 1200, userid)

	local shotpos
	local toppos
	local bottompos
	local hitent
	if _TraceHitNonWorld() then
		hitent = _TraceGetEnt()
		shotpos = _EntGetPos(hitent)
		_TraceLine(shotpos, vector3(0,0,-1), 4064, hitent)
		bottompos = _TraceEndPos()
		_TraceLine(shotpos, vector3(0,0,1), 4064, hitent)
		toppos = _TraceEndPos()
		_TraceAttack(hitent, userid, userid, math.random(25, 40)+(_EntGetWaterLevel(hitent)*13))
	else
		shotpos = _TraceEndPos()
		_TraceLine(shotpos, vector3(0,0,1), 4064, userid)
		toppos = _TraceEndPos()
		_TraceLine(toppos, vector3(0,0,-1), 4064, userid)
		if _TraceHitNonWorld() then
			hitent = _TraceGetEnt()
			_TraceAttack(hitent, userid, userid, math.random(25, 40)+(_EntGetWaterLevel(hitent)*13))
			bottompos = _EntGetPos(hitent)
		else
			bottompos = _TraceEndPos()
			if _TraceHitWorld() then
				_MakeDecal(math.random(67,70))
			end
		end
	end

	local tempent = _EntCreate("info_target")
	if tempent > 0 then
		_EntSetPos(tempent, bottompos)
		_EntSetName(tempent, _PlayerInfo(userid, "name").."templighttarget")
		_EntSpawn(tempent)
		_EntFire(tempent, "kill", "", 0.41)
	end

	_EntEmitSound(tempent, "nox/lightning_impact.wav")
	--_EntEmitSound(tempent, "weapons/physcannon/energy_sing_explosion2.wav")
	_EntEmitSound(tempent, "ambient/levels/labs/electric_explosion"..math.random(1,5)..".wav")

	local laser = _EntCreate("env_laser")
	if laser > 0 then
		_EntSetPos(laser, toppos)
		_EntSetKeyValue(laser, "renderamt", "255")
		_EntSetKeyValue(laser, "rendercolor", "21 106 234")
		_EntSetKeyValue(laser, "width", "30")
		_EntSetKeyValue(laser, "texture", "Effects/laser1.vmt")
		_EntSetKeyValue(laser, "TextureScroll", "25")
		_EntSetKeyValue(laser, "damage", "0")
		_EntSetKeyValue(laser, "renderfx", "0")
		_EntSetKeyValue(laser, "LaserTarget", _PlayerInfo(userid, "name").."templighttarget")
		_EntSetKeyValue(laser, "NoiseAmplitude", "8")
		_EntSetKeyValue(laser, "spawnflags", "33")
		_EntSpawn(laser)
		_EntSetOwner(laser, userid)
		_EntFire(laser, "kill", "", 0.4)
	end
	local effect2 = _EntCreate("point_tesla")
	if effect2 > 0 then
		_EntSetKeyValue(effect2, "m_flRadius", "250")
		_EntSetKeyValue(effect2, "m_SoundName", "DoSpark")
		_EntSetKeyValue(effect2, "m_Color", "255 255 255")
		_EntSetKeyValue(effect2, "texture", "effects/laser1.vmt")
		_EntSetKeyValue(effect2, "beamcount_min", "6")
		_EntSetKeyValue(effect2, "beamcount_max", "10")
		_EntSetKeyValue(effect2, "thick_min", "20")
		_EntSetKeyValue(effect2, "thick_max", "50")
		_EntSetKeyValue(effect2, "lifetime_min", "0.5")
		_EntSetKeyValue(effect2, "lifetime_max", "1")
		_EntSetKeyValue(effect2, "interval_min", "0.1")
		_EntSetKeyValue(effect2, "interval_max", "0.25")
		_EntSetPos(effect2, vecAdd(bottompos, vector3(0,0,32)))
		_EntSpawn(effect2)
		_EntFire(effect2, "DoSpark", "", 0.1)
		_EntFire(effect2, "DoSpark", "", 0.3)
		_EntFire(effect2, "DoSpark", "", 0.5)
		_EntFire(effect2, "kill", "", 0.8)
	end
	_EffectInit()
	_EffectSetEnt(userid)
	_EffectSetOrigin(bottompos)
	_EffectSetStart(bottompos)
	_EffectSetScale(70)
	_EffectSetMagnitude(10)
	_EffectSetRadius(10)
	_EffectDispatch("ThumperDust")
	_EffectDispatch("cball_explode")
	_util.ScreenShake(bottompos, math.random(10,30), 150.0, 0.75, 150)
end

INVISIBLETIMERS = {}
function Invisibility(userid)
	if not _PlayerInfo(userid, "alive") or not _PlayerInfo(userid, "connected") then return end
	_PlayerViewModelSequence(userid, 171) _PlayerSetWeaponSequence(userid, 16)
	local targ = userid
	_TraceLine(_PlayerGetShootPos(userid), _PlayerGetShootAng(userid), 100, userid)
	if _TraceHitNonWorld() then
		if _TraceGetEnt() <= _MaxPlayers() then
			if _PlayerInfo(_TraceGetEnt(), "team") == _PlayerInfo(userid, "team") then
				targ = _TraceGetEnt()
			end
		end
	end
	if not players[targ].Invisible then
		_EntEmitSound(targ, "nox/invison.wav")
		_EntSetKeyValue(targ, "rendermode", "1")
		_EntFire(targ, "alpha", "8", 0)
		players[targ].Invisible = true
		INVISIBLETIMERS[targ] = AddTimer(0.1, 0, InvisibleTimer, targ)
		_EffectInit()
		_EffectSetEnt(targ)
		_EffectSetOrigin(_EntGetPos(targ))
		_EffectSetStart(_EntGetPos(targ))
		_EffectSetScale(70)
		_EffectSetMagnitude(10)
		_EffectSetRadius(10)
		_EffectDispatch("ThumperDust")
		_GModRect_Start("models/props_combine/com_shield001a")
		 _GModRect_SetPos(0, 0, 1, 1)
		 _GModRect_SetColor(255, 255, 255, 100)
		 _GModRect_SetTime(9999, 0, 0)
		_GModRect_Send(targ, 9109)
	end
	_PlayerSetDrawWorldModel(targ, false)
end

function InvisibilitySelf(userid)
	if not _PlayerInfo(userid, "alive") or not _PlayerInfo(userid, "connected") then return end
	_PlayerViewModelSequence(userid, 171) _PlayerSetWeaponSequence(userid, 16)
	if not players[userid].Invisible then
		_EntEmitSound(userid, "nox/invison.wav")
		_EntSetKeyValue(userid, "rendermode", "1")
		_EntFire(userid, "alpha", "8", 0)
		_GModRect_Start("models/props_combine/com_shield001a")
		 _GModRect_SetPos(0, 0, 1, 1)
		 _GModRect_SetColor(255, 255, 255, 100)
		 _GModRect_SetTime(9999, 0, 0)
		_GModRect_Send(userid, 9109)
		players[userid].Invisible = true
		INVISIBLETIMERS[userid] = AddTimer(0.1, 0, InvisibleTimer, userid)
	end
	_PlayerSetDrawWorldModel(userid, false)
end

function InvisibleTimer(userid)
	if not players[userid].Invisible then
		HaltTimer(INVISIBLETIMERS[userid])
		INVISIBLETIMERS[userid] = nil
		return
	end
	local fVel = vecLength(_EntGetVelocity(userid))
	if fVel > 1020 then fVel = 1020
	elseif fVel < 140 then fVel = 0 end
	_EntFire(userid, "alpha", tostring(fVel*0.25), 0)
end

function Teleport(userid)
	if not _PlayerInfo(userid, "alive") or not _PlayerInfo(userid, "connected") then return end
	_PlayerViewModelSequence(userid, 171) _PlayerSetWeaponSequence(userid, 16)
	_EntEmitSound(userid, "nox/blink.wav")
	local effect = _EntCreate("env_explosion")
	if effect > 0 then
		_EntSetKeyValue(effect, "iMagnitute", "1")
		_EntSetKeyValue(effect, "spawnflags", "349")
		_EntSetKeyValue(effect, "fireballsprite", "sprites/blueflare1.spr")
		_EntSetPos(effect, _EntGetPos(userid))
		_EntSpawn(effect)
		_EntFire(effect, "Explode", "", 0)
		_EntFire(effect, "kill", "", 0.1)
		_EntEmitSound(effect, "nox/blink.wav")
	end
	local effect2 = _EntCreate("point_tesla")
	if effect2 > 0 then
		_EntSetKeyValue(effect2, "m_flRadius", "100")
		_EntSetKeyValue(effect2, "m_SoundName", "DoSpark")
		_EntSetKeyValue(effect2, "m_Color", "0 0 255")
		_EntSetKeyValue(effect2, "texture", "effects/laser1.vmt")
		_EntSetKeyValue(effect2, "beamcount_min", "6")
		_EntSetKeyValue(effect2, "beamcount_max", "10")
		_EntSetKeyValue(effect2, "thick_min", "10")
		_EntSetKeyValue(effect2, "thick_max", "30")
		_EntSetKeyValue(effect2, "lifetime_min", "0.5")
		_EntSetKeyValue(effect2, "lifetime_max", "1")
		_EntSetKeyValue(effect2, "interval_min", "0.1")
		_EntSetKeyValue(effect2, "interval_max", "0.25")
		_EntSetPos(effect2, vecAdd(_EntGetPos(userid), vector3(0,0,32)))
		_EntSpawn(effect2)
		_EntFire(effect2, "DoSpark", "", 0.1)
		_EntFire(effect2, "DoSpark", "", 0.3)
		_EntFire(effect2, "kill", "", 0.5)
	end
	_EffectInit()
	_EffectSetEnt(userid)
	_EffectSetOrigin(_EntGetPos(userid))
	_EffectSetStart(_EntGetPos(userid))
	_EffectSetScale(70)
	_EffectSetMagnitude(10)
	_EffectSetRadius(10)
	_EffectDispatch("cball_explode")
	_TraceLine(_PlayerGetShootPos(userid), vecMul(_PlayerGetShootAng(userid), vector3(1,1,0)), 750, userid)
	_EntSetPos(userid, vecAdd(_TraceEndPos(), vector3(0,0,16)))
	effect2 = _EntCreate("point_tesla")
	if effect2 > 0 then
		_EntSetKeyValue(effect2, "m_flRadius", "100")
		_EntSetKeyValue(effect2, "m_SoundName", "DoSpark")
		_EntSetKeyValue(effect2, "m_Color", "0 0 255")
		_EntSetKeyValue(effect2, "texture", "effects/laser1.vmt")
		_EntSetKeyValue(effect2, "beamcount_min", "6")
		_EntSetKeyValue(effect2, "beamcount_max", "10")
		_EntSetKeyValue(effect2, "thick_min", "10")
		_EntSetKeyValue(effect2, "thick_max", "30")
		_EntSetKeyValue(effect2, "lifetime_min", "0.5")
		_EntSetKeyValue(effect2, "lifetime_max", "1")
		_EntSetKeyValue(effect2, "interval_min", "0.1")
		_EntSetKeyValue(effect2, "interval_max", "0.25")
		_EntSetPos(effect2, vecAdd(_EntGetPos(userid), vector3(0,0,32)))
		_EntSpawn(effect2)
		_EntFire(effect2, "DoSpark", "", 0.1)
		_EntFire(effect2, "DoSpark", "", 0.3)
		_EntFire(effect2, "kill", "", 0.5)
	end
	_EffectInit()
	_EffectSetEnt(userid)
	_EffectSetOrigin(_EntGetPos(userid))
	_EffectSetStart(_EntGetPos(userid))
	_EffectSetScale(70)
	_EffectSetMagnitude(10)
	_EffectSetRadius(10)
	_EffectDispatch("cball_explode")
end

function Blink(userid)
	if not _PlayerInfo(userid, "alive") or not _PlayerInfo(userid, "connected") then return end
	_PlayerViewModelSequence(userid, 171) _PlayerSetWeaponSequence(userid, 16)
	if not teams then return end
	_EntEmitSound(userid, "nox/blink.wav")
	local effect = _EntCreate("env_explosion")
	if effect > 0 then
		_EntSetKeyValue(effect, "iMagnitute", "1")
		_EntSetKeyValue(effect, "spawnflags", "349")
		_EntSetKeyValue(effect, "fireballsprite", "sprites/blueflare1.spr")
		_EntSetPos(effect, _EntGetPos(userid))
		_EntSpawn(effect)
		_EntFire(effect, "Explode", "", 0)
		_EntFire(effect, "kill", "", 0.1)
		_EntEmitSound(effect, "nox/blink.wav")
	end
	local effect2 = _EntCreate("point_tesla")
	if effect2 > 0 then
		_EntSetKeyValue(effect2, "m_flRadius", "100")
		_EntSetKeyValue(effect2, "m_SoundName", "DoSpark")
		_EntSetKeyValue(effect2, "m_Color", "0 0 255")
		_EntSetKeyValue(effect2, "texture", "effects/laser1.vmt")
		_EntSetKeyValue(effect2, "beamcount_min", "6")
		_EntSetKeyValue(effect2, "beamcount_max", "10")
		_EntSetKeyValue(effect2, "thick_min", "10")
		_EntSetKeyValue(effect2, "thick_max", "30")
		_EntSetKeyValue(effect2, "lifetime_min", "0.5")
		_EntSetKeyValue(effect2, "lifetime_max", "1")
		_EntSetKeyValue(effect2, "interval_min", "0.1")
		_EntSetKeyValue(effect2, "interval_max", "0.25")
		_EntSetPos(effect2, vecAdd(_EntGetPos(userid), vector3(0,0,32)))
		_EntSpawn(effect2)
		_EntFire(effect2, "DoSpark", "", 0.1)
		_EntFire(effect2, "DoSpark", "", 0.3)
		_EntFire(effect2, "kill", "", 0.5)
	end

	local tabletotele = {}
	local tab = _EntitiesFindInSphere(_EntGetPos(userid), 85)
	local destination = vector3(0, 0, 0)
	table.insert(tabletotele, userid)
	for i=1, table.getn(tab) do
		if tab[i] ~= userid and IsPlayer(tab[i]) then
			if _PlayerInfo(tab[i], "alive") and not isFlagCarrier(tab[i]) then
				table.insert(tabletotele, tab[i])
			end
		end
	end

	if players[userid].spawn.x ~= 0 then
		destination = players[userid].spawn
	else
		destination = vecAdd(_EntGetPos(teams[_PlayerInfo(userid,"team")].flagpoint), vector3(math.random(-120, 120), math.random(-120, 120), 0))
	end

	for i=1, table.getn(tabletotele) do
		_EntSetPos(tabletotele[i], vecAdd(destination, vector3(math.random(-60, 60), math.random(-60, 60), 32)))
		local effect2 = _EntCreate("point_tesla")
		if effect2 > 0 then
			_EntSetKeyValue(effect2, "m_flRadius", "100")
			_EntSetKeyValue(effect2, "m_SoundName", "DoSpark")
			_EntSetKeyValue(effect2, "m_Color", "0 0 255")
			_EntSetKeyValue(effect2, "texture", "effects/laser1.vmt")
			_EntSetKeyValue(effect2, "beamcount_min", "3")
			_EntSetKeyValue(effect2, "beamcount_max", "6")
			_EntSetKeyValue(effect2, "thick_min", "10")
			_EntSetKeyValue(effect2, "thick_max", "30")
			_EntSetKeyValue(effect2, "lifetime_min", "0.5")
			_EntSetKeyValue(effect2, "lifetime_max", "1")
			_EntSetKeyValue(effect2, "interval_min", "0.1")
			_EntSetKeyValue(effect2, "interval_max", "0.25")
			_EntSetPos(effect2, vecAdd(_EntGetPos(tabletotele[i]), vector3(0,0,32)))
			_EntSpawn(effect2)
			_EntFire(effect2, "DoSpark", "", 0.1)
			_EntFire(effect2, "kill", "", 0.3)
		end
	end
end

function Shock(userid)
	if not _PlayerInfo(userid, "alive") or not _PlayerInfo(userid, "connected") then return end
	_PlayerViewModelSequence(userid, 171) _PlayerSetWeaponSequence(userid, 16)
	local effect2 = _EntCreate("point_tesla")
	if effect2 > 0 then
		_EntSetKeyValue(effect2, "m_flRadius", "150")
		_EntSetKeyValue(effect2, "m_SoundName", "DoSpark")
		_EntSetKeyValue(effect2, "m_Color", "200 200 255")
		_EntSetKeyValue(effect2, "texture", "effects/laser1.vmt")
		_EntSetKeyValue(effect2, "beamcount_min", "6")
		_EntSetKeyValue(effect2, "beamcount_max", "10")
		_EntSetKeyValue(effect2, "thick_min", "10")
		_EntSetKeyValue(effect2, "thick_max", "30")
		_EntSetKeyValue(effect2, "lifetime_min", "0.5")
		_EntSetKeyValue(effect2, "lifetime_max", "1")
		_EntSetKeyValue(effect2, "interval_min", "0.1")
		_EntSetKeyValue(effect2, "interval_max", "0.25")
		_EntSetPos(effect2, vecAdd(_EntGetPos(userid), vector3(0,0,32)))
		_EntSpawn(effect2)
		_EntFire(effect2, "DoSpark", "", 0.1)
		_EntFire(effect2, "DoSpark", "", 0.3)
		_EntFire(effect2, "DoSpark", "", 0.3)
		_EntFire(effect2, "kill", "", 0.5)
	end
	_EntEmitSound(userid, "ambient/levels/labs/electric_explosion"..math.random(1,5)..".wav")
	local tab = _EntitiesFindInSphere(_EntGetPos(userid), 135)
	for i=1, table.getn(tab) do
		if tab[i] ~= userid and _phys.HasPhysics(tab[i]) then
			_TraceAttack(tab[i], userid, userid, math.random(20, 40))
		end
	end
end

function Shield(userid)
	if not _PlayerInfo(userid, "alive") or not _PlayerInfo(userid, "connected") then return end
	_PlayerViewModelSequence(userid, 171) _PlayerSetWeaponSequence(userid, 16)
	local targ = userid
	_TraceLine(_PlayerGetShootPos(userid), _PlayerGetShootAng(userid), 100, userid)
	if _TraceHitNonWorld() then
		if _TraceGetEnt() <= _MaxPlayers() then
			if _PlayerInfo(_TraceGetEnt(), "team") == _PlayerInfo(userid, "team") then
				targ = _TraceGetEnt()
			end
		end
	end
	if _PlayerInfo(targ, "armor") < 50 then
		_PlayerSetArmor(targ, 50)
		if targ ~= userid then
			_GModText_Start( "Default" )
			 _GModText_SetPos( 0.0, 0.0 )
			 _GModText_SetColor( 160, 160, 170, 255 )
			 _GModText_SetTime( 0.75, 0.2, 0.2 )
			 _GModText_SetAdditive(true)
			 _GModText_SetEntity(targ)
			 _GModText_SetEntityOffset(vector3(math.random(-25,25),math.random(-25,25),math.random(40,50)))
			 _GModText_SetText( "Shield")
			_GModText_Send(userid, userid+targ+math.random(10000,22000))
		end
	end
	_EntEmitSound(targ, "nox/shield.wav")
end

function Mortar(userid)
	if not _PlayerInfo(userid, "alive") or not _PlayerInfo(userid, "connected") then return end
	_PlayerViewModelSequence(userid, 171) _PlayerSetWeaponSequence(userid, 16)

	local fireball = _EntCreate("prop_physics")
	local firetrail = _EntCreate("env_fire_trail")
	_EntPrecacheModel("models/props/cs_italy/orange.mdl")
	if fireball > 0 then
		_EntSetPos(fireball, vecAdd( _PlayerGetShootPos(userid), vecMul( _PlayerGetShootAng(userid), vector3(20,20,20))))
		_EntSetModel(fireball, "models/props/cs_italy/orange.mdl")
		_phys.SetMass(fireball, 10)
		_EntSetPos(firetrail, _EntGetPos(fireball))
		_EntSetOwner(fireball, userid)
		_EntSetKeyValue(fireball, "physdamagescale", "500")
		_EntSpawn(fireball)
		_EntitySetPhysicsAttacker(fireball, userid)
		_EntSpawn(firetrail)
		_phys.ApplyForceCenter(fireball, vecMul(_PlayerGetShootAng(userid), vector3(10000, 10000, 10000)))
		_EntSetParent(firetrail, fireball)
		_EntFire(fireball, "sethealth", "9999", 0)
		_EntFire(fireball, "kill", "", 20)
		OutputEntity(fireball, "onhealthchanged", "MortarExplode", 2)
		OutputEntity(fireball, "onphysgunpickup", "MortarExplode", 0.01)
	end
end

MakeFunction("MortarExplode")
function MortarExplode(Activator, Caller)
	if _EntGetType(Caller) ~= "prop_physics" then return end
	FireBallExplode(Caller, _EntGetOwner(Caller))
end

function FireBallExplode(prop, userid)
	local ppos = _EntGetPos(prop)
	local ents = _EntitiesFindInSphere(ppos, 185)
	for i in ents do
		if ents[i] ~= prop then
			if _phys.HasPhysics(ents[i]) then
				if IsVisible(ppos, _EntGetPos(ents[i]), 5000) then
					_TraceAttack(ents[i], userid, userid, 90-(Distance(ppos, _EntGetPos(ents[i])))*0.4)
				end
			end
		end
	end

	local expl = _EntCreate("env_explosion")
	if expl > 0 then
		_EntSetKeyValue(expl, "spawnflags", "17")
		_EntSetPos(expl, ppos)
		_EntSpawn(expl)
		_EntFire(expl, "explode", "", 0)
		_EntFire(expl, "kill", "", 0.1)
	end
	_util.ScreenShake(ppos, math.random(15,35), 160.0, 1.15, 140)
	_EntFire(prop, "kill", "", 0)
end

function FireBallJustExplode(fireball, userid)
	if _EntExists(fireball) then
		FireBallExplode(fireball, userid)
	end
end

function Heal(userid)
	if not _PlayerInfo(userid, "alive") or not _PlayerInfo(userid, "connected") then return end
	_PlayerViewModelSequence(userid, 171) _PlayerSetWeaponSequence(userid, 16)
	local targ = userid
	local addedhealth = 0
	_TraceLine(_PlayerGetShootPos(userid), _PlayerGetShootAng(userid), 110, userid)
	if _TraceHitNonWorld() then
		if _TraceGetEnt() <= _MaxPlayers() then
			if _PlayerInfo(_TraceGetEnt(), "team") == _PlayerInfo(userid, "team") then
				targ = _TraceGetEnt()
				local health = _PlayerInfo(targ, "health")
				_PlayerSetHealth(targ, _PlayerInfo(targ, "health")+25)
				if _PlayerInfo(targ, "health") > _EntGetMaxHealth(targ) then
					_PlayerSetHealth(targ, _EntGetMaxHealth(targ))
				end
				addedhealth = _PlayerInfo(targ, "health")-health
			end
		end
	end
	_EntEmitSound(targ, "nox/heal.wav")
	if targ ~= userid then
		_GModText_Start( "Default" )
		 _GModText_SetPos( 0.0, 0.0 )
		 _GModText_SetColor( 0, 230, 0, 255 )
		 _GModText_SetTime( 0.75, 0.2, 0.2 )
		 _GModText_SetAdditive(true)
		 _GModText_SetEntity(targ)
		 _GModText_SetEntityOffset(vector3(math.random(-25,25),math.random(-25,25),math.random(40,50)))
		 _GModText_SetText( "+ "..addedhealth)
		_GModText_Send(userid, userid+targ+math.random(10000,22000))
	else
		local health = _PlayerInfo(userid, "health")
		_PlayerSetHealth(userid, _PlayerInfo(userid, "health")+25)
		if _PlayerInfo(userid, "health") > _EntGetMaxHealth(userid) then
			_PlayerSetHealth(userid, _EntGetMaxHealth(userid))
		end
		addedhealth = _PlayerInfo(userid, "health")-health
	end
	local trail = _EntCreate("env_smoketrail")
	if trail > 0 then
		_EntSetPos(trail, vecAdd(_EntGetPos(targ), vector3(0,0,32)))
		_EntSetKeyValue(trail, "spawnrate", "70")
		_EntSetKeyValue(trail, "lifetime", "1")
		_EntSetKeyValue(trail, "startcolor", "0 255 0")
		_EntSetKeyValue(trail, "endcolor", "0 255 0")
		_EntSetKeyValue(trail, "minspeed", "10")
		_EntSetKeyValue(trail, "maxspeed", "80")
		_EntSetKeyValue(trail, "startsize", "8")
		_EntSetKeyValue(trail, "endsize", "12")
		_EntSetKeyValue(trail, "spawnradius", "16")
		_EntSetKeyValue(trail, "firesprite", "sprites/redglow3.spr")
		_EntSetKeyValue(trail, "smokesprite", "sprites/redglow3.spr")
		_EntSpawn(trail)
		_EntSetParent(trail, targ)
		_EntFire(trail, "kill", "", 1.0)
	end
	AttatchTrail2(targ, "0 255 0", 1.5)
end

BerserkTimer = {}
function BerserkerCharge(userid)
	if BerserkTimer[userid] == nil then
		local ang = _PlayerGetShootAng(userid)
		if not ang then return end
		ang.z = 0
		_EntEmitSound(userid, "nox/berserkercharge.wav")
		local fire = _EntCreate("env_fire_trail")
		if fire > 0 then
			_EntSetPos(fire, _EntGetPos(userid))
			_EntSetParent(fire, userid)
			_EntSpawn(fire)
			_EntFire(fire, "kill", "", 4.0)
		end
		BerserkTimer[userid] = AddTimer(0.05, 0, BerserkerChargeTimer, userid, ang)
	end
end

function BerserkerChargeTimer(userid, heading)
	if not _PlayerInfo(userid, "alive") or not IsPlayerOnline(userid) then HaltTimer(BerserkTimer[userid]) BerserkTimer[userid] = nil return end
	_TraceLine(vecAdd(vector3(0,0,22), _EntGetPos(userid)), heading, 80, userid)
	_EntSetAng(userid, heading)
	if _TraceHit() then
		if _TraceHitWorld() then
			_TraceAttack(userid, userid, userid, _PlayerInfo(userid,"health")*0.2)
			AddTimer(2.0, 1, _PlayerFreeze, userid, false)
			_PlayerFreeze(userid, true)
			_EntEmitSound(userid, "physics/concrete/boulder_impact_hard"..math.random(1,4)..".wav")
			HaltTimer(BerserkTimer[userid])
			BerserkTimer[userid] = nil
		elseif _TraceHitNonWorld() then
			if _EntGetModel(_TraceGetEnt()) ~= "models/mixerman3d/weapons/axe01.mdl" then
				if IsPlayer(_TraceGetEnt()) then
					if _PlayerInfo(_TraceGetEnt(), "team") ~= _PlayerInfo(userid, "team") then
						_EntSetVelocity(_TraceGetEnt(), vecAdd(vecMul(heading, vector3(2500, 2500, 0)), vecMul(_EntGetVelocity(userid), vector3(0.25,0.25,0))))
					end
					_EntEmitSound(userid, "physics/concrete/boulder_impact_hard"..math.random(1,4)..".wav")
					_TraceAttack(_TraceGetEnt(), userid, userid, 100)
					if _PlayerInfo(userid, "health") > 0 then
						HaltTimer(BerserkTimer[userid])
						BerserkTimer[userid] = nil
					end
				else
					_TraceAttack(_TraceGetEnt(), userid, userid, 100)
					_EntEmitSound(userid, "physics/concrete/boulder_impact_hard"..math.random(1,4)..".wav")
					HaltTimer(BerserkTimer[userid])
					BerserkTimer[userid] = nil
				end
			else
				_EntSetVelocity(userid, vecAdd(vecMul(heading, vector3(1250, 1250, 0)), vecMul(_EntGetVelocity(userid), vector3(0,0,1))))
			end
		end
	else
		_EntSetVelocity(userid, vecAdd(vecMul(heading, vector3(1250, 1250, 0)), vecMul(_EntGetVelocity(userid), vector3(0,0,1))))
	end
end
