function pointgrav(centervec,zerooffset,radius,force)
    for key,found in _EntitiesFindInSphere(centervec,radius) do -- Get the enities in the radius
        if (_EntHasPhysics(found)) then -- Make sure that the entity is a physics object
            local entpos = _EntGetPos(found)
            if ( centervec.x == entpos.x and centervec.y == entpos.y and centervec.z == entpos.z ) then return end
            local gravforce = force * _PhysGetMass(found) / (vecLength(vecSub(centervec,entpos)) + (zerooffset)) ^ 2
            local entvec = vecNormalize(vecSub(centervec,entpos))
            local gravforcevec = vecMul(entvec,vector3(gravforce,gravforce,gravforce))
            _PhysApplyForce(found,gravforcevec)
        end
    end
end

function gamerulesThink()
	pointgrav(vector3(0,0,300),64,18096,5800000)
end
