_EntPrecacheModel("models/props_junk/watermelon01.mdl")

RocketTimers = {}
function RocketTransform(userid)
	local ent = _EntCreate("rpg_missile")
	if ent > 0 then
		_EntSetPos(ent, _PlayerGetShootPos(userid))
		_EntSetAng(ent, _PlayerGetShootAng(userid))
		_EntSetOwner(ent, userid)
		_EntSetKeyValue(ent, "damage", "300")
		_EntSpawn(ent)
		_EntSetVelocity(ent, vecMul(_PlayerGetShootAng(userid), 1500))
		_PlayerSpectatorStart(userid, OBS_MODE_CHASE)
		_PlayerSetChaseCamDistance(userid, 32)
		_PlayerSpectatorTarget(userid, ent)
		_PlayerRemoveAllWeapons(userid)
		local ent2 = _EntCreate("prop_dynamic_override")
		if ent2 > 0 then
			_EntSetPos(ent2, _EntGetPos(ent))
			_EntSetModel(ent2, "models/props_junk/watermelon01.mdl")
			_EntSpawn(ent2)
			_EntSetParent(ent2, ent)
		end
		RocketTimers[userid] = AddTimer(0.05, 0, RocketCheck, userid, ent)
	end
	_PrintMessageAll(4, _PlayerInfo(userid,"name").." launched a kamikaze watermelon!")
end

function RocketCheck(userid, rocket)
	if not IsPlayerOnline(userid) or not _PlayerInfo(userid, "alive") then HaltTimer(RocketTimers[userid]) RocketTimers[userid] = nil return end
	if not _EntExists(rocket) then _PlayerKill(userid) HaltTimer(RocketTimers[userid]) RocketTimers[userid] = nil ShoopExplode(_EntGetPos(userid)) return end
	local ang = _PlayerGetShootAng(userid) or vector3(0,0,-1)
	_EntSetAng(rocket, ang)
	_EntSetVelocity(rocket, vecMul(ang, 1500))
end
