-- Dragoon Sword/System
_OpenScript( "includes/tickrate.lua" )
-- Prototype True-Melee weapon system for NoXious
-- By JetBoom

model = "models/peanut/conansword.mdl"

-------------------
-- Non-Edit line --
-------------------
sprinttick = 0
damagedone = 0
sword = 0
fire = 0
LastTime = 0
LastMagic = 0
Charging = false
StartCharge = 0
LastPos = vector3(0, 0, 0)
transformed = false

    function Holster()
   		if _EntExists(sword) then
			_EntRemove(sword)
			_EntRemove(fire)
			fire = 0
			sword = 0
		end
		if _EntGetType(fire) ~= "n/a" then
			_EntRemove(fire)
			fire = 0
		end
		if _EntGetType(dragonwings) ~= "n/a" then
			_EntRemove(dragonwings)
			dragonwings = 0
		end
		_PlayerSetDrawViewModel(Owner, true)
    end
    
    function Deploy()
		LastTime = LastTime+0.5
    end

	function onRemove()
		if _EntExists(sword) then
			_EntRemove(sword)
			sword = 0
		end
		if _EntGetType(fire) ~= "n/a" then
			_EntRemove(fire)
			fire = 0
		end
		if _EntGetType(dragonwings) ~= "n/a" then
			_EntRemove(dragonwings)
			dragonwings = 0
		end
	end
	
    function onInit()
    end

	function getForce()
		local force = math.abs(vecLength(vecSub(_EntGetPos(sword),LastPos)))
		return force*22
	end

	function isValidTarget(ent)
		local name = _EntGetType(ent)

		if name == "player" or string.find(name, "prop_") ~= nil or string.find(name, "npc_") ~= nil then
			return true
		end
		return false
	end

	function DoAttack()
		LastTime = _CurTime()
		local tab = _EntitiesFindInSphere(_EntGetPos(sword), 40)
		for i=1, table.getn(tab) do
			if tab[i] ~= Owner and tab[i] ~= sword and isValidTarget(tab[i]) then
				local force = getForce()/TICKRATE
				if force <= 10 then
					-- do nothing
				else
					if force <= 100 then
						_EntEmitSound(tab[i], "physics/body/body_medium_impact_soft"..math.random(1,7)..".wav")
					elseif force <= 200 then
						_EntEmitSound(tab[i], "physics/body/body_medium_impact_hard"..math.random(1,6)..".wav")
					elseif force <= 500 then
						_EntEmitSound(tab[i], "physics/body/body_medium_break"..math.random(2,4)..".wav")
					elseif force <= 1000 then
						_EntEmitSound(tab[i], "physics/flesh/flesh_bloody_break.wav")
					else
						_EntEmitSound(tab[i], "physics/concrete/boulder_impact_hard"..math.random(1,4)..".wav")
					end
					_RunString("_TraceAttack("..tab[i]..", "..Owner..", "..Owner..", "..(force*0.2)..")")
				end
			end
		end
	end

    function onThink( )
    	if not _EntExists(sword) then
			_EntPrecacheModel(model)
			sword = _EntCreate("prop_dynamic_override")
			if sword > 0 then
				_EntSetKeyValue(sword, "model", model)
				_EntSetOwner(sword, Owner)
				_EntitySetPhysicsAttacker(sword, Owner)
				_EntSetPos(sword, vecAdd(_PlayerGetShootPos( Owner ),vecMul(_PlayerGetShootAng( Owner ),vector3(40,40,40))))
				_EntSetAng(sword, _PlayerGetShootAng(Owner))
				_EntSpawn(sword)
				_phys.EnableGravity(sword, false)
				LastPos = _EntGetPos(sword)
				_RunString("AttatchTrail("..sword..", '255 255 50')")
			end
			_PlayerSetDrawViewModel(Owner, false)
		end
		if sprinttick < 5 then
			sprinttick = sprinttick+1
			if sprinttick >= 5 then
				_PlayerEnableSprint(Owner, false)
				_PlayerSetMaxSpeed(Owner, 315)
			end
		end
		LastPos = _EntGetPos(sword)
		_EntitySetPhysicsAttacker(sword, Owner)
		_EntSetPos(sword, vecAdd(vecAdd(_PlayerGetShootPos( Owner ),vecMul(_PlayerGetShootAng( Owner ),vector3(35,35,35))), vector3(0,0,-21)))
		if _PlayerIsKeyDown(Owner, IN_ATTACK) and not Charging then
			_EntSetAng(sword, vecAdd(_PlayerGetShootAng(Owner), vector3(0.7,0,0)))
			if _CurTime() > LastTime+0.4 then
				DoAttack()
			end
			if fire <= 0 and transformed then
				fire = _EntCreate("env_fire_trail")
				if fire > 0 then
					_EntSetPos(fire, _EntGetPos(sword))
					_EntSpawn(fire)
					_EntSetParent(fire, sword)
				end
			end
   	    else
			if _EntExists(fire) then
				_EntRemove(fire)
				fire = 0
			end
			_EntSetAng(sword, vecMul(_PlayerGetShootAng(Owner), vector3(0,0,0.5)))
   	    end
		--[[
		if _PlayerIsKeyDown(Owner, IN_ATTACK2) and not Charging and transformed then
			if _CurTime() > LastMagic+5.0 then
				_EntEmitSoundEx(Owner, "weapons/cguard/charging.wav", 0.8, 0.8)
				Charging = true
				StartCharge = _CurTime()
				LastMagic = _CurTime()
			end
			]]
		if _PlayerIsKeyDown(Owner, IN_ATTACK2) and not transformed then
			transformed = true
			_RunString("StartDragoonTransSequence("..Owner..")")
			LastMagic = _CurTime()-3
			return
		--[[elseif Charging then
			if not _PlayerIsKeyDown(Owner, IN_ATTACK2) or _CurTime()-StartCharge >= 4.0 then
				DoSpell(_CurTime()-StartCharge)
			end]]
		end
		if transformed then
			DragonFlight()
		else
			if damagedone >= 1000 and not transformed then
				transformed = true
				_RunString("StartDragoonTransSequence("..Owner..")")
			end
		end
    end

dragonwings = 0
function DragonFlight()
	if _PlayerIsKeyDown(Owner, IN_JUMP) then
		_TraceLine(_EntGetPos(Owner), vector3(0,0,-90), 256, Owner)
		local curvel = _EntGetVelocity(Owner)
		local vAim = _PlayerGetShootAng(Owner)
		if vAim == nil then	return end
		if math.abs(curvel.x) < 550 and math.abs(curvel.y) < 550 then			
			vAim.x = vAim.x * 7
			vAim.y = vAim.y * 7
		end
		if _TraceHit() then
			vAim.z = (vAim.z * 7)
			if vAim.z < 0 then vAim.z = 0 end
			vAim.z = vAim.z+8
		else
			vAim.z = 4
		end
		_EntSetVelocity(Owner, vecAdd(vecMul(vAim, TICKRATE), _EntGetVelocity(Owner)))
		if _EntGetType(dragonwings) == "n/a" then
			dragonwings = _EntCreate("env_fire_trail")
			_EntSetPos(dragonwings, vecAdd(_EntGetPos(Owner), vector3(0,0,20)))
			_EntSpawn(dragonwings)
			_EntSetParent(dragonwings, Owner)
		end
	else
		if _EntGetType(dragonwings) ~= "n/a" then
			_EntRemove(dragonwings)
			dragonwings = 0
		end
	end
end
	
	function DoSpell(mytime)
		Charging = false
		StartCharge = 0
		if not _PlayerInfo(Owner, "alive") or not _PlayerInfo(Owner, "connected") then return end
		if mytime < 0.25 then return end
	
	_TraceLine(_PlayerGetShootPos(Owner), _PlayerGetShootAng(Owner), mytime*340, Owner)

	local tempent = _EntCreate("info_target")
	if tempent > 0 then
		_EntSetPos(tempent, _TraceEndPos())
		_EntSetName(tempent, _PlayerInfo(Owner, "name").."temptarget")
		_EntSpawn(tempent)
		_EntFire(tempent, "kill", "", 0.6)
	end

	if _TraceHitNonWorld() then
		_EntEmitSound(_TraceGetEnt(), "weapons/physcannon/energy_disintegrate5.wav")
		_RunString("_TraceAttack(".._TraceGetEnt()..", "..MyIndex..", "..Owner..", "..(mytime*17)..")")
		if _TraceGetEnt() <= _MaxPlayers() then
			if _PlayerInfo(_TraceGetEnt(), "team") ~= _PlayerInfo(Owner, "team") then
				_PlayerSetHealth(Owner, _PlayerInfo(Owner, "health")+math.floor((mytime*17)))
				if _PlayerInfo(Owner, "health") > _EntGetMaxHealth(Owner) then
					_PlayerSetHealth(Owner, _EntGetMaxHealth(Owner))
				end
			end
		end
	else
		_EntEmitSound(tempent, "weapons/physcannon/energy_disintegrate5.wav")
	end

	local laser = _EntCreate("env_laser")
	if laser > 0 then
		_EntSetPos(laser, _PlayerGetShootPos(Owner))
		_EntSetKeyValue(laser, "renderamt", "170")
		_EntSetKeyValue(laser, "rendercolor", math.ceil(((mytime/4)*255)-1).." 0 "..math.ceil(255-(mytime/4)*255))
		_EntSetKeyValue(laser, "width", tostring(math.ceil(mytime*2)))
		_EntSetKeyValue(laser, "texture", "sprites/laserbeam.spr")
		_EntSetKeyValue(laser, "TextureScroll", "35")
		_EntSetKeyValue(laser, "damage", "0")
		_EntSetKeyValue(laser, "renderfx", "0")
		_EntSetKeyValue(laser, "TextureScroll", "35")
		_EntSetKeyValue(laser, "LaserTarget", _PlayerInfo(Owner, "name").."temptarget")
		_EntSetKeyValue(laser, "NoiseAmplitude", tostring(math.ceil(mytime)))
		_EntSetKeyValue(laser, "spawnflags", "33")
		_EntSpawn(laser)
		_EntFire(laser, "kill", "", 0.45)
	end
	end
	
	function onPrimaryAttack( )
	end

    function onSecondaryAttack( )
    end

    function onReload( )
    end
    
    function getWeaponSwapHands()
        return false
    end
    
    function getWeaponFOV()
        return 60
    end
    
    function getWeaponSlot()
        return 5
    end
    
    function getWeaponSlotPos()
        return 2    
    end
    
    function getFiresUnderwater()
        return true
    end
    
    function getReloadsSingly()
        return false
    end

    function getDamage()
        return 10
    end
    
    function getPrimaryShotDelay()
        return 400
    end
        
    function getPrimaryIsAutomatic()
        return true
    end
            
    function getBulletSpread()
        return vector3( 0.00, 0.00, 0.00 )
    end
    
    function getViewKick()
        return vector3( 0.0, 0.0, 0.0)
    end
    
    function getViewKickRandom()
        return vector3( 0.0, 0.0, 0.0 )
    end
        
    function getNumShotsPrimary()
        return 1
    end
    
    function getPrimaryAmmoType()
        return "none"
    end

    function getDamageSecondary()
        return 10
    end
    
    function getSecondaryShotDelay()
        return 400
    end
    
    function getSecondaryIsAutomatic()
        return true
    end
    
    function getBulletSpreadSecondary()
        return vector3( 0.001, 0.001, 0.001 )
    end
    
    function getViewKickSecondary()
        return vector3( 0.0, 0.0, 0.0)
    end
    
    function getViewKickRandomSecondary()
        return vector3( 0.5, 0.5, 0.2 )
    end
    
    function getNumShotsSecondary()
        return 1
    end
    
    function getSecondaryAmmoType()
        return "none"
    end

    function getViewModel( )
		return "models/weapons/v_knife_t.mdl"
    end
    
    function getWorldModel( )
 		return "models/weapons/shell.mdl"
    end
    
    function getClassName() 
        return "dragoon_sword"
    end     

    function getMaxClipPrimary()
        return 1
    end
    
    function getMaxClipSecondary()
        return -1
    end
    
    function getDefClipPrimary()
        return 1
    end
    
    function getDefClipSecondary()
        return 0
    end

    function getAnimPrefix()
        return "slam"
    end

    function getPrintName()
        return "Dragoon Blade"
    end

    function getDeathIcon()
	    return "d_sword"
    end

    function getPrimaryScriptOverride()
        return 3
    end

    function getSecondaryScriptOverride()
        return 3
    end
