-- Crowbarang by JetBoom

Crowbarang = 0
Think = 0

Owner = 0
MyIndex = 0
LastThrow = 0
_EntPrecacheModel("models/weapons/shell.mdl")
_EntPrecacheModel("models/weapons/w_crowbar.mdl")

    function Holster()
    	if _EntExists(Crowbarang) then
			_EntRemove(Crowbarang)
			_PlayerViewModelSequence(Owner, ACT_VM_DRAW)
			Crowbarang = 0
			_GModRect_Hide(Owner, 9999, 0, 0)
			_SWEPUpdateVariables(MyIndex)
			_PlayerSetDrawViewModel(Owner, true)
		end
    end
    
    function Deploy()
		_SWEPUpdateVariables(MyIndex)
		_PlayerSetDrawViewModel(Owner, true)
    end

    function onInit( )
    end

    function onThink( )
        if Think == 85 then
        	local entvec = vecNormalize(vecSub(vecAdd(_EntGetPos(Owner), vector3(0,0,20)),_EntGetPos(Crowbarang)))
			local forcevec = vecMul(entvec,vector3(600,600,500))
			_phys.ApplyForceCenter(Crowbarang,forcevec)
	        _EntitySetPhysicsAttacker( Crowbarang, Owner )
            local entlist = _EntitiesFindInSphere(_PlayerGetShootPos( Owner ),65)
            for i,v in entlist do
                if _EntGetName(v) == "Crowbarang"..Owner then
					_EntRemove(v)
					_PlayerViewModelSequence(Owner, ACT_VM_DRAW)
					Crowbarang = 0
					_GModRect_Hide(Owner, 9999, 0, 0)
					_SWEPUpdateVariables(MyIndex)
					_PlayerSetDrawViewModel(Owner, true)
                end
            end
        else
            Think = Think + 1
        end
    end

	function MakeIcon(ent)
		_GModRect_Start( "sprites/redglow1")
			_GModRect_SetPos(0, 0, 0.04, 0.04)
			_GModRect_SetTime(99999, 0, 0)
			_GModRect_SetColor(255, 255, 255, 200)
			_GModRect_SetDelay(0)
			_GModRect_SetEntityOffset(vector3(0, 0, 16))
			_GModRect_SetEntity(ent)
		_GModRect_Send(Owner, 9999)
	end

	function onPrimaryAttack( )
		if ( _PlayerInfo( Owner, "alive" ) == false ) then return; end
		if (_EntExists(Crowbarang)) then return; end
		_PlayerSetDrawViewModel(Owner, true)
		local tracedVictim
		_TraceLine( _PlayerGetShootPos( Owner ), _PlayerGetShootAng( Owner ), 55, Owner )
		_PlayerViewModelSequence(Owner, 171)
		if (_TraceHitNonWorld()) then
			tracedVictim = _TraceGetEnt()
			_MakeDecal(0)
			_EntEmitSound(tracedVictim, "physics/flesh/flesh_impact_bullet"..math.random( 3, 5 )..".wav")
			TraceAttack(tracedVictim, Owner, Owner, 25)
			_PhysApplyForce(tracedVictim, vecMul( _PlayerGetShootAng(Owner), vector3(30000, 30000, 85000)))
		elseif(_TraceHitWorld()) then
			_MakeDecal(0)
			_EntEmitSound(Owner, "physics/flesh/flesh_impact_bullet"..math.random( 3, 5 )..".wav")
		else
			_EntEmitSound(Owner, "weapons/iceaxe/iceaxe_swing1.wav")
		end
	end

    function onSecondaryAttack( )
    	if(_EntExists(Crowbarang)) then return; end
    	if(LastThrow > _CurTime()-2) then return; end
        _PlayerViewModelSequence(Owner, ACT_VM_MISSCENTER);
        _EntEmitSound(Owner, "weapons/iceaxe/iceaxe_swing1.wav")
		Crowbarang = _EntCreate("prop_physics")
        if(Crowbarang > 0) then
        _EntSetKeyValue(Crowbarang, "model", "models/Weapons/w_crowbar.mdl");
        _EntSetName(Crowbarang,"Crowbarang"..Owner)
        _EntSetOwner( Crowbarang, Owner )
        _EntitySetPhysicsAttacker( Crowbarang, Owner )
        _EntSetPos( Crowbarang,_PlayerGetShootPos( Owner ) )
        _EntSetAng( Crowbarang, _PlayerGetShootAng( Owner ) )
        _EntSpawn( Crowbarang )
        _EntFire(Crowbarang, "kill", "", 20)
        local vVelocity = vecMul( _PlayerGetShootAng( Owner ), vector3(6000, 6000, 6000) )
        _phys.ApplyForceCenter( Crowbarang, vVelocity )
        _phys.ApplyTorqueCenter( Crowbarang, vector3(1000,1000,5000) )
        _phys.SetMass(Crowbarang, 50)
        Think = 0
        _phys.EnableGravity(Crowbarang, false)
        MakeIcon(Crowbarang)
        LastThrow = _CurTime()
		_SWEPUpdateVariables(MyIndex)
		_PlayerSetDrawViewModel(Owner, false)
        end
    end

    function onReload( )
        return false
    end
    
    function getWeaponSwapHands()
        return false
    end
    
    function getWeaponFOV()
        return 60
    end
    
    function getWeaponSlot()
        return 0    
    end
    
    function getWeaponSlotPos()
        return 8    
    end
    
    function getFiresUnderwater()
        return true
    end
    
    function getReloadsSingly()
        return false
    end

    function getDamage()
        return 10
    end
    
    function getPrimaryShotDelay()
        return 0.75
    end
        
    function getPrimaryIsAutomatic()
        return true
    end
            
    function getBulletSpread()
        return vector3( 0.00, 0.00, 0.00 )
    end
    
    function getViewKick()
        return vector3( 0.0, 0.0, 0.0)
    end
    
    function getViewKickRandom()
        return vector3( 0.0, 0.0, 0.0 )
    end
        
    function getNumShotsPrimary()
        return 1
    end
    
    function getPrimaryAmmoType()
        return "none"
    end

    function getDamageSecondary()
        return 10
    end
    
    function getSecondaryShotDelay()
        return 2.0
    end
    
    function getSecondaryIsAutomatic()
        return false
    end
    
    function getBulletSpreadSecondary()
        return vector3( 0.001, 0.001, 0.001 )
    end
    
    function getViewKickSecondary()
        return vector3( 0.5, 0.0, 0.0)
    end
    
    function getViewKickRandomSecondary()
        return vector3( 0.5, 0.5, 0.2 )
    end
    
    function getNumShotsSecondary()
        return 1
    end
    
    function getSecondaryAmmoType()
        return "none"
    end

    function getViewModel( )
        return "models/weapons/v_crowbar.mdl"
    end
    
    function getWorldModel( )
    	if(Crowbarang > 0) then
			return "models/weapons/shell.mdl"
    	else
	        return "models/weapons/w_crowbar.mdl"
        end
    end
    
    function getClassName() 
        return "weapon_crowbarang"
    end     

    function getMaxClipPrimary()
        return 1
    end
    
    function getMaxClipSecondary()
        return -1
    end
    
    function getDefClipPrimary()
        return 1
    end
    
    function getDefClipSecondary()
        return 0
    end

    function getAnimPrefix()
        return "melee"
    end

    function getPrintName()
        return "Crowbarang"
    end

    function getDeathIcon()
	    return "d_crowbar"
    end

    function getPrimaryScriptOverride()
        return 2
    end

    function getSecondaryScriptOverride()
        return 2
    end
