-- Blade Spirits
-- By JetBoom

--model = "models/mixerman3d/weapons/axe01.mdl"
--model = "models/weapons/w_knife_t.mdl"
model = "models/mixerman3d/weapons/machete.mdl"
NumBlades = 10

-------------------
-- Non-Edit line --
-------------------

blades = {}
bladesangles = {}
bladesangles2 = {}
bladesangles3 = {}
LastSummon = 0
Owner = 0
MyIndex = 0

    function Holster()
    	for i=1, NumBlades do
	    	if(_EntExists(blades[i])) then
				_EntRemove(blades[i])
				blades[i] = 0
				bladesangles[i] = 0
				bladesangles2[i] = 0
				bladesangles3[i] = 0
			end
		end
    end
    
    function Deploy()
		_EntPrecacheModel(model)
		for i=1, NumBlades do
			blades[i] = _EntCreate("prop_physics")
        	if(blades[i] > 0) then
		        _EntSetKeyValue(blades[i], "model", model)
        		_EntSetOwner(blades[i], Owner)
        		_EntitySetPhysicsAttacker(blades[i], Owner)
				_EntSetPos(blades[i], vecAdd(_PlayerGetShootPos(Owner), vecMul( _PlayerGetShootAng(Owner), vector3(25,25,25))))
	    	    _EntSetAng(blades[i], vecAdd(_PlayerGetShootAng(Owner), vector3(math.random(-90,90),math.random(-90,90),math.random(-90,90))))
    	    	_EntSpawn(blades[i])
    		    _phys.EnableGravity(blades[i], false)
    		    _phys.SetMass(blades[i], 300)
    		    bladesangles[i] = math.random(-80, 80)
    		    bladesangles2[i] = math.random(-80, 80)
				bladesangles3[i] = math.random(-80, 80)
				local fire = _EntCreate("env_fire_trail")
				_EntSetPos(fire, _EntGetPos(blades[i]))
				_EntSpawn(fire)
				_EntSetParent(fire, blades[i])
			end
		end
    end

    function onInit( )
    end

    function onThink( )
    	local entvec
    	local forcevec
		for i=1, NumBlades do
			_EntitySetPhysicsAttacker( blades[i], Owner )
			entvec = vecNormalize(vecSub(vecAdd(_PlayerGetShootPos(Owner), vecMul( _PlayerGetShootAng(Owner), vector3(bladesangles[i],bladesangles2[i],bladesangles3[i]))),_EntGetPos(blades[i])))
			forcevec = vecMul(entvec,vector3(2300,2300,1000))
			_phys.ApplyForceCenter(blades[i], forcevec)
		end
    end

	function onPrimaryAttack( )
		_TraceLine( _PlayerGetShootPos( Owner ), _PlayerGetShootAng( Owner ), 400, Owner )
		local tehhax
		local fireforce
		local force = 80000
		for i=1, NumBlades do
			tehhax = vecNormalize(vecSub(_TraceEndPos(), _EntGetPos(blades[i])))
			fireforce = vecMul(tehhax, vector3(force, force, force))
			_phys.ApplyForceCenter(blades[i], fireforce)

			_phys.ApplyTorqueCenter( blades[i], vector3(500,500,1000) )
		end
	end

    function onSecondaryAttack( )
    	local tehhax
    	local fireforce
		local force = 60000

		for i=1, NumBlades do
			tehhax = vecNormalize(vecSub(vecAdd(_EntGetPos(Owner), vector3(0,0,32)), _EntGetPos(blades[i])))
			fireforce = vecMul(tehhax, vector3(force, force, force))
			_phys.ApplyForceCenter(blades[i], fireforce)
			_phys.ApplyTorqueCenter( blades[i], vector3(500,500,1000) )
		end
    end

    function onReload( )
    	if(LastSummon < _CurTime()-1) then
    	    Holster()
	        Deploy()
	        LastSummon = _CurTime()
        end
        return false
    end
    
    function getWeaponSwapHands()
        return false
    end
    
    function getWeaponFOV()
        return 60
    end
    
    function getWeaponSlot()
        return 0    
    end
    
    function getWeaponSlotPos()
        return 8    
    end
    
    function getFiresUnderwater()
        return true
    end
    
    function getReloadsSingly()
        return false
    end

    function getDamage()
        return 10
    end
    
    function getPrimaryShotDelay()
        return 0.2
    end
        
    function getPrimaryIsAutomatic()
        return true
    end
            
    function getBulletSpread()
        return vector3( 0.00, 0.00, 0.00 )
    end
    
    function getViewKick()
        return vector3( 0.0, 0.0, 0.0)
    end
    
    function getViewKickRandom()
        return vector3( 0.0, 0.0, 0.0 )
    end
        
    function getNumShotsPrimary()
        return 1
    end
    
    function getPrimaryAmmoType()
        return "none"
    end

    function getDamageSecondary()
        return 10
    end
    
    function getSecondaryShotDelay()
        return 0.2
    end
    
    function getSecondaryIsAutomatic()
        return true
    end
    
    function getBulletSpreadSecondary()
        return vector3( 0.001, 0.001, 0.001 )
    end
    
    function getViewKickSecondary()
        return vector3( 0.0, 0.0, 0.0)
    end
    
    function getViewKickRandomSecondary()
        return vector3( 0.5, 0.5, 0.2 )
    end
    
    function getNumShotsSecondary()
        return 1
    end
    
    function getSecondaryAmmoType()
        return "none"
    end

    function getViewModel( )
		return "models/weapons/v_knife_t.mdl"
    end
    
    function getWorldModel( )
 		return "models/weapons/w_knife_t.mdl"
    end
    
    function getClassName() 
        return "weapon_bladespirits"
    end     

    function getMaxClipPrimary()
        return 1
    end
    
    function getMaxClipSecondary()
        return -1
    end
    
    function getDefClipPrimary()
        return 1
    end
    
    function getDefClipSecondary()
        return 0
    end

    function getAnimPrefix()
        return "pistol"
    end

    function getPrintName()
        return "Blade Spirits\nBy JetBoom"
    end

    function getDeathIcon()
	    return "d_crowbar"
    end

    function getPrimaryScriptOverride()
        return 3
    end

    function getSecondaryScriptOverride()
        return 3
    end
