accuracy = 0.25
brickmodel = "models/props_junk/CinderBlock01a.mdl"
stomachmodel = "models/props_wasteland/cargo_container01b.mdl"
_EntPrecacheModel(stomachmodel)
_EntPrecacheModel(brickmodel)
bricks = 0
peopleeaten = {}
stomachpos = vector3(0, 0, -100)
stomachwall1=0
stomachwall2=0

	function onPickup( playerid )
		stomachwall1 = _EntCreate("prop_dynamic_override")
		if stomachwall1 > 0 then
			_EntSetPos(stomachwall1, stomachpos)
			_EntSetAngAngle(stomachwall1, vector3(0,0,-90))
			_EntSetModel(stomachwall1, stomachmodel)
			_EntSetKeyValue(stomachwall1, "solid", "6")
			_EntSetKeyValue(stomachwall1, "rendermode", "5")
			_EntSpawn(stomachwall1)
			_EntSetMaterial(stomachwall1, "models/debug/debugwhite")
			_EntFire(stomachwall1, "color", "255 0 0 ", 0)
		end

		stomachwall2 = _EntCreate("prop_dynamic_override")
		if stomachwall2 > 0 then
			_EntSetPos(stomachwall2, vecAdd(stomachpos, vector3(0, 0, 230)))
			_EntSetModel(stomachwall2, stomachmodel)
			_EntSetKeyValue(stomachwall2, "solid", "6")
			_EntSetKeyValue(stomachwall2, "rendermode", "5")
			_EntSpawn(stomachwall2)
			_EntSetMaterial(stomachwall2, "models/debug/debugwhite")
			_EntFire(stomachwall2, "color", "255 0 0 ", 0)
		end
		_PlayerSetDrawViewModel(playerid, false)
	end

	function onDrop( playerid )
		onRemove()
	end
	
    function Holster()
		_PlayerSetDrawViewModel(Owner, true)
    end

    function onRemove( )
		_PlayerSetDrawViewModel(Owner, true)
		if _EntGetType(stomachwall1) == "prop_dynamic" then _EntRemove(stomachwall1) end
		if _EntGetType(stomachwall2) == "prop_dynamic" then _EntRemove(stomachwall2) end
		for a,i in peopleeaten do
			_PlayerRespawn(i)
			_PrintMessage(i, 3, "The person who ate you died.")
		end 
	end

    function Deploy()
		_PlayerSetDrawViewModel(Owner, false)
    end

    function onInit( )
    end

    function onThink( )
		for a,i in peopleeaten do
			if not _PlayerInfo(i, "alive") or not _PlayerInfo(i, "active") then
				bricks = bricks - 1
				peopleeaten[a] = nil
			end
		end
    end

	function math.frandom(minn, maxn)
		minn = minn * 100
		maxn = maxn * 100
		return math.random(minn, maxn)*0.01
	end
	
	function onPrimaryAttack()
		if bricks <= 0 then _PrintMessage(Owner, 4, "You need to eat more people first.") return end
		local i = 1
		while peopleeaten[i] == nil and i < 128 do i = i+1 end
		local userid = peopleeaten[i]
		peopleeaten[i] = nil
		_PrintMessage(userid, 4, "You were shitted out!")
		_RunString("AddTimer(6.5, 1, _PlayerRespawn, "..userid..")")
		local ang = vecAdd(_PlayerGetShootAng(Owner), vector3(math.frandom(-accuracy, accuracy), math.frandom(-accuracy, accuracy), math.frandom(-accuracy, accuracy)))
		local vec = vecAdd(vecAdd(_EntGetPos(Owner), vecMul(vecMul(ang, vector3(1,1,0)), -32)), vector3(0,0,32))
		local ent = _EntCreate("prop_physics")
		if ent > 0 then
			_EntSetPos(ent, vec)
			_EntSetModel(ent, brickmodel)
			_EntSetAngAngle(ent, vector3(math.random(-180,180),math.random(-180,180),math.random(-180,180)))
			_EntSetOwner(ent, Owner)
			_EntitySetPhysicsAttacker(ent, Owner)
			_EntSpawn(ent)
			_EntFire(ent, "color", "120 100 65", 0)
			_EntFire(ent, "AddOutput", "onhealthchanged !self,kill,,7,-1", 0)
			_EntFire(ent, "kill", "", 20)
			local trail = _EntCreate("env_smoketrail")
			if trail > 0 then
				_EntSetPos(trail, vec)
				_EntSetKeyValue(trail, "spawnrate", "15")
				_EntSetKeyValue(trail, "lifetime", "0.5")
				_EntSetKeyValue(trail, "startcolor", "120 100 65")
				_EntSetKeyValue(trail, "endcolor", "0 255 0")
				_EntSetKeyValue(trail, "minspeed", "0")
				_EntSetKeyValue(trail, "maxspeed", "0")
				_EntSetKeyValue(trail, "startsize", "14")
				_EntSetKeyValue(trail, "endsize", "8")
				_EntSetKeyValue(trail, "spawnradius", "2")
				_EntSetKeyValue(trail, "firesprite", "sprites/greenglow3.spr")
				_EntSetKeyValue(trail, "smokesprite", "sprites/redglow3.spr")
				_EntSpawn(trail)
				_EntSetParent(trail, ent)
				_EntFire(trail, "kill", "", 10)
			end
			_phys.ApplyForceCenter(ent, vecMul(ang, vector3(-90000,-90000,-30000)))
			_phys.SetMass(ent, 25000)
			_EntEmitSoundEx(Owner, "physics/body/body_medium_break"..math.random(2, 4)..".wav", 1, math.frandom(0.6, 0.75))
			_PlayerSpectatorStart(userid, OBS_MODE_CHASE)
			_PlayerSetChaseCamDistance(userid, 64)
			_PlayerSpectatorTarget(userid, ent)
			_PlayerRemoveAllWeapons(userid)
		end
		bricks = bricks - 1
    end
	
    function onSecondaryAttack()
		PlayerLookTrace(Owner, 80)
		if _TraceHitNonWorld() then
			if _EntGetType(_TraceGetEnt()) == "player" then
				local i = 1
				while peopleeaten[i] ~= nil do i = i+1 end
				peopleeaten[i] = _TraceGetEnt()
				TransportTo(_TraceGetEnt())
				bricks = bricks+1
			end
		end		
    end

	function TransportTo(entity)
		local ent = _EntCreate("info_target")
		if ent > 0 then
			_EntSetPos(ent, _EntGetPos(entity))
			_EntSpawn(ent)
			_EntEmitSound(ent, "physics/body/body_medium_break"..math.random(2, 4)..".wav")
			_EntFire(ent, "kill", "", 0.5)
		end
		_EntSetPos(entity, vecAdd(stomachpos, vector3(0,0,75)))
		_EntSetVelocity(entity, vector3(0,0,0))
		_PrintMessage(entity, 4, _PlayerInfo(Owner,"name").." has eaten you!")
	end

    function onReload( )
    end
    
    function getWeaponSwapHands()
        return false
    end
    
    function getWeaponFOV()
        return 60
    end
    
    function getWeaponSlot()
        return 5
    end
    
    function getWeaponSlotPos()
        return 2    
    end
    
    function getFiresUnderwater()
        return true
    end
    
    function getReloadsSingly()
        return false
    end

    function getDamage()
        return 10
    end
    
    function getPrimaryShotDelay()
        return 0.2
    end
        
    function getPrimaryIsAutomatic()
        return true
    end
            
    function getBulletSpread()
        return vector3( 0.00, 0.00, 0.00 )
    end
    
    function getViewKick()
        return vector3( 0.0, 0.0, 0.0)
    end
    
    function getViewKickRandom()
        return vector3( 0.0, 0.0, 0.0 )
    end
        
    function getNumShotsPrimary()
        return 1
    end
    
    function getPrimaryAmmoType()
        return "none"
    end

    function getDamageSecondary()
        return 10
    end
    
    function getSecondaryShotDelay()
        return 0.25
    end
    
    function getSecondaryIsAutomatic()
        return true
    end
    
    function getBulletSpreadSecondary()
        return vector3( 0.0, 0.0, 0.0 )
    end
    
    function getViewKickSecondary()
        return vector3( 0.0, 0.0, 0.0)
    end
    
    function getViewKickRandomSecondary()
        return vector3( 0, 0, 0 )
    end
    
    function getNumShotsSecondary()
        return 1
    end
    
    function getSecondaryAmmoType()
        return "none"
    end

    function getViewModel( )
		return "models/weapons/v_knife_t.mdl"
    end
    
    function getWorldModel( )
 		return "models/weapons/shell.mdl"
    end
    
    function getClassName() 
        return "brickshitter"
    end     

    function getMaxClipPrimary()
        return 1
    end
    
    function getMaxClipSecondary()
        return -1
    end
    
    function getDefClipPrimary()
        return 1
    end
    
    function getDefClipSecondary()
        return 0
    end

    function getAnimPrefix()
        return "slam"
    end

    function getPrintName()
        return "Brick Shitter\nBy JetBoom"
    end

    function getDeathIcon()
	    return "d_pwn"
    end

    function getPrimaryScriptOverride()
        return 3
    end

    function getSecondaryScriptOverride()
        return 3
    end
