_OpenScript( "includes/vector3.lua" );
myindex = 0;
owner = 0;
currenttime = 0;

function onInit()
		_SWEPSetSound( MyIndex, "single_shot", "Weapon_MAC10.Single" )
end

function onThink()
end

function onPrimaryAttack()
	if (_PlayerInfo(Owner, "alive") == false) then return; end
	local harpoon = _EntCreate( "prop_physics" );
	_EntPrecacheModel( "models/props_junk/harpoon002a.mdl" );
	_EntSetModel(harpoon, "models/props_junk/harpoon002a.mdl");
	_EntSetPos(harpoon, vecAdd(_PlayerGetShootPos(Owner),vector3(0,0,32)))
	_EntSetAng(harpoon, _PlayerGetShootAng(Owner));
	_EntSetOwner(harpoon, Owner);
	local power = 600000;
	local fireforce = vecMul(_PlayerGetShootAng(Owner), vector3(power, power, power));
	_EntSpawn(harpoon);
	_PhysApplyForce(harpoon, fireforce);
	_SWEPUseAmmo(MyIndex, 0, 1);
end

function onSecondaryAttack()		
      if (_PlayerInfo(Owner, "alive") == false) then return; end
	local sawblade = _EntCreate( "prop_physics" );
	_EntPrecacheModel( "models/props_junk/sawblade001a.mdl" );
	_EntSetModel(sawblade, "models/props_junk/sawblade001a.mdl");
	_EntSetPos(sawblade, vecAdd(_PlayerGetShootPos(Owner),vector3(0,0,32)))
	_EntSetAng(sawblade, _PlayerGetShootAng(Owner));
	_EntSetOwner(sawblade, Owner);
	local power = 600000;
	local fireforce = vecMul(_PlayerGetShootAng(Owner), vector3(power, power, power));
	_EntSpawn(sawblade);
	_PhysApplyForce(sawblade, fireforce);
	_SWEPUseAmmo(MyIndex, 0, 1);

end

function onReload( )
	return true;
end

function getWeaponSwapHands()
	return true;	
end

function getWeaponFOV()
	return 80;	
end


function getWeaponSlot()
	return 5;	
end

function getWeaponSlotPos()
	return 2;	
end

function getFiresUnderwater()
	return true;
end

function getReloadsSingly()
	return true;
end

function getDamage()
	return 100;
end

function getPrimaryShotDelay()
	return 0.1;
end

function getSecondaryShotDelay()
	return 0.1;
end

function getPrimaryIsAutomatic()
	return true;
end

function getSecondaryIsAutomatic()
	return false;
end

function getPrimaryAmmoType()
	return "pistol";
end

function getSecondaryAmmoType()
	return "none";
end

function getMaxClipPrimary()
	return 500;
end

function getMaxClipSecondary()
	return -1;
end

function getDefClipPrimary()
	return 500;
end


function getDefClipSecondary()
	return -1;
end

function getPrimaryScriptOverride()
	return 2;
end

function getSecondaryScriptOverride()
	return 3;
end

function getBulletSpread()
	return vector3( 0.0, 0.0, 0.0 );
end

function getViewKick()
	return vector3( 0, 0.0, 0.0);
end

function getViewKickRandom()
	return vector3( 0.0, 0.0, 0.0 );
end

function getViewModel( )
	return "models/weapons/v_rpg.mdl";
end

function getWorldModel( )
	return "models/weapons/w_rocket_launcher.mdl";
end

function getClassName()
	return "weapon_harpoon";
end

function getAnimPrefix()
	return "rpg";
end

function getPrintName()
	return "Slim's Harpoon Gun v2";
end
