
-- Called when the weapon is created.
	
	function onInit( )
		
		_SWEPSetSound( MyIndex, "single_shot", "Weapon_MAC10.Single" );
		
	end

	
-- Called every frame

	function onThink( )
			
	end
	
	
-- 

		function onPrimaryAttack( )
		
		if ( _PlayerInfo( Owner, "alive" ) == false ) then return; end
			
		local iBolt = _EntCreate( "crossbow_bolt" );
		
		if (iBolt > 0) then
			
			_EntSetKeyValue( iBolt, "damage", "65");
			_EntSetPos( iBolt, _PlayerGetShootPos( Owner ) );
			_EntSetAng( iBolt, _PlayerGetShootAng( Owner ) );
			_EntSetOwner( iBolt, Owner );
			
			local vVelocity = vecMul( _PlayerGetShootAng( Owner ), vector3(900, 900, 900) );
			_EntSetVelocity( iBolt, vVelocity );
				
			_EntSpawn( iBolt );
			
		end
		
		
		_SWEPUseAmmo( MyIndex, 0, 1 );
			
	end	
	
	-- Secondary gives ammo
	
	function onSecondaryAttack( )		
		
		
	   local vecpos = _PlayerGetShootPos( Owner );
	   local plyang = _PlayerGetShootAng( Owner );
	 
	   _TraceLine( vecpos, plyang, 8000, Owner );
	   
	   vecpos = vecAdd( vecpos, vector3( 0, 0, -20 ) );
	   
	   local hitpos = _TraceEndPos();
	 
	   if ( _TraceHit() == false )  then
	   
	   hitpos = vecAdd( vecpos, vecMul( plyang, vector3(8000,8000,8000) ) )
	   
	   end
	 
	   

		_EffectInit();
		
			_EffectSetEnt( 255 ); -- green
			
			_EffectSetOrigin( hitpos );
			_EffectSetStart( vecpos );
			_EffectSetScale( 20 );
			_EffectSetMagnitude( 0.5 );
		
		_EffectDispatch( "FadingLine" );
		
		if ( _TraceHitNonWorld() ) then
		
			local iHealth = _PlayerInfo( _TraceGetEnt(), "health" );
			
			if (iHealth == 200) then

				_EntEmitSound( _TraceGetEnt(), "hl1/fvox/medical_repaired.wav" );
			
			end
			
			iHealth = iHealth + 1;
			
			if (iHealth > 250) then return; end
			
			_PlayerSetHealth( _TraceGetEnt(), iHealth );
			local Pitch = (iHealth / 150.0) * 0.50 + 0.80;
			_EntEmitSoundEx( _TraceGetEnt(), "items/medshot4.wav", 1.0, Pitch );
		
		end

					
	end
	
	
	function onReload( )
			
		return true;
			
	end
	
	
	
-- Weapon settings.
-- These are only accessed once when setting the weapon up
	
	function getWeaponSwapHands()
		return false;	
	end
	
	function getWeaponFOV()
		return 74;	
	end
	
	function getWeaponSlot()
		return 1;	
	end
	
	function getWeaponSlotPos()
		return 5;	
	end
	
	function getFiresUnderwater()
		return true;
	end
	
	function getReloadsSingly()
		return false;
	end
	
	function getDamage()
		return 120;
	end
	
	function getPrimaryShotDelay()
		return 0.0;
	end
	
	function getSecondaryShotDelay()
		return 0.0;
	end
	
	function getPrimaryIsAutomatic()
		return true;
	end
	
	function getSecondaryIsAutomatic()
		return true;
	end
	
	function getBulletSpread()
		return vector3( 0.0, 0.0, 0.0 );
	end
	
	function getViewKick()
		return vector3( -0.0, 0.0, 0.0);
	end
	
	function getViewKickRandom()
		return vector3( 0.5, 0.5, 0.5 );
	end
	
	
	function getBulletSpreadSecondary()
		return vector3( 0.001, 0.001, 0.001 );
	end
	
	function getViewKickSecondary()
		return vector3( 0.0, 0.0, 0.0);
	end
	
	function getViewKickRandomSecondary()
		return vector3( 0.0, 0.0, 0.0 );
	end
	

	function getViewModel( )
		return "models/weapons/v_smg_p90.mdl";
	end
	
	function getWorldModel( )
		return "models/weapons/w_smg_p90.mdl";
	end
	
	function getClassName()
		return "weapon_medic";
	end

	function getPrimaryAmmoType()
		return "XBowBolt";
	end
		
	function getSecondaryAmmoType()
		return "XBowBolt";
	end
	
	-- return -1 if it doesn't use clips
	function getMaxClipPrimary()
		return 800;
	end
	
	function getMaxClipSecondary()
		return 800;
	end
	
	-- ammo in gun by default
	function getDefClipPrimary()
		return 800;
	end
	
	function getDefClipSecondary()
		return 800;
	end

	-- pistol, smg, ar2, shotgun, rpg, phys, crossbow, melee, slam, grenade
	function getAnimPrefix()
		return "smg";
	end

	function getPrintName()
		return "Slim's Medic Gun";
	end
	
	
	-- 0 = Don't override, shoot bullets, make sound and flash
	-- 1 = Don't shoot bullets but do make flash/sounds
	-- 2 = Only play animations
	-- 3 = Don't do anything
	
	function getPrimaryScriptOverride()
		return 0;
	end

	function getSecondaryScriptOverride()
		return 2;
	end

