





-- Called when the weapon is created.

	

	function onInit( )

		

		_SWEPSetSound( MyIndex, "single_shot", "Weapon_AWP.Single" );

		

	end



	

-- Called every frame



	function onThink( )

			

	end

	

	

-- 



	function onPrimaryAttack( )

		

	

		if ( _PlayerInfo( Owner, "alive" ) == false ) then return; end

			

		local iBolt = _EntCreate( "crossbow_bolt" );

		

		if (iBolt > 0) then

			

			_EntSetKeyValue( iBolt, "damage", "200");

			_EntSetPos( iBolt, _PlayerGetShootPos( Owner ) );

			_EntSetAng( iBolt, _PlayerGetShootAng( Owner ) );

			_EntSetOwner( iBolt, Owner );

			

			local vVelocity = vecMul( _PlayerGetShootAng( Owner ), vector3(3000, 3000, 3000) );

			_EntSetVelocity( iBolt, vVelocity );

				

			_EntSpawn( iBolt );

			

		end

		

		-- Make the player fly backwards

		local vPlayerVel = vecMul( _PlayerGetShootAng( Owner ), vector3(-2000, -2000, -2000) );

		_EntSetVelocity( Owner, vPlayerVel );

		

		-- Nice sparky effects

		

		--_EffectInit();

		

		local vSparksVel = vecMul( _PlayerGetShootAng( Owner ), vector3(1000, 1000, 1000) );

		_EffectSetNormal( vSparksVel );

		_EffectSetOrigin( _PlayerGetShootPos( Owner ) );

		_EffectDispatch( "cball_bounce" );

		_EffectDispatch( "cball_bounce" );

		_EffectDispatch( "cball_bounce" );

		

		local vTracerEnd = vecAdd( _PlayerGetShootPos( Owner ), vSparksVel );

		_EffectSetOrigin( vTracerEnd );

		_EffectSetStart( _PlayerGetShootPos( Owner ) );

		_EffectSetScale( 2900 );

		_EffectDispatch( "GaussTracer" );

		_EffectSetScale( 2700 );

		_EffectDispatch( "GaussTracer" );

		_EffectSetScale( 2400 );

		_EffectDispatch( "GaussTracer" );

		

		

		

		_SWEPUseAmmo( MyIndex, 0, 1 );

			

	end

	

	

	function onSecondaryAttack( )		

		

		-- No sec attack

					

	end

	

	

	function onReload( )

			

		return true;

			

	end

	

	

	

-- Weapon settings.

-- These are only accessed once when setting the weapon up

	

	function getWeaponSwapHands()

		return true;	

	end

	

	function getWeaponFOV()

		return 80;	

	end

	

	function getWeaponSlot()

		return 1;	

	end

	

	function getWeaponSlotPos()

		return 5;	

	end

	

	function getFiresUnderwater()

		return true;

	end

	

	function getReloadsSingly()

		return false;

	end

	

	function getDamage()

		return 35;

	end

	

	function getNumShotsPrimary()

		return 1;

	end

	

	function getNumShotsSecondary()

		return 1;

	end

	

	function getPrimaryShotDelay()

		return 2;

	end

	

	function getSecondaryShotDelay()

		return 0.01;

	end

	

	function getPrimaryIsAutomatic()

		return false;

	end

	

	function getSecondaryIsAutomatic()

		return false;

	end

	

	function getSecondaryIsAutomatic()

		return false;

	end

	

	function getBulletSpread()

		return vector3( 0.0001, 0.0001, 0.0001 );

	end

	

	function getBulletSpreadSecondary()

		return vector3( 0.0001, 0.0001, 0.0001 );

	end

	

	function getViewKick()

		return vector3( -20.0, 0.0, 0.0);

	end

	

	function getViewKickSecondary()

		return vector3( -20.0, 0.0, 0.0);

	end

	

	function getViewKickRandom()

		return vector3( 0.5, 0.5, 20.2 );

	end

	

	function getViewKickRandomSecondary()

		return vector3( 0.5, 0.5, 20.2 );

	end



	function getViewModel( )

		return "models/weapons/v_pist_p228.mdl";

	end

	

	function getWorldModel( )

		return "models/weapons/w_pist_p228.mdl";

	end

	

	function getClassName()

		return "weapon_megabolt";

	end



	function getPrimaryAmmoType()

		return "357";

	end

		

	function getSecondaryAmmoType()

		return "357";

	end

	

	-- return -1 if it doesn't use clips

	function getMaxClipPrimary()

		return 25;

	end

	

	function getMaxClipSecondary()

		return -1;

	end

	

	-- ammo in gun by default

	function getDefClipPrimary()

		return 7;

	end

	

	function getDefClipSecondary()

		return 0;

	end



	-- pistol, smg, ar2, shotgun, rpg, phys, crossbow, melee, slam, grenade

	function getAnimPrefix()

		return "pistol";

	end



	function getPrintName()

		return "Mega Bolt";

	end

	

	

	-- 0 = Don't override, shoot bullets, make sound and flash

	-- 1 = Don't shoot bullets but do make flash/sounds

	-- 2 = Only play animations

	-- 3 = Don't do anything

	

	function getPrimaryScriptOverride()

		return 1;

	end



	function getSecondaryScriptOverride()

		return 3;

	end



