-- Pin Cushion
-- By JetBoom

PinRate = 12 -- Make this bigger or smaller according to tick rate / your preference
PinDamage = 25 -- This should be kept pretty low.
PinBalls = 7 -- Number of balls
model = "models/Roller.mdl" -- Model to use
_EntPrecacheModel(model)
-------------------
-- Non-Edit line --
-------------------

Target = 0
Tick = 0
Balls = {}
Owner = 0
MyIndex = 0

    function Holster()
    	Target = 0
    	Tick = 0
    	for i=1, PinBalls do
    		if(_EntExists(Balls[i])) then
	    		_EntRemove(Balls[i])
    		end
    	end
    end
    
	function Deploy()
		Holster()
	end

    function onInit( )
    end

    function onThink( )
		if(Target > 0) then
			if(not _EntExists(Target)) then
				Holster()
				return
			end
			if(Target <= _MaxPlayers()) then
				if(not _PlayerInfo(Target, "alive")) then
					Holster()
					return
				end
			end
			for i=1, PinBalls do
				local entvec = vecNormalize(vecSub(vecAdd(_EntGetPos(Target), vector3(0,0,50)),_EntGetPos(Balls[i])))
    	        local forcevec = vecAdd(vecMul(entvec,vector3(50,50,50)), vector3(0,0,math.random(-100,100)))
	            _PhysApplyForce(Balls[i],forcevec)
            end
            Tick = Tick+1
            if(Tick >= PinRate) then DoBolt() end
		end
    end

	function SpawnBalls()
		for i=1, PinBalls do
			Balls[i] = _EntCreate("prop_physics")
        	if(Balls[i] > 0) then
		        _EntSetKeyValue(Balls[i], "model", model)
        		_EntSetOwner(Balls[i], Owner)
        		_EntitySetPhysicsAttacker(Balls[i], Owner)
				_EntSetPos(Balls[i], vecAdd(_PlayerGetShootPos(Owner), vecMul( _PlayerGetShootAng(Owner), vector3(25,25,25))))
    	    	_EntSpawn(Balls[i])
    	    	_EntFire(Balls[i], "sethealth", "99999", 0)
    		    _phys.EnableGravity(Balls[i], false)
    		    _phys.SetMass(Balls[i], 10)
    		    _phys.EnableGravity(Balls[i], false)
			end
		end
	end

	function DoBolt()
		if(not _PlayerInfo(Owner, "alive") or Target == 0) then return end
		if(not _EntExists(Target)) then return end
		local ball = math.random(PinBalls)
		local iBolt = _EntCreate( "crossbow_bolt" )
		if (iBolt > 0) then
			_EntSetKeyValue(iBolt, "damage", tostring(PinDamage))
			_EntSetOwner(iBolt, Owner)
			_EntSetPos(iBolt, vecAdd(_EntGetPos(Balls[ball]), vector3(0,0,-18)))
			local entvec = vecNormalize(vecSub(vecAdd(_EntGetPos(Target), vector3(0,0,32)),vecAdd(_EntGetPos(Balls[ball]), vector3(0,0,-18))))
			_EntSetAng(iBolt, entvec)
            local forcevec = vecMul(entvec,vector3(2000,2000,2000))
			_EntSetVelocity(iBolt, forcevec)
			_EntSpawn(iBolt)
		end
		Tick = 0
	end

	function onPrimaryAttack( )
		_TraceLine( _PlayerGetShootPos( Owner ), _PlayerGetShootAng( Owner ), 4064, Owner )
		if(_TraceHitNonWorld()) then
			Holster()
			Target = _TraceGetEnt()
			SpawnBalls()
		else
			Target = 0
		end
	end

    function onSecondaryAttack( )
    	onPrimaryAttack()
    end

    function onReload( )
    	Holster()
    end
    
    function getWeaponSwapHands()
        return false
    end
    
    function getWeaponFOV()
        return 60
    end
    
    function getWeaponSlot()
        return 0    
    end
    
    function getWeaponSlotPos()
        return 8    
    end
    
    function getFiresUnderwater()
        return true
    end
    
    function getReloadsSingly()
        return false
    end

    function getDamage()
        return 10
    end
    
    function getPrimaryShotDelay()
        return 0.2
    end
        
    function getPrimaryIsAutomatic()
        return true
    end
            
    function getBulletSpread()
        return vector3( 0.00, 0.00, 0.00 )
    end
    
    function getViewKick()
        return vector3( 0.0, 0.0, 0.0)
    end
    
    function getViewKickRandom()
        return vector3( 0.0, 0.0, 0.0 )
    end
        
    function getNumShotsPrimary()
        return 1
    end
    
    function getPrimaryAmmoType()
        return "none"
    end

    function getDamageSecondary()
        return 10
    end
    
    function getSecondaryShotDelay()
        return 0.2
    end
    
    function getSecondaryIsAutomatic()
        return true
    end
    
    function getBulletSpreadSecondary()
        return vector3( 0.001, 0.001, 0.001 )
    end
    
    function getViewKickSecondary()
        return vector3( 0.0, 0.0, 0.0)
    end
    
    function getViewKickRandomSecondary()
        return vector3( 0.5, 0.5, 0.2 )
    end
    
    function getNumShotsSecondary()
        return 1
    end
    
    function getSecondaryAmmoType()
        return "none"
    end

    function getViewModel( )
		return "models/weapons/v_crossbow.mdl"
    end
    
    function getWorldModel( )
 		return "models/weapons/w_crossbow.mdl"
    end
    
    function getClassName() 
        return "weapon_PinCushion"
    end     

    function getMaxClipPrimary()
        return 1
    end
    
    function getMaxClipSecondary()
        return -1
    end
    
    function getDefClipPrimary()
        return 1
    end
    
    function getDefClipSecondary()
        return 0
    end

    function getAnimPrefix()
        return "pistol"
    end

    function getPrintName()
        return "Pin Cushion\nBy JetBoom"
    end

    function getDeathIcon()
	    return "d_crowbar"
    end

    function getPrimaryScriptOverride()
        return 3
    end

    function getSecondaryScriptOverride()
        return 3
    end
